/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.AttributeSource;

public class ReversedWildcardFilter
extends TokenFilter {
    private boolean withOriginal;
    private char markerChar;
    private AttributeSource.State save;
    private TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    private PositionIncrementAttribute posAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

    protected ReversedWildcardFilter(TokenStream input, boolean withOriginal, char markerChar) {
        super(input);
        this.withOriginal = withOriginal;
        this.markerChar = markerChar;
    }

    public boolean incrementToken() throws IOException {
        if (this.save != null) {
            this.restoreState(this.save);
            this.save = null;
            return true;
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        int oldLen = this.termAtt.termLength();
        if (oldLen == 0) {
            return true;
        }
        int origOffset = this.posAtt.getPositionIncrement();
        if (this.withOriginal) {
            this.posAtt.setPositionIncrement(0);
            this.save = this.captureState();
        }
        char[] buffer = this.termAtt.resizeTermBuffer(oldLen + 1);
        buffer[oldLen] = this.markerChar;
        ReverseStringFilter.reverse(buffer, oldLen + 1);
        this.posAtt.setPositionIncrement(origOffset);
        this.termAtt.setTermBuffer(buffer, 0, oldLen + 1);
        return true;
    }
}

