/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.scriptengine.engine;

import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.RhinoDebuggerImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoTransportService;
import org.eclipse.wst.jsdt.debug.transport.TransportService;
import org.jaggeryjs.scriptengine.cache.CacheManager;
import org.jaggeryjs.scriptengine.cache.ScriptCachingContext;
import org.jaggeryjs.scriptengine.engine.JavaScriptHostObject;
import org.jaggeryjs.scriptengine.engine.JavaScriptMethod;
import org.jaggeryjs.scriptengine.engine.JavaScriptModule;
import org.jaggeryjs.scriptengine.engine.JavaScriptProperty;
import org.jaggeryjs.scriptengine.engine.JavaScriptScript;
import org.jaggeryjs.scriptengine.engine.RhinoContextFactory;
import org.jaggeryjs.scriptengine.engine.RhinoTopLevel;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.security.RhinoSecurityController;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoEngine {
    private static final Log log = LogFactory.getLog(RhinoEngine.class);
    private static ContextFactory globalContextFactory;
    private CacheManager cacheManager;
    private ContextFactory contextFactory;
    private List<JavaScriptModule> modules = new ArrayList<JavaScriptModule>();
    private JavaScriptModule globalModule = new JavaScriptModule("global");
    private static boolean debugMode;
    private static String debugPort;

    public RhinoEngine(CacheManager cacheManager, RhinoContextFactory contextFactory) {
        this.cacheManager = cacheManager;
        this.contextFactory = contextFactory != null ? contextFactory : globalContextFactory;
        if (debugMode) {
            RhinoDebuggerImpl debugger = new RhinoDebuggerImpl((TransportService)new RhinoTransportService(), debugPort, true, true);
            debugger.start();
            this.contextFactory.addListener((ContextFactory.Listener)debugger);
        }
    }

    public static void defineHostObject(ScriptableObject scope, JavaScriptHostObject hostObject) throws ScriptException {
        String msg = "Error while registering the hostobject : ";
        Class clazz = hostObject.getClazz();
        String className = clazz.getName();
        try {
            ScriptableObject.defineClass((Scriptable)scope, (Class)clazz);
        }
        catch (InvocationTargetException e) {
            log.error((Object)(msg + className), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)(msg + className), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)(msg + className), (Throwable)e);
        }
    }

    public void defineHostObject(JavaScriptHostObject hostObject) {
        this.globalModule.addHostObject(hostObject);
    }

    public static void defineProperty(ScriptableObject scope, JavaScriptProperty property) {
        String name = property.getName();
        Object object = property.getValue();
        if (object instanceof Number || object instanceof String || object instanceof Boolean) {
            scope.defineProperty(name, object, property.getAttribute());
        } else {
            Scriptable wrapped = Context.toObject((Object)object, (Scriptable)scope);
            scope.defineProperty(name, (Object)wrapped, property.getAttribute());
        }
    }

    public void defineProperty(JavaScriptProperty property) {
        this.globalModule.addProperty(property);
    }

    public static void defineScript(ScriptableObject scope, JavaScriptScript script) {
        Context cx = RhinoEngine.enterGlobalContext();
        script.getScript().exec(cx, (Scriptable)scope);
        RhinoEngine.exitContext();
    }

    public void defineScript(JavaScriptScript script) {
        this.globalModule.addScript(script);
    }

    public static void defineMethod(ScriptableObject scope, JavaScriptMethod method) throws ScriptException {
        String name = method.getName();
        FunctionObject f = new FunctionObject(name, (Member)method.getMethod(), (Scriptable)scope);
        scope.defineProperty(name, (Object)f, method.getAttribute());
    }

    public void defineMethod(JavaScriptMethod method) {
        this.globalModule.addMethod(method);
    }

    public void defineModule(JavaScriptModule module) {
        this.modules.add(module);
    }

    public Object eval(Reader scriptReader, ScriptCachingContext sctx) throws ScriptException {
        return this.evalScript(scriptReader, this.getRuntimeScope(), sctx);
    }

    public Object eval(Reader scriptReader, ScriptableObject scope, ScriptCachingContext sctx) throws ScriptException {
        if (scope == null) {
            String msg = "ScriptableObject value for scope, can not be null.";
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        return this.evalScript(scriptReader, scope, sctx);
    }

    public ScriptableObject exec(Reader scriptReader, ScriptCachingContext sctx) throws ScriptException {
        return this.execScript(scriptReader, this.getRuntimeScope(), sctx);
    }

    public void exec(Reader scriptReader, ScriptableObject scope, ScriptCachingContext sctx) throws ScriptException {
        if (scope == null) {
            String msg = "ScriptableObject value for scope, can not be null.";
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        this.execScript(scriptReader, scope, sctx);
    }

    public Object call(Reader scriptReader, String funcName, Object[] args, ScriptCachingContext sctx) throws ScriptException {
        return this.execFunc(scriptReader, funcName, args, this.getRuntimeScope(), this.getRuntimeScope(), sctx);
    }

    public Object call(Reader scriptReader, String funcName, Object[] args, ScriptableObject thiz, ScriptCachingContext sctx) throws ScriptException {
        if (thiz == null) {
            String msg = "ScriptableObject value for thiz, can not be null.";
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        return this.execFunc(scriptReader, funcName, args, thiz, this.getRuntimeScope(), sctx);
    }

    public Object call(Reader scriptReader, String funcName, Object[] args, ScriptableObject thiz, ScriptableObject scope, ScriptCachingContext sctx) throws ScriptException {
        if (scope == null) {
            String msg = "ScriptableObject value for scope, can not be null.";
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        if (thiz == null) {
            String msg = "ScriptableObject value for thiz, can not be null.";
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        return this.execFunc(scriptReader, funcName, args, thiz, scope, sctx);
    }

    public ScriptableObject getRuntimeScope() throws ScriptException {
        Context cx = this.enterContext();
        ScriptableObject scope = RhinoEngine.removeUnsafeObjects((ScriptableObject)new RhinoTopLevel(cx, false));
        this.exposeModule(cx, scope, this.globalModule);
        for (JavaScriptModule module : this.modules) {
            String name = module.getName();
            ScriptableObject object = (ScriptableObject)cx.newObject((Scriptable)scope);
            this.exposeModule(cx, object, module);
            JavaScriptProperty property = new JavaScriptProperty(name);
            property.setValue(object);
            property.setAttribute(4);
            RhinoEngine.defineProperty(scope, property);
        }
        RhinoEngine.exitContext();
        return scope;
    }

    public void unloadTenant(String tenantId) {
        this.cacheManager.unloadTenant(tenantId);
        RhinoTopLevel.removeTasks(tenantId);
    }

    public static Scriptable newObject(ScriptableObject scope) {
        Context cx = RhinoEngine.enterGlobalContext();
        Scriptable obj = cx.newObject((Scriptable)scope);
        RhinoEngine.exitContext();
        return obj;
    }

    public static void putContextProperty(Object key, Object value) {
        Context cx = Context.getCurrentContext();
        cx.putThreadLocal(key, value);
    }

    public static Object getContextProperty(Object key) {
        Context cx = Context.getCurrentContext();
        return cx.getThreadLocal(key);
    }

    public Context enterContext() {
        return this.contextFactory.enterContext();
    }

    public static Context enterContext(ContextFactory factory) {
        return factory.enterContext();
    }

    public static Context enterGlobalContext() {
        return globalContextFactory.enterContext();
    }

    public static void exitContext() {
        Context.exit();
    }

    private void defineClass(ScriptableObject scope, Class clazz) {
        try {
            ScriptableObject.defineClass((Scriptable)scope, (Class)clazz);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void defineMethod(ScriptableObject scope, String name, Method method, int attribute) {
        FunctionObject f = new FunctionObject(name, (Member)method, (Scriptable)scope);
        scope.defineProperty(name, (Object)f, attribute);
    }

    private void exposeModule(Context cx, ScriptableObject scope, JavaScriptModule module) throws ScriptException {
        for (JavaScriptHostObject hostObject : module.getHostObjects()) {
            this.defineClass(scope, hostObject.getClazz());
        }
        for (JavaScriptMethod method : module.getMethods()) {
            this.defineMethod(scope, method.getName(), method.getMethod(), method.getAttribute());
        }
        for (JavaScriptScript script : module.getScripts()) {
            script.getScript().exec(cx, (Scriptable)scope);
        }
    }

    private CacheManager getCacheManager() {
        return this.cacheManager;
    }

    private Object execFunc(Reader scriptReader, String funcName, Object[] args, ScriptableObject thiz, ScriptableObject scope, ScriptCachingContext sctx) throws ScriptException {
        Context cx = this.enterContext();
        try {
            Object script;
            if (sctx == null) {
                cx.evaluateString((Scriptable)scope, HostObjectUtil.readerToString(scriptReader), "wso2js", 1, null);
            } else if (debugMode) {
                String scriptPath = sctx.getContext() + sctx.getPath() + sctx.getCacheKey();
                cx.evaluateString((Scriptable)scope, HostObjectUtil.readerToString(scriptReader), scriptPath, 1, null);
            } else {
                script = this.cacheManager.getScriptObject(scriptReader, sctx);
                if (script == null) {
                    this.cacheManager.cacheScript(scriptReader, sctx);
                    script = this.cacheManager.getScriptObject(scriptReader, sctx);
                }
                script.exec(cx, (Scriptable)scope);
            }
            script = RhinoEngine.execFunc(funcName, args, thiz, scope, cx);
            return script;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            RhinoEngine.exitContext();
        }
    }

    private static Object execFunc(String funcName, Object[] args, ScriptableObject thiz, ScriptableObject scope, Context cx) throws ScriptException {
        Object object = scope.get(funcName, (Scriptable)scope);
        if (!(object instanceof Function)) {
            String msg = "Function cannot be found with the name '" + funcName + "', but a " + object.toString();
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        try {
            return ((Function)object).call(cx, (Scriptable)scope, (Scriptable)thiz, args);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    private Object evalScript(Reader scriptReader, ScriptableObject scope, ScriptCachingContext sctx) throws ScriptException {
        Context cx = this.enterContext();
        try {
            Object script;
            Object result;
            if (sctx == null) {
                result = cx.evaluateString((Scriptable)scope, HostObjectUtil.readerToString(scriptReader), "wso2js", 1, null);
            } else if (debugMode) {
                String scriptPath = sctx.getContext() + sctx.getPath() + sctx.getCacheKey();
                result = cx.evaluateString((Scriptable)scope, HostObjectUtil.readerToString(scriptReader), scriptPath, 1, null);
            } else {
                script = this.cacheManager.getScriptObject(scriptReader, sctx);
                if (script == null) {
                    this.cacheManager.cacheScript(scriptReader, sctx);
                    script = this.cacheManager.getScriptObject(scriptReader, sctx);
                }
                result = script.exec(cx, (Scriptable)scope);
            }
            script = result;
            return script;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            RhinoEngine.exitContext();
        }
    }

    private ScriptableObject execScript(Reader scriptReader, ScriptableObject scope, ScriptCachingContext sctx) throws ScriptException {
        Context cx = this.enterContext();
        try {
            Script script;
            if (sctx == null) {
                cx.evaluateString((Scriptable)scope, HostObjectUtil.readerToString(scriptReader), "wso2js", 1, null);
            } else if (debugMode) {
                String scriptPath = sctx.getContext() + sctx.getPath() + sctx.getCacheKey();
                cx.evaluateString((Scriptable)scope, HostObjectUtil.readerToString(scriptReader), scriptPath, 1, null);
            } else {
                script = this.cacheManager.getScriptObject(scriptReader, sctx);
                if (script == null) {
                    this.cacheManager.cacheScript(scriptReader, sctx);
                    script = this.cacheManager.getScriptObject(scriptReader, sctx);
                }
                script.exec(cx, (Scriptable)scope);
            }
            script = scope;
            return script;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            RhinoEngine.exitContext();
        }
    }

    private static ScriptableObject removeUnsafeObjects(ScriptableObject scope) {
        return scope;
    }

    private static void copyEngineScope(ScriptableObject engineScope, ScriptableObject scope) {
        Object[] objs;
        for (Object obj : objs = engineScope.getAllIds()) {
            String id = (String)obj;
            scope.put(id, (Scriptable)scope, engineScope.get(id, (Scriptable)engineScope));
        }
    }

    static {
        debugMode = false;
        debugPort = "-1";
        globalContextFactory = new RhinoContextFactory(RhinoSecurityController.isSecurityEnabled() ? new RhinoSecurityController() : null);
        ContextFactory.initGlobal((ContextFactory)globalContextFactory);
        String property = System.getProperty("jsDebug");
        if (property != null) {
            debugPort = property;
            debugMode = true;
        }
    }
}

