/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.io.StringReader;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAMLTokenIssuer;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.util.SAMLAttributeCallback;
import org.apache.rahas.impl.util.SAMLCallbackHandler;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLSubject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SAMLPassiveTokenIssuer
extends SAMLTokenIssuer {
    private SAMLTokenIssuerConfig config = null;
    private RahasData data = null;
    private Element audienceRestriction = null;
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public void setConfig(SAMLTokenIssuerConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement issuePassiveRSTR(RahasData data) throws TrustException {
        try {
            OMElement oMElement;
            MessageContext inMsgCtx = data.getInMessageContext();
            this.data = data;
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)true);
            SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
            Crypto crypto = this.config.cryptoElement != null ? CryptoFactory.getInstance((Properties)TrustUtil.toProperties(this.config.cryptoElement), (ClassLoader)inMsgCtx.getAxisService().getClassLoader()) : (this.config.cryptoPropertiesElement != null && this.config.cryptoPropertiesElement.getFirstElement() != null ? CryptoFactory.getInstance((Properties)TrustUtil.toProperties(this.config.cryptoPropertiesElement.getFirstElement()), (ClassLoader)inMsgCtx.getAxisService().getClassLoader()) : CryptoFactory.getInstance((String)this.config.cryptoPropertiesFile, (ClassLoader)inMsgCtx.getAxisService().getClassLoader()));
            Date creationTime = new Date();
            Date expirationTime = new Date();
            expirationTime.setTime(creationTime.getTime() + this.config.ttl);
            Document doc = ((Element)env).getOwnerDocument();
            int keySize = data.getKeysize();
            keySize = keySize == -1 ? this.config.keySize : keySize;
            SAMLAssertion assertion = this.createBearerAssertion(this.config, doc, crypto, creationTime, expirationTime, data);
            OMElement rstrElem = null;
            OMElement rstrcElem = null;
            int wstVersion = data.getVersion();
            if (1 == wstVersion) {
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
            } else {
                rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, rstrcElem);
            }
            TrustUtil.createTokenTypeElement(wstVersion, rstrElem).setText("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            if (this.config.addRequestedAttachedRef) {
                this.createAttachedRef(rstrElem, assertion.getId(), wstVersion);
            }
            if (this.config.addRequestedUnattachedRef) {
                this.createUnattachedRef(rstrElem, assertion.getId(), wstVersion);
            }
            if (data.getAppliesToAddress() != null) {
                TrustUtil.createAppliesToElement(rstrElem, data.getAppliesToAddress(), data.getAddressingNs());
            }
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            TrustUtil.createLifetimeElement(wstVersion, rstrElem, zulu.format(creationTime), zulu.format(expirationTime));
            OMElement reqSecTokenElem = TrustUtil.createRequestedSecurityTokenElement(wstVersion, rstrElem);
            try {
                Node tempNode = assertion.toDOM();
                reqSecTokenElem.addChild((OMNode)((Element)rstrElem).getOwnerDocument().importNode(tempNode, true));
                Token assertionToken = new Token(assertion.getId(), (OMElement)assertion.toDOM(), creationTime, expirationTime);
                assertionToken.setSecret(data.getEphmeralKey());
                TrustUtil.getTokenStore(inMsgCtx).add(assertionToken);
            }
            catch (SAMLException e) {
                throw new TrustException("samlConverstionError", e);
            }
            if (rstrcElem != null) {
                oMElement = rstrcElem;
                return oMElement;
            }
            oMElement = rstrElem;
            return oMElement;
        }
        finally {
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
        }
    }

    protected SAMLAssertion createAuthAssertion(Document doc, String confMethod, SAMLNameIdentifier subjectNameId, Element keyInfoContent, SAMLTokenIssuerConfig config, Crypto crypto, Date notBefore, Date notAfter, String actAs) throws TrustException {
        try {
            SAMLCallbackHandler handler;
            SAMLAttributeCallback cb;
            String[] confirmationMethods = new String[]{confMethod};
            Element keyInfoElem = null;
            if (keyInfoContent != null) {
                keyInfoElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
                ((OMElement)keyInfoContent).declareNamespace("http://www.w3.org/2000/09/xmldsig#", "ds");
                ((OMElement)keyInfoContent).declareNamespace("http://www.w3.org/2001/04/xmlenc#", "xenc");
                keyInfoElem.appendChild(keyInfoContent);
            }
            SAMLSubject subject = new SAMLSubject(subjectNameId, Arrays.asList(confirmationMethods), null, (Object)keyInfoElem);
            ArrayList<SAMLAttributeStatement> statements = new ArrayList<SAMLAttributeStatement>();
            SAMLAttribute[] attrs = null;
            if (config.getCallbackHander() != null) {
                cb = new SAMLAttributeCallback(this.data);
                handler = config.getCallbackHander();
                handler.handle(cb);
                attrs = cb.getAttributes();
            } else if (config.getCallbackHandlerName() != null && config.getCallbackHandlerName().trim().length() > 0) {
                cb = new SAMLAttributeCallback(this.data);
                handler = null;
                MessageContext msgContext = this.data.getInMessageContext();
                ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
                Class cbClass = null;
                try {
                    cbClass = Loader.loadClass((ClassLoader)classLoader, (String)config.getCallbackHandlerName());
                }
                catch (ClassNotFoundException e) {
                    throw new TrustException("cannotLoadPWCBClass", new String[]{config.getCallbackHandlerName()}, e);
                }
                try {
                    handler = (SAMLCallbackHandler)cbClass.newInstance();
                }
                catch (Exception e) {
                    throw new TrustException("cannotCreatePWCBInstance", new String[]{config.getCallbackHandlerName()}, e);
                }
                handler.handle(cb);
                attrs = cb.getAttributes();
            } else {
                SAMLAttribute attribute = new SAMLAttribute("Name", "https://rahas.apache.org/saml/attrns", null, -1L, Arrays.asList("Colombo/Rahas"));
                attrs = new SAMLAttribute[]{attribute};
            }
            List<SAMLAttribute> attributeList = Arrays.asList(attrs);
            if (this.data.getActAs() != null) {
                SAMLAttribute actAsAttribute = new SAMLAttribute("ActAs", "https://rahas.apache.org/saml/attrns", null, -1L, Arrays.asList(this.data.getActAs()));
                attributeList.add(actAsAttribute);
            }
            SAMLAttributeStatement attrStmt = new SAMLAttributeStatement(subject, attributeList);
            statements.add(attrStmt);
            ArrayList<SAMLCondition> conditions = null;
            if (this.audienceRestriction != null) {
                SAMLCondition condition = SAMLCondition.getInstance((Element)this.audienceRestriction);
                conditions = new ArrayList<SAMLCondition>();
                conditions.add(condition);
            }
            SAMLAssertion assertion = new SAMLAssertion(config.issuerName, notBefore, notAfter, conditions, null, statements);
            X509Certificate[] issuerCerts = crypto.getCertificates(config.issuerKeyAlias);
            String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
            if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
            PrivateKey issuerPK = crypto.getPrivateKey(config.issuerKeyAlias, config.issuerKeyPassword);
            assertion.sign(sigAlgo, (Key)issuerPK, Arrays.asList(issuerCerts));
            return assertion;
        }
        catch (Exception e) {
            throw new TrustException("samlAssertionCreationError", e);
        }
    }

    public void setAudienceRestrictionCondition(String uri) throws TrustException {
        String audienceRestrictionXmlString = "<saml1:AudienceRestrictionCondition xmlns:saml1=\"urn:oasis:names:tc:SAML:1.0:assertion\"><saml1:Audience>" + uri + "</saml1:Audience></saml1:AudienceRestrictionCondition>";
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(audienceRestrictionXmlString)));
            this.audienceRestriction = document.getDocumentElement();
        }
        catch (Exception e) {
            throw new TrustException("samlAssertionCreationError");
        }
    }
}

