/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisService2WSDL11;
import org.apache.axis2.description.AxisService2WSDL20;
import org.apache.axis2.description.java2wsdl.DefaultNamespaceGenerator;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.axis2.description.java2wsdl.DocLitBareSchemaGenerator;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.axis2.description.java2wsdl.Java2WSDLUtils;
import org.apache.axis2.description.java2wsdl.NamespaceGenerator;
import org.apache.axis2.description.java2wsdl.SchemaGenerator;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.XMLPrettyPrinter;

public class Java2WSDLBuilder
implements Java2WSDLConstants {
    public static final String ALL = "all";
    private OutputStream out;
    private String className;
    private ClassLoader classLoader;
    private String wsdlPrefix = "wsdl";
    private String serviceName = null;
    private String targetNamespace = null;
    private String targetNamespacePrefix = null;
    private String attrFormDefault = null;
    private String elementFormDefault = null;
    private String schemaTargetNamespace = null;
    private String schemaTargetNamespacePrefix = null;
    private String style = "document";
    private String use = "literal";
    private String locationUri;
    private ArrayList<String> extraClasses;
    private boolean nillableElementsAllowed = true;
    private String nsGenClassName = null;
    private Map<String, String> pkg2nsMap = null;
    private boolean pretty = true;
    private String wsdlVersion = "1.1";
    private String schemaGenClassName = null;
    private boolean generateDocLitBare = false;
    private AxisConfiguration axisConfig;
    private String customSchemaLocation;
    private String mappingFileLocation;
    private HashMap<String, MessageReceiver> messageReceivers = null;
    private boolean disableSOAP11 = false;
    private boolean disableSOAP12 = false;
    private boolean disableREST = false;
    private String messagePartName;
    private String portTypeName;
    private String soap11BindingName;
    private String soap12BindingName;
    private String restBindingName;
    private String requestElementSuffix;
    private boolean anonymousTypesAllowed = true;

    public Java2WSDLBuilder() {
        try {
            ConfigurationContext configCtx = ConfigurationContextFactory.createDefaultConfigurationContext();
            this.axisConfig = configCtx.getAxisConfiguration();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Java2WSDLBuilder(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public Java2WSDLBuilder(OutputStream out, String className, ClassLoader classLoader) {
        try {
            ConfigurationContext configCtx = ConfigurationContextFactory.createDefaultConfigurationContext();
            this.axisConfig = configCtx.getAxisConfiguration();
            this.out = out;
            this.className = className;
            this.classLoader = classLoader;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Java2WSDLBuilder(OutputStream out, String className, ClassLoader classLoader, HashMap<String, MessageReceiver> messageReceivers) {
        this(out, className, classLoader);
        this.messageReceivers = messageReceivers;
    }

    public String getSchemaTargetNamespace() throws Exception {
        if (this.schemaTargetNamespace == null) {
            this.schemaTargetNamespace = Java2WSDLUtils.schemaNamespaceFromClassName(this.className, this.classLoader, this.resolveNSGen()).toString();
        }
        return this.schemaTargetNamespace;
    }

    public String getStyle() {
        return this.style;
    }

    public String getLocationUri() {
        return this.locationUri;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public void setSchemaTargetNamespace(String schemaTargetNamespace) {
        this.schemaTargetNamespace = schemaTargetNamespace;
    }

    public String getSchemaTargetNamespacePrefix() {
        if (this.schemaTargetNamespacePrefix == null) {
            this.schemaTargetNamespacePrefix = "ns";
        }
        return this.schemaTargetNamespacePrefix;
    }

    public void setSchemaTargetNamespacePrefix(String schemaTargetNamespacePrefix) {
        this.schemaTargetNamespacePrefix = schemaTargetNamespacePrefix;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getTargetNamespacePrefix() {
        if (this.targetNamespacePrefix == null) {
            this.targetNamespacePrefix = "tns";
        }
        return this.targetNamespacePrefix;
    }

    public void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getWsdlPrefix() {
        return this.wsdlPrefix;
    }

    public void setWsdlPrefix(String wsdlPrefix) {
        this.wsdlPrefix = wsdlPrefix;
    }

    public boolean isGenerateDocLitBare() {
        return this.generateDocLitBare;
    }

    public void setGenerateDocLitBare(boolean generateDocLitBare) {
        this.generateDocLitBare = generateDocLitBare;
    }

    public void generateWSDL() throws Exception {
        Object g;
        String uri;
        SchemaGenerator schemaGenerator = this.resolveSchemaGen(this.classLoader, this.className, this.getSchemaTargetNamespace(), this.getSchemaTargetNamespacePrefix());
        ArrayList<String> excludedOperation = new ArrayList<String>();
        org.apache.axis2.deployment.util.Utils.addExcludeMethods(excludedOperation);
        schemaGenerator.setExcludeMethods(excludedOperation);
        schemaGenerator.setAttrFormDefault(this.getAttrFormDefault());
        schemaGenerator.setElementFormDefault(this.getElementFormDefault());
        schemaGenerator.setExtraClasses(this.getExtraClasses());
        schemaGenerator.setNsGen(this.resolveNSGen());
        schemaGenerator.setPkg2nsmap(this.getPkg2nsMap());
        schemaGenerator.setMappingFileLocation(this.getMappingFileLocation());
        schemaGenerator.setCustomSchemaLocation(this.getCustomSchemaLocation());
        if (this.getPkg2nsMap() != null && !this.getPkg2nsMap().isEmpty() && (this.getPkg2nsMap().containsKey(ALL) || this.getPkg2nsMap().containsKey(ALL.toUpperCase()))) {
            schemaGenerator.setUseWSDLTypesNamespace(true);
        }
        if (this.messageReceivers == null) {
            this.messageReceivers = new HashMap();
            Class inOnlyMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
            MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
            Class inoutMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
            MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/in-out", inOutmessageReceiver);
        }
        AxisService service = new AxisService();
        if (!this.nillableElementsAllowed) {
            service.addParameter("disallowNillableElements", "true");
        }
        if (this.messagePartName != null) {
            service.addParameter("messagePartName", this.messagePartName);
        }
        if (this.portTypeName != null) {
            service.addParameter("portTypeName", this.portTypeName);
        }
        if (this.soap11BindingName != null) {
            service.addParameter("soap11BindingName", this.soap11BindingName);
        }
        if (this.soap12BindingName != null) {
            service.addParameter("soap12BindingName", this.soap12BindingName);
        }
        if (this.restBindingName != null) {
            service.addParameter("restBindingName", this.restBindingName);
        }
        if (this.messagePartName != null) {
            service.addParameter("messagePartName", this.messagePartName);
        }
        if (this.requestElementSuffix != null) {
            service.addParameter("requestElementSuffix", this.requestElementSuffix);
        }
        if (!this.anonymousTypesAllowed) {
            service.addParameter("disallowAnonymousTypes", "true");
        }
        schemaGenerator.setAxisService(service);
        AxisService axisService = AxisService.createService(this.className, this.serviceName == null ? Java2WSDLUtils.getSimpleClassName(this.className) : this.serviceName, this.axisConfig, this.messageReceivers, this.targetNamespace == null ? Java2WSDLUtils.namespaceFromClassName(this.className, this.classLoader, this.resolveNSGen()).toString() : this.targetNamespace, this.classLoader, schemaGenerator, service);
        schemaGenerator.setAxisService(axisService);
        axisService.setTargetNamespacePrefix(this.getTargetNamespacePrefix());
        axisService.setSchemaTargetNamespace(this.getSchemaTargetNamespace());
        axisService.setSchemaTargetNamespacePrefix(this.getSchemaTargetNamespacePrefix());
        if (this.disableREST) {
            axisService.addParameter("disableREST", this.disableREST);
        }
        if (this.disableSOAP11) {
            axisService.addParameter("disableSOAP11", this.disableSOAP11);
        }
        if (this.disableSOAP12) {
            axisService.addParameter("disableSOAP12", this.disableSOAP12);
        }
        if ((uri = this.locationUri) == null) {
            uri = "http://localhost:8080/axis2/services/" + (this.serviceName == null ? Java2WSDLUtils.getSimpleClassName(this.className) : this.serviceName);
        }
        this.setServiceEPR(axisService, uri);
        this.axisConfig.addService(axisService);
        if ("1.1".equals(this.wsdlVersion)) {
            g = new AxisService2WSDL11(axisService);
            ((AxisService2WSDL11)g).setStyle(this.style);
            ((AxisService2WSDL11)g).setUse(this.use);
            OMElement wsdlElement = ((AxisService2WSDL11)g).generateOM();
            if (!this.isPretty()) {
                wsdlElement.serialize(this.out);
            } else {
                XMLPrettyPrinter.prettify(wsdlElement, this.out);
            }
        } else {
            g = new AxisService2WSDL20(axisService);
            OMElement wsdlElement = ((AxisService2WSDL20)g).generateOM();
            if (!this.isPretty()) {
                wsdlElement.serialize(this.out);
            } else {
                XMLPrettyPrinter.prettify(wsdlElement, this.out);
            }
        }
        this.out.flush();
        this.out.close();
    }

    public String getAttrFormDefault() {
        return this.attrFormDefault;
    }

    public void setAttrFormDefault(String attrFormDefault) {
        this.attrFormDefault = attrFormDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public ArrayList<String> getExtraClasses() {
        return this.extraClasses;
    }

    public void setExtraClasses(ArrayList<String> extraClasses) {
        this.extraClasses = extraClasses;
    }

    public String getNsGenClassName() {
        return this.nsGenClassName;
    }

    public void setNsGenClassName(String nsGenClassName) {
        this.nsGenClassName = nsGenClassName;
    }

    public String getSchemaGenClassName() {
        return this.schemaGenClassName;
    }

    public void setSchemaGenClassName(String schemaGenClassName) {
        this.schemaGenClassName = schemaGenClassName;
    }

    public Map<String, String> getPkg2nsMap() {
        return this.pkg2nsMap;
    }

    public void setPkg2nsMap(Map<String, String> pkg2nsMap) {
        this.pkg2nsMap = pkg2nsMap;
    }

    private NamespaceGenerator resolveNSGen() {
        NamespaceGenerator nsGen;
        if (this.nsGenClassName == null) {
            nsGen = new DefaultNamespaceGenerator();
        } else {
            try {
                nsGen = (NamespaceGenerator)Class.forName(this.nsGenClassName).newInstance();
            }
            catch (Exception e) {
                nsGen = new DefaultNamespaceGenerator();
            }
        }
        return nsGen;
    }

    private SchemaGenerator resolveSchemaGen(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix) throws Exception {
        SchemaGenerator schemaGen;
        if (this.schemaGenClassName == null) {
            schemaGen = this.generateDocLitBare ? new DocLitBareSchemaGenerator(loader, className, schematargetNamespace, schematargetNamespacePrefix, null) : new DefaultSchemaGenerator(loader, className, schematargetNamespace, schematargetNamespacePrefix, null);
        } else {
            try {
                Class<?> clazz = Class.forName(this.schemaGenClassName);
                Constructor<?> constructor = clazz.getConstructor(ClassLoader.class, String.class, String.class, String.class);
                schemaGen = (SchemaGenerator)constructor.newInstance(loader, className, schematargetNamespace, schematargetNamespacePrefix);
            }
            catch (Exception e) {
                schemaGen = this.generateDocLitBare ? new DocLitBareSchemaGenerator(loader, className, schematargetNamespace, schematargetNamespacePrefix, null) : new DefaultSchemaGenerator(loader, className, schematargetNamespace, schematargetNamespacePrefix, null);
            }
        }
        return schemaGen;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public void setWSDLVersion(String wsdlVersion) {
        this.wsdlVersion = wsdlVersion;
    }

    private void setServiceEPR(AxisService axisService, String urlString) throws Exception {
        org.apache.axis2.deployment.util.Utils.addSoap11Endpoint(axisService, urlString);
        org.apache.axis2.deployment.util.Utils.addSoap12Endpoint(axisService, urlString);
        if ("http".equals(Utils.getURIScheme(urlString))) {
            org.apache.axis2.deployment.util.Utils.addHttpEndpoint(axisService, urlString);
        }
    }

    public String getCustomSchemaLocation() {
        return this.customSchemaLocation;
    }

    public void setCustomSchemaLocation(String customSchemaLocation) {
        this.customSchemaLocation = customSchemaLocation;
    }

    public String getMappingFileLocation() {
        return this.mappingFileLocation;
    }

    public void setMappingFileLocation(String mappingFileLocation) {
        this.mappingFileLocation = mappingFileLocation;
    }

    public boolean isNillableElementsAllowed() {
        return this.nillableElementsAllowed;
    }

    public void setNillableElementsAllowed(boolean nillableElementsAllowed) {
        this.nillableElementsAllowed = nillableElementsAllowed;
    }

    public boolean isDisableREST() {
        return this.disableREST;
    }

    public void setDisableREST(boolean disableREST) {
        this.disableREST = disableREST;
    }

    public boolean isDisableSOAP12() {
        return this.disableSOAP12;
    }

    public void setDisableSOAP12(boolean disableSOAP12) {
        this.disableSOAP12 = disableSOAP12;
    }

    public boolean isDisableSOAP11() {
        return this.disableSOAP11;
    }

    public void setDisableSOAP11(boolean disableSOAP11) {
        this.disableSOAP11 = disableSOAP11;
    }

    public String getMessagePartName() {
        return this.messagePartName;
    }

    public void setMessagePartName(String messagePartName) {
        this.messagePartName = messagePartName;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String portTypeName) {
        this.portTypeName = portTypeName;
    }

    public String getSoap11BindingName() {
        return this.soap11BindingName;
    }

    public void setSoap11BindingName(String soap11BindingName) {
        this.soap11BindingName = soap11BindingName;
    }

    public String getSoap12BindingName() {
        return this.soap12BindingName;
    }

    public void setSoap12BindingName(String soap12BindingName) {
        this.soap12BindingName = soap12BindingName;
    }

    public String getRestBindingName() {
        return this.restBindingName;
    }

    public void setRestBindingName(String restBindingName) {
        this.restBindingName = restBindingName;
    }

    public String getRequestElementSuffix() {
        return this.requestElementSuffix;
    }

    public void setRequestElementSuffix(String requestElementSuffix) {
        this.requestElementSuffix = requestElementSuffix;
    }

    public boolean isAnonymousTypesAllowed() {
        return this.anonymousTypesAllowed;
    }

    public void setAnonymousTypesAllowed(boolean anonymousTypesAllowed) {
        this.anonymousTypesAllowed = anonymousTypesAllowed;
    }
}

