/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.axis2.transport.base.ProtocolEndpoint;
import org.apache.axis2.util.Utils;

public class TCPEndpoint
extends ProtocolEndpoint {
    private String host = null;
    private int port = -1;
    private int backlog = 50;
    private String contentType;

    public TCPEndpoint() {
    }

    public TCPEndpoint(String host, int port, int backlog) {
        this.host = host;
        this.port = port;
        this.backlog = backlog;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean loadConfiguration(ParameterInclude params) throws AxisFault {
        this.port = ParamUtils.getOptionalParamInt(params, "transport.tcp.port", -1);
        if (this.port == -1) {
            return false;
        }
        this.contentType = ParamUtils.getOptionalParam(params, "transport.tcp.contentType");
        if (this.contentType == null) {
            this.contentType = "text/xml";
        }
        this.host = ParamUtils.getOptionalParam(params, "transport.tcp.hostname");
        this.backlog = ParamUtils.getOptionalParamInt(params, "transport.tcp.backlog", 50);
        return true;
    }

    @Override
    public EndpointReference[] getEndpointReferences(AxisService service, String ip) throws AxisFault {
        if (this.host == null && ip == null) {
            try {
                ip = Utils.getIpAddress(this.getListener().getConfigurationContext().getAxisConfiguration());
            }
            catch (SocketException ex) {
                throw new AxisFault("Unable to determine the host's IP address", ex);
            }
        }
        String url = "tcp://" + (this.host != null ? this.host : ip) + ":" + this.port;
        String context = this.getListener().getConfigurationContext().getServiceContextPath();
        url = url + (context.startsWith("/") ? "" : "/") + context + (context.endsWith("/") ? "" : "/") + (this.getService() == null ? service.getName() : this.getServiceName());
        if (!this.contentType.equals("text/xml")) {
            url = url + "?contentType=" + this.contentType;
        }
        return new EndpointReference[]{new EndpointReference(url)};
    }
}

