/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarInputStream;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceProvider;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMap;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMapManager;
import org.apache.axis2.jaxws.addressing.util.EndpointKey;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.apache.axis2.util.Loader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXWSDeployer
extends AbstractDeployer {
    private static Log log = LogFactory.getLog(JAXWSDeployer.class);
    protected ConfigurationContext configCtx;
    protected AxisConfiguration axisConfig;
    private String directory;

    @Override
    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
        this.deployServicesInWARClassPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployServicesInWARClassPath() {
        String dir = DeploymentEngine.getWebLocationString();
        if (dir != null) {
            File file = new File(dir + "/WEB-INF/classes/");
            URL repository = this.axisConfig.getRepository();
            if (!file.isDirectory() || repository == null) {
                return;
            }
            ArrayList<String> classList = this.getClassesInWebInfDirectory(file);
            ClassLoader threadClassLoader = null;
            try {
                threadClassLoader = Thread.currentThread().getContextClassLoader();
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(repository);
                String webLocation = DeploymentEngine.getWebLocationString();
                if (webLocation != null) {
                    urls.add(new File(webLocation).toURL());
                }
                ClassLoader classLoader = Utils.createClassLoader(urls, this.axisConfig.getSystemClassLoader(), true, (File)this.axisConfig.getParameterValue("artifactsDIR"), this.axisConfig.isChildFirstClassLoading());
                Thread.currentThread().setContextClassLoader(classLoader);
                this.deployClasses("JAXWS-Builtin", file.toURL(), Thread.currentThread().getContextClassLoader(), classList);
            }
            catch (NoClassDefFoundError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage("deployingexception", e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                log.info((Object)Messages.getMessage("deployingexception", e.getMessage()), (Throwable)e);
            }
            finally {
                if (threadClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                }
            }
        }
    }

    protected ArrayList<String> getClassesInWebInfDirectory(File file) {
        String filePath = file.getAbsolutePath();
        Collection files = FileUtils.listFiles((File)file, (String[])new String[]{"class"}, (boolean)true);
        ArrayList<String> classList = new ArrayList<String>();
        for (File f : files) {
            String fPath = f.getAbsolutePath();
            String fqcn = fPath.substring(filePath.length() + 1);
            fqcn = fqcn.substring(0, fqcn.length() - ".class".length());
            fqcn = fqcn.replace('/', '.');
            fqcn = fqcn.replace('\\', '.');
            classList.add(fqcn);
        }
        return classList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(DeploymentFileData deploymentFileData) {
        ClassLoader threadClassLoader = null;
        try {
            threadClassLoader = Thread.currentThread().getContextClassLoader();
            String groupName = deploymentFileData.getName();
            URL location = deploymentFileData.getFile().toURL();
            if (JAXWSDeployer.isJar(deploymentFileData.getFile())) {
                log.info((Object)("Deploying artifact : " + deploymentFileData.getAbsolutePath()));
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(deploymentFileData.getFile().toURL());
                urls.add(this.axisConfig.getRepository());
                this.addJaxwsLibs(urls, this.axisConfig.getRepository().getPath() + this.directory);
                String webLocation = DeploymentEngine.getWebLocationString();
                if (webLocation != null) {
                    urls.add(new File(webLocation).toURL());
                }
                ClassLoader classLoader = Utils.createClassLoader(urls, this.axisConfig.getSystemClassLoader(), true, (File)this.axisConfig.getParameterValue("artifactsDIR"), this.axisConfig.isChildFirstClassLoading());
                Thread.currentThread().setContextClassLoader(classLoader);
                List<String> classList = Utils.getListOfClasses(deploymentFileData);
                AxisServiceGroup serviceGroup = this.deployClasses(groupName, location, classLoader, classList);
                if (serviceGroup == null) {
                    String msg = "Error while deploying JAX-WS jar: " + location.toString() + ". JAX-WS Service deployment failed.";
                    log.error((Object)msg);
                    this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), msg);
                }
            }
            super.deploy(deploymentFileData);
        }
        catch (Throwable t) {
            log.debug((Object)Messages.getMessage("stroringfaultyservice", t.getMessage()), t);
            this.storeFaultyService(deploymentFileData, t);
        }
        finally {
            if (threadClassLoader != null) {
                Thread.currentThread().setContextClassLoader(threadClassLoader);
            }
        }
    }

    protected AxisServiceGroup deployClasses(String groupName, URL location, ClassLoader classLoader, List<String> classList) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        ArrayList<AxisService> axisServiceList = new ArrayList<AxisService>();
        String serviceHierarchy = Utils.getServiceHierarchy(location.getPath(), this.directory);
        for (String className : classList) {
            AxisService axisService;
            Class pojoClass;
            try {
                pojoClass = Loader.loadClass(classLoader, className);
            }
            catch (Exception e) {
                continue;
            }
            WebService wsAnnotation = pojoClass.getAnnotation(WebService.class);
            WebServiceProvider wspAnnotation = null;
            if (wsAnnotation == null) {
                wspAnnotation = pojoClass.getAnnotation(WebServiceProvider.class);
            }
            if (wsAnnotation == null && wspAnnotation == null || pojoClass.isInterface() || (axisService = this.createAxisService(classLoader, className, location)) == null) continue;
            log.info((Object)("Deploying JAXWS annotated class " + className + " as a service - " + serviceHierarchy + axisService.getName()));
            axisServiceList.add(axisService);
        }
        int size = axisServiceList.size();
        if (size <= 0) {
            return null;
        }
        AxisServiceGroup serviceGroup = new AxisServiceGroup();
        serviceGroup.setServiceGroupName(serviceHierarchy + groupName);
        for (AxisService axisService : axisServiceList) {
            axisService.setName(serviceHierarchy + axisService.getName());
            serviceGroup.addService(axisService);
        }
        this.axisConfig.addServiceGroup(serviceGroup);
        this.configureAddressing(serviceGroup);
        return serviceGroup;
    }

    protected void storeFaultyService(DeploymentFileData deploymentFileData, Throwable t) {
        StringWriter errorWriter = new StringWriter();
        PrintWriter ptintWriter = new PrintWriter(errorWriter);
        t.printStackTrace(ptintWriter);
        String error = "Error:\n" + errorWriter.toString();
        this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), error);
    }

    protected AxisService createAxisService(ClassLoader classLoader, String className, URL serviceLocation) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        AxisService axisService;
        Class pojoClass = Loader.loadClass(classLoader, className);
        try {
            axisService = DescriptionFactory.createAxisService(pojoClass, this.configCtx);
        }
        catch (Throwable t) {
            log.info((Object)("Exception creating Axis Service : " + t.getCause()), t);
            return null;
        }
        if (axisService != null) {
            Iterator<AxisOperation> operations = axisService.getOperations();
            while (operations.hasNext()) {
                AxisOperation axisOperation = operations.next();
                if (axisOperation.getMessageReceiver() != null) continue;
                axisOperation.setMessageReceiver(new JAXWSMessageReceiver());
            }
            axisService.addParameter("serviceType", "jaxws");
            axisService.setElementFormDefault(false);
            axisService.setFileName(serviceLocation);
            axisService.setClassLoader(classLoader);
            axisService.addParameter(new Parameter("CACHE_CLASSLOADER", classLoader));
            axisService.addParameter(new Parameter("modifyUserWSDLPortAddress", "true"));
        }
        return axisService;
    }

    @Override
    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public void setExtension(String extension) {
    }

    @Override
    public void undeploy(String fileName) {
        String serviceHierarchy = Utils.getServiceHierarchy(fileName, this.directory);
        fileName = serviceHierarchy + Utils.getShortFileName(fileName);
        try {
            AxisServiceGroup serviceGroup = this.axisConfig.removeServiceGroup(fileName);
            if (this.configCtx != null) {
                this.configCtx.removeServiceGroupContext(serviceGroup);
            }
            super.undeploy(fileName);
            log.info((Object)Messages.getMessage("serviceremoved", fileName));
        }
        catch (AxisFault axisFault) {
            log.debug((Object)Messages.getMessage("faultyserviceremoval", axisFault.getMessage()), (Throwable)axisFault);
            this.axisConfig.removeFaultyService(fileName);
        }
    }

    public static boolean isJar(File f) {
        try {
            JarInputStream jis = new JarInputStream(new FileInputStream(f));
            if (jis.getNextEntry() != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    private void configureAddressing(AxisServiceGroup serviceGroup) {
        EndpointContextMap map = (EndpointContextMap)this.configCtx.getProperty("org.apache.axis2.jaxws.addressing.util.EndpointContextMap");
        if (map == null) {
            map = EndpointContextMapManager.getEndpointContextMap();
            this.configCtx.setProperty("org.apache.axis2.jaxws.addressing.util.EndpointContextMap", map);
        }
        Iterator<AxisService> iterator = serviceGroup.getServices();
        while (iterator.hasNext()) {
            AxisService axisService = iterator.next();
            Parameter param = axisService.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
            EndpointDescription ed = (EndpointDescription)param.getValue();
            QName serviceName = ed.getServiceQName();
            QName portName = ed.getPortQName();
            EndpointKey key = new EndpointKey(serviceName, portName);
            map.put(key, axisService);
        }
    }

    private void addJaxwsLibs(ArrayList<URL> urls, String jaxwsDepDirPath) throws Exception {
        File jaxwsDepDirLib = new File(jaxwsDepDirPath + File.separator + "lib");
        if (jaxwsDepDirLib.exists() && jaxwsDepDirLib.isDirectory()) {
            for (File file : jaxwsDepDirLib.listFiles()) {
                if (!file.isFile()) continue;
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new Exception("Error while loading libraries from the 'lib' directory under jaxws deployment direcotry.", e);
                }
            }
        }
    }
}

