/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.util;

import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.KeyGenerator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.client.MexClient;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.mex.MexException;
import org.apache.axis2.mex.om.Metadata;
import org.apache.axis2.mex.om.MetadataReference;
import org.apache.axis2.mex.om.MetadataSection;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.client.STSClient;
import org.apache.rampart.PolicyBasedResultsValidator;
import org.apache.rampart.PolicyValidatorCallbackHandler;
import org.apache.rampart.RampartConfigCallbackHandler;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.SupportingPolicyData;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.util.Axis2Util;
import org.apache.ws.secpolicy.model.HttpsToken;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Wss11;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.ConversationConstants;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.jaxen.JaxenException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RampartUtil {
    private static final String CRYPTO_PROVIDER = "org.apache.ws.security.crypto.provider";
    private static Log log = LogFactory.getLog(RampartUtil.class);
    private static Map<String, CachedCrypto> cryptoStore = new ConcurrentHashMap<String, CachedCrypto>();

    public static CallbackHandler getPasswordCB(RampartMessageData rmd) throws RampartException {
        MessageContext msgContext = rmd.getMsgContext();
        RampartPolicyData rpd = rmd.getPolicyData();
        return RampartUtil.getPasswordCB(msgContext, rpd);
    }

    public static CallbackHandler getPasswordCB(MessageContext msgContext, RampartPolicyData rpd) throws RampartException {
        Parameter param;
        CallbackHandler cbHandler;
        if (rpd.getRampartConfig() != null && rpd.getRampartConfig().getPwCbClass() != null) {
            Class cbClass;
            String cbHandlerClass = rpd.getRampartConfig().getPwCbClass();
            ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading class : " + cbHandlerClass));
            }
            try {
                cbClass = Loader.loadClass((ClassLoader)classLoader, (String)cbHandlerClass);
            }
            catch (ClassNotFoundException e) {
                throw new RampartException("cannotLoadPWCBClass", new String[]{cbHandlerClass}, e);
            }
            try {
                cbHandler = (CallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new RampartException("cannotCreatePWCBInstance", new String[]{cbHandlerClass}, e);
            }
        }
        cbHandler = (CallbackHandler)msgContext.getProperty("passwordCallbackRef");
        if (cbHandler == null && (param = msgContext.getParameter("passwordCallbackRef")) != null) {
            cbHandler = (CallbackHandler)param.getValue();
        }
        return cbHandler;
    }

    public static PolicyValidatorCallbackHandler getPolicyValidatorCB(MessageContext msgContext, RampartPolicyData rpd) throws RampartException {
        PolicyValidatorCallbackHandler cbHandler;
        if (rpd.getRampartConfig() != null && rpd.getRampartConfig().getPolicyValidatorCbClass() != null) {
            Class cbClass;
            String cbHandlerClass = rpd.getRampartConfig().getPolicyValidatorCbClass();
            ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading class : " + cbHandlerClass));
            }
            try {
                cbClass = Loader.loadClass((ClassLoader)classLoader, (String)cbHandlerClass);
            }
            catch (ClassNotFoundException e) {
                throw new RampartException("cannotLoadPolicyValidatorCbClass", new String[]{cbHandlerClass}, e);
            }
            try {
                cbHandler = (PolicyValidatorCallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new RampartException("cannotCreatePolicyValidatorCallbackInstance", new String[]{cbHandlerClass}, e);
            }
        }
        cbHandler = new PolicyBasedResultsValidator();
        return cbHandler;
    }

    public static RampartConfigCallbackHandler getRampartConfigCallbackHandler(MessageContext msgContext, RampartPolicyData rpd) throws RampartException {
        if (rpd.getRampartConfig() != null && rpd.getRampartConfig().getRampartConfigCbClass() != null) {
            RampartConfigCallbackHandler rampartConfigCB;
            Class cbClass;
            String cbHandlerClass = rpd.getRampartConfig().getRampartConfigCbClass();
            ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading class : " + cbHandlerClass));
            }
            try {
                cbClass = Loader.loadClass((ClassLoader)classLoader, (String)cbHandlerClass);
            }
            catch (ClassNotFoundException e) {
                throw new RampartException("cannotLoadRampartConfigCallbackClass", new String[]{cbHandlerClass}, e);
            }
            try {
                rampartConfigCB = (RampartConfigCallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new RampartException("cannotCreateRampartConfigCallbackInstance", new String[]{cbHandlerClass}, e);
            }
            return rampartConfigCB;
        }
        return null;
    }

    public static WSPasswordCallback performCallback(CallbackHandler cbHandler, String username, int doAction) throws RampartException {
        int reason = 0;
        switch (doAction) {
            case 1: 
            case 64: {
                reason = 2;
                break;
            }
            case 2: {
                reason = 3;
                break;
            }
            case 4: {
                reason = 4;
            }
        }
        WSPasswordCallback pwCb = new WSPasswordCallback(username, reason);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cbHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new RampartException("pwcbFailed", e);
        }
        return pwCb;
    }

    public static Crypto getEncryptionCrypto(RampartConfig config, ClassLoader loader) throws RampartException {
        log.debug((Object)"Loading encryption crypto");
        Crypto crypto = null;
        if (config != null && config.getEncrCryptoConfig() != null) {
            CryptoConfig cryptoConfig = config.getEncrCryptoConfig();
            String provider = cryptoConfig.getProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using provider: " + provider));
            }
            Properties prop = cryptoConfig.getProp();
            prop.put(CRYPTO_PROVIDER, provider);
            String cryptoKey = null;
            String interval = null;
            if (cryptoConfig.isCacheEnabled()) {
                if (cryptoConfig.getCryptoKey() != null) {
                    cryptoKey = prop.getProperty(cryptoConfig.getCryptoKey());
                    interval = cryptoConfig.getCacheRefreshInterval();
                } else if (provider.equals("org.apache.ws.security.components.crypto.Merlin")) {
                    cryptoKey = cryptoConfig.getProp().getProperty("org.apache.ws.security.crypto.merlin.file");
                }
            }
            if (cryptoKey != null) {
                crypto = RampartUtil.retrieveCryptoFromCache(cryptoKey.trim() + "#" + provider.trim(), interval);
            }
            if (crypto == null) {
                crypto = CryptoFactory.getInstance((Properties)prop, (ClassLoader)loader);
                if (cryptoKey != null) {
                    RampartUtil.cacheCrypto(cryptoKey.trim() + "#" + provider.trim(), crypto);
                }
            }
        } else {
            log.debug((Object)"Trying the signature crypto info");
            crypto = RampartUtil.getSignatureCrypto(config, loader);
        }
        return crypto;
    }

    public static Crypto getSignatureCrypto(RampartConfig config, ClassLoader loader) throws RampartException {
        log.debug((Object)"Loading Signature crypto");
        Crypto crypto = null;
        if (config != null && config.getSigCryptoConfig() != null) {
            CryptoConfig cryptoConfig = config.getSigCryptoConfig();
            String provider = cryptoConfig.getProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using provider: " + provider));
            }
            Properties prop = cryptoConfig.getProp();
            prop.put(CRYPTO_PROVIDER, provider);
            String cryptoKey = null;
            String interval = null;
            if (cryptoConfig.isCacheEnabled()) {
                if (cryptoConfig.getCryptoKey() != null) {
                    cryptoKey = prop.getProperty(cryptoConfig.getCryptoKey());
                    interval = cryptoConfig.getCacheRefreshInterval();
                } else if (provider.equals("org.apache.ws.security.components.crypto.Merlin")) {
                    cryptoKey = cryptoConfig.getProp().getProperty("org.apache.ws.security.crypto.merlin.file");
                }
            }
            if (cryptoKey != null) {
                crypto = RampartUtil.retrieveCryptoFromCache(cryptoKey.trim() + "#" + provider.trim(), interval);
            }
            if (crypto == null) {
                crypto = CryptoFactory.getInstance((Properties)prop, (ClassLoader)loader);
                if (cryptoKey != null) {
                    RampartUtil.cacheCrypto(cryptoKey.trim() + "#" + provider.trim(), crypto);
                }
            }
        }
        return crypto;
    }

    public static int getKeyIdentifier(X509Token token) throws RampartException {
        if (token.isRequireIssuerSerialReference()) {
            return 2;
        }
        if (token.isRequireThumbprintReference()) {
            return 8;
        }
        if (token.isRequireEmbeddedTokenReference()) {
            return 1;
        }
        throw new RampartException("unknownKeyRefSpeficier");
    }

    public static String processIssuerAddress(OMElement issuerAddress) throws RampartException {
        if (issuerAddress == null) {
            throw new RampartException("invalidIssuerAddress", new String[]{"Issuer address null"});
        }
        if (issuerAddress.getText() == null || "".equals(issuerAddress.getText())) {
            throw new RampartException("invalidIssuerAddress", new String[]{issuerAddress.toString()});
        }
        return issuerAddress.getText().trim();
    }

    public static Policy getPolicyFromMetadataRef(OMElement mex) throws RampartException {
        try {
            Metadata metadata = new Metadata();
            metadata.fromOM(mex.getFirstElement());
            MetadataSection[] metadataSections = metadata.getMetadatSections();
            MetadataReference reference = metadataSections[0].getMetadataReference();
            MexClient serviceClient = new MexClient();
            Options options = serviceClient.getOptions();
            options.setTo(reference.getEPR());
            options.setAction("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request");
            OMElement request = serviceClient.setupGetMetadataRequest("http://schemas.xmlsoap.org/ws/2004/09/policy", null);
            OMElement result = serviceClient.sendReceive(request);
            metadata.fromOM(result);
            MetadataSection[] mexSecs = metadata.getMetadataSection("http://schemas.xmlsoap.org/ws/2004/09/policy", null);
            OMElement policyElement = (OMElement)mexSecs[0].getInlineData();
            return PolicyEngine.getPolicy((OMElement)policyElement);
        }
        catch (MexException e) {
            throw new RampartException("Error Retrieving the policy from mex", e);
        }
        catch (AxisFault e) {
            throw new RampartException("Error Retrieving the policy from mex", e);
        }
    }

    public static Policy addRampartConfig(RampartMessageData rmd, Policy policy) {
        RampartConfig servicRampConf = rmd.getPolicyData().getRampartConfig();
        RampartConfig stsRampConf = new RampartConfig();
        stsRampConf.setUser(servicRampConf.getUser());
        stsRampConf.setSigCryptoConfig(servicRampConf.getSigCryptoConfig());
        stsRampConf.setPwCbClass(servicRampConf.getPwCbClass());
        stsRampConf.setEncryptionUser(servicRampConf.getStsAlias());
        stsRampConf.setEncrCryptoConfig(servicRampConf.getStsCryptoConfig());
        policy.addAssertion((Assertion)stsRampConf);
        return policy;
    }

    public static OMElement createRSTTempalteForSCT(int conversationVersion, int wstVersion) throws RampartException {
        try {
            log.debug((Object)"Creating RSTTemplate for an SCT request");
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace wspNs = fac.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
            OMElement rstTempl = fac.createOMElement("RequestSecurityTokenTemplate", wspNs);
            OMElement tokenTypeElem = TrustUtil.createTokenTypeElement((int)wstVersion, (OMElement)rstTempl);
            String tokenType = ConversationConstants.getWSCNs((int)conversationVersion) + "/sct";
            tokenTypeElem.setText(tokenType);
            return rstTempl;
        }
        catch (TrustException e) {
            throw new RampartException("errorCreatingRSTTemplateForSCT", e);
        }
        catch (ConversationException e) {
            throw new RampartException("errorCreatingRSTTemplateForSCT", e);
        }
    }

    public static int getTimeToLive(RampartMessageData messageData) {
        RampartConfig rampartConfig = messageData.getPolicyData().getRampartConfig();
        if (rampartConfig != null) {
            String ttl = rampartConfig.getTimestampTTL();
            int ttl_i = 0;
            if (ttl != null) {
                try {
                    ttl_i = Integer.parseInt(ttl);
                }
                catch (NumberFormatException e) {
                    ttl_i = messageData.getTimeToLive();
                }
            }
            if (ttl_i <= 0) {
                ttl_i = messageData.getTimeToLive();
            }
            return ttl_i;
        }
        return 300;
    }

    public static int getTimestampMaxSkew(RampartMessageData messageData) {
        RampartConfig rampartConfig = messageData.getPolicyData().getRampartConfig();
        if (rampartConfig != null) {
            String maxSkew = rampartConfig.getTimestampMaxSkew();
            int maxSkew_i = 0;
            if (maxSkew != null) {
                try {
                    maxSkew_i = Integer.parseInt(maxSkew);
                }
                catch (NumberFormatException e) {
                    maxSkew_i = messageData.getTimestampMaxSkew();
                }
            }
            if (maxSkew_i < 0) {
                maxSkew_i = 0;
            }
            return maxSkew_i;
        }
        return 300;
    }

    public static String getSecConvToken(RampartMessageData rmd, SecureConversationToken secConvTok) throws TrustException, RampartException {
        String action = TrustUtil.getActionValue((int)rmd.getWstVersion(), (String)"/RST/SCT");
        OMElement issuerEpr = secConvTok.getIssuerEpr();
        String issuerEprAddress = rmd.getMsgContext().getTo().getAddress();
        if (issuerEpr != null) {
            issuerEprAddress = RampartUtil.processIssuerAddress(issuerEpr);
        }
        int conversationVersion = rmd.getSecConvVersion();
        OMElement rstTemplate = RampartUtil.createRSTTempalteForSCT(conversationVersion, rmd.getWstVersion());
        Policy stsPolicy = null;
        Policy bsPol = secConvTok.getBootstrapPolicy();
        if (bsPol != null) {
            log.debug((Object)"BootstrapPolicy found");
            bsPol.addAssertion((Assertion)rmd.getPolicyData().getRampartConfig());
            if (rmd.getPolicyData().getMTOMAssertion() != null) {
                bsPol.addAssertion((Assertion)rmd.getPolicyData().getMTOMAssertion());
            }
            stsPolicy = bsPol;
        } else {
            log.debug((Object)"No bootstrap policy, using issuer policy");
            stsPolicy = rmd.getPolicyData().getIssuerPolicy();
        }
        String id = RampartUtil.getToken(rmd, rstTemplate, issuerEprAddress, action, stsPolicy);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SecureConversationToken obtained: id=" + id));
        }
        return id;
    }

    public static String getIssuedToken(RampartMessageData rmd, IssuedToken issuedToken) throws RampartException {
        try {
            String action = TrustUtil.getActionValue((int)rmd.getWstVersion(), (String)"/RST/Issue");
            String issuerEprAddress = RampartUtil.processIssuerAddress(issuedToken.getIssuerEpr());
            OMElement rstTemplate = issuedToken.getRstTemplate();
            Policy stsPolicy = (Policy)rmd.getMsgContext().getProperty("rampartStsPolicy");
            if (stsPolicy == null && issuedToken.getIssuerMex() != null) {
                stsPolicy = RampartUtil.getPolicyFromMetadataRef(issuedToken.getIssuerMex());
                RampartUtil.addRampartConfig(rmd, stsPolicy);
            }
            String id = RampartUtil.getToken(rmd, rstTemplate, issuerEprAddress, action, stsPolicy);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Issued token obtained: id=" + id));
            }
            return id;
        }
        catch (TrustException e) {
            throw new RampartException("errorInObtainingToken", e);
        }
    }

    public static String getToken(RampartMessageData rmd, OMElement rstTemplate, String issuerEpr, String action, Policy issuerPolicy) throws RampartException {
        try {
            MessageContext msgContext = rmd.getMsgContext();
            String customTokeId = (String)msgContext.getProperty("customIssuedToken");
            if (customTokeId != null) {
                return customTokeId;
            }
            Axis2Util.useDOOM(false);
            STSClient client = new STSClient(rmd.getMsgContext().getConfigurationContext());
            client.setAction(action);
            client.setVersion(rmd.getWstVersion());
            client.setRstTemplate(rstTemplate);
            Crypto crypto = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getMsgContext().getAxisService().getClassLoader());
            CallbackHandler cbh = RampartUtil.getPasswordCB(rmd);
            client.setCryptoInfo(crypto, cbh);
            Policy servicePolicy = rmd.getServicePolicy();
            String servceEprAddress = rmd.getMsgContext().getOptions().getTo().getAddress();
            Object addrVersionNs = msgContext.getProperty("WSAddressingVersion");
            if (addrVersionNs != null) {
                client.setAddressingNs((String)addrVersionNs);
            }
            Options options = new Options();
            options.setUserName(rmd.getMsgContext().getOptions().getUserName());
            options.setPassword(rmd.getMsgContext().getOptions().getPassword());
            if (msgContext.getProperty("CUSTOM_PROTOCOL_HANDLER") != null) {
                Protocol protocolHandler = (Protocol)msgContext.getProperty("CUSTOM_PROTOCOL_HANDLER");
                options.setProperty("CUSTOM_PROTOCOL_HANDLER", (Object)protocolHandler);
            }
            if (msgContext.getParameter("passwordCallbackRef") != null) {
                Parameter pwCallback = msgContext.getParameter("passwordCallbackRef");
                client.addParameter(pwCallback);
            }
            client.setOptions(options);
            if (msgContext.isSOAP11()) {
                client.setSoapVersion("http://schemas.xmlsoap.org/soap/envelope/");
            } else {
                client.setSoapVersion("http://www.w3.org/2003/05/soap-envelope");
            }
            Token rst = client.requestSecurityToken(servicePolicy, issuerEpr, issuerPolicy, servceEprAddress);
            rst.setState(1);
            rmd.getTokenStorage().add(rst);
            Axis2Util.useDOOM(true);
            return rst.getId();
        }
        catch (Exception e) {
            throw new RampartException("errorInObtainingToken", e);
        }
    }

    public static String getSoapBodyId(SOAPEnvelope env) {
        return RampartUtil.addWsuIdToElement((OMElement)env.getBody());
    }

    public static String addWsuIdToElement(OMElement elem) {
        String id;
        OMAttribute idAttr = elem.getAttribute(new QName("Id"));
        if (idAttr == null) {
            idAttr = elem.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
        }
        if (idAttr != null) {
            id = idAttr.getAttributeValue();
        } else {
            OMNamespace ns = elem.getOMFactory().createOMNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
            id = "Id-" + elem.hashCode();
            idAttr = elem.getOMFactory().createOMAttribute("Id", ns, id);
            elem.addAttribute(idAttr);
        }
        return id;
    }

    public static Element appendChildToSecHeader(RampartMessageData rmd, OMElement elem) {
        return RampartUtil.appendChildToSecHeader(rmd, (Element)elem);
    }

    public static Element appendChildToSecHeader(RampartMessageData rmd, Element elem) {
        Element secHeaderElem = rmd.getSecHeader().getSecurityHeader();
        Node node = secHeaderElem.getOwnerDocument().importNode(elem, true);
        return (Element)secHeaderElem.appendChild(node);
    }

    public static Element insertSiblingAfter(RampartMessageData rmd, Element child, Element sibling) {
        if (child == null) {
            return RampartUtil.appendChildToSecHeader(rmd, sibling);
        }
        if (child.getOwnerDocument().equals(sibling.getOwnerDocument())) {
            if (child.getParentNode() == null && !child.getLocalName().equals("UsernameToken")) {
                rmd.getSecHeader().getSecurityHeader().appendChild(child);
            }
            ((OMElement)child).insertSiblingAfter((OMNode)((OMElement)sibling));
            return sibling;
        }
        Element newSib = (Element)child.getOwnerDocument().importNode(sibling, true);
        ((OMElement)child).insertSiblingAfter((OMNode)((OMElement)newSib));
        return newSib;
    }

    public static Element insertSiblingBefore(RampartMessageData rmd, Element child, Element sibling) {
        if (child == null) {
            return RampartUtil.appendChildToSecHeader(rmd, sibling);
        }
        if (child.getOwnerDocument().equals(sibling.getOwnerDocument())) {
            ((OMElement)child).insertSiblingBefore((OMNode)((OMElement)sibling));
            return sibling;
        }
        Element newSib = (Element)child.getOwnerDocument().importNode(sibling, true);
        ((OMElement)child).insertSiblingBefore((OMNode)((OMElement)newSib));
        return newSib;
    }

    public static Vector getEncryptedParts(RampartMessageData rmd) {
        RampartPolicyData rpd = rmd.getPolicyData();
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        Set namespaces = rmd.getDeclaredNamespaces();
        if (namespaces == null) {
            namespaces = RampartUtil.findAllPrefixNamespaces((OMElement)rmd.getMsgContext().getEnvelope(), rpd.getDeclaredNamespaces());
        }
        Vector encryptedPartsElements = RampartUtil.getPartsAndElements(false, envelope, rpd.isEncryptBody() && !rpd.isEncryptBodyOptional(), rpd.getEncryptedParts(), rpd.getEncryptedElements(), namespaces);
        return RampartUtil.getContentEncryptedElements(encryptedPartsElements, envelope, rpd.getContentEncryptedElements(), namespaces);
    }

    public static Vector getSignedParts(RampartMessageData rmd) {
        RampartPolicyData rpd = rmd.getPolicyData();
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        Set namespaces = rmd.getDeclaredNamespaces();
        if (namespaces == null) {
            namespaces = RampartUtil.findAllPrefixNamespaces((OMElement)rmd.getMsgContext().getEnvelope(), rpd.getDeclaredNamespaces());
        }
        if (rpd.isSignAllHeaders()) {
            Iterator childHeaders = envelope.getHeader().getChildElements();
            while (childHeaders.hasNext()) {
                OMElement hb = (OMElement)childHeaders.next();
                if (hb.getLocalName().equals("Security") && hb.getNamespace().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
                rpd.addSignedPart(hb.getNamespace().getNamespaceURI(), hb.getLocalName());
            }
        }
        return RampartUtil.getPartsAndElements(true, envelope, rpd.isSignBody() && !rpd.isSignBodyOptional(), rpd.getSignedParts(), rpd.getSignedElements(), namespaces);
    }

    public static Vector getSupportingEncryptedParts(RampartMessageData rmd, SupportingPolicyData rpd) {
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        Set namespaces = rmd.getDeclaredNamespaces();
        if (namespaces == null) {
            namespaces = RampartUtil.findAllPrefixNamespaces((OMElement)rmd.getMsgContext().getEnvelope(), rpd.getDeclaredNamespaces());
        }
        return RampartUtil.getPartsAndElements(false, envelope, rpd.isEncryptBody() && !rpd.isEncryptBodyOptional(), rpd.getEncryptedParts(), rpd.getEncryptedElements(), namespaces);
    }

    public static Vector getSupportingSignedParts(RampartMessageData rmd, SupportingPolicyData rpd) {
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        Set namespaces = rmd.getDeclaredNamespaces();
        if (namespaces == null) {
            namespaces = RampartUtil.findAllPrefixNamespaces((OMElement)rmd.getMsgContext().getEnvelope(), rpd.getDeclaredNamespaces());
        }
        return RampartUtil.getPartsAndElements(true, envelope, rpd.isSignBody() && !rpd.isSignBodyOptional(), rpd.getSignedParts(), rpd.getSignedElements(), namespaces);
    }

    public static Set findAllPrefixNamespaces(OMElement currentElement, HashMap decNamespacess) {
        HashSet<OMNamespace> results = new HashSet<OMNamespace>();
        RampartUtil.findPrefixNamespaces(currentElement, results);
        List defaultNamespaces = RampartUtil.getDefaultPrefixNamespaces(currentElement.getOMFactory());
        for (OMNamespace ns : defaultNamespaces) {
            results.add(ns);
        }
        for (String prefix : decNamespacess.keySet()) {
            String ns = (String)decNamespacess.get(prefix);
            OMFactory omFactory = currentElement.getOMFactory();
            OMNamespace namespace = omFactory.createOMNamespace(ns, prefix);
            results.add(namespace);
        }
        return results;
    }

    private static void findPrefixNamespaces(OMElement e, Set results) {
        Iterator iter = e.getAllDeclaredNamespaces();
        if (iter != null) {
            while (iter.hasNext()) {
                results.add(iter.next());
            }
        }
        Iterator children = e.getChildElements();
        while (children.hasNext()) {
            RampartUtil.findPrefixNamespaces((OMElement)children.next(), results);
        }
    }

    private static List getDefaultPrefixNamespaces(OMFactory factory) {
        ArrayList<OMNamespace> namespaces = new ArrayList<OMNamespace>();
        namespaces.add(factory.createOMNamespace("http://www.w3.org/2001/04/xmlenc#", "xenc"));
        namespaces.add(factory.createOMNamespace("http://www.w3.org/2000/09/xmldsig#", "ds"));
        namespaces.add(factory.createOMNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse"));
        namespaces.add(factory.createOMNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu"));
        return namespaces;
    }

    public static Vector getContentEncryptedElements(Vector encryptedPartsElements, SOAPEnvelope envelope, Vector elements, Set namespaces) {
        for (String expression : elements) {
            try {
                AXIOMXPath xp = new AXIOMXPath(expression);
                for (OMNamespace tmpNs : namespaces) {
                    xp.addNamespace(tmpNs.getPrefix(), tmpNs.getNamespaceURI());
                }
                List selectedNodes = xp.selectNodes((Object)envelope);
                for (OMElement e : selectedNodes) {
                    String localName = e.getLocalName();
                    String namespace = e.getNamespace() != null ? e.getNamespace().getNamespaceURI() : null;
                    WSEncryptionPart encryptedElem = new WSEncryptionPart(localName, namespace, "Content", 3);
                    encryptedElem.setXpath(expression);
                    OMAttribute wsuId = e.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
                    if (wsuId != null) {
                        encryptedElem.setEncId(wsuId.getAttributeValue());
                    }
                    encryptedPartsElements.add(encryptedElem);
                }
            }
            catch (JaxenException e) {
                throw new RuntimeException(e);
            }
        }
        return encryptedPartsElements;
    }

    public static Vector getPartsAndElements(boolean sign, SOAPEnvelope envelope, boolean includeBody, Vector parts, Vector elements, Set namespaces) {
        Vector<Object> found = new Vector<Object>();
        Vector<WSEncryptionPart> result = new Vector<WSEncryptionPart>();
        if (includeBody) {
            if (sign) {
                result.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)envelope.getBody()), null, 2));
            } else {
                result.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)envelope.getBody()), "Content", 2));
            }
            found.add(envelope.getBody());
        }
        SOAPHeader header = envelope.getHeader();
        for (int i = 0; i < parts.size(); ++i) {
            WSEncryptionPart wsep = (WSEncryptionPart)parts.get(i);
            if (wsep.getName() == null) {
                ArrayList headerList = header.getHeaderBlocksWithNSURI(wsep.getNamespace());
                for (int j = 0; j < headerList.size(); ++j) {
                    SOAPHeaderBlock shb = (SOAPHeaderBlock)headerList.get(j);
                    OMElement e = header.getFirstChildWithName(shb.getQName());
                    if (found.contains(e)) continue;
                    found.add(e);
                    if (sign) {
                        result.add(new WSEncryptionPart(e.getLocalName(), wsep.getNamespace(), "Content", 1));
                        continue;
                    }
                    WSEncryptionPart encryptedHeader = new WSEncryptionPart(e.getLocalName(), wsep.getNamespace(), "Element", 1);
                    OMAttribute wsuId = e.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
                    if (wsuId != null) {
                        encryptedHeader.setEncId(wsuId.getAttributeValue());
                    }
                    result.add(encryptedHeader);
                }
                continue;
            }
            OMElement e = header.getFirstChildWithName(new QName(wsep.getNamespace(), wsep.getName()));
            if (e == null || found.contains(e)) continue;
            found.add(e);
            wsep.setType(1);
            OMAttribute wsuId = e.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
            if (wsuId != null) {
                wsep.setEncId(wsuId.getAttributeValue());
            }
            result.add(wsep);
        }
        for (String expression : elements) {
            try {
                AXIOMXPath xp = new AXIOMXPath(expression);
                for (OMNamespace tmpNs : namespaces) {
                    xp.addNamespace(tmpNs.getPrefix(), tmpNs.getNamespaceURI());
                }
                List selectedNodes = xp.selectNodes((Object)envelope);
                for (OMElement e : selectedNodes) {
                    WSEncryptionPart encryptedElem;
                    String namespace;
                    String localName = e.getLocalName();
                    String string = namespace = e.getNamespace() != null ? e.getNamespace().getNamespaceURI() : null;
                    if (sign) {
                        encryptedElem = new WSEncryptionPart(localName, namespace, "Content", 3);
                        encryptedElem.setXpath(expression);
                        result.add(encryptedElem);
                        continue;
                    }
                    encryptedElem = new WSEncryptionPart(localName, namespace, "Element", 3);
                    encryptedElem.setXpath(expression);
                    OMAttribute wsuId = e.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
                    if (wsuId != null) {
                        encryptedElem.setEncId(wsuId.getAttributeValue());
                    }
                    result.add(encryptedElem);
                }
            }
            catch (JaxenException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static boolean checkRequiredElements(SOAPEnvelope envelope, Set namespaces, String expression) {
        SOAPHeader header = envelope.getHeader();
        try {
            AXIOMXPath xp = new AXIOMXPath(expression);
            for (OMNamespace tmpNs : namespaces) {
                xp.addNamespace(tmpNs.getPrefix(), tmpNs.getNamespaceURI());
            }
            List selectedNodes = xp.selectNodes((Object)header);
            if (selectedNodes.size() == 0) {
                return false;
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public static KeyGenerator getEncryptionKeyGenerator(String symEncrAlgo) throws WSSecurityException {
        KeyGenerator keyGen;
        block6: {
            try {
                keyGen = KeyGenerator.getInstance("AES");
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    keyGen = KeyGenerator.getInstance("DESede");
                    break block6;
                }
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    keyGen.init(128);
                    break block6;
                }
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    keyGen.init(192);
                    break block6;
                }
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    keyGen.init(256);
                    break block6;
                }
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                throw new WSSecurityException(2, null, null, (Throwable)e);
            }
        }
        return keyGen;
    }

    public static String getContextIdentifierKey(MessageContext msgContext) {
        return msgContext.getAxisService().getName();
    }

    public static Hashtable getContextMap(MessageContext msgContext) {
        Hashtable map = msgContext.getConfigurationContext().getProperty("contextMap");
        if (map == null) {
            map = new Hashtable();
            msgContext.getConfigurationContext().setProperty("contextMap", map);
        }
        return map;
    }

    public static boolean isTokenValid(RampartMessageData rmd, String id) throws RampartException {
        try {
            Token token = rmd.getTokenStorage().getToken(id);
            return token != null && token.getState() == 1;
        }
        catch (TrustException e) {
            throw new RampartException("errorExtractingToken");
        }
    }

    public static void setEncryptionUser(RampartMessageData rmd, WSSecEncryptedKey encrKeyBuilder) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        String encrUser = rpd.getRampartConfig().getEncryptionUser();
        RampartUtil.setEncryptionUser(rmd, encrKeyBuilder, encrUser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setEncryptionUser(RampartMessageData rmd, WSSecEncryptedKey encrKeyBuilder, String encrUser) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        if (encrUser == null) {
            encrUser = rpd.getRampartConfig().getEncryptionUser();
        }
        if (encrUser == null || "".equals(encrUser)) {
            throw new RampartException("missingEncryptionUser");
        }
        if (encrUser.equals("useReqSigCert")) {
            Object resultsObj = rmd.getMsgContext().getProperty("RECV_RESULTS");
            if (resultsObj == null) throw new RampartException("noSecurityResults");
            encrKeyBuilder.setUseThisCert(RampartUtil.getReqSigCert((Vector)resultsObj));
            if (!encrKeyBuilder.isCertSet()) return;
            encrKeyBuilder.setUserInfo(RampartUtil.getUsername((Vector)resultsObj));
            return;
        } else {
            encrKeyBuilder.setUserInfo(encrUser);
        }
    }

    public static void setKeyIdentifierType(RampartMessageData rmd, WSSecBase secBase, org.apache.ws.secpolicy.model.Token token) {
        boolean useReference;
        boolean bl = useReference = token.getInclusion() == 1 || !rmd.isInitiator() && token.getInclusion() == 3 || rmd.isInitiator() && token.getInclusion() == 4;
        if (useReference) {
            boolean tokenTypeSet = false;
            if (token instanceof X509Token) {
                X509Token x509Token = (X509Token)token;
                if (x509Token.isRequireIssuerSerialReference()) {
                    secBase.setKeyIdentifierType(2);
                    tokenTypeSet = true;
                } else if (x509Token.isRequireKeyIdentifierReference()) {
                    secBase.setKeyIdentifierType(4);
                    tokenTypeSet = true;
                } else if (x509Token.isRequireThumbprintReference()) {
                    secBase.setKeyIdentifierType(8);
                    tokenTypeSet = true;
                } else if (x509Token.isRequireEmbeddedTokenReference()) {
                    secBase.setKeyIdentifierType(6);
                    tokenTypeSet = true;
                }
            }
            if (!tokenTypeSet) {
                RampartPolicyData rpd = rmd.getPolicyData();
                Wss11 wss = rpd.getWss11();
                if (wss == null) {
                    wss = rpd.getWss10();
                }
                if (wss.isMustSupportRefKeyIdentifier()) {
                    secBase.setKeyIdentifierType(4);
                } else if (wss.isMustSupportRefIssuerSerial()) {
                    secBase.setKeyIdentifierType(2);
                } else if (wss instanceof Wss11 && wss.isMustSupportRefThumbprint()) {
                    secBase.setKeyIdentifierType(8);
                }
            }
        } else {
            secBase.setKeyIdentifierType(1);
        }
    }

    private static X509Certificate getReqSigCert(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 2) continue;
                return (X509Certificate)wser.get((Object)"x509-certificate");
            }
        }
        return null;
    }

    public static String getUsername(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 1) continue;
                WSUsernameTokenPrincipal principal = (WSUsernameTokenPrincipal)wser.get((Object)"principal");
                return principal.getName();
            }
        }
        return null;
    }

    public static String getRequestEncryptedKeyId(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                String encrKeyId = (String)wser.get((Object)"encrypted-key-id");
                if (actInt != 4 || encrKeyId == null) continue;
                return encrKeyId;
            }
        }
        return null;
    }

    public static byte[] getRequestEncryptedKeyValue(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                byte[] decryptedKey = (byte[])wser.get((Object)"decrypted-key");
                if (actInt != 4 || decryptedKey == null) continue;
                return decryptedKey;
            }
        }
        return null;
    }

    public static Element insertSiblingAfterOrPrepend(RampartMessageData rmd, Element child, Element elem) {
        Element retElem = null;
        retElem = child != null ? RampartUtil.insertSiblingAfter(rmd, child, elem) : RampartUtil.prependSecHeader(rmd, elem);
        return retElem;
    }

    public static Element insertSiblingBeforeOrPrepend(RampartMessageData rmd, Element child, Element elem) {
        Element retElem = null;
        retElem = child != null && child.getPreviousSibling() != null ? RampartUtil.insertSiblingBefore(rmd, child, elem) : RampartUtil.prependSecHeader(rmd, elem);
        return retElem;
    }

    private static Element prependSecHeader(RampartMessageData rmd, Element elem) {
        Element retElem = null;
        Element secHeaderElem = rmd.getSecHeader().getSecurityHeader();
        Node node = secHeaderElem.getOwnerDocument().importNode(elem, true);
        Element firstElem = (Element)secHeaderElem.getFirstChild();
        if (firstElem == null) {
            retElem = (Element)secHeaderElem.appendChild(node);
        } else if (firstElem.getOwnerDocument().equals(elem.getOwnerDocument())) {
            ((OMElement)firstElem).insertSiblingBefore((OMNode)((OMElement)elem));
            retElem = elem;
        } else {
            Element newSib = (Element)firstElem.getOwnerDocument().importNode(elem, true);
            ((OMElement)firstElem).insertSiblingBefore((OMNode)((OMElement)newSib));
            retElem = newSib;
        }
        return retElem;
    }

    public static boolean isSecHeaderRequired(RampartPolicyData rpd, boolean initiator, boolean inflow) {
        if (rpd.isIncludeTimestamp()) {
            return true;
        }
        if (rpd.isSignBody() || rpd.getSignedParts().size() != 0 || rpd.getSignedElements().size() != 0) {
            return true;
        }
        if (rpd.isEncryptBody() || rpd.getEncryptedParts().size() != 0 || rpd.getEncryptedElements().size() != 0) {
            return true;
        }
        if (!initiator && inflow || initiator && !inflow) {
            SupportingToken supportingTokens;
            Vector supportingToks = rpd.getSupportingTokensList();
            for (int i = 0; i < supportingToks.size(); ++i) {
                supportingTokens = (SupportingToken)supportingToks.get(i);
                if (supportingTokens == null || supportingTokens.getTokens().size() == 0) continue;
                return true;
            }
            supportingTokens = rpd.getSignedSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getEndorsingSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getSignedEndorsingSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getEncryptedSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getSignedEncryptedSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getEndorsingEncryptedSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getSignedEndorsingEncryptedSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
        }
        return false;
    }

    public static void handleEncryptedSignedHeaders(Vector encryptedParts, Vector signedParts, Document doc) {
        for (int i = 0; i < signedParts.size(); ++i) {
            WSEncryptionPart signedPart = (WSEncryptionPart)signedParts.get(i);
            if (signedPart.getNamespace() == null || signedPart.getName() == null) continue;
            for (int j = 0; j < encryptedParts.size(); ++j) {
                Element encHeader;
                String encHeaderId;
                WSEncryptionPart encryptedPart = (WSEncryptionPart)encryptedParts.get(j);
                if (encryptedPart.getNamespace() == null || encryptedPart.getName() == null || !signedPart.getName().equals(encryptedPart.getName()) || !signedPart.getNamespace().equals(encryptedPart.getNamespace())) continue;
                String encDataID = encryptedPart.getEncId();
                Element encDataElem = WSSecurityUtil.findElementById((Node)doc.getDocumentElement(), (String)encDataID, null);
                if (encDataElem == null || (encHeaderId = (encHeader = (Element)encDataElem.getParentNode()).getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) == null || "".equals(encHeaderId.trim())) continue;
                signedParts.remove(signedPart);
                WSEncryptionPart encHeaderToSign = new WSEncryptionPart(encHeaderId);
                signedParts.add(encHeaderToSign);
            }
        }
    }

    public static String getSigElementId(RampartMessageData rmd) {
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        SOAPHeader header = envelope.getHeader();
        if (header == null) {
            return null;
        }
        ArrayList secHeaders = header.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (secHeaders != null && secHeaders.size() > 0) {
            QName sigQName = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
            QName wsuIdQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            OMElement sigElem = ((SOAPHeaderBlock)secHeaders.get(0)).getFirstChildWithName(sigQName);
            OMAttribute wsuId = sigElem.getAttribute(wsuIdQName);
            if (wsuId != null) {
                return wsuId.getAttributeValue();
            }
            wsuId = sigElem.getAttribute(new QName("Id"));
            if (wsuId != null) {
                return wsuId.getAttributeValue();
            }
        }
        return null;
    }

    public static WSSConfig getWSSConfigInstance() {
        WSSConfig defaultWssConfig = WSSConfig.getDefaultWSConfig();
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setEnableSignatureConfirmation(defaultWssConfig.isEnableSignatureConfirmation());
        wssConfig.setTimeStampStrict(defaultWssConfig.isTimeStampStrict());
        wssConfig.setWsiBSPCompliant(defaultWssConfig.isWsiBSPCompliant());
        wssConfig.setPrecisionInMilliSeconds(defaultWssConfig.isPrecisionInMilliSeconds());
        return wssConfig;
    }

    public static void validateTransport(RampartMessageData rmd) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd == null) {
            return;
        }
        if (rpd.isTransportBinding() && !rmd.isInitiator() && rpd.getTransportToken() instanceof HttpsToken) {
            HttpServletRequest request;
            MessageContext messageContext;
            String incomingTransport = rmd.getMsgContext().getIncomingTransportName();
            if (!incomingTransport.equals("https")) {
                throw new RampartException("invalidTransport", new String[]{incomingTransport});
            }
            if (((HttpsToken)rpd.getTransportToken()).isRequireClientCertificate() && (messageContext = rmd.getMsgContext()).getProperty("ssl.client.auth.cert.X509") == null && ((request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)) == null || request.getAttribute("javax.servlet.request.X509Certificate") == null)) {
                throw new RampartException("clientAuthRequired");
            }
        }
    }

    private static Crypto retrieveCryptoFromCache(String cryptoKey, String refreshInterval) {
        if (cryptoStore.containsKey(cryptoKey)) {
            CachedCrypto cachedCrypto = cryptoStore.get(cryptoKey);
            if (refreshInterval != null) {
                if (cachedCrypto.creationTime + new Long(refreshInterval) > Calendar.getInstance().getTimeInMillis()) {
                    log.debug((Object)"Cache Hit : Crypto Object was found in cache.");
                    return cachedCrypto.crypto;
                }
                log.debug((Object)"Cache Miss : Crypto Object found in cache is expired.");
                return null;
            }
            log.debug((Object)"Cache Hit : Crypto Object was found in cache.");
            return cachedCrypto.crypto;
        }
        log.debug((Object)"Cache Miss : Crypto Object was not found in cache.");
        return null;
    }

    private static void cacheCrypto(String cryptoKey, Crypto crypto) {
        cryptoStore.put(cryptoKey, new CachedCrypto(crypto, Calendar.getInstance().getTimeInMillis()));
        log.debug((Object)"Crypto object is inserted into the Cache.");
    }

    private static class CachedCrypto {
        private Crypto crypto;
        private long creationTime;

        public CachedCrypto(Crypto crypto, long creationTime) {
            this.crypto = crypto;
            this.creationTime = creationTime;
        }
    }
}

