/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.plugins;

import java.io.File;
import javax.servlet.ServletContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.file.JavaScriptFile;
import org.jaggeryjs.hostobjects.file.JavaScriptFileManager;
import org.jaggeryjs.hostobjects.file.JavaScriptFileManagerImpl;
import org.jaggeryjs.jaggery.core.plugins.UploadedFile;
import org.jaggeryjs.jaggery.core.plugins.WebAppFile;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;

public class WebAppFileManager
implements JavaScriptFileManager {
    private static final Log log = LogFactory.getLog(WebAppFileManager.class);
    private ServletContext context;

    public WebAppFileManager(ServletContext context) throws ScriptException {
        this.context = context;
    }

    public JavaScriptFile getJavaScriptFile(Object object) throws ScriptException {
        if (object instanceof String) {
            String path = (String)object;
            if (path.startsWith("file://")) {
                return new JavaScriptFileManagerImpl().getJavaScriptFile((Object)path);
            }
            WebAppFile webAppFile = new WebAppFile(path, this.context);
            webAppFile.setFileManager(this);
            return webAppFile;
        }
        if (object instanceof FileItem) {
            UploadedFile uploadedFile = new UploadedFile((FileItem)object);
            uploadedFile.setFileManager(this);
            return uploadedFile;
        }
        String msg = "Unsupported parameter to the File constructor : " + object.getClass();
        log.error((Object)msg);
        throw new ScriptException(msg);
    }

    public File getFile(String path) throws ScriptException {
        if (path.startsWith("file://")) {
            return new JavaScriptFileManagerImpl().getFile(path);
        }
        String oldPath = path;
        if ((path = FilenameUtils.normalizeNoEndSeparator((String)path)) == null) {
            String msg = "Invalid file path : " + oldPath;
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        File file = new File(this.context.getRealPath("/"), path);
        if (file.isDirectory()) {
            String msg = "File hostobject doesn't handle directories. Specified path contains a directory : " + path;
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        return file;
    }
}

