/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.search.services;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axis2.context.MessageContext;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.admin.api.search.ISearchService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.indexing.service.ContentSearchService;
import org.wso2.carbon.registry.search.Utils;
import org.wso2.carbon.registry.search.beans.AdvancedSearchResultsBean;
import org.wso2.carbon.registry.search.beans.CustomSearchParameterBean;
import org.wso2.carbon.registry.search.beans.MediaTypeValueList;
import org.wso2.carbon.registry.search.beans.SearchResultsBean;
import org.wso2.carbon.registry.search.services.utils.AdvancedSearchFilterActions;
import org.wso2.carbon.registry.search.services.utils.AdvancedSearchResultsBeanPopulator;
import org.wso2.carbon.registry.search.services.utils.CustomSearchParameterPopulator;
import org.wso2.carbon.registry.search.services.utils.SearchResultsBeanPopulator;
import org.wso2.carbon.registry.search.services.utils.SearchUtils;

public class SearchService
extends RegistryAbstractAdmin
implements ISearchService<SearchResultsBean, AdvancedSearchResultsBean, CustomSearchParameterBean, MediaTypeValueList> {
    public SearchResultsBean getSearchResults(String searchType, String criteria) throws RegistryException {
        RegistryUtils.recordStatistics((Object[])new Object[]{searchType, criteria});
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return SearchResultsBeanPopulator.populate(registry, searchType, criteria);
    }

    public AdvancedSearchResultsBean getAdvancedSearchResults(CustomSearchParameterBean parameters) throws RegistryException {
        RegistryUtils.recordStatistics((Object[])new Object[]{parameters});
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        Registry configSystemRegistry = this.getConfigSystemRegistry();
        ContentSearchService contentSearchService = Utils.getContentSearchService();
        String[][] tempParameterValues = parameters.getParameterValues();
        boolean allEmpty = true;
        for (String[] tempParameterValue : tempParameterValues) {
            if (!(tempParameterValue[1] != null & tempParameterValue[1].trim().length() > 0)) continue;
            allEmpty = false;
            if (tempParameterValue[0].equals("createdAfter") || tempParameterValue[0].equals("createdBefore") || tempParameterValue[0].equals("updatedAfter") || tempParameterValue[0].equals("updatedBefore")) {
                if (SearchUtils.validateDateInput(tempParameterValue[1])) continue;
                String message = tempParameterValue[0] + " contains illegal characters";
                return SearchUtils.getEmptyResultBeanWithErrorMsg(message);
            }
            if (tempParameterValue[0].equals("mediaType")) {
                if (!SearchUtils.validateMediaTypeInput(tempParameterValue[1])) continue;
                String message = tempParameterValue[0] + " contains illegal characters";
                return SearchUtils.getEmptyResultBeanWithErrorMsg(message);
            }
            if (tempParameterValue[0].equals("content")) {
                if (!SearchUtils.validateContentInput(tempParameterValue[1])) continue;
                String message = tempParameterValue[0] + " contains illegal characters";
                return SearchUtils.getEmptyResultBeanWithErrorMsg(message);
            }
            if (tempParameterValue[0].equals("tags")) {
                String message;
                boolean containsTag = false;
                for (String str : tempParameterValue[1].split(",")) {
                    if (str.trim().length() <= 0) continue;
                    containsTag = true;
                    break;
                }
                if (!containsTag) {
                    message = tempParameterValue[0] + " contains illegal characters";
                    return SearchUtils.getEmptyResultBeanWithErrorMsg(message);
                }
                if (!SearchUtils.validateTagsInput(tempParameterValue[1])) continue;
                message = tempParameterValue[0] + " contains illegal characters";
                return SearchUtils.getEmptyResultBeanWithErrorMsg(message);
            }
            if (!SearchUtils.validatePathInput(tempParameterValue[1])) continue;
            String message = tempParameterValue[0] + " contains illegal characters";
            return SearchUtils.getEmptyResultBeanWithErrorMsg(message);
        }
        if (allEmpty) {
            return SearchUtils.getEmptyResultBeanWithErrorMsg("At least one field must be filled");
        }
        boolean onlyContent = true;
        for (String[] tempParameterValue : tempParameterValues) {
            if (tempParameterValue[0].equals("content") || tempParameterValue[0].equals("leftOp") || tempParameterValue[0].equals("rightOp") || tempParameterValue[1] == null || tempParameterValue[1].length() <= 0) continue;
            onlyContent = false;
            break;
        }
        for (String[] tempParameterValue : tempParameterValues) {
            ResourceData[] contentSearchResourceData;
            if (!tempParameterValue[0].equals("content") || tempParameterValue[1] == null || tempParameterValue[1].length() <= 0) continue;
            try {
                contentSearchResourceData = (ResourceData[])contentSearchService.search(registry, (Object)tempParameterValue[1]);
            }
            catch (RegistryException e) {
                AdvancedSearchResultsBean metaDataSearchResultsBean = new AdvancedSearchResultsBean();
                metaDataSearchResultsBean.setErrorMessage(e.getMessage());
                return this.getPaginatedResult(metaDataSearchResultsBean);
            }
            if (contentSearchResourceData != null && contentSearchResourceData.length > 0) {
                HashMap<String, ResourceData> aggregatedMap = new HashMap<String, ResourceData>();
                for (ResourceData resourceData : contentSearchResourceData) {
                    aggregatedMap.put(resourceData.getResourcePath(), resourceData);
                }
                AdvancedSearchResultsBean metaDataSearchResultsBean = AdvancedSearchResultsBeanPopulator.populate(configSystemRegistry, registry, parameters);
                if (metaDataSearchResultsBean != null) {
                    ResourceData[] metaDataResourceData = metaDataSearchResultsBean.getResourceDataList();
                    if (metaDataResourceData != null && metaDataResourceData.length > 0) {
                        ArrayList<String> invalidKeys = new ArrayList<String>();
                        for (String key : aggregatedMap.keySet()) {
                            boolean keyFound = false;
                            for (ResourceData resourceData : metaDataResourceData) {
                                if (!resourceData.getResourcePath().equals(key)) continue;
                                keyFound = true;
                                break;
                            }
                            if (keyFound) continue;
                            invalidKeys.add(key);
                        }
                        for (String invalidKey : invalidKeys) {
                            aggregatedMap.remove(invalidKey);
                        }
                    } else if (!onlyContent) {
                        aggregatedMap.clear();
                    }
                }
                ArrayList<ResourceData> sortedList = new ArrayList<ResourceData>(aggregatedMap.values());
                SearchUtils.sortResourceDataList(sortedList);
                metaDataSearchResultsBean = new AdvancedSearchResultsBean();
                metaDataSearchResultsBean.setResourceDataList(sortedList.toArray(new ResourceData[sortedList.size()]));
                return this.getPaginatedResult(metaDataSearchResultsBean);
            }
            AdvancedSearchResultsBean metaDataSearchResultsBean = new AdvancedSearchResultsBean();
            metaDataSearchResultsBean.setResourceDataList(contentSearchResourceData);
            return this.getPaginatedResult(metaDataSearchResultsBean);
        }
        return this.getPaginatedResult(AdvancedSearchResultsBeanPopulator.populate(configSystemRegistry, registry, parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdvancedSearchResultsBean getPaginatedResult(AdvancedSearchResultsBean advancedSearchResultsBean) {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext != null && PaginationUtils.isPaginationHeadersExist((MessageContext)messageContext)) {
            int rowCount = advancedSearchResultsBean.getResourceDataList().length;
            try {
                ResourceData[] paginatedResult;
                PaginationUtils.setRowCount((MessageContext)messageContext, (String)Integer.toString(rowCount));
                PaginationContext paginationContext = PaginationUtils.initPaginationContext((MessageContext)messageContext);
                int start = paginationContext.getStart();
                int count = paginationContext.getCount();
                int startIndex = start == 1 ? 0 : start;
                if (rowCount < start + count) {
                    paginatedResult = new ResourceData[rowCount - startIndex];
                    System.arraycopy(advancedSearchResultsBean.getResourceDataList(), startIndex, paginatedResult, 0, rowCount - startIndex);
                } else {
                    paginatedResult = new ResourceData[count];
                    System.arraycopy(advancedSearchResultsBean.getResourceDataList(), startIndex, paginatedResult, 0, count);
                }
                advancedSearchResultsBean.setResourceDataList(paginatedResult);
                AdvancedSearchResultsBean advancedSearchResultsBean2 = advancedSearchResultsBean;
                return advancedSearchResultsBean2;
            }
            finally {
                PaginationContext.destroy();
            }
        }
        return advancedSearchResultsBean;
    }

    public MediaTypeValueList getMediaTypeSearch(String mediaType) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return CustomSearchParameterPopulator.getMediaTypeParameterValues(registry, mediaType);
    }

    public void saveAdvancedSearchFilter(CustomSearchParameterBean queryBean, String filterName) throws RegistryException {
        UserRegistry configUserRegistry = (UserRegistry)this.getConfigUserRegistry();
        AdvancedSearchFilterActions.saveAdvancedSearchQueryBean(configUserRegistry, queryBean, filterName);
    }

    public CustomSearchParameterBean getAdvancedSearchFilter(String filterName) throws RegistryException {
        UserRegistry configUserRegistry = (UserRegistry)this.getConfigUserRegistry();
        return AdvancedSearchFilterActions.getAdvancedSearchQueryBean(configUserRegistry, filterName);
    }

    public String[] getSavedFilters() throws RegistryException {
        UserRegistry configUserRegistry = (UserRegistry)this.getConfigUserRegistry();
        return AdvancedSearchFilterActions.getSavedFilterNames(configUserRegistry);
    }

    public void deleteFilter(String filterName) throws RegistryException {
        UserRegistry configUserRegistry = (UserRegistry)this.getConfigUserRegistry();
        configUserRegistry.delete("/users/" + CarbonContext.getCurrentContext().getUsername() + "/" + "searchFilters" + "/" + filterName);
    }
}

