/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.service;

import java.util.Calendar;
import java.util.Map;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.TagCount;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.service.SearchResultsBean;

public class SearchResultsBeanPopulator {
    public static SearchResultsBean populate(UserRegistry userRegistry, String searchType, String criteria) {
        SearchResultsBean searchResultsBean = new SearchResultsBean();
        try {
            if (searchType.equalsIgnoreCase("Tag")) {
                searchResultsBean.setResourceDataList(SearchResultsBeanPopulator.searchByTags(criteria, userRegistry));
            } else {
                searchResultsBean.setResourceDataList(SearchResultsBeanPopulator.searchByContent(criteria, userRegistry));
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to generate search results. " + e.getMessage();
            searchResultsBean.setErrorMessage(msg);
        }
        return searchResultsBean;
    }

    private static ResourceData[] searchByTags(String tag, UserRegistry registry) throws RegistryException {
        ResourceData[] resourceDataList = new ResourceData[]{};
        if (tag != null && tag.length() != 0) {
            TaggedResourcePath[] taggedPaths = registry.getResourcePathsWithTag(tag);
            resourceDataList = new ResourceData[taggedPaths.length];
            for (int i = 0; i < taggedPaths.length; ++i) {
                String resultPath = taggedPaths[i].getResourcePath();
                ResourceData resourceData = new ResourceData();
                resourceData.setResourcePath(resultPath);
                if (resultPath != null) {
                    if (resultPath.equals("/")) {
                        resourceData.setName("/");
                    } else {
                        String[] parts = resultPath.split("/");
                        resourceData.setName(parts[parts.length - 1]);
                    }
                }
                try {
                    Resource child = registry.get(resultPath);
                    resourceData.setResourceType(child instanceof Collection ? "collection" : "resource");
                    resourceData.setAuthorUserName(child.getAuthorUserName());
                    resourceData.setDescription(child.getDescription());
                    resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
                    Calendar createdDateTime = Calendar.getInstance();
                    createdDateTime.setTime(child.getCreatedTime());
                    resourceData.setCreatedOn(createdDateTime);
                    Map counts = taggedPaths[i].getTagCounts();
                    Object[] keySet = counts.keySet().toArray();
                    TagCount[] tagCounts = new TagCount[counts.size()];
                    for (int j = 0; j < counts.size(); ++j) {
                        TagCount tagCount = new TagCount();
                        tagCount.setKey((String)keySet[j]);
                        tagCount.setValue((Long)counts.get(keySet[j]));
                        tagCounts[j] = tagCount;
                    }
                    resourceData.setTagCounts(tagCounts);
                    CommonUtil.populateAverageStars((ResourceData)resourceData);
                    child.discard();
                    resourceDataList[i] = resourceData;
                    continue;
                }
                catch (AuthorizationFailedException e) {
                    // empty catch block
                }
            }
        }
        return resourceDataList;
    }

    private static ResourceData[] searchByContent(String content, UserRegistry registry) throws RegistryException {
        ResourceData[] resourceDataList = new ResourceData[]{};
        if (content != null && content.length() != 0) {
            String[] paths;
            try {
                paths = (String[])registry.searchContent(content).getContent();
            }
            catch (Exception e) {
                return new ResourceData[0];
            }
            resourceDataList = new ResourceData[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                ResourceData resourceData = new ResourceData();
                resourceData.setResourcePath(paths[i]);
                if (paths[i] != null) {
                    if (paths[i].equals("/")) {
                        resourceData.setName("/");
                    } else {
                        String[] parts = paths[i].split("/");
                        resourceData.setName(parts[parts.length - 1]);
                    }
                }
                try {
                    Resource child = registry.get(paths[i]);
                    resourceData.setResourceType(child instanceof Collection ? "collection" : "resource");
                    resourceData.setAuthorUserName(child.getAuthorUserName());
                    resourceData.setDescription(child.getDescription());
                    resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
                    Calendar createdDateTime = Calendar.getInstance();
                    createdDateTime.setTime(child.getCreatedTime());
                    resourceData.setCreatedOn(createdDateTime);
                    CommonUtil.populateAverageStars((ResourceData)resourceData);
                    child.discard();
                    resourceDataList[i] = resourceData;
                    continue;
                }
                catch (AuthorizationFailedException e) {
                    // empty catch block
                }
            }
        }
        return resourceDataList;
    }
}

