/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.utils.IndexingUtils;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.WaitBeforeShutdownObserver;

public class ResourceSubmitter
implements Runnable {
    private static Log log = LogFactory.getLog(ResourceSubmitter.class);
    private IndexingManager indexingManager;
    private boolean taskComplete = false;
    private boolean isShutdown = false;

    protected ResourceSubmitter(IndexingManager indexingManager) {
        this.indexingManager = indexingManager;
        Utils.setWaitBeforeShutdownObserver(new WaitBeforeShutdownObserver(){

            public void startingShutdown() {
                ResourceSubmitter.this.isShutdown = true;
            }

            public boolean isTaskComplete() {
                return ResourceSubmitter.this.taskComplete;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"})
    public void run() {
        Date currentTime = this.indexingManager.getLastAccessTime();
        try {
            Tenant[] allTenants;
            PrivilegedCarbonContext.startTenantFlow();
            try {
                currentTime = this.submitResource(currentTime, -1234, "carbon.super");
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
            for (Tenant tenant : allTenants = RegistryCoreServiceComponent.getRealmService().getTenantManager().getAllTenants()) {
                PrivilegedCarbonContext.startTenantFlow();
                try {
                    currentTime = this.submitResource(currentTime, tenant.getId(), tenant.getDomain());
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
        }
        catch (UserStoreException userStoreException) {
            // empty catch block
        }
        this.indexingManager.setLastAccessTime(currentTime);
    }

    private Date submitResource(Date currentTime, int tenantId, String tenantDomain) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantDomain(tenantDomain);
        carbonContext.setTenantId(tenantId);
        try {
            if (this.isShutdown || Thread.currentThread().isInterrupted()) {
                this.taskComplete = true;
                return currentTime;
            }
            UserRegistry registry = this.indexingManager.getRegistry(tenantId);
            if (registry == null) {
                log.warn((Object)("Unable to submit resource for tenant " + tenantId + ". Unable to get registry instance"));
                return currentTime;
            }
            String lastAccessTimeLocation = this.indexingManager.getLastAccessTimeLocation();
            LogEntry[] entries = registry.getLogs(null, -1, null, this.indexingManager.getLastAccessTime(), new Date(), false);
            Arrays.sort(entries, new Comparator<LogEntry>(){

                @Override
                public int compare(LogEntry o1, LogEntry o2) {
                    return o1.getDate().compareTo(o2.getDate());
                }
            });
            if (entries.length > 0) {
                Date temp = entries[entries.length - 1].getDate();
                if (currentTime == null || currentTime.before(temp)) {
                    currentTime = temp;
                }
            }
            for (LogEntry logEntry : entries) {
                String path = logEntry.getResourcePath();
                try {
                    Resource resourceToIndex;
                    if (path.equals(lastAccessTimeLocation)) continue;
                    if (logEntry.getAction() == 7) {
                        this.indexingManager.deleteFromIndex(logEntry.getResourcePath(), tenantId);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Resource Deleted: Resource at " + path + " will be deleted from Indexing Server"));
                        continue;
                    }
                    if (!this.indexingManager.canIndex(path) || !IndexingUtils.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get") || !registry.resourceExists(path) || !this.indexingManager.isIndexable(resourceToIndex = registry.get(path))) continue;
                    if (logEntry.getAction() == 1) {
                        this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, resourceToIndex, path, null);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Resource Updated: Resource at " + path + " has been submitted to the Indexing Server"));
                        continue;
                    }
                    if (logEntry.getAction() == 0) {
                        this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, resourceToIndex, path, null);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Resource Inserted: Resource at " + path + " has been submitted to the Indexing Server"));
                        continue;
                    }
                    if (logEntry.getAction() == 10) {
                        this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, resourceToIndex, path, null);
                        this.indexingManager.deleteFromIndex(logEntry.getActionData(), tenantId);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Resource Moved: Resource at " + path + " has been submitted to the Indexing Server"));
                        continue;
                    }
                    if (logEntry.getAction() != 11) continue;
                    path = logEntry.getActionData();
                    this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, resourceToIndex, path, null);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Resource Copied : Resource at " + path + " has been submitted to the Indexing Server"));
                }
                catch (Exception e) {
                    log.warn((Object)("An error occurred while submitting the resource for indexing, path: " + path), (Throwable)e);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("last successfully indexed activity time is : " + this.indexingManager.getLastAccessTime().toString()));
            }
        }
        catch (Throwable e) {
            log.warn((Object)"An error occurred while submitting resources for indexing", e);
        }
        return currentTime;
    }
}

