/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.startup.ContextConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployer;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;

public class GhostWebappDeployerUtils {
    private static final Log log = LogFactory.getLog(GhostWebappDeployerUtils.class);
    private static final String ENABLE_GHOST_DEPLOYER = "EnableGhostDeployer";
    private static final String TRANSIT_GHOST_WEBAPP_MAP = "TransitGhostWebappMap";

    private GhostWebappDeployerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebApplication deployActualWebApp(WebApplication ghostWebapp, ConfigurationContext configurationContext) {
        WebApplication newWebApp = null;
        String string = ghostWebapp.getContextName().intern();
        synchronized (string) {
            WebApplicationsHolder webappsHolder = (WebApplicationsHolder)configurationContext.getProperty("carbon.webapps.holder");
            if (webappsHolder != null) {
                WebApplication deployedWebapp = webappsHolder.getStartedWebapps().get(ghostWebapp.getWebappFile().getName());
                if (deployedWebapp == null) {
                    return null;
                }
                if (!GhostWebappDeployerUtils.isGhostWebApp(deployedWebapp)) {
                    newWebApp = deployedWebapp;
                } else {
                    GhostDeployer ghostDeployer = GhostWebappDeployerUtils.getGhostDeployer(configurationContext.getAxisConfiguration());
                    if (ghostDeployer == null) {
                        return null;
                    }
                    DeploymentFileData dfd = ghostDeployer.getFileData(deployedWebapp.getWebappFile().getPath());
                    Host host = DataHolder.getCarbonTomcatService().getTomcat().getHost();
                    if (dfd != null) {
                        log.info((Object)("Removing Ghost webapp and loading actual webapp : " + deployedWebapp.getWebappFile().getName()));
                        try {
                            Map<String, WebApplication> transitGhostList = GhostWebappDeployerUtils.getTransitGhostWebAppsMap(configurationContext);
                            transitGhostList.put(deployedWebapp.getContextName(), deployedWebapp);
                            webappsHolder.undeployWebapp(deployedWebapp);
                            TomcatGenericWebappsDeployer tomcatWebappDeployer = deployedWebapp.getTomcatGenericWebappsDeployer();
                            WebContextParameter serverUrlParam = new WebContextParameter("webServiceServerURL", CarbonUtils.getServerURL((ServerConfigurationService)ServerConfiguration.getInstance(), (ConfigurationContext)configurationContext));
                            ArrayList servletContextParameters = (ArrayList)configurationContext.getProperty("servlet.context.parameters.list");
                            if (servletContextParameters != null) {
                                servletContextParameters.add(serverUrlParam);
                            }
                            if (host != null && host.findChild(deployedWebapp.getContextName()) != null) {
                                host.removeChild((Container)deployedWebapp.getContext());
                            }
                            ArrayList<Object> listeners = new ArrayList<Object>(1);
                            tomcatWebappDeployer.deploy(dfd.getFile(), servletContextParameters, listeners);
                            newWebApp = webappsHolder.getStartedWebapps().get(dfd.getFile().getName());
                            newWebApp.setProperty("GhostWebApp", "false");
                            newWebApp.setProperty("webappFilter", deployedWebapp.getProperty("webappFilter"));
                            newWebApp.setIsGhostWebapp(false);
                            transitGhostList.remove(newWebApp.getContextName());
                        }
                        catch (CarbonException e) {
                            log.error((Object)("Error while loading actual webapp : " + deployedWebapp.getWebappFile().getName()), (Throwable)e);
                        }
                    }
                }
                GhostWebappDeployerUtils.updateLastUsedTime(newWebApp);
            }
        }
        return newWebApp;
    }

    public static void updateLastUsedTime(WebApplication webApplication) {
        if (webApplication == null) {
            return;
        }
        try {
            webApplication.setProperty("lastUsedTime", String.valueOf(System.currentTimeMillis()));
        }
        catch (Exception e) {
            log.error((Object)("Error while updating lastUsedTime parameter in webapp : " + webApplication.getContextName()), (Throwable)e);
        }
    }

    public static GhostDeployer getGhostDeployer(AxisConfiguration axisConfig) {
        GhostDeployer ghostDeployer = null;
        Parameter param = axisConfig.getParameter("ghostDeployer");
        if (param != null) {
            return (GhostDeployer)param.getValue();
        }
        return ghostDeployer;
    }

    public static synchronized Map<String, WebApplication> getTransitGhostWebAppsMap(ConfigurationContext cfgContext) {
        HashMap transitMap = null;
        transitMap = (HashMap)cfgContext.getProperty(TRANSIT_GHOST_WEBAPP_MAP);
        if (transitMap == null) {
            transitMap = new HashMap();
            cfgContext.setProperty(TRANSIT_GHOST_WEBAPP_MAP, transitMap);
        }
        return transitMap;
    }

    public static WebApplication dispatchWebAppFromTransitGhosts(String ctxName, ConfigurationContext cfgContext) {
        WebApplication actualWebapp = null;
        Map<String, WebApplication> transitGhostMap = GhostWebappDeployerUtils.getTransitGhostWebAppsMap(cfgContext);
        if (ctxName != null && transitGhostMap.containsKey(ctxName)) {
            actualWebapp = transitGhostMap.get(ctxName);
        }
        return actualWebapp;
    }

    public static void waitForWebAppToLeaveTransit(String contextName, ConfigurationContext cfgContext) {
        Map<String, WebApplication> transitGhostMap = GhostWebappDeployerUtils.getTransitGhostWebAppsMap(cfgContext);
        while (transitGhostMap.containsKey(contextName)) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean isGhostWebApp(WebApplication webApplication) {
        if (webApplication == null) {
            return false;
        }
        String ghostParam = (String)webApplication.getProperty("GhostWebApp");
        return ghostParam != null && "true".equals(ghostParam);
    }

    public static WebApplication createGhostWebApp(File ghostFile, File originalFile, TomcatGenericWebappsDeployer applicationDeployer, ConfigurationContext configContext) {
        OMElement webAppElm;
        WebApplication ghostWebApp = null;
        try {
            FileInputStream xmlInputStream = new FileInputStream(ghostFile);
            webAppElm = new StAXOMBuilder((InputStream)xmlInputStream).getDocumentElement();
        }
        catch (Exception e) {
            log.error((Object)("Error while parsing ghost XML file : " + ghostFile.getAbsolutePath()));
            return null;
        }
        try {
            String contextName = webAppElm.getAttributeValue(new QName("name"));
            String contextPath = webAppElm.getAttributeValue(new QName("contextPath"));
            String jaxContext = webAppElm.getAttributeValue(new QName("jaxContext"));
            String jaxMapping = webAppElm.getAttributeValue(new QName("jaxMapping"));
            StandardContext context = new StandardContext();
            context.setName(contextName);
            context.setPath(contextPath);
            if (jaxMapping != null && jaxContext != null) {
                Wrapper jaxContextWrapper = context.createWrapper();
                jaxContextWrapper.setName(jaxMapping);
                jaxContextWrapper.setLoadOnStartup(1);
                jaxContextWrapper.setServletClass(DefaultServlet.class.getName());
                context.addChild((Container)jaxContextWrapper);
                context.addServletMapping(jaxContext, jaxMapping);
            }
            String filterProp = webAppElm.getAttributeValue(new QName("webappFilter"));
            if (applicationDeployer == null) {
                if ("webapp".equals(filterProp)) {
                    applicationDeployer = (TomcatGenericWebappsDeployer)configContext.getProperty("tomcatGenericWebappsDeplyer");
                } else if ("jaggeryWebapp".equals(filterProp)) {
                    applicationDeployer = (TomcatGenericWebappsDeployer)configContext.getProperty("tomcatJaggeryWebappsDeplyer");
                }
            }
            if (applicationDeployer != null) {
                String lastModifiedTime;
                String webAppFile;
                Host host;
                String displayName = webAppElm.getAttributeValue(new QName("displayName"));
                String dummyContextPath = GhostWebappDeployerUtils.getDummyContextDirectoryPath(contextName, configContext.getAxisConfiguration());
                File dummyCtxFolder = new File(dummyContextPath);
                if (!dummyCtxFolder.exists() && !dummyCtxFolder.mkdirs()) {
                    log.error((Object)("Error while creating dummy context folder at : " + dummyContextPath));
                    return null;
                }
                if (dummyContextPath != null && (host = DataHolder.getCarbonTomcatService().getTomcat().getHost()).findChild(contextName) == null) {
                    context.setDocBase(dummyContextPath);
                    ContextConfig ctxCfg = new ContextConfig();
                    context.addLifecycleListener((LifecycleListener)ctxCfg);
                    context.addLifecycleListener((LifecycleListener)new DefaultConfListener(displayName));
                    host.addChild((Container)context);
                }
                ghostWebApp = new WebApplication(applicationDeployer, (Context)context, originalFile);
                ghostWebApp.setProperty("GhostWebApp", "true");
                ghostWebApp.setIsGhostWebapp(true);
                if (displayName != null) {
                    ghostWebApp.setDisplayName(displayName);
                }
                if ((webAppFile = webAppElm.getAttributeValue(new QName("file"))) != null) {
                    ghostWebApp.setProperty("AppFileName", webAppFile);
                }
                if ((lastModifiedTime = webAppElm.getAttributeValue(new QName("lastModifiedTime"))) != null) {
                    ghostWebApp.setLastModifiedTime(Long.parseLong(lastModifiedTime));
                }
                if (filterProp != null) {
                    ghostWebApp.setProperty("webappFilter", filterProp);
                }
            } else {
                log.error((Object)("Unable to retrieve " + filterProp + " Application Deployer instance."));
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while creating Ghost Webapp from Ghost File : " + ghostFile.getAbsolutePath()), (Throwable)e);
        }
        return ghostWebApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeWebApp(WebApplication webApplication, AxisConfiguration axisConfig, String webappPath) {
        String lastModifiedTime;
        String file;
        String displayName;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        String contextPath = webApplication.getContextName();
        String jaxContext = null;
        String jaxMapping = null;
        for (Container container : webApplication.getContext().findChildren()) {
            if (!((StandardWrapper)container).getServletClass().equals("org.apache.cxf.transport.servlet.CXFServlet")) continue;
            jaxContext = ((StandardWrapper)container).findMappings()[0];
            jaxMapping = ((StandardWrapper)container).getServletName();
            if (!jaxContext.endsWith("/*")) break;
            jaxContext = jaxContext.substring(0, jaxContext.indexOf("/*"));
            break;
        }
        OMElement webappEle = omFactory.createOMElement(new QName("webApplication"));
        webappEle.addAttribute("name", webApplication.getContext().getName(), null);
        if (contextPath != null) {
            webappEle.addAttribute("contextPath", contextPath, null);
        }
        if (jaxContext != null && jaxMapping != null) {
            webappEle.addAttribute("jaxContext", jaxContext, null);
            webappEle.addAttribute("jaxMapping", jaxMapping, null);
        }
        if ((displayName = webApplication.getDisplayName()) != null) {
            webappEle.addAttribute("displayName", displayName, null);
        }
        if ((file = webApplication.getWebappFile().getName()) != null) {
            webappEle.addAttribute("file", file, null);
        }
        if ((lastModifiedTime = String.valueOf(webApplication.getLastModifiedTime())) != null) {
            webappEle.addAttribute("lastModifiedTime", lastModifiedTime, null);
        }
        webappEle.addAttribute("webappFilter", (String)webApplication.getProperty("webappFilter"), null);
        String ghostMetafilesDirPath = CarbonUtils.getGhostMetafileDir((AxisConfiguration)axisConfig);
        if (ghostMetafilesDirPath == null) {
            return;
        }
        String ghostPath = ghostMetafilesDirPath + File.separator + "ghostWebapps";
        File ghostFolder = new File(ghostPath);
        if (!ghostFolder.exists() && !ghostFolder.mkdir()) {
            log.error((Object)("Error while creating ghostWebapps folder at : " + ghostPath));
            return;
        }
        FileOutputStream fos = null;
        try {
            File serviceFile = new File(ghostPath + File.separator + GhostWebappDeployerUtils.calculateGhostFileName(webappPath, axisConfig.getRepository().getPath()));
            fos = new FileOutputStream(serviceFile);
            webappEle.serialize((OutputStream)fos);
            fos.flush();
        }
        catch (Exception e) {
            log.error((Object)"Error while serializing OMElement for Ghost Webapp", (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing the file output stream", (Throwable)e);
                }
            }
        }
    }

    public static File getGhostFile(String fileName, AxisConfiguration axisConfig) {
        String ghostMetafilesDirPath = CarbonUtils.getGhostMetafileDir((AxisConfiguration)axisConfig);
        if (ghostMetafilesDirPath == null) {
            return null;
        }
        return new File(ghostMetafilesDirPath + File.separator + "ghostWebapps" + File.separator + GhostWebappDeployerUtils.calculateGhostFileName(fileName, axisConfig.getRepository().getPath()));
    }

    public static String calculateGhostFileName(String fileName, String repoPath) {
        String pathPrefix = "";
        if (fileName != null && fileName.indexOf("\\") != -1) {
            pathPrefix = "/";
        }
        fileName = GhostWebappDeployerUtils.separatorsToUnix(fileName);
        String ghostFileName = null;
        fileName = pathPrefix + fileName;
        if (fileName != null && fileName.startsWith(repoPath)) {
            ghostFileName = fileName.substring(repoPath.length());
            if (!new File(fileName).isDirectory() && ghostFileName.lastIndexOf(46) != -1) {
                ghostFileName = ghostFileName.substring(0, ghostFileName.lastIndexOf(46));
            }
            if (File.separatorChar == '\\') {
                ghostFileName = ghostFileName.replace('\\', '/');
            }
            ghostFileName = ghostFileName.replace('/', '_');
            ghostFileName = ghostFileName + ".xml";
        }
        return ghostFileName;
    }

    public static WebApplication findDeployedWebapp(ConfigurationContext configurationContext, String webappName) {
        try {
            WebApplicationsHolder webApplicationsHolder = (WebApplicationsHolder)configurationContext.getProperty("carbon.webapps.holder");
            if (webApplicationsHolder != null) {
                return webApplicationsHolder.getStartedWebapps().get(webappName);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving the webapp from webappsHolder..", (Throwable)e);
        }
        return null;
    }

    public static String getDummyContextDirectoryPath(String contextName, AxisConfiguration axisConfig) {
        String tenantTmpDirPath;
        File tenantTmpDir;
        if (contextName.contains("/t/")) {
            String tenantCtx = "/t/" + TenantAxisUtils.getTenantDomain((String)contextName);
            if (contextName.contains("/webapps/")) {
                tenantCtx = tenantCtx + File.separator + "webapps";
            } else if (contextName.contains("/jaggeryapps/")) {
                tenantCtx = tenantCtx + File.separator + "jaggeryapps";
            } else if (contextName.contains("/jaxwebapps/")) {
                tenantCtx = tenantCtx + File.separator + "jaxwebapps";
            } else {
                return null;
            }
            contextName = contextName.substring(tenantCtx.length() + 1);
        }
        if (!(tenantTmpDir = new File(tenantTmpDirPath = CarbonUtils.getTenantTmpDirPath((AxisConfiguration)axisConfig) + File.separator + "ghostWebapps")).exists() && !tenantTmpDir.mkdir()) {
            log.error((Object)("Error while creating tenant temporary directory at : " + tenantTmpDirPath));
            return null;
        }
        return tenantTmpDirPath + File.separator + contextName;
    }

    public static File getDummyContextFile(String fileName, AxisConfiguration axisConfig) {
        File dummyContextFile = null;
        String dummyContextName = null;
        String repoPath = axisConfig.getRepository().getPath();
        if (fileName != null && fileName.startsWith(repoPath)) {
            dummyContextName = fileName.substring((repoPath + File.separator + "webapps").length());
            if (dummyContextName.lastIndexOf(46) != -1) {
                dummyContextName = dummyContextName.substring(0, dummyContextName.lastIndexOf(46));
            }
            if (File.separatorChar == '\\') {
                dummyContextName = dummyContextName.replace('\\', '/');
            }
            String tenantTmpDirPath = CarbonUtils.getTenantTmpDirPath((AxisConfiguration)axisConfig);
            dummyContextFile = new File(tenantTmpDirPath + File.separator + "ghostWebapps" + File.separator + dummyContextName);
        }
        return dummyContextFile;
    }

    public static boolean skipUndeploy(String fileName) {
        if (fileName.endsWith(".svn") || fileName.endsWith(".meta")) {
            return true;
        }
        File warFile = new File(fileName + ".war");
        return warFile.exists();
    }

    public static void deployGhostArtifacts(ConfigurationContext configContext) {
        File ghostMetafilesDir = new File(CarbonUtils.getGhostMetafileDir((AxisConfiguration)configContext.getAxisConfiguration()) + File.separator + "ghostWebapps");
        if (!ghostMetafilesDir.exists()) {
            return;
        }
        File[] ghostMetaArtifacts = ghostMetafilesDir.listFiles();
        for (File ghostFile : ghostMetaArtifacts) {
            if (ghostFile.getPath().endsWith(".svn")) continue;
            try {
                WebApplication ghostWebApplication = GhostWebappDeployerUtils.createGhostWebApp(ghostFile, ghostFile, null, configContext);
                WebApplicationsHolder webappsHolder = (WebApplicationsHolder)configContext.getProperty("carbon.webapps.holder");
                String ghostWebappFileName = ghostWebApplication.getWebappFile().getName();
                String webappFileProperty = (String)ghostWebApplication.getProperty("AppFileName");
                if (webappsHolder.getStartedWebapps().containsKey(ghostWebappFileName) || webappsHolder.getStartedWebapps().containsKey(webappFileProperty)) continue;
                log.info((Object)("Deploying Ghost webapp : " + webappFileProperty));
                webappsHolder.getStartedWebapps().put(ghostWebappFileName, ghostWebApplication);
                webappsHolder.getFaultyWebapps().remove(ghostWebappFileName);
            }
            catch (Exception e) {
                log.error((Object)("Error while deploying Ghost webapp :" + ghostFile.getPath()));
            }
        }
    }

    public static String separatorsToUnix(String path) {
        if (path == null || path.indexOf("\\") == -1) {
            return path;
        }
        return path.replace("\\", "/");
    }

    private static class DefaultConfListener
    implements LifecycleListener {
        private String displayName;

        private DefaultConfListener(String displayName) {
            this.displayName = displayName;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if ("start".equals(event.getType())) {
                ((Context)event.getLifecycle()).setDisplayName(this.displayName);
            }
        }
    }
}

