/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.core.StandardContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataException;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataManager;
import org.wso2.carbon.core.persistence.metadata.ArtifactType;
import org.wso2.carbon.core.persistence.metadata.DeploymentArtifactMetadataFactory;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;
import org.wso2.carbon.webapp.mgt.WebappsConstants;
import org.wso2.carbon.webapp.mgt.utils.GhostWebappDeployerUtils;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;

public abstract class AbstractWebappDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(AbstractWebappDeployer.class);
    protected String webappsDir;
    protected String extension;
    protected TomcatGenericWebappsDeployer tomcatWebappDeployer;
    protected final List<WebContextParameter> servletContextParameters = new ArrayList<WebContextParameter>();
    protected ConfigurationContext configContext;
    protected AxisConfiguration axisConfig;
    protected WebApplicationsHolder webappsHolder;
    private boolean isGhostOn;
    private String[] defaultWatchedResources;

    public void init(ConfigurationContext configCtx) {
        this.configContext = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
        String repoPath = configCtx.getAxisConfiguration().getRepository().getPath();
        File webappsDirFile = new File(repoPath + File.separator + this.webappsDir);
        if (!webappsDirFile.exists() && !webappsDirFile.mkdirs()) {
            log.warn((Object)("Could not create directory " + webappsDirFile.getAbsolutePath()));
        }
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        int tenantId = privilegedCarbonContext.getTenantId();
        String tenantDomain = privilegedCarbonContext.getTenantDomain();
        String webContextPrefix = tenantDomain != null && !"carbon.super".equals(tenantDomain) ? "/t/" + tenantDomain + "/" + this.webappsDir + "/" : "";
        this.webappsHolder = (WebApplicationsHolder)configCtx.getProperty("carbon.webapps.holder");
        if (this.webappsHolder == null) {
            this.webappsHolder = new WebApplicationsHolder(new File(this.webappsDir));
            configCtx.setProperty("carbon.webapps.holder", (Object)this.webappsHolder);
        }
        this.tomcatWebappDeployer = this.createTomcatGenericWebappDeployer(webContextPrefix, tenantId, tenantDomain);
        configCtx.setProperty("servlet.context.parameters.list", this.servletContextParameters);
        this.isGhostOn = GhostDeployerUtils.isGhostOn();
        this.defaultWatchedResources = new String[]{"WEB-INF" + File.separator + "web.xml", "WEB-INF" + File.separator + "lib", "WEB-INF" + File.separator + "classes"};
    }

    protected abstract TomcatGenericWebappsDeployer createTomcatGenericWebappDeployer(String var1, int var2, String var3);

    protected abstract String getType();

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        if (!this.isSkippedWebapp(deploymentFileData.getFile())) {
            String webappName = deploymentFileData.getFile().getName();
            if (!this.isGhostOn) {
                this.deployThisWebApp(deploymentFileData);
            } else {
                String absoluteFilePath = deploymentFileData.getAbsolutePath();
                File ghostFile = GhostWebappDeployerUtils.getGhostFile(absoluteFilePath, this.axisConfig);
                if (ghostFile == null || !ghostFile.exists()) {
                    this.deployThisWebApp(deploymentFileData);
                    WebApplication webApplication = GhostWebappDeployerUtils.findDeployedWebapp(this.configContext, webappName);
                    if (webApplication != null) {
                        GhostWebappDeployerUtils.updateLastUsedTime(webApplication);
                        if (!CarbonUtils.isWorkerNode()) {
                            GhostWebappDeployerUtils.serializeWebApp(webApplication, this.axisConfig, absoluteFilePath);
                        }
                    }
                } else {
                    WebApplication ghostWebApplication = GhostWebappDeployerUtils.createGhostWebApp(ghostFile, deploymentFileData.getFile(), this.tomcatWebappDeployer, this.configContext);
                    String ghostWebappFileName = deploymentFileData.getFile().getName();
                    if (!this.webappsHolder.getStartedWebapps().containsKey(ghostWebappFileName)) {
                        WebApplicationsHolder webappsHolder = (WebApplicationsHolder)this.configContext.getProperty("carbon.webapps.holder");
                        log.info((Object)("Deploying Ghost webapp : " + ghostWebappFileName));
                        webappsHolder.getStartedWebapps().put(ghostWebappFileName, ghostWebApplication);
                        webappsHolder.getFaultyWebapps().remove(ghostWebappFileName);
                    }
                }
            }
        }
    }

    private void deployThisWebApp(DeploymentFileData deploymentFileData) throws DeploymentException {
        try {
            ArrayList<Object> listeners = new ArrayList<Object>(1);
            this.tomcatWebappDeployer.deploy(deploymentFileData.getFile(), (ArrayList)this.configContext.getProperty("servlet.context.parameters.list"), listeners);
            super.deploy(deploymentFileData);
            WebApplication webApplication = GhostWebappDeployerUtils.findDeployedWebapp(this.configContext, deploymentFileData.getFile().getName());
            if (webApplication != null) {
                String webappType = this.getType();
                if (webappType.equals("webapp") && WebAppUtils.checkJaxApplication(webApplication) != null) {
                    webappType = "jaxWebapp";
                }
                webApplication.setProperty("webappFilter", webappType);
                if (!CarbonUtils.isWorkerNode()) {
                    this.persistWebappMetadata(webApplication, this.axisConfig);
                }
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while deploying webapp : " + deploymentFileData.getFile().getAbsolutePath();
            if (deploymentFileData.getAbsolutePath().contains("carbonapps")) {
                String failedArtifact = deploymentFileData.getFile().getName();
                WebApplicationsHolder webappsHolder = (WebApplicationsHolder)this.configContext.getProperty("carbon.webapps.holder");
                webappsHolder.getFaultyWebapps().remove(failedArtifact);
            }
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
    }

    public void undeploy(String fileName) throws DeploymentException {
        File unpackedFile = null;
        File warFile = null;
        if (fileName.endsWith(".war")) {
            warFile = new File(fileName);
            if (!warFile.exists()) {
                this.handleUndeployment(fileName, warFile);
            } else {
                this.handleUndeployment(fileName, warFile);
                this.handleRedeployment(warFile);
            }
        } else {
            warFile = new File(fileName.concat(".war"));
            unpackedFile = new File(fileName);
            if (!unpackedFile.exists()) {
                if (!warFile.exists()) {
                    this.handleUndeployment(fileName, unpackedFile);
                } else {
                    this.handleUndeployment(fileName, unpackedFile);
                    this.handleRedeployment(warFile);
                }
            } else if (this.isWatchedResourceChanged(fileName, unpackedFile)) {
                if (!warFile.exists()) {
                    this.handleRedeployment(unpackedFile);
                } else {
                    this.handleRedeployment(warFile);
                }
            }
        }
    }

    private boolean isWatchedResourceChanged(String fileName, File file) {
        for (String watchedResource : this.defaultWatchedResources) {
            File watchedResourceFile = new File(fileName + File.separator + watchedResource);
            if (watchedResourceFile.lastModified() <= file.lastModified()) continue;
            return true;
        }
        Context context = this.getWebappContext(file);
        if (context != null) {
            String[] watchedResources;
            for (String watchedResource : watchedResources = ((StandardContext)context).findWatchedResources()) {
                File watchedResourceFile = new File(fileName + File.separator + watchedResource);
                if (watchedResourceFile.lastModified() < file.lastModified()) continue;
                return true;
            }
        }
        return false;
    }

    private Context getWebappContext(File file) {
        WebApplicationsHolder webApplicationsHolder = (WebApplicationsHolder)this.configContext.getProperty("carbon.webapps.holder");
        Map<String, WebApplication> webappMap = webApplicationsHolder.getStartedWebapps();
        WebApplication webapp = null;
        webapp = webappMap.get(file.getName() + ".war");
        if (webapp != null || (webapp = webappMap.get(file.getName())) != null) {
            return webapp.getContext();
        }
        webappMap = webApplicationsHolder.getStoppedWebapps();
        webapp = webappMap.get(file.getName() + ".war");
        if (webapp != null || (webapp = webappMap.get(file.getName())) != null) {
            return webapp.getContext();
        }
        return null;
    }

    public void cleanup() throws DeploymentException {
        for (String filePath : this.deploymentFileDataMap.keySet()) {
            try {
                this.tomcatWebappDeployer.lazyUnload(new File(filePath));
            }
            catch (CarbonException e) {
                String msg = "Error occurred during cleaning up webapps";
                log.error((Object)msg, (Throwable)e);
                throw new DeploymentException(msg, (Throwable)e);
            }
        }
        if (this.isGhostOn && this.webappsHolder != null) {
            for (WebApplication webApplication : this.webappsHolder.getStartedWebapps().values()) {
                try {
                    this.tomcatWebappDeployer.lazyUnload(webApplication.getWebappFile());
                }
                catch (CarbonException e) {
                    String msg = "Error occurred during cleaning up webapps";
                    log.error((Object)msg, (Throwable)e);
                    throw new DeploymentException(msg, (Throwable)e);
                }
            }
        }
    }

    private void persistWebappMetadata(WebApplication webApplication, AxisConfiguration axisConfig) throws ArtifactMetadataException, AxisFault {
        String bamStatsEnabled = webApplication.findParameter("enable.statistics");
        if (bamStatsEnabled == null) {
            webApplication.addParameter("enable.statistics", Boolean.FALSE.toString());
            bamStatsEnabled = "false";
        }
        ArtifactType type = new ArtifactType("webapp", WebappsConstants.WEBAPP_METADATA_DIR);
        ArtifactMetadataManager manager = DeploymentArtifactMetadataFactory.getInstance((AxisConfiguration)axisConfig).getMetadataManager();
        manager.setParameter(webApplication.getWebappFile().getName(), type, "enable.statistics", bamStatsEnabled, false);
    }

    private boolean isSkippedWebapp(File webappFile) {
        String webappFilePath = webappFile.getPath();
        boolean isSkipped = true;
        if (webappFilePath.contains("##")) {
            log.info((Object)("Unsupported file path format : " + webappFile));
            return true;
        }
        if ("war".equals(this.extension) || webappFilePath.endsWith(".war")) {
            return this.isInsideAnotherApp(webappFilePath);
        }
        if (webappFilePath.contains("jaxwebapps") || webappFilePath.contains("jaggeryapps") || webappFilePath.contains("carbonapps")) {
            return false;
        }
        String warFilePath = webappFilePath.concat(".war");
        File warFile = new File(warFilePath);
        if (warFile.exists()) {
            return true;
        }
        Host host = DataHolder.getCarbonTomcatService().getTomcat().getHost();
        String webappContext = "/" + webappFile.getName();
        boolean isExistingFaultyApp = this.isExistingFaultyApp(webappFile.getName());
        if (host.findChild(webappContext) == null && webappFile.isDirectory() && !isExistingFaultyApp) {
            isSkipped = false;
        }
        return isSkipped;
    }

    private boolean isHotUpdating(File file) {
        return file.exists();
    }

    private void handleUndeployment(String fileName, File webappToUndeploy) throws DeploymentException {
        try {
            this.tomcatWebappDeployer.undeploy(webappToUndeploy);
            if (this.isGhostOn && !GhostWebappDeployerUtils.skipUndeploy(fileName)) {
                File ghostFile = GhostWebappDeployerUtils.getGhostFile(fileName, this.axisConfig);
                File dummyContextDir = GhostWebappDeployerUtils.getDummyContextFile(fileName, this.axisConfig);
                if (ghostFile != null && ghostFile.exists() && !ghostFile.delete()) {
                    log.error((Object)("Error while deleting Ghost webapp file : " + ghostFile.getAbsolutePath()));
                }
                if (dummyContextDir != null && dummyContextDir.exists() && !dummyContextDir.delete()) {
                    log.error((Object)("Error while deleting dummy context file : " + dummyContextDir.getAbsolutePath()));
                }
            }
        }
        catch (CarbonException e) {
            String msg = "Error occurred during undeploying webapp: " + fileName;
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
        super.undeploy(fileName);
    }

    public boolean isExistingFaultyApp(String fileName) {
        if (this.webappsHolder.getFaultyWebapps() != null) {
            if (this.webappsHolder.getFaultyWebapps().get(fileName) != null) {
                return true;
            }
            if (this.webappsHolder.getFaultyWebapps().get(fileName + ".war") != null) {
                return true;
            }
        }
        return false;
    }

    private boolean isInsideAnotherApp(String path) {
        boolean fromCApp = path.contains("carbonapps");
        if (path != null && path.endsWith(".war") && !fromCApp) {
            String base = path.substring(0, path.lastIndexOf(File.separator));
            int index = base.lastIndexOf(File.separator) + 1;
            String baseName = base.substring(index);
            if (base != null && !"webapps".equals(baseName)) {
                return true;
            }
            String preBase = base.substring(0, index - 1);
            String preBaseName = preBase.substring(preBase.lastIndexOf(File.separator) + 1);
            if (preBaseName != null && "webapps".equals(preBaseName)) {
                return true;
            }
        }
        return false;
    }

    protected void handleRedeployment(File file) throws DeploymentException {
        DeploymentFileData data = new DeploymentFileData(file, (Deployer)this);
        this.deploy(data);
    }
}

