/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.WildcardGenerator;

public class WildcardFilter
extends Filter {
    protected final Term term;

    public WildcardFilter(Term wildcardTerm) {
        this.term = wildcardTerm;
    }

    public Term getTerm() {
        return this.term;
    }

    public BitSet bits(IndexReader reader) throws IOException {
        final BitSet bitSet = new BitSet(reader.maxDoc());
        new WildcardGenerator(this.term){

            public void handleDoc(int doc) {
                bitSet.set(doc);
            }
        }.generate(reader);
        return bitSet;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final OpenBitSet bitSet = new OpenBitSet(reader.maxDoc());
        new WildcardGenerator(this.term){

            public void handleDoc(int doc) {
                bitSet.set(doc);
            }
        }.generate(reader);
        return bitSet;
    }

    public boolean equals(Object o) {
        return o instanceof WildcardFilter && ((WildcardFilter)o).term.equals(this.term);
    }

    public int hashCode() {
        return this.term.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WildcardFilter(");
        sb.append(this.term.toString());
        sb.append(")");
        return sb.toString();
    }
}

