/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.schema.BeanWriterMetaInfoHolder;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.axis2.schema.typemap.JavaTypeMap;
import org.apache.axis2.schema.util.PrimitiveTypeFinder;
import org.apache.axis2.schema.util.PrimitiveTypeWrapper;
import org.apache.axis2.schema.util.SchemaPropertyLoader;
import org.apache.axis2.schema.writer.BeanWriter;
import org.apache.axis2.util.FileWriter;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PrettyPrinter;
import org.apache.axis2.util.URLProcessor;
import org.apache.axis2.util.XSLTTemplateProcessor;
import org.apache.axis2.util.XSLTUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaBeanWriter
implements BeanWriter {
    private static final Log log = LogFactory.getLog(JavaBeanWriter.class);
    public static final String WRAPPED_DATABINDING_CLASS_NAME = "WrappedDatabinder";
    private String javaBeanTemplateName = null;
    private boolean templateLoaded = false;
    private Templates templateCache;
    private List<String> nameList;
    private Map<String, List<String>> packageNameToClassNamesMap;
    private static int count = 0;
    private boolean wrapClasses = false;
    private boolean writeClasses = false;
    private boolean isUseWrapperClasses = false;
    private String packageName = null;
    private File rootDir;
    private Document globalWrappedDocument;
    private Map modelMap = new HashMap();
    private static final String DEFAULT_PACKAGE = "adb";
    private Map baseTypeMap = new JavaTypeMap().getTypeMap();
    private Map<String, String> ns2packageNameMap = new HashMap<String, String>();
    private boolean isHelperMode = false;
    private boolean isSuppressPrefixesMode = false;
    private String mappingClassPackage = null;
    public static final String EXTENSION_MAPPER_CLASSNAME = "ExtensionMapper";
    public static final String DEFAULT_CLASS_NAME = OMElement.class.getName();
    public static final String DEFAULT_CLASS_ARRAY_NAME = "org.apache.axiom.om.OMElement[]";
    public static final String DEFAULT_ATTRIB_CLASS_NAME = OMAttribute.class.getName();
    public static final String DEFAULT_ATTRIB_ARRAY_CLASS_NAME = "org.apache.axiom.om.OMAttribute[]";
    private int lastPrefixIndex = 1;
    HashMap<String, String> mapURItoPrefix = new HashMap();
    HashMap<String, String> mapPrefixtoURI = new HashMap();

    @Override
    public Map getModelMap() {
        return this.modelMap;
    }

    @Override
    public String getDefaultClassName() {
        return DEFAULT_CLASS_NAME;
    }

    @Override
    public String getDefaultClassArrayName() {
        return DEFAULT_CLASS_ARRAY_NAME;
    }

    @Override
    public String getDefaultAttribClassName() {
        return DEFAULT_ATTRIB_CLASS_NAME;
    }

    @Override
    public String getDefaultAttribArrayClassName() {
        return DEFAULT_ATTRIB_ARRAY_CLASS_NAME;
    }

    @Override
    public void init(CompilerOptions options) throws SchemaCompilationException {
        try {
            this.modelMap = new HashMap();
            this.ns2packageNameMap = new HashMap<String, String>();
            this.mappingClassPackage = null;
            this.initWithFile(options.getOutputLocation());
            this.packageName = options.getPackageName();
            this.writeClasses = options.isWriteOutput();
            this.isUseWrapperClasses = options.isUseWrapperClasses();
            this.wrapClasses = !this.writeClasses ? false : options.isWrapClasses();
            if (options.isWrapClasses()) {
                this.globalWrappedDocument = XSLTUtils.getDocument();
                Element rootElement = XSLTUtils.getElement(this.globalWrappedDocument, "beans");
                this.globalWrappedDocument.appendChild(rootElement);
                XSLTUtils.addAttribute(this.globalWrappedDocument, "name", WRAPPED_DATABINDING_CLASS_NAME, rootElement);
                String tempPackageName = this.packageName != null && this.packageName.endsWith(".") ? this.packageName.substring(0, this.packageName.lastIndexOf(".")) : DEFAULT_PACKAGE;
                XSLTUtils.addAttribute(this.globalWrappedDocument, "package", tempPackageName, rootElement);
            }
            this.ns2packageNameMap = options.getNs2PackageMap();
            this.isHelperMode = options.isHelperMode();
            this.isSuppressPrefixesMode = options.isSuppressPrefixesMode();
            if (options.isMapperClassPackagePresent()) {
                this.mappingClassPackage = options.getMapperClassPackage();
            }
        }
        catch (IOException e) {
            throw new SchemaCompilationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(XmlSchemaElement element, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = element.getQName();
            return this.process(qName, metainf, typeMap, groupTypeMap, true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(QName qName, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf, boolean isAbstract) throws SchemaCompilationException {
        try {
            return this.process(qName, metainf, typeMap, groupTypeMap, false, isAbstract);
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public void writeBatch() throws SchemaCompilationException {
        try {
            if (this.wrapClasses) {
                String tempPackage = this.packageName == null ? DEFAULT_PACKAGE : this.packageName;
                File out = this.createOutFile(tempPackage, WRAPPED_DATABINDING_CLASS_NAME);
                this.parse(this.globalWrappedDocument, out);
            }
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(XmlSchemaSimpleType simpleType, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = simpleType.getQName();
            if (qName == null) {
                qName = (QName)simpleType.getMetaInfoMap().get("Q_NAME");
            }
            metainf.addtStatus(qName, 64);
            return this.process(qName, metainf, typeMap, groupTypeMap, true, false);
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    private void initWithFile(File rootDir) throws IOException {
        if (rootDir == null) {
            this.rootDir = new File(".");
        } else {
            if (!rootDir.isDirectory()) {
                throw new IOException(SchemaCompilerMessages.getMessage("schema.rootnotfolderexception"));
            }
            this.rootDir = rootDir;
        }
        this.nameList = new ArrayList<String>();
        this.packageNameToClassNamesMap = new HashMap<String, List<String>>();
        this.javaBeanTemplateName = SchemaPropertyLoader.getBeanTemplate();
    }

    @Override
    public String makeFullyQualifiedClassName(QName qName) {
        String namespaceURI = qName.getNamespaceURI();
        String packageName = this.getPackage(namespaceURI);
        String originalName = qName.getLocalPart();
        String className = null;
        if (!this.wrapClasses) {
            className = this.makeUniqueJavaClassName(this.nameList, originalName);
        } else {
            if (!this.packageNameToClassNamesMap.containsKey(packageName)) {
                this.packageNameToClassNamesMap.put(packageName, new ArrayList());
            }
            className = this.makeUniqueJavaClassName(this.packageNameToClassNamesMap.get(packageName), originalName);
        }
        String packagePrefix = null;
        if (this.wrapClasses) {
            packagePrefix = (this.packageName == null ? "adb." : this.packageName) + WRAPPED_DATABINDING_CLASS_NAME;
        } else if (this.writeClasses) {
            packagePrefix = packageName;
        }
        String fullyqualifiedClassName = packagePrefix != null ? packagePrefix + (packagePrefix.endsWith(".") ? "" : ".") + className : className;
        return fullyqualifiedClassName;
    }

    private String getPackage(String namespaceURI) {
        String basePackageName = this.ns2packageNameMap != null && this.ns2packageNameMap.containsKey(namespaceURI) ? this.ns2packageNameMap.get(namespaceURI) : URLProcessor.makePackageName(namespaceURI);
        return this.packageName == null ? basePackageName : this.packageName + basePackageName;
    }

    private String process(QName qName, BeanWriterMetaInfoHolder metainf, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isElement, boolean isAbstract) throws Exception {
        String fullyQualifiedClassName = metainf.getOwnClassName();
        if (fullyQualifiedClassName == null) {
            fullyQualifiedClassName = this.makeFullyQualifiedClassName(qName);
        }
        String className = fullyQualifiedClassName.substring(1 + fullyQualifiedClassName.lastIndexOf(46));
        String basePackageName = fullyQualifiedClassName.lastIndexOf(46) == -1 ? "" : fullyQualifiedClassName.substring(0, fullyQualifiedClassName.lastIndexOf(46));
        String originalName = qName == null ? "" : qName.getLocalPart();
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (!this.templateLoaded) {
            this.loadTemplate();
        }
        if (this.wrapClasses) {
            this.globalWrappedDocument.getDocumentElement().appendChild(this.getBeanElement(this.globalWrappedDocument, className, originalName, basePackageName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
        } else {
            Document model = XSLTUtils.getDocument();
            model.appendChild(this.getBeanElement(model, className, originalName, basePackageName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
            if (this.writeClasses) {
                File out = this.createOutFile(basePackageName, className);
                if (this.isHelperMode) {
                    XSLTUtils.addAttribute(model, "helperMode", "yes", model.getDocumentElement());
                    this.parse(model, out);
                    out = this.createOutFile(basePackageName, className + "Helper");
                    XSLTUtils.addAttribute(model, "helper", "yes", model.getDocumentElement());
                    this.parse(model, out);
                } else {
                    this.parse(model, out);
                }
            }
            this.modelMap.put(new QName(qName.getNamespaceURI(), className), model);
        }
        return fullyQualifiedClassName;
    }

    private Element getBeanElement(Document model, String className, String originalName, String packageName, QName qName, boolean isElement, boolean isAbstract, BeanWriterMetaInfoHolder metainf, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap) throws SchemaCompilationException {
        Element rootElt = XSLTUtils.getElement(model, "bean");
        XSLTUtils.addAttribute(model, "name", className, rootElt);
        XSLTUtils.addAttribute(model, "originalName", originalName, rootElt);
        XSLTUtils.addAttribute(model, "package", packageName, rootElt);
        XSLTUtils.addAttribute(model, "nsuri", qName.getNamespaceURI(), rootElt);
        XSLTUtils.addAttribute(model, "nsprefix", this.isSuppressPrefixesMode ? "" : this.getPrefixForURI(qName.getNamespaceURI(), qName.getPrefix()), rootElt);
        if (!this.wrapClasses) {
            XSLTUtils.addAttribute(model, "unwrapped", "yes", rootElt);
        }
        if (isAbstract) {
            XSLTUtils.addAttribute(model, "isAbstract", "yes", rootElt);
        }
        if (!this.writeClasses) {
            XSLTUtils.addAttribute(model, "skip-write", "yes", rootElt);
        }
        if (!isElement) {
            XSLTUtils.addAttribute(model, "type", "yes", rootElt);
        }
        if (metainf.isAnonymous()) {
            XSLTUtils.addAttribute(model, "anon", "yes", rootElt);
        }
        if (this.isUseWrapperClasses) {
            XSLTUtils.addAttribute(model, "usewrapperclasses", "yes", rootElt);
        }
        if (metainf.isExtension()) {
            XSLTUtils.addAttribute(model, "extension", metainf.getExtensionClassName(), rootElt);
        }
        if (metainf.isRestriction()) {
            XSLTUtils.addAttribute(model, "restriction", metainf.getRestrictionClassName(), rootElt);
        }
        XSLTUtils.addAttribute(model, "mapperClass", this.getFullyQualifiedMapperClassName(), rootElt);
        if (metainf.isChoice()) {
            XSLTUtils.addAttribute(model, "choice", "yes", rootElt);
        }
        if (metainf.isSimple()) {
            XSLTUtils.addAttribute(model, "simple", "yes", rootElt);
        }
        if (metainf.isUnion()) {
            XSLTUtils.addAttribute(model, "union", "yes", rootElt);
        }
        if (metainf.isList()) {
            XSLTUtils.addAttribute(model, "list", "yes", rootElt);
        }
        if (metainf.isOrdered()) {
            XSLTUtils.addAttribute(model, "ordered", "yes", rootElt);
        }
        if (isElement && metainf.isNillable(qName)) {
            XSLTUtils.addAttribute(model, "nillable", "yes", rootElt);
        }
        if (metainf.isParticleClass()) {
            XSLTUtils.addAttribute(model, "particleClass", "yes", rootElt);
        }
        if (metainf.isHasParticleType()) {
            XSLTUtils.addAttribute(model, "hasParticleType", "yes", rootElt);
        }
        this.populateInfo(metainf, model, rootElt, propertyNames, typeMap, groupTypeMap, false);
        if (metainf.isSimple() && metainf.isUnion()) {
            this.populateMemberInfo(metainf, model, rootElt, typeMap);
        }
        if (metainf.isSimple() && metainf.isList()) {
            this.populateListInfo(metainf, model, rootElt, typeMap, groupTypeMap);
        }
        return rootElt;
    }

    protected void populateListInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElement, Map<QName, String> typeMap, Map<QName, String> groupTypeMap) {
        String javaName = this.makeUniqueJavaClassName(new ArrayList<String>(), metainf.getItemTypeQName().getLocalPart());
        Element itemType = XSLTUtils.addChildElement(model, "itemtype", rootElement);
        XSLTUtils.addAttribute(model, "type", metainf.getItemTypeClassName(), itemType);
        XSLTUtils.addAttribute(model, "nsuri", metainf.getItemTypeQName().getNamespaceURI(), itemType);
        XSLTUtils.addAttribute(model, "originalName", metainf.getItemTypeQName().getLocalPart(), itemType);
        XSLTUtils.addAttribute(model, "javaname", javaName, itemType);
        if (typeMap.containsKey(metainf.getItemTypeQName()) || groupTypeMap.containsKey(metainf.getItemTypeClassName())) {
            XSLTUtils.addAttribute(model, "ours", "true", itemType);
        }
        if (PrimitiveTypeFinder.isPrimitive(metainf.getItemTypeClassName())) {
            XSLTUtils.addAttribute(model, "primitive", "yes", itemType);
        }
        String shortTypeName = this.getShortTypeName(metainf.getItemTypeClassName());
        XSLTUtils.addAttribute(model, "shorttypename", shortTypeName, itemType);
    }

    protected void populateMemberInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElement, Map<QName, String> typeMap) {
        Map<QName, String> memberTypes = metainf.getMemberTypes();
        for (QName memberQName : metainf.getMemberTypesKeys()) {
            String memberClass = memberTypes.get(memberQName);
            if (PrimitiveTypeFinder.isPrimitive(memberClass)) {
                memberClass = PrimitiveTypeWrapper.getWrapper(memberClass);
            }
            Element memberType = XSLTUtils.addChildElement(model, "memberType", rootElement);
            XSLTUtils.addAttribute(model, "type", memberClass, memberType);
            XSLTUtils.addAttribute(model, "nsuri", memberQName.getNamespaceURI(), memberType);
            XSLTUtils.addAttribute(model, "originalName", memberQName.getLocalPart(), memberType);
            if (typeMap.containsKey(memberQName)) {
                XSLTUtils.addAttribute(model, "ours", "true", memberType);
            }
            String shortTypeName = this.getShortTypeName(memberClass);
            XSLTUtils.addAttribute(model, "shorttypename", shortTypeName, memberType);
        }
    }

    private void populateInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isInherited) throws SchemaCompilationException {
        if (metainf.getParent() != null && (!metainf.isRestriction() || metainf.isRestriction() && metainf.isSimple())) {
            this.populateInfo(metainf.getParent(), model, rootElt, propertyNames, typeMap, groupTypeMap, true);
        }
        this.addPropertyEntries(metainf, model, rootElt, propertyNames, typeMap, groupTypeMap, isInherited);
    }

    private void addPropertyEntries(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isInherited) throws SchemaCompilationException {
        ArrayList<QName> missingQNames = new ArrayList<QName>();
        ArrayList<QName> qNames = new ArrayList<QName>();
        BeanWriterMetaInfoHolder parentMetaInf = metainf.getParent();
        QName[] qName = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        for (int i = 0; i < qName.length; ++i) {
            qNames.add(qName[i]);
        }
        if (metainf.isRestriction() && !metainf.isSimple()) {
            this.addMissingQNames(metainf, qNames, missingQNames);
        }
        ArrayList<BeanWriterMetaInfoHolder> parents = new ArrayList<BeanWriterMetaInfoHolder>();
        for (BeanWriterMetaInfoHolder immediateParent = metainf.getParent(); immediateParent != null; immediateParent = immediateParent.getParent()) {
            parents.add(immediateParent);
        }
        for (QName name : qNames) {
            QName schemaQName;
            String javaName;
            Element property = XSLTUtils.addChildElement(model, "property", rootElt);
            String xmlName = name.getLocalPart();
            String xmlNameNew = this.identifyUniqueNameForQName(parents, xmlName, metainf, name, name);
            while (!xmlName.equalsIgnoreCase(xmlNameNew)) {
                xmlName = xmlNameNew;
                xmlNameNew = this.identifyUniqueNameForQName(parents, xmlNameNew, metainf, name, new QName(xmlNameNew));
            }
            XSLTUtils.addAttribute(model, "name", xmlName, property);
            XSLTUtils.addAttribute(model, "nsuri", name.getNamespaceURI(), property);
            if (metainf.isJavaNameMappingAvailable(xmlName)) {
                javaName = metainf.getJavaName(xmlName);
            } else {
                javaName = this.makeUniqueJavaClassName(propertyNames, xmlName);
                if (parentMetaInf != null && metainf.isRestriction() && !missingQNames.contains(name) && parentMetaInf.getArrayStatusForQName(name) && !metainf.getArrayStatusForQName(name)) {
                    javaName = this.makeUniqueJavaClassName(propertyNames, xmlName);
                }
                metainf.addXmlNameJavaNameMapping(xmlName, javaName);
            }
            XSLTUtils.addAttribute(model, "javaname", javaName, property);
            String javaClassNameForElement = parentMetaInf != null && metainf.isRestriction() && missingQNames.contains(name) ? parentMetaInf.getClassNameForQName(name) : metainf.getClassNameForQName(name);
            if (javaClassNameForElement == null) {
                javaClassNameForElement = this.getDefaultClassName();
                log.warn((Object)SchemaCompilerMessages.getMessage("schema.typeMissing", name.toString()));
            }
            if (metainf.isRestriction() && this.typeChanged(name, missingQNames, metainf)) {
                XSLTUtils.addAttribute(model, "typeChanged", "yes", property);
            }
            long minOccurs = metainf.getMinOccurs(name);
            if (PrimitiveTypeFinder.isPrimitive(javaClassNameForElement) && this.isUseWrapperClasses && (minOccurs == 0L || metainf.isNillable(name))) {
                javaClassNameForElement = PrimitiveTypeWrapper.getWrapper(javaClassNameForElement);
            }
            XSLTUtils.addAttribute(model, "type", javaClassNameForElement, property);
            if (PrimitiveTypeFinder.isPrimitive(javaClassNameForElement)) {
                XSLTUtils.addAttribute(model, "primitive", "yes", property);
            }
            if (metainf.isDefaultValueAvailable(name) && this.baseTypeMap.containsKey(schemaQName = metainf.getSchemaQNameForQName(name))) {
                XSLTUtils.addAttribute(model, "defaultValue", metainf.getDefaultValueForQName(name), property);
            }
            if (parentMetaInf != null && metainf.isRestriction() && !missingQNames.contains(name) && parentMetaInf.getArrayStatusForQName(name) && !metainf.getArrayStatusForQName(name)) {
                XSLTUtils.addAttribute(model, "rewrite", "yes", property);
                XSLTUtils.addAttribute(model, "occuranceChanged", "yes", property);
            } else if (metainf.isRestriction() && !missingQNames.contains(name) && (this.minOccursChanged(name, missingQNames, metainf) || this.maxOccursChanged(name, missingQNames, metainf))) {
                XSLTUtils.addAttribute(model, "restricted", "yes", property);
                XSLTUtils.addAttribute(model, "occuranceChanged", "yes", property);
            }
            if (metainf.getParticleTypeStatusForQName(name)) {
                XSLTUtils.addAttribute(model, "particleClassType", "yes", property);
            }
            if (metainf.isHasParticleType()) {
                XSLTUtils.addAttribute(model, "hasParticleType", "yes", rootElt);
            }
            if (metainf.isRestriction() && missingQNames.contains(name) && !metainf.isSimple()) {
                XSLTUtils.addAttribute(model, "removed", "yes", property);
            }
            if (isInherited) {
                XSLTUtils.addAttribute(model, "inherited", "yes", property);
            }
            if (metainf.getInnerChoiceStatusForQName(name)) {
                XSLTUtils.addAttribute(model, "innerchoice", "yes", property);
            }
            if (parentMetaInf != null && metainf.isRestriction() && missingQNames.contains(name)) {
                this.addAttributesToProperty(parentMetaInf, name, model, property, typeMap, groupTypeMap, javaClassNameForElement);
                continue;
            }
            this.addAttributesToProperty(metainf, name, model, property, typeMap, groupTypeMap, javaClassNameForElement);
        }
    }

    private void addAttributesToProperty(BeanWriterMetaInfoHolder metainf, QName name, Document model, Element property, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, String javaClassNameForElement) {
        if (metainf.getDefaultStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "default", "yes", property);
        }
        if (typeMap.containsKey(metainf.getSchemaQNameForQName(name)) || groupTypeMap.containsKey(metainf.getSchemaQNameForQName(name))) {
            XSLTUtils.addAttribute(model, "ours", "yes", property);
        }
        if (metainf.getAttributeStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "attribute", "yes", property);
        }
        if (metainf.isNillable(name)) {
            XSLTUtils.addAttribute(model, "nillable", "yes", property);
        }
        if (metainf.getOptionalAttributeStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "optional", "yes", property);
        }
        String shortTypeName = metainf.getSchemaQNameForQName(name) != null ? (this.baseTypeMap.containsKey(metainf.getSchemaQNameForQName(name)) ? metainf.getSchemaQNameForQName(name).getLocalPart() : this.getShortTypeName(javaClassNameForElement)) : this.getShortTypeName(javaClassNameForElement);
        XSLTUtils.addAttribute(model, "shorttypename", shortTypeName, property);
        if (metainf.getAnyStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "any", "yes", property);
        }
        if (metainf.getBinaryStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "binary", "yes", property);
        }
        if (metainf.isSimple() || metainf.getSimpleStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "simple", "yes", property);
        }
        long minOccurs = metainf.getMinOccurs(name);
        XSLTUtils.addAttribute(model, "minOccurs", minOccurs + "", property);
        if (metainf.getArrayStatusForQName(name)) {
            XSLTUtils.addAttribute(model, "array", "yes", property);
            int endIndex = javaClassNameForElement.indexOf("[");
            if (endIndex >= 0) {
                XSLTUtils.addAttribute(model, "arrayBaseType", javaClassNameForElement.substring(0, endIndex), property);
            } else {
                XSLTUtils.addAttribute(model, "arrayBaseType", javaClassNameForElement, property);
            }
            long maxOccurs = metainf.getMaxOccurs(name);
            if (maxOccurs == Long.MAX_VALUE) {
                XSLTUtils.addAttribute(model, "unbound", "yes", property);
            } else {
                XSLTUtils.addAttribute(model, "maxOccurs", maxOccurs + "", property);
            }
        }
        if (metainf.isRestrictionBaseType(name)) {
            XSLTUtils.addAttribute(model, "restrictionBaseType", "yes", property);
        }
        if (metainf.isExtensionBaseType(name)) {
            XSLTUtils.addAttribute(model, "extensionBaseType", "yes", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getLengthFacet() != -1L) {
            XSLTUtils.addAttribute(model, "lenFacet", metainf.getLengthFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxLengthFacet() != -1L) {
            XSLTUtils.addAttribute(model, "maxLenFacet", metainf.getMaxLengthFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinLengthFacet() != -1L) {
            XSLTUtils.addAttribute(model, "minLenFacet", metainf.getMinLengthFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxExclusiveFacet() != null) {
            XSLTUtils.addAttribute(model, "maxExFacet", metainf.getMaxExclusiveFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinExclusiveFacet() != null) {
            XSLTUtils.addAttribute(model, "minExFacet", metainf.getMinExclusiveFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxInclusiveFacet() != null) {
            XSLTUtils.addAttribute(model, "maxInFacet", metainf.getMaxInclusiveFacet() + "", property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinInclusiveFacet() != null) {
            XSLTUtils.addAttribute(model, "minInFacet", metainf.getMinInclusiveFacet() + "", property);
        }
        if (!metainf.getEnumFacet().isEmpty()) {
            boolean validJava = true;
            for (String value : metainf.getEnumFacet()) {
                if (JavaUtils.isJavaId(value)) continue;
                validJava = false;
            }
            int id = 0;
            for (String attribValue : metainf.getEnumFacet()) {
                Element enumFacet = XSLTUtils.addChildElement(model, "enumFacet", property);
                XSLTUtils.addAttribute(model, "value", attribValue, enumFacet);
                if (validJava) {
                    XSLTUtils.addAttribute(model, "id", attribValue, enumFacet);
                    continue;
                }
                XSLTUtils.addAttribute(model, "id", "value" + ++id, enumFacet);
            }
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getPatternFacet() != null) {
            XSLTUtils.addAttribute(model, "patternFacet", metainf.getPatternFacet(), property);
        }
    }

    private void addMissingQNames(BeanWriterMetaInfoHolder metainf, ArrayList<QName> qName, ArrayList<QName> missingQNames) {
        int i;
        QName[] qNames = null;
        QName[] pQNames = null;
        BeanWriterMetaInfoHolder parentMetaInf = metainf.getParent();
        qNames = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        if (parentMetaInf != null) {
            pQNames = parentMetaInf.isOrdered() ? parentMetaInf.getOrderedQNameArray() : parentMetaInf.getQNameArray();
        }
        for (i = 0; pQNames != null && i < pQNames.length; ++i) {
            if (!this.qNameNotFound(pQNames[i], metainf)) continue;
            missingQNames.add(pQNames[i]);
        }
        if (!missingQNames.isEmpty()) {
            for (i = 0; i < missingQNames.size(); ++i) {
                qName.add(missingQNames.get(i));
            }
        }
    }

    private boolean qNameNotFound(QName qname, BeanWriterMetaInfoHolder metainf) {
        boolean found = false;
        QName[] qNames = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        for (int j = 0; j < qNames.length; ++j) {
            if (!qname.getLocalPart().equals(qNames[j].getLocalPart())) continue;
            found = true;
        }
        return !found;
    }

    private boolean typeChanged(QName qname, ArrayList<QName> missingQNames, BeanWriterMetaInfoHolder metainf) {
        boolean typeChanged = false;
        BeanWriterMetaInfoHolder parentMetainf = metainf.getParent();
        if (parentMetainf != null && !missingQNames.contains(qname)) {
            QName[] pQNames = parentMetainf.isOrdered() ? parentMetainf.getOrderedQNameArray() : parentMetainf.getQNameArray();
            for (int j = 0; j < pQNames.length; ++j) {
                String javaClassForElement;
                String javaClassForParentElement;
                if (!qname.getLocalPart().equals(pQNames[j].getLocalPart()) || (javaClassForParentElement = parentMetainf.getClassNameForQName(pQNames[j])).equals(javaClassForElement = metainf.getClassNameForQName(qname))) continue;
                if (javaClassForParentElement.endsWith("[]")) {
                    if (!javaClassForParentElement.substring(0, javaClassForParentElement.indexOf(91)).equals(javaClassForElement)) continue;
                    continue;
                }
                if (javaClassForElement.endsWith("[]")) {
                    if (!javaClassForElement.substring(0, javaClassForElement.indexOf(91)).equals(javaClassForParentElement)) continue;
                    continue;
                }
                typeChanged = true;
            }
        }
        return typeChanged;
    }

    private boolean minOccursChanged(QName qname, ArrayList<QName> missingQNames, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        boolean minChanged = false;
        BeanWriterMetaInfoHolder parentMetainf = metainf.getParent();
        if (parentMetainf != null && !missingQNames.contains(qname)) {
            QName[] pQNames = parentMetainf.isOrdered() ? parentMetainf.getOrderedQNameArray() : parentMetainf.getQNameArray();
            for (int j = 0; j < pQNames.length; ++j) {
                if (!qname.getLocalPart().equals(pQNames[j].getLocalPart())) continue;
                if (metainf.getMinOccurs(qname) > parentMetainf.getMinOccurs(pQNames[j])) {
                    minChanged = true;
                    continue;
                }
                if (metainf.getMinOccurs(qname) >= parentMetainf.getMinOccurs(pQNames[j])) continue;
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("minOccurs Wrong!"));
            }
        }
        return minChanged;
    }

    private boolean maxOccursChanged(QName qname, ArrayList<QName> missingQNames, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        boolean maxChanged = false;
        BeanWriterMetaInfoHolder parentMetainf = metainf.getParent();
        if (parentMetainf != null && !missingQNames.contains(qname)) {
            QName[] pQNames = parentMetainf.isOrdered() ? parentMetainf.getOrderedQNameArray() : parentMetainf.getQNameArray();
            for (int j = 0; j < pQNames.length; ++j) {
                if (!qname.getLocalPart().equals(pQNames[j].getLocalPart())) continue;
                if (metainf.getMaxOccurs(qname) < parentMetainf.getMaxOccurs(pQNames[j])) {
                    maxChanged = true;
                    continue;
                }
                if (metainf.getMaxOccurs(qname) <= parentMetainf.getMaxOccurs(pQNames[j])) continue;
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("maxOccurs Wrong!"));
            }
        }
        return maxChanged;
    }

    private boolean isDefault(String javaClassNameForElement) {
        return this.getDefaultClassName().equals(javaClassNameForElement) || this.getDefaultClassArrayName().equals(javaClassNameForElement);
    }

    private String makeUniqueJavaClassName(List<String> listOfNames, String xmlName) {
        String javaName = JavaUtils.isJavaKeyword(xmlName) ? JavaUtils.makeNonJavaKeyword(xmlName) : JavaUtils.capitalizeFirstChar(JavaUtils.xmlNameToJava(xmlName));
        while (listOfNames.contains(javaName.toLowerCase())) {
            if (!listOfNames.contains((javaName + "E").toLowerCase())) {
                javaName = javaName + "E";
                continue;
            }
            javaName = javaName + count++;
        }
        listOfNames.add(javaName.toLowerCase());
        return javaName;
    }

    private void loadTemplate() throws SchemaCompilationException {
        Class<?> clazz = this.getClass();
        String templateName = this.javaBeanTemplateName;
        if (templateName != null) {
            try {
                URL xsl = clazz.getResource(templateName);
                this.templateCache = TransformerFactory.newInstance().newTemplates(new StreamSource(xsl.toExternalForm()));
                this.templateLoaded = true;
            }
            catch (TransformerConfigurationException e) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateLoadException"), e);
            }
        } else {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateNotFoundException"));
        }
    }

    private File createOutFile(String packageName, String fileName) throws Exception {
        return FileWriter.createClassFile(this.rootDir, packageName, fileName, ".java");
    }

    private void parse(Document doc, File outputFile) throws Exception {
        FileOutputStream outStream = new FileOutputStream(outputFile);
        XSLTTemplateProcessor.parse((OutputStream)outStream, doc, this.getTransformer());
        outStream.flush();
        ((OutputStream)outStream).close();
        PrettyPrinter.prettify(outputFile);
    }

    private Transformer getTransformer() throws TransformerConfigurationException, SchemaCompilationException {
        try {
            return this.templateCache.newTransformer();
        }
        catch (Exception e) {
            this.loadTemplate();
            return this.templateCache.newTransformer();
        }
    }

    public String getPrefixForURI(String uri) {
        return this.getPrefixForURI(uri, null);
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String prefix = this.mapURItoPrefix.get(uri);
        if (prefix == null) {
            if (defaultPrefix == null || defaultPrefix.length() == 0) {
                prefix = "ns" + this.lastPrefixIndex++;
                while (this.mapPrefixtoURI.get(prefix) != null) {
                    prefix = "ns" + this.lastPrefixIndex++;
                }
            } else {
                prefix = defaultPrefix;
            }
            this.mapPrefixtoURI.put(prefix, uri);
            this.mapURItoPrefix.put(uri, prefix);
        }
        return prefix;
    }

    private String getShortTypeName(String typeClassName) {
        if (typeClassName.endsWith("[]")) {
            typeClassName = typeClassName.substring(0, typeClassName.lastIndexOf("["));
        }
        return typeClassName.substring(typeClassName.lastIndexOf(".") + 1, typeClassName.length());
    }

    private String getFullyQualifiedMapperClassName() {
        if (this.wrapClasses || !this.writeClasses || this.mappingClassPackage == null) {
            return EXTENSION_MAPPER_CLASSNAME;
        }
        return this.mappingClassPackage + "." + EXTENSION_MAPPER_CLASSNAME;
    }

    @Override
    public String getExtensionMapperPackageName() {
        return this.mappingClassPackage;
    }

    @Override
    public void registerExtensionMapperPackageName(String mapperPackageName) {
        this.mappingClassPackage = mapperPackageName;
    }

    @Override
    public void writeExtensionMapper(BeanWriterMetaInfoHolder[] metainfArray) throws SchemaCompilationException {
        try {
            String mapperClassName = this.getFullyQualifiedMapperClassName();
            Document model = XSLTUtils.getDocument();
            Element rootElt = XSLTUtils.getElement(model, "mapper");
            String mapperName = mapperClassName.substring(mapperClassName.lastIndexOf(".") + 1);
            XSLTUtils.addAttribute(model, "name", mapperName, rootElt);
            String basePackageName = "";
            if (mapperClassName.indexOf(".") != -1) {
                basePackageName = mapperClassName.substring(0, mapperClassName.lastIndexOf("."));
                XSLTUtils.addAttribute(model, "package", basePackageName, rootElt);
            } else {
                XSLTUtils.addAttribute(model, "package", "", rootElt);
            }
            if (!this.wrapClasses) {
                XSLTUtils.addAttribute(model, "unwrapped", "yes", rootElt);
            }
            if (!this.writeClasses) {
                XSLTUtils.addAttribute(model, "skip-write", "yes", rootElt);
            }
            if (this.isHelperMode) {
                XSLTUtils.addAttribute(model, "helpermode", "yes", rootElt);
            }
            for (int i = 0; i < metainfArray.length; ++i) {
                QName ownQname = metainfArray[i].getOwnQname();
                String className = metainfArray[i].getOwnClassName();
                if (ownQname == null) continue;
                Element typeChild = XSLTUtils.addChildElement(model, "type", rootElt);
                XSLTUtils.addAttribute(model, "nsuri", ownQname.getNamespaceURI(), typeChild);
                XSLTUtils.addAttribute(model, "classname", className == null ? "" : className, typeChild);
                XSLTUtils.addAttribute(model, "shortname", ownQname == null ? "" : ownQname.getLocalPart(), typeChild);
            }
            model.appendChild(rootElt);
            if (!this.templateLoaded) {
                this.loadTemplate();
            }
            if (this.wrapClasses) {
                rootElt = (Element)this.globalWrappedDocument.importNode(rootElt, true);
                this.globalWrappedDocument.getDocumentElement().appendChild(rootElt);
            } else {
                if (this.writeClasses) {
                    File out = this.createOutFile(basePackageName, mapperName);
                    this.parse(model, out);
                }
                this.modelMap.put(new QName(mapperName), model);
            }
        }
        catch (ParserConfigurationException e) {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.docuement.error"), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SchemaCompilationException(e);
        }
    }

    private String identifyUniqueNameForQName(List<BeanWriterMetaInfoHolder> parents, String xmlName, BeanWriterMetaInfoHolder metainf, QName original, QName modified) {
        int count = 0;
        for (BeanWriterMetaInfoHolder beanWriterMetaInfoHolder : parents) {
            QName[] pQNmame = null;
            pQNmame = beanWriterMetaInfoHolder.isOrdered() ? beanWriterMetaInfoHolder.getOrderedQNameArray() : beanWriterMetaInfoHolder.getQNameArray();
            List<QName> pQNameList = null;
            if (pQNmame != null) {
                pQNameList = Arrays.asList(pQNmame);
            }
            if (pQNameList != null && pQNameList.contains(modified) && metainf.getClassNameForQName(original) != null && !metainf.getClassNameForQName(original).equalsIgnoreCase(beanWriterMetaInfoHolder.getClassNameForQName(modified))) {
                xmlName = xmlName + count;
                break;
            }
            ++count;
        }
        return xmlName;
    }
}

