/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class OutOnlyAxisOperationClient
extends OperationClient {
    private static final Log log = LogFactory.getLog(OutOnlyAxisOperationClient.class);
    private MessageContext mc;

    OutOnlyAxisOperationClient(OutOnlyAxisOperation axisOp, ServiceContext sc, Options options) {
        super(axisOp, sc, options);
    }

    @Override
    public void addMessageContext(MessageContext mc) throws AxisFault {
        if (this.mc != null) {
            throw new AxisFault(Messages.getMessage("cannotaddmsgctx"));
        }
        this.mc = mc;
        if (mc.getMessageID() == null) {
            this.setMessageID(mc);
        }
        mc.setServiceContext(this.sc);
        this.axisOp.registerOperationContext(mc, this.oc);
        this.completed = false;
    }

    @Override
    public MessageContext getMessageContext(String messageLabel) throws AxisFault {
        if (messageLabel.equals("Out")) {
            return this.mc;
        }
        throw new AxisFault(Messages.getMessage("unknownMsgLabel", messageLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeImpl(boolean block) throws AxisFault {
        if (this.completed) {
            throw new AxisFault(Messages.getMessage("mepiscomplted"));
        }
        ConfigurationContext cc = this.sc.getConfigurationContext();
        this.prepareMessageContext(cc, this.mc);
        EndpointReference epr = this.mc.getReplyTo();
        if (epr == null) {
            this.mc.setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/none"));
        } else if (epr.isWSAddressingAnonymous() && epr.getAllReferenceParameters() != null) {
            this.mc.setProperty("includeOptionalHeaders", Boolean.TRUE);
        }
        OperationContext oc = this.sc.createOperationContext(this.axisOp);
        oc.addMessageContext(this.mc);
        if (this.axisCallback != null) {
            CallbackReceiver callbackReceiver;
            AxisOperation axisOperation = this.axisOp;
            synchronized (axisOperation) {
                if (this.axisOp.getMessageReceiver() != null && this.axisOp.getMessageReceiver() instanceof CallbackReceiver) {
                    callbackReceiver = (CallbackReceiver)this.axisOp.getMessageReceiver();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Creating new callback receiver");
                    }
                    callbackReceiver = new CallbackReceiver();
                    this.axisOp.setMessageReceiver(callbackReceiver);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("OutInAxisOperation: callbackReceiver " + callbackReceiver + " : " + this.axisOp));
                    }
                }
            }
            callbackReceiver.addCallback(this.mc.getMessageID(), this.axisCallback);
            if (log.isDebugEnabled()) {
                log.debug((Object)"OutInAxisOperationClient: Creating axis callback");
            }
        }
        AxisEngine.send(this.mc);
        this.completed = true;
    }
}

