/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.scriptengine.engine;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class RhinoTopLevel
extends ImporterTopLevel {
    private static final String JS_TIMER_THREADS = "jsTimerThreads";
    private static final Log log = LogFactory.getLog(RhinoTopLevel.class);
    private static final ScheduledExecutorService timerExecutor;
    private static final Map<String, Map<String, ScheduledFuture>> timeouts;
    private static final Map<String, Map<String, ScheduledFuture>> intervals;

    public RhinoTopLevel(Context context, boolean sealed) {
        super(context, sealed);
    }

    public static Object parse(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "parse";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs("[GLOBAL]", functionName, argsCount, false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError("[GLOBAL]", "[GLOBAL]", "1", "string", args[0], false);
        }
        return HostObjectUtil.parseJSON(thisObj, (String)args[0]);
    }

    public static String stringify(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "stringify";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs("[GLOBAL]", functionName, argsCount, false);
        }
        return HostObjectUtil.serializeJSON(args[0]);
    }

    public static String setTimeout(Context cx, final Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "setTimeout";
        int argsCount = args.length;
        if (argsCount < 2) {
            HostObjectUtil.invalidNumberOfArgs("[GLOBAL]", functionName, argsCount, false);
        }
        Function function = null;
        if (args[0] instanceof Function) {
            function = (Function)args[0];
        } else if (args[0] instanceof String) {
            function = RhinoTopLevel.getFunction(cx, thisObj, (String)args[0], functionName);
        } else {
            HostObjectUtil.invalidArgsError("[GLOBAL]", "[GLOBAL]", "1", "string|function", args[0], false);
        }
        if (!(args[1] instanceof Number)) {
            HostObjectUtil.invalidArgsError("[GLOBAL]", "[GLOBAL]", "2", "number", args[1], false);
        }
        if (function == null) {
            String error = "Callback cannot be null in " + functionName;
            log.error((Object)error);
            throw new ScriptException(error);
        }
        final JaggeryContext context = RhinoTopLevel.getJaggeryContext();
        final Object[] params = Arrays.copyOfRange(args, 2, args.length);
        final Function callback = function;
        final ContextFactory factory = cx.getFactory();
        long timeout = ((Number)args[1]).longValue();
        String uuid = UUID.randomUUID().toString();
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        final int tenantId = carbonContext.getTenantId();
        final String tenantDomain = carbonContext.getTenantDomain();
        final String applicationName = carbonContext.getApplicationName();
        ScheduledFuture<Void> future = timerExecutor.schedule(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(tenantId);
                carbonContext.setTenantDomain(tenantDomain);
                carbonContext.setApplicationName(applicationName);
                try {
                    Context ctx = RhinoEngine.enterContext(factory);
                    RhinoEngine.putContextProperty("engine.jaggeryContext", context);
                    callback.call(ctx, thisObj, thisObj, params);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                    RhinoEngine.exitContext();
                }
                return null;
            }
        }, timeout, TimeUnit.MILLISECONDS);
        Map<String, ScheduledFuture> tasks = timeouts.get(context.getTenantId());
        if (tasks == null) {
            tasks = new HashMap<String, ScheduledFuture>();
            timeouts.put(context.getTenantId(), tasks);
        }
        tasks.put(uuid, future);
        return uuid;
    }

    public static String setInterval(Context cx, final Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "setTimeout";
        int argsCount = args.length;
        if (argsCount < 2) {
            HostObjectUtil.invalidNumberOfArgs("[GLOBAL]", functionName, argsCount, false);
        }
        Function function = null;
        if (args[0] instanceof Function) {
            function = (Function)args[0];
        } else if (args[0] instanceof String) {
            function = RhinoTopLevel.getFunction(cx, thisObj, (String)args[0], functionName);
        } else {
            HostObjectUtil.invalidArgsError("[GLOBAL]", "[GLOBAL]", "1", "string|function", args[0], false);
        }
        if (!(args[1] instanceof Number)) {
            HostObjectUtil.invalidArgsError("[GLOBAL]", "[GLOBAL]", "2", "number", args[1], false);
        }
        if (function == null) {
            String error = "Callback cannot be null in " + functionName;
            log.error((Object)error);
            throw new ScriptException(error);
        }
        final JaggeryContext context = RhinoTopLevel.getJaggeryContext();
        final Object[] params = Arrays.copyOfRange(args, 2, args.length);
        final Function callback = function;
        final ContextFactory factory = cx.getFactory();
        long interval = ((Number)args[1]).longValue();
        String uuid = UUID.randomUUID().toString();
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        final int tenantId = carbonContext.getTenantId();
        final String tenantDomain = carbonContext.getTenantDomain();
        final String applicationName = carbonContext.getApplicationName();
        ScheduledFuture<?> future = timerExecutor.scheduleAtFixedRate(new Runnable(){
            private boolean firstTime = true;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(tenantId);
                carbonContext.setTenantDomain(tenantDomain);
                carbonContext.setApplicationName(applicationName);
                try {
                    Context cx = RhinoEngine.enterContext(factory);
                    RhinoEngine.putContextProperty("engine.jaggeryContext", context);
                    callback.call(cx, thisObj, thisObj, params);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                    RhinoEngine.exitContext();
                }
            }
        }, interval, interval, TimeUnit.MILLISECONDS);
        Map<String, ScheduledFuture> tasks = intervals.get(context.getTenantId());
        if (tasks == null) {
            tasks = new HashMap<String, ScheduledFuture>();
            intervals.put(context.getTenantId(), tasks);
        }
        tasks.put(uuid, future);
        return uuid;
    }

    private static JaggeryContext getJaggeryContext() throws ScriptException {
        JaggeryContext context = (JaggeryContext)RhinoEngine.getContextProperty("engine.jaggeryContext");
        if (context == null) {
            String error = "JaggeryContext instance cannot be found in the current thread : " + Thread.currentThread().getName();
            log.error((Object)error);
            throw new ScriptException(error);
        }
        return context;
    }

    public static void clearTimeout(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "clearTimeout";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs("[GLOBAL]", functionName, argsCount, false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError("[GLOBAL]", "[GLOBAL]", "1", "string", args[0], false);
        }
        RhinoTopLevel.clearTimeout((String)args[0]);
    }

    public static void clearInterval(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "clearTimeout";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs("[GLOBAL]", functionName, argsCount, false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError("[GLOBAL]", "[GLOBAL]", "1", "string", args[0], false);
        }
        RhinoTopLevel.clearInterval((String)args[0]);
    }

    public static void clearTimeout(String taskId) throws ScriptException {
        JaggeryContext context = RhinoTopLevel.getJaggeryContext();
        Map<String, ScheduledFuture> tasks = timeouts.get(context.getTenantId());
        if (tasks == null) {
            return;
        }
        ScheduledFuture future = tasks.get(taskId);
        future.cancel(true);
    }

    public static void clearInterval(String taskId) throws ScriptException {
        JaggeryContext context = RhinoTopLevel.getJaggeryContext();
        Map<String, ScheduledFuture> tasks = intervals.get(context.getTenantId());
        if (tasks == null) {
            return;
        }
        ScheduledFuture future = tasks.get(taskId);
        future.cancel(true);
    }

    public static void removeTasks(String tenantId) {
        intervals.remove(tenantId);
        timeouts.remove(tenantId);
    }

    private static Function getFunction(Context cx, Scriptable thisObj, String source, String functionName) {
        ScriptableObject scope = (ScriptableObject)cx.evaluateString(thisObj, "var fn=" + source + ";", functionName, 0, null);
        return (Function)scope.get("fn", (Scriptable)scope);
    }

    static {
        timeouts = new HashMap<String, Map<String, ScheduledFuture>>();
        intervals = new HashMap<String, Map<String, ScheduledFuture>>();
        String threadCount = System.getProperty(JS_TIMER_THREADS);
        timerExecutor = Executors.newScheduledThreadPool(threadCount != null ? Integer.parseInt(threadCount) : 5);
    }
}

