/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.emitter;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL20DefaultValueHolder;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.XSLTUtils;
import org.apache.axis2.wsdl.HTTPHeaderMessage;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.SOAPModuleMessage;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.emitter.Emitter;
import org.apache.axis2.wsdl.codegen.writer.AntBuildWriter;
import org.apache.axis2.wsdl.codegen.writer.CallbackHandlerWriter;
import org.apache.axis2.wsdl.codegen.writer.ExceptionWriter;
import org.apache.axis2.wsdl.codegen.writer.FileWriter;
import org.apache.axis2.wsdl.codegen.writer.InterfaceImplementationWriter;
import org.apache.axis2.wsdl.codegen.writer.InterfaceWriter;
import org.apache.axis2.wsdl.codegen.writer.MessageReceiverWriter;
import org.apache.axis2.wsdl.codegen.writer.SchemaWriter;
import org.apache.axis2.wsdl.codegen.writer.ServiceXMLWriter;
import org.apache.axis2.wsdl.codegen.writer.SkeletonInterfaceWriter;
import org.apache.axis2.wsdl.codegen.writer.SkeletonWriter;
import org.apache.axis2.wsdl.codegen.writer.TestClassWriter;
import org.apache.axis2.wsdl.codegen.writer.WSDL11Writer;
import org.apache.axis2.wsdl.codegen.writer.WSDL20Writer;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.util.MessagePartInformationHolder;
import org.apache.axis2.wsdl.util.TypeTesterUtil;
import org.apache.axis2.wsdl.util.XSLTIncludeResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class AxisServiceBasedMultiLanguageEmitter
implements Emitter {
    protected static final String CALL_BACK_HANDLER_SUFFIX = "CallbackHandler";
    protected static final String STUB_SUFFIX = "Stub";
    protected static final String TEST_SUFFIX = "Test";
    protected static final String SKELETON_CLASS_SUFFIX = "Skeleton";
    protected static final String SKELETON_CLASS_SUFFIX_BACK = "Impl";
    protected static final String SKELETON_INTERFACE_SUFFIX = "SkeletonInterface";
    protected static final String SKELETON_INTERFACE_SUFFIX_BACK = "";
    protected static final String STUB_INTERFACE_SUFFIX_BACK = "Stub";
    protected static final String MESSAGE_RECEIVER_SUFFIX = "MessageReceiver";
    protected static final String DATABINDING_SUPPORTER_NAME_SUFFIX = "DatabindingSupporter";
    protected static final Map mepToClassMap;
    protected static final Map mepToSuffixMap;
    protected AxisBinding axisBinding;
    protected AxisEndpoint axisEndpoint;
    protected int uniqueFaultNameCounter = 0;
    protected static final HashMap constructorMap;
    protected static final Log log;
    protected URIResolver resolver;
    protected Map infoHolder;
    protected Map allServiceInfoHolder;
    protected CodeGenConfiguration codeGenConfiguration;
    protected TypeMapper mapper;
    protected AxisService axisService;
    protected List axisServices;
    protected Map fullyQualifiedFaultClassNameMap = new HashMap();
    protected Map faultClassNameMap = new HashMap();
    protected Map faultElementQNameMap = new HashMap();
    protected Map instantiatableMessageClassNames = new HashMap();
    protected static final String TEST_SRC_DIR_NAME = "test";
    protected boolean useHolderClass_jaxws = false;
    protected boolean wrapped_jaxws = false;

    public AxisServiceBasedMultiLanguageEmitter() {
        this.infoHolder = new HashMap();
        this.allServiceInfoHolder = new HashMap();
    }

    @Override
    public void setCodeGenConfiguration(CodeGenConfiguration configuration) {
        this.codeGenConfiguration = configuration;
        this.axisServices = this.codeGenConfiguration.getAxisServices();
        this.axisService = this.codeGenConfiguration.getAxisService();
        this.axisEndpoint = this.axisService.getEndpoint(this.axisService.getEndpointName());
        this.axisBinding = this.axisEndpoint.getBinding();
        this.resolver = new XSLTIncludeResolver(this.codeGenConfiguration);
    }

    @Override
    public void setMapper(TypeMapper mapper) {
        this.mapper = mapper;
    }

    protected Object getBindingPropertyFromOperation(String name, QName qName) {
        AxisBindingOperation axisBindingOperation = null;
        if (this.axisBinding != null) {
            axisBindingOperation = (AxisBindingOperation)this.axisBinding.getChild(qName);
        }
        Object property = null;
        if (axisBindingOperation != null) {
            property = axisBindingOperation.getProperty(name);
        }
        if (property == null && this.axisBinding != null) {
            property = this.axisBinding.getProperty(name);
        }
        if (property == null) {
            property = WSDL20DefaultValueHolder.getDefaultValue(name);
        }
        return property;
    }

    protected Policy getBindingPolicyFromMessage(AxisBindingOperation axisBindingOperation, String key) {
        AxisBindingMessage axisBindingMessage = null;
        if (axisBindingOperation != null && (axisBindingMessage = (AxisBindingMessage)axisBindingOperation.getChild(key)) != null) {
            try {
                return axisBindingMessage.getEffectivePolicy();
            }
            catch (RuntimeException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    protected Object getBindingPropertyFromMessage(String name, QName qName, String key) {
        Object property = null;
        AxisBindingOperation axisBindingOperation = null;
        if (this.axisBinding != null) {
            axisBindingOperation = (AxisBindingOperation)this.axisBinding.getChild(qName);
        }
        AxisBindingMessage axisBindingMessage = null;
        if (axisBindingOperation != null) {
            axisBindingMessage = (AxisBindingMessage)axisBindingOperation.getChild(key);
            if (axisBindingMessage != null) {
                property = axisBindingMessage.getProperty(name);
            }
            if (property == null) {
                property = axisBindingOperation.getProperty(name);
            }
        }
        if (property == null && this.axisBinding != null) {
            property = this.axisBinding.getProperty(name);
        }
        if (property == null) {
            property = WSDL20DefaultValueHolder.getDefaultValue(name);
        }
        return property;
    }

    protected Object getBindingPropertyFromMessageFault(String name, QName qName, String key) {
        Object property = null;
        AxisBindingOperation axisBindingOperation = (AxisBindingOperation)this.axisBinding.getChild(qName);
        AxisBindingMessage axisBindingMessageFault = null;
        AxisBindingMessage axisBindingFault = null;
        if (axisBindingOperation != null) {
            axisBindingMessageFault = axisBindingOperation.getFault(key);
            if (axisBindingMessageFault != null) {
                property = axisBindingMessageFault.getProperty(name);
            }
            if (property == null) {
                axisBindingFault = this.axisBinding.getFault(key);
                property = axisBindingFault.getProperty(name);
            }
        }
        if (property == null) {
            property = WSDL20DefaultValueHolder.getDefaultValue(name);
        }
        return property;
    }

    protected void updateMapperForStub() {
        this.updateMapperClassnames(this.getFullyQualifiedStubName());
    }

    protected String getFullyQualifiedStubName() {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = null;
        localPart = this.axisService.getEndpoints().size() > 1 ? this.makeJavaClassName(this.axisService.getName() + this.axisService.getEndpointName()) : this.makeJavaClassName(this.axisService.getName());
        return packageName + "." + localPart + "Stub";
    }

    protected void resetFaultNames() {
        this.fullyQualifiedFaultClassNameMap.clear();
        this.faultClassNameMap.clear();
        this.faultElementQNameMap.clear();
    }

    protected void generateAndPopulateFaultNames() {
        Iterator<AxisOperation> operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            AxisOperation operation = operations.next();
            ArrayList<AxisMessage> faultMessages = operation.getFaultMessages();
            for (int i = 0; i < faultMessages.size(); ++i) {
                AxisMessage faultMessage = faultMessages.get(i);
                if (this.fullyQualifiedFaultClassNameMap.containsKey(faultMessage.getName())) continue;
                String className = this.makeJavaClassName(faultMessage.getName());
                QName faultQName = new QName(this.codeGenConfiguration.getTargetNamespace(), faultMessage.getName());
                if (this.mapper.getQNameToMappingObject(faultQName) != null) {
                    className = this.makeJavaClassName(className + "Exception");
                }
                while (this.fullyQualifiedFaultClassNameMap.containsValue(className)) {
                    className = this.makeJavaClassName(className + this.uniqueFaultNameCounter++);
                }
                this.fullyQualifiedFaultClassNameMap.put(faultMessage.getName(), className);
                this.faultClassNameMap.put(faultMessage.getName(), className);
                this.faultElementQNameMap.put(faultMessage.getName(), faultMessage.getElementQName());
            }
        }
    }

    @Override
    public void emitStub() throws CodeGenerationException {
        try {
            Map originalTypeMap = this.getNewCopy(this.mapper.getAllMappedNames());
            for (AxisService this.axisService : this.axisServices) {
                this.axisBinding = this.axisService.getEndpoint(this.axisService.getEndpointName()).getBinding();
                if (!this.codeGenConfiguration.isPackClasses()) {
                    this.writeCallBackHandlers();
                }
                Map<String, AxisEndpoint> endpoints = this.axisService.getEndpoints();
                for (AxisEndpoint this.axisEndpoint : endpoints.values()) {
                    this.axisBinding = this.axisEndpoint.getBinding();
                    this.axisService.setEndpointName(this.axisEndpoint.getName());
                    this.axisService.setBindingName(this.axisEndpoint.getBinding().getName().getLocalPart());
                    if (this.mapper.isObjectMappingPresent()) {
                        this.copyMap(originalTypeMap, this.mapper.getAllMappedNames());
                        this.updateMapperForStub();
                    } else {
                        this.copyToFaultMap();
                    }
                    this.resetFaultNames();
                    this.generateAndPopulateFaultNames();
                    this.updateFaultPackageForStub();
                    if (!this.codeGenConfiguration.isPackClasses()) {
                        this.writeInterface(false);
                    }
                    if (this.codeGenConfiguration.isPackClasses()) {
                        this.writeCallBackHandlers();
                    }
                    this.writeExceptions();
                    this.writeInterfaceImplementation();
                    this.writeTestClasses();
                }
            }
            if (this.mapper.isObjectMappingPresent()) {
                this.copyMap(originalTypeMap, this.mapper.getAllMappedNames());
            }
            if (!(this.codeGenConfiguration.isSkipBuildXML() || this.codeGenConfiguration.isGenerateAll() || this.codeGenConfiguration.isFlattenFiles())) {
                this.writeAntBuild();
            }
        }
        catch (CodeGenerationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    public Map getNewCopy(Map copyFormMap) {
        HashMap copyToMap = new HashMap();
        for (Object key : copyFormMap.keySet()) {
            copyToMap.put(key, copyFormMap.get(key));
        }
        return copyToMap;
    }

    public void copyMap(Map copyFormMap, Map copyToMap) {
        for (Object key : copyFormMap.keySet()) {
            copyToMap.put(key, copyFormMap.get(key));
        }
    }

    protected void writeAntBuild() throws Exception {
        Document skeletonModel = this.createDOMDocumentForAntBuild();
        this.debugLogDocument("Document for ant build:", skeletonModel);
        AntBuildWriter antBuildWriter = new AntBuildWriter(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getOutputLanguage());
        antBuildWriter.setDatabindingFramework(this.codeGenConfiguration.getDatabindingType());
        antBuildWriter.setOverride(this.codeGenConfiguration.isOverride());
        this.writeFile(skeletonModel, antBuildWriter);
    }

    protected Document createDOMDocumentForAntBuild() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("ant");
        String serviceName = this.makeJavaClassName(this.axisService.getName());
        String packageName = this.codeGenConfiguration.getPackageName();
        String[] dotSeparatedValues = packageName.split("\\.");
        this.addAttribute(doc, "package", dotSeparatedValues[0], rootElement);
        this.addAttribute(doc, "name", serviceName, rootElement);
        this.addAttribute(doc, "servicename", serviceName, rootElement);
        this.addAttribute(doc, "src", this.codeGenConfiguration.getSourceLocation(), rootElement);
        this.addAttribute(doc, "resource", this.codeGenConfiguration.getResourceLocation(), rootElement);
        if (this.codeGenConfiguration.getAxisServices().size() > 1) {
            this.addAttribute(doc, "artifactname", "Services", rootElement);
        } else {
            this.addAttribute(doc, "artifactname", this.axisService.getName(), rootElement);
        }
        if (!this.codeGenConfiguration.isWriteTestCase()) {
            this.addAttribute(doc, "testOmit", "true", rootElement);
        }
        if (this.codeGenConfiguration.isServerSide()) {
            this.addAttribute(doc, "isserverside", "yes", rootElement);
        }
        doc.appendChild(rootElement);
        return doc;
    }

    protected void writeTestClasses() throws Exception {
        if (this.codeGenConfiguration.isWriteTestCase()) {
            Document classModel = this.createDOMDocumentForTestCase();
            this.debugLogDocument("Document for test case:", classModel);
            TestClassWriter callbackWriter = new TestClassWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), TEST_SRC_DIR_NAME), this.codeGenConfiguration.getOutputLanguage());
            callbackWriter.setOverride(this.codeGenConfiguration.isOverride());
            this.writeFile(classModel, callbackWriter);
        }
    }

    protected Document createDOMDocumentForTestCase() {
        String coreClassName = this.makeJavaClassName(this.axisService.getName());
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("class");
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        if (this.axisService.getEndpoints().size() > 1) {
            this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getName() + this.axisService.getEndpointName()) + TEST_SUFFIX, rootElement);
        } else {
            this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getName()) + TEST_SUFFIX, rootElement);
        }
        this.addAttribute(doc, "namespace", this.axisService.getTargetNamespace(), rootElement);
        this.addAttribute(doc, "interfaceName", coreClassName, rootElement);
        if (this.codeGenConfiguration.isPackClasses()) {
            if (this.axisService.getEndpoints().size() > 1) {
                this.addAttribute(doc, "callbackname", this.makeJavaClassName(this.axisService.getName() + this.axisService.getEndpointName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
            } else {
                this.addAttribute(doc, "callbackname", this.makeJavaClassName(this.axisService.getName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
            }
        } else {
            this.addAttribute(doc, "callbackname", coreClassName + CALL_BACK_HANDLER_SUFFIX, rootElement);
        }
        if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
            this.addAttribute(doc, "stubname", this.makeJavaClassName(this.axisService.getBindingName()) + "Stub", rootElement);
        } else if (this.axisService.getEndpoints().size() > 1) {
            this.addAttribute(doc, "stubname", this.makeJavaClassName(this.axisService.getName() + this.axisService.getEndpointName()) + "Stub", rootElement);
        } else {
            this.addAttribute(doc, "stubname", this.makeJavaClassName(this.axisService.getName()) + "Stub", rootElement);
        }
        this.addAttribute(doc, "isbackcompatible", String.valueOf(this.codeGenConfiguration.isBackwordCompatibilityMode()), rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc, false));
        doc.appendChild(rootElement);
        return doc;
    }

    protected void writeInterfaceImplementation() throws Exception {
        Document interfaceImplModel = this.createDOMDocumentForInterfaceImplementation();
        this.debugLogDocument("Document for interface implementation:", interfaceImplModel);
        InterfaceImplementationWriter writer = new InterfaceImplementationWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        writer.setOverride(this.codeGenConfiguration.isOverride());
        this.writeFile(interfaceImplModel, writer);
    }

    protected Document createDOMDocumentForInterfaceImplementation() throws Exception {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        String stubName = this.makeJavaClassName(this.axisService.getName() + this.axisService.getEndpointName()) + "Stub";
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("class");
        this.addAttribute(doc, "package", packageName, rootElement);
        this.addAttribute(doc, "servicename", localPart, rootElement);
        this.addAttribute(doc, "namespace", this.axisService.getTargetNamespace(), rootElement);
        if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
            this.addAttribute(doc, "interfaceName", this.makeJavaClassName(this.axisService.getEndpointName()) + "Stub", rootElement);
            this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getBindingName()) + "Stub", rootElement);
        } else if (this.axisService.getEndpoints().size() > 1) {
            this.addAttribute(doc, "interfaceName", this.makeJavaClassName(this.axisService.getName() + this.axisService.getEndpointName()), rootElement);
            this.addAttribute(doc, "name", stubName, rootElement);
        } else {
            this.addAttribute(doc, "interfaceName", this.makeJavaClassName(this.axisService.getName()), rootElement);
            this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getName()) + "Stub", rootElement);
        }
        if (this.codeGenConfiguration.isPackClasses()) {
            if (this.axisService.getEndpoints().size() > 1) {
                this.addAttribute(doc, "callbackname", this.makeJavaClassName(this.axisService.getName() + this.axisService.getEndpointName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
            } else {
                this.addAttribute(doc, "callbackname", this.makeJavaClassName(this.axisService.getName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
            }
        } else {
            this.addAttribute(doc, "callbackname", localPart + CALL_BACK_HANDLER_SUFFIX, rootElement);
        }
        this.addAttribute(doc, "isbackcompatible", String.valueOf(this.codeGenConfiguration.isBackwordCompatibilityMode()), rootElement);
        if (this.codeGenConfiguration.isPackClasses()) {
            this.addAttribute(doc, "wrapped", "yes", rootElement);
        }
        this.addSoapVersion(doc, rootElement);
        this.addEndpoint(doc, rootElement);
        this.fillSyncAttributes(doc, rootElement);
        if (this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc, false));
        Object moduleCodegenPolicyExtensionElement = this.codeGenConfiguration.getProperty("module-codegen-policy-extensions");
        if (moduleCodegenPolicyExtensionElement != null) {
            rootElement.appendChild(doc.importNode((Element)moduleCodegenPolicyExtensionElement, true));
        }
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Element getUniqueListofFaults(Document doc) {
        Element rootElement = doc.createElement("fault-list");
        Iterator iterator = this.fullyQualifiedFaultClassNameMap.keySet().iterator();
        while (iterator.hasNext()) {
            Element faultElement = doc.createElement("fault");
            String key = (String)iterator.next();
            this.addAttribute(doc, "name", (String)this.fullyQualifiedFaultClassNameMap.get(key), faultElement);
            this.addAttribute(doc, "shortName", (String)this.faultClassNameMap.get(key), faultElement);
            String typeMapping = this.mapper.getTypeMappingName((QName)this.faultElementQNameMap.get(key));
            this.addAttribute(doc, "type", typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping, faultElement);
            String attribValue = (String)this.instantiatableMessageClassNames.get(key);
            this.addAttribute(doc, "instantiatableType", attribValue == null ? SKELETON_INTERFACE_SUFFIX_BACK : attribValue, faultElement);
            if (this.mapper.getDefaultMappingName().equals(typeMapping)) {
                this.addAttribute(doc, "default", "yes", faultElement);
            }
            this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), faultElement);
            rootElement.appendChild(faultElement);
        }
        return rootElement;
    }

    protected void addFaultMessages(List operationFaultMessages, Set faultMessagesToMep) {
        for (AxisMessage faultMessage : operationFaultMessages) {
            faultMessagesToMep.add(faultMessage.getName());
        }
    }

    protected Element getUniqueListofFaultsofMep(Document doc, String mep) {
        HashSet faultListForMep = new HashSet();
        Iterator<AxisOperation> iter = this.axisService.getOperations();
        while (iter.hasNext()) {
            AxisOperation axisOperation = iter.next();
            if (mep == null) {
                this.addFaultMessages(axisOperation.getFaultMessages(), faultListForMep);
                continue;
            }
            if (!mep.equals(axisOperation.getMessageExchangePattern())) continue;
            this.addFaultMessages(axisOperation.getFaultMessages(), faultListForMep);
        }
        Element rootElement = doc.createElement("fault-list");
        Iterator iterator = faultListForMep.iterator();
        while (iterator.hasNext()) {
            Element faultElement = doc.createElement("fault");
            String key = (String)iterator.next();
            this.addAttribute(doc, "name", (String)this.fullyQualifiedFaultClassNameMap.get(key), faultElement);
            this.addAttribute(doc, "shortName", (String)this.faultClassNameMap.get(key), faultElement);
            String typeMapping = this.mapper.getTypeMappingName((QName)this.faultElementQNameMap.get(key));
            this.addAttribute(doc, "type", typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping, faultElement);
            String attribValue = (String)this.instantiatableMessageClassNames.get(key);
            this.addAttribute(doc, "instantiatableType", attribValue == null ? SKELETON_INTERFACE_SUFFIX_BACK : attribValue, faultElement);
            String exceptionName = ((QName)this.faultElementQNameMap.get(key)).getLocalPart();
            this.addAttribute(doc, "localname", exceptionName == null ? SKELETON_INTERFACE_SUFFIX_BACK : exceptionName, faultElement);
            if (this.mapper.getDefaultMappingName().equals(typeMapping)) {
                this.addAttribute(doc, "default", "yes", faultElement);
            }
            this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), faultElement);
            rootElement.appendChild(faultElement);
        }
        return rootElement;
    }

    protected void addEndpoint(Document doc, Element rootElement) throws Exception {
        Element endpointElement = doc.createElement("endpoint");
        String endpoint = this.axisEndpoint.getEndpointURL();
        Text text = doc.createTextNode(endpoint != null ? endpoint : SKELETON_INTERFACE_SUFFIX_BACK);
        endpointElement.appendChild(text);
        rootElement.appendChild(endpointElement);
    }

    protected void addSoapVersion(Document doc, Element rootElement) {
        this.addAttribute(doc, "soap-version", (String)this.axisBinding.getProperty("wsoap:version"), rootElement);
    }

    protected void writeExceptions() throws Exception {
        Iterator iterator = this.fullyQualifiedFaultClassNameMap.keySet().iterator();
        while (iterator.hasNext()) {
            Document doc = this.getEmptyDocument();
            Element faultElement = doc.createElement("fault");
            this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), faultElement);
            String key = (String)iterator.next();
            this.addAttribute(doc, "name", (String)this.faultClassNameMap.get(key), faultElement);
            this.addAttribute(doc, "shortName", (String)this.faultClassNameMap.get(key), faultElement);
            this.addAttribute(doc, "serialVersionUID", String.valueOf(System.currentTimeMillis()), faultElement);
            if (this.codeGenConfiguration.getExceptionBaseClassName() != null) {
                this.addAttribute(doc, "exceptionBaseClass", this.codeGenConfiguration.getExceptionBaseClassName(), faultElement);
                try {
                    this.addConstructorDetails(doc, faultElement, this.codeGenConfiguration.getExceptionBaseClassName());
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)"Can not load the Exception base class");
                }
            } else {
                this.addAttribute(doc, "exceptionBaseClass", Exception.class.getName(), faultElement);
            }
            String typeMapping = this.mapper.getTypeMappingName((QName)this.faultElementQNameMap.get(key));
            this.addAttribute(doc, "type", typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping, faultElement);
            String attribValue = (String)this.instantiatableMessageClassNames.get(key);
            this.addAttribute(doc, "instantiatableType", attribValue == null ? SKELETON_INTERFACE_SUFFIX_BACK : attribValue, faultElement);
            if (this.mapper.getDefaultMappingName().equals(typeMapping)) {
                this.addAttribute(doc, "default", "yes", faultElement);
            }
            this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), faultElement);
            ExceptionWriter exceptionWriter = new ExceptionWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
            doc.appendChild(faultElement);
            exceptionWriter.setOverride(this.codeGenConfiguration.isOverride());
            this.writeFile(doc, exceptionWriter);
        }
    }

    private void addConstructorDetails(Document doc, Element faultElement, String exceptionClassName) throws ClassNotFoundException {
        Class<?> exceptionClass = Class.forName(exceptionClassName);
        Constructor<?>[] constructors = exceptionClass.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Element constructorElement = doc.createElement("constructor");
            faultElement.appendChild(constructorElement);
            Type[] parameters = constructors[i].getGenericParameterTypes();
            ArrayList existingParamNames = new ArrayList();
            for (int j = 0; j < parameters.length; ++j) {
                Element parameterElement = doc.createElement("param");
                constructorElement.appendChild(parameterElement);
                this.addAttribute(doc, "type", this.getTypeName(parameters[j]), parameterElement);
                this.addAttribute(doc, "name", this.getParameterName(parameters[j], existingParamNames), parameterElement);
            }
        }
    }

    private String getParameterName(Type type, List existingParamNames) {
        String paramName = null;
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (classType.isArray()) {
                paramName = this.getParameterName(classType.getComponentType(), existingParamNames);
            } else {
                String className = classType.getName();
                if (className.lastIndexOf(".") > 0) {
                    className = className.substring(className.lastIndexOf(".") + 1);
                }
                if (existingParamNames.contains(paramName = JavaUtils.xmlNameToJavaIdentifier(className))) {
                    paramName = paramName + existingParamNames.size();
                }
                existingParamNames.add(paramName);
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            paramName = this.getParameterName(parameterizedType.getRawType(), existingParamNames);
        }
        return paramName;
    }

    private String getTypeName(Type type) {
        String typeName = null;
        if (type instanceof Class) {
            Class classType = (Class)type;
            typeName = classType.isArray() ? this.getTypeName(classType.getComponentType()) + "[]" : classType.getName();
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            typeName = parameterizedType.toString();
        }
        return typeName;
    }

    protected Document createDOMDocumentForException() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("callback");
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.loadOperations(doc, rootElement, null);
        doc.appendChild(rootElement);
        return doc;
    }

    protected void writeCallBackHandlers() throws Exception {
        if (this.codeGenConfiguration.isAsyncOn()) {
            Document interfaceModel = this.createDOMDocumentForCallbackHandler();
            this.debugLogDocument("Document for callback handler:", interfaceModel);
            CallbackHandlerWriter callbackWriter = new CallbackHandlerWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
            callbackWriter.setOverride(this.codeGenConfiguration.isOverride());
            this.writeFile(interfaceModel, callbackWriter);
        }
    }

    protected Document createDOMDocumentForCallbackHandler() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("callback");
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        if (this.codeGenConfiguration.isPackClasses() && this.axisService.getEndpoints().size() > 1) {
            this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getName() + this.axisService.getEndpointName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
        } else {
            this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
        }
        this.loadOperations(doc, rootElement, null);
        doc.appendChild(rootElement);
        return doc;
    }

    protected void writeInterface(boolean writeDatabinders) throws Exception {
        Document interfaceModel = this.createDOMDocumentForInterface(writeDatabinders);
        this.debugLogDocument("Document for interface:", interfaceModel);
        InterfaceWriter interfaceWriter = new InterfaceWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        interfaceWriter.setOverride(this.codeGenConfiguration.isOverride());
        this.writeFile(interfaceModel, interfaceWriter);
    }

    protected Document createDOMDocumentForInterface(boolean writeDatabinders) {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String localPart = null;
        localPart = this.codeGenConfiguration.isBackwordCompatibilityMode() ? this.makeJavaClassName(this.axisService.getEndpointName() + "Stub") : (this.axisService.getEndpoints().size() > 1 ? this.makeJavaClassName(this.axisService.getName() + this.axisService.getEndpointName()) : this.makeJavaClassName(this.axisService.getName()));
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        this.addAttribute(doc, "name", localPart, rootElement);
        this.addAttribute(doc, "callbackname", this.makeJavaClassName(this.axisService.getName()) + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.addAttribute(doc, "isbackcompatible", String.valueOf(this.codeGenConfiguration.isBackwordCompatibilityMode()), rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        if (writeDatabinders && this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        doc.appendChild(rootElement);
        return doc;
    }

    protected void updateMapperForMessageReceiver() {
        this.updateMapperClassnames(this.getFullyQualifiedMessageReceiverName());
    }

    protected String getFullyQualifiedMessageReceiverName() {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        return packageName + "." + localPart + MESSAGE_RECEIVER_SUFFIX;
    }

    protected String getFullyQualifiedSkeletonName() {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        String skeltonName = this.codeGenConfiguration.isBackwordCompatibilityMode() ? packageName + "." + this.makeJavaClassName(this.axisService.getBindingName()) + SKELETON_CLASS_SUFFIX_BACK : packageName + "." + localPart + SKELETON_CLASS_SUFFIX;
        return skeltonName;
    }

    protected String getFullyQualifiedSkeletonInterfaceName() {
        String packageName = this.codeGenConfiguration.getPackageName();
        String localPart = this.makeJavaClassName(this.axisService.getName());
        String skeltonInterfaceName = this.codeGenConfiguration.isBackwordCompatibilityMode() ? packageName + "." + this.makeJavaClassName(this.axisService.getEndpointName()) + SKELETON_INTERFACE_SUFFIX_BACK : packageName + "." + localPart + SKELETON_INTERFACE_SUFFIX;
        return skeltonInterfaceName;
    }

    @Override
    public void emitSkeleton() throws CodeGenerationException {
        try {
            this.allServiceInfoHolder = new HashMap();
            Map originalMap = this.getNewCopy(this.mapper.getAllMappedNames());
            Iterator axisServicesIter = this.axisServices.iterator();
            while (axisServicesIter.hasNext()) {
                this.infoHolder = new HashMap();
                this.axisService = (AxisService)axisServicesIter.next();
                this.axisBinding = this.axisService.getEndpoint(this.axisService.getEndpointName()).getBinding();
                if (this.mapper.isObjectMappingPresent()) {
                    this.copyMap(originalMap, this.mapper.getAllMappedNames());
                    this.updateMapperForMessageReceiver();
                } else {
                    this.copyToFaultMap();
                }
                this.generateAndPopulateFaultNames();
                if (this.codeGenConfiguration.isServerSideInterface()) {
                    this.writeSkeletonInterface();
                }
                if (this.codeGenConfiguration.isServerSideInterface()) {
                    if (this.codeGenConfiguration.isGenerateDeployementDescriptor()) {
                        this.writeSkeleton();
                    }
                } else {
                    this.writeSkeleton();
                }
                if (!this.codeGenConfiguration.isSkipMessageReceiver()) {
                    this.writeMessageReceiver();
                }
                this.writeExceptions();
                if (!this.codeGenConfiguration.isSkipWriteWSDLs()) {
                    this.writeWSDLFiles();
                }
                this.allServiceInfoHolder.put(this.axisService.getName(), this.infoHolder);
            }
            if (this.mapper.isObjectMappingPresent()) {
                this.copyMap(originalMap, this.mapper.getAllMappedNames());
            }
            if (this.codeGenConfiguration.isGenerateDeployementDescriptor()) {
                this.writeServiceXml();
            }
            if (!this.codeGenConfiguration.isSkipBuildXML() && !this.codeGenConfiguration.isFlattenFiles()) {
                this.writeAntBuild();
            }
        }
        catch (CodeGenerationException cgExp) {
            throw cgExp;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    protected void writeWSDLFiles() {
        this.axisService.setCustomSchemaNamePrefix(SKELETON_INTERFACE_SUFFIX_BACK);
        this.axisService.setCustomSchemaNameSuffix(".xsd");
        this.axisService.setSchemaLocationsAdjusted(false);
        Map changedMap = this.axisService.populateSchemaMappings(this.codeGenConfiguration.isOverrideAbsoluteAddress());
        try {
            this.axisService.addParameter(new Parameter("useOriginalwsdl", "true"));
            this.axisService.addParameter(new Parameter("modifyUserWSDLPortAddress", "false"));
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
        SchemaWriter schemaWriter = new SchemaWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getResourceLocation()));
        Map schemaMappings = this.axisService.getSchemaMappingTable();
        Iterator keys = schemaMappings.keySet().iterator();
        String key = null;
        while (keys.hasNext()) {
            key = (String)keys.next();
            if (key.startsWith("http")) continue;
            schemaWriter.writeSchema((XmlSchema)schemaMappings.get(key), key);
        }
        if ("2.0".equals(this.codeGenConfiguration.getWSDLVersion())) {
            WSDL20Writer wsdl20Writer = new WSDL20Writer(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getResourceLocation()));
            wsdl20Writer.writeWSDL(this.axisService);
        } else {
            WSDL11Writer wsdl11Writer = new WSDL11Writer(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getResourceLocation()));
            wsdl11Writer.writeWSDL(this.axisService, this.codeGenConfiguration.getWsdlDefinition(), changedMap);
        }
    }

    protected void copyToFaultMap() {
        Map classNameMap = this.mapper.getAllMappedNames();
        for (Object key : classNameMap.keySet()) {
            this.instantiatableMessageClassNames.put(key, classNameMap.get(key));
        }
    }

    protected void updateFaultPackageForStub() {
        for (Object key : this.fullyQualifiedFaultClassNameMap.keySet()) {
            String className = (String)this.fullyQualifiedFaultClassNameMap.get(key);
            String fullyQualifiedStubName = this.getFullyQualifiedStubName();
            this.fullyQualifiedFaultClassNameMap.put(key, this.codeGenConfiguration.getPackageName() + "." + className);
        }
    }

    protected void writeMessageReceiver() throws Exception {
        for (String mep : mepToClassMap.keySet()) {
            Document classModel = this.createDocumentForMessageReceiver(mep, this.codeGenConfiguration.isServerSideInterface());
            this.debugLogDocument("Document for message receiver (mep=" + mep + "):", classModel);
            if (!Boolean.TRUE.equals(this.infoHolder.get(mep))) continue;
            MessageReceiverWriter writer = new MessageReceiverWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
            writer.setOverride(this.codeGenConfiguration.isOverride());
            this.writeFile(classModel, writer);
        }
    }

    protected Document createDocumentForMessageReceiver(String mep, boolean isServerSideInterface) {
        boolean isOpsFound;
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        String localPart = this.makeJavaClassName(this.axisService.getName());
        this.addAttribute(doc, "name", localPart + mepToSuffixMap.get(mep), rootElement);
        if (!this.codeGenConfiguration.isUseOperationName()) {
            this.addAttribute(doc, "isLowerCaseMethodName", "true", rootElement);
        }
        this.addAttribute(doc, "isbackcompatible", String.valueOf(this.codeGenConfiguration.isBackwordCompatibilityMode()), rootElement);
        if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
            this.addAttribute(doc, "skeletonname", this.makeJavaClassName(this.axisService.getBindingName()) + SKELETON_CLASS_SUFFIX_BACK, rootElement);
            if (isServerSideInterface) {
                this.addAttribute(doc, "skeletonInterfaceName", this.makeJavaClassName(this.axisService.getEndpointName()) + SKELETON_INTERFACE_SUFFIX_BACK, rootElement);
            } else {
                this.addAttribute(doc, "skeletonInterfaceName", this.makeJavaClassName(this.axisService.getBindingName()) + SKELETON_CLASS_SUFFIX_BACK, rootElement);
            }
        } else {
            if (this.codeGenConfiguration.getSkeltonClassName() != null) {
                this.addAttribute(doc, "skeletonname", this.codeGenConfiguration.getSkeltonClassName(), rootElement);
            } else {
                this.addAttribute(doc, "skeletonname", localPart + SKELETON_CLASS_SUFFIX, rootElement);
            }
            if (isServerSideInterface) {
                if (this.codeGenConfiguration.getSkeltonInterfaceName() != null) {
                    this.addAttribute(doc, "skeletonInterfaceName", this.codeGenConfiguration.getSkeltonInterfaceName(), rootElement);
                } else {
                    this.addAttribute(doc, "skeletonInterfaceName", localPart + SKELETON_INTERFACE_SUFFIX, rootElement);
                }
            } else if (this.codeGenConfiguration.getSkeltonClassName() != null) {
                this.addAttribute(doc, "skeletonInterfaceName", this.codeGenConfiguration.getSkeltonClassName(), rootElement);
            } else {
                this.addAttribute(doc, "skeletonInterfaceName", localPart + SKELETON_CLASS_SUFFIX, rootElement);
            }
        }
        this.addAttribute(doc, "basereceiver", (String)mepToClassMap.get(mep), rootElement);
        this.fillSyncAttributes(doc, rootElement);
        if (this.mapper.isObjectMappingPresent()) {
            this.addAttribute(doc, "skip-write", "yes", rootElement);
            this.processModelObjects(this.mapper.getAllMappedObjects(), rootElement, doc);
        }
        this.infoHolder.put(mep, (isOpsFound = this.loadOperations(doc, rootElement, mep)) ? Boolean.TRUE : Boolean.FALSE);
        rootElement.appendChild(this.createDOMElementforDatabinders(doc, true));
        rootElement.appendChild(this.getUniqueListofFaultsofMep(doc, mep));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Element createDOMElementforDatabinders(Document doc, boolean isServerside) {
        ArrayList<Element> parameters = new ArrayList<Element>();
        AxisOperation axisOperation = null;
        AxisBindingOperation axisBindingOperation = null;
        Iterator<AxisBindingOperation> bindingOperationsIter = this.axisBinding.getChildren();
        while (bindingOperationsIter.hasNext()) {
            int i;
            Element outputParamElement;
            int i2;
            axisBindingOperation = bindingOperationsIter.next();
            axisOperation = axisBindingOperation.getAxisOperation();
            String MEP2 = axisOperation.getMessageExchangePattern();
            if (WSDLUtil.isInputPresentForMEP(MEP2)) {
                Element[] inputParamElement = this.getInputParamElement(doc, axisOperation);
                for (i2 = 0; i2 < inputParamElement.length; ++i2) {
                    this.addAttribute(doc, "direction", "in", inputParamElement[i2]);
                    parameters.add(inputParamElement[i2]);
                }
            }
            if (WSDLUtil.isOutputPresentForMEP(MEP2) && (outputParamElement = this.getOutputParamElement(doc, axisOperation)) != null) {
                this.addAttribute(doc, "direction", "out", outputParamElement);
                parameters.add(outputParamElement);
            }
            Element[] faultParamElements = this.getFaultParamElements(doc, axisOperation);
            for (i2 = 0; i2 < faultParamElements.length; ++i2) {
                this.addAttribute(doc, "direction", "out", faultParamElements[i2]);
                parameters.add(faultParamElements[i2]);
            }
            ArrayList headerParameterQNameList = new ArrayList();
            this.addHeaderOperations(headerParameterQNameList, axisBindingOperation, true);
            List parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "soap_header");
            for (i = 0; i < parameterElementList.size(); ++i) {
                Element newChild = (Element)parameterElementList.get(i);
                parameters.add(newChild);
            }
            headerParameterQNameList.clear();
            parameterElementList.clear();
            this.addHeaderOperations(headerParameterQNameList, axisBindingOperation, false);
            parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "soap_header");
            for (i = 0; i < parameterElementList.size(); ++i) {
                Element newChild = (Element)parameterElementList.get(i);
                parameters.add(newChild);
            }
        }
        Element rootElement = doc.createElement("databinders");
        this.addAttribute(doc, "dbtype", this.codeGenConfiguration.getDatabindingType(), rootElement);
        String wrapflag = Boolean.toString(this.codeGenConfiguration.isParametersWrapped());
        this.addAttribute(doc, "wrapped", wrapflag, rootElement);
        Element extraElement = this.addElement(doc, "extra", null, rootElement);
        Map<Object, Object> propertiesMap = this.codeGenConfiguration.getProperties();
        for (Object key : propertiesMap.keySet()) {
            if (!(key instanceof String)) continue;
            Object value = propertiesMap.get(key);
            if (value == null) {
                value = SKELETON_INTERFACE_SUFFIX_BACK;
            }
            if (!(value instanceof String)) continue;
            this.addAttribute(doc, (String)key, (String)value, extraElement);
        }
        if (isServerside) {
            this.addAttribute(doc, "isserverside", "yes", rootElement);
        }
        rootElement.appendChild(this.getBase64Elements(doc));
        rootElement.appendChild(this.getOpNames(doc));
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            rootElement.appendChild((Element)iterator.next());
        }
        Parameter details = this.axisService.getParameter("databinding-service-details");
        if (details != null) {
            Object value = details.getValue();
            if (value instanceof Element) {
                rootElement.appendChild(doc.importNode((Element)value, true));
            } else if (value instanceof List) {
                Iterator iter = ((List)value).iterator();
                while (iter.hasNext()) {
                    rootElement.appendChild(doc.importNode((Element)iter.next(), true));
                }
            }
        }
        axisOperation = null;
        Iterator<AxisOperation> operationsIterator = this.axisService.getOperations();
        while (operationsIterator.hasNext()) {
            axisOperation = operationsIterator.next();
            details = axisOperation.getParameter("databinding-operation-details");
            if (details == null) continue;
            rootElement.appendChild(doc.importNode((Element)details.getValue(), true));
        }
        return rootElement;
    }

    protected void addShortType(Element paramElement, String xmlName) {
        if (xmlName != null) {
            String javaName = JavaUtils.isJavaKeyword(xmlName) ? JavaUtils.makeNonJavaKeyword(xmlName) : JavaUtils.capitalizeFirstChar(JavaUtils.xmlNameToJava(xmlName));
            this.addAttribute(paramElement.getOwnerDocument(), "shorttype", javaName, paramElement);
        } else {
            this.addAttribute(paramElement.getOwnerDocument(), "shorttype", SKELETON_INTERFACE_SUFFIX_BACK, paramElement);
        }
    }

    protected Element getOpNames(Document doc) {
        Element root = doc.createElement("opnames");
        Iterator<AxisOperation> operationsIterator = this.axisService.getOperations();
        while (operationsIterator.hasNext()) {
            AxisOperation axisOperation = operationsIterator.next();
            Element elt = doc.createElement("name");
            String localPart = axisOperation.getName().getLocalPart();
            elt.appendChild(doc.createTextNode(JavaUtils.xmlNameToJava(localPart)));
            this.addAttribute(doc, "opnsuri", this.axisService.getTargetNamespace(), elt);
            root.appendChild(elt);
        }
        return root;
    }

    protected Element getBase64Elements(Document doc) {
        Element root = doc.createElement("base64Elements");
        List list = (List)this.codeGenConfiguration.getProperties().get("base64map");
        if (list != null && !list.isEmpty()) {
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                QName qname = (QName)list.get(i);
                Element elt = doc.createElement("name");
                this.addAttribute(doc, "ns-url", qname.getNamespaceURI(), elt);
                this.addAttribute(doc, "localName", qname.getLocalPart(), elt);
                root.appendChild(elt);
            }
        }
        return root;
    }

    protected void processModelObjects(Map objectMappings, Element root, Document doc) {
        for (Object o : objectMappings.values()) {
            if (!(o instanceof Document)) continue;
            root.appendChild(doc.importNode(((Document)o).getDocumentElement(), true));
        }
    }

    protected void updateMapperClassnames(String fullyQulifiedIncludingClassNamePrefix) {
        Map classNameMap = this.mapper.getAllMappedNames();
        for (Object key : classNameMap.keySet()) {
            String className;
            String realClassName = className = (String)classNameMap.get(key);
            if (className.endsWith("[]")) {
                realClassName = realClassName.substring(0, realClassName.indexOf("[]"));
            }
            if (!TypeTesterUtil.hasPackage(realClassName) && !TypeTesterUtil.isPrimitive(realClassName)) {
                classNameMap.put(key, fullyQulifiedIncludingClassNamePrefix + "." + className);
                this.instantiatableMessageClassNames.put(key, fullyQulifiedIncludingClassNamePrefix + "$" + className);
                continue;
            }
            classNameMap.put(key, className);
            this.instantiatableMessageClassNames.put(key, className);
        }
    }

    protected void writeServiceXml() throws Exception {
        Document serviceXMLModel = this.createDOMDocumentForServiceXML();
        this.debugLogDocument("Document for service XML:", serviceXMLModel);
        ServiceXMLWriter serviceXmlWriter = new ServiceXMLWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getResourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        serviceXmlWriter.setOverride(this.codeGenConfiguration.isOverride());
        this.writeFile(serviceXMLModel, serviceXmlWriter);
    }

    protected Document createDOMDocumentForServiceXML() {
        Document doc = this.getEmptyDocument();
        String className = null;
        String serviceName = null;
        Element rootElement = doc.createElement("interfaces");
        doc.appendChild(rootElement);
        for (AxisService this.axisService : this.axisServices) {
            this.axisBinding = this.axisService.getEndpoint(this.axisService.getEndpointName()).getBinding();
            serviceName = this.axisService.getName();
            className = this.codeGenConfiguration.isBackwordCompatibilityMode() ? this.makeJavaClassName(this.axisService.getBindingName()) : this.makeJavaClassName(serviceName);
            rootElement.appendChild(this.getServiceElement(serviceName, className, doc));
        }
        return doc;
    }

    protected Element getServiceElement(String serviceName, String className, Document doc) {
        if (this.allServiceInfoHolder.get(serviceName) != null) {
            this.infoHolder = (Map)this.allServiceInfoHolder.get(serviceName);
        }
        Element rootElement = doc.createElement("interface");
        this.addAttribute(doc, "package", SKELETON_INTERFACE_SUFFIX_BACK, rootElement);
        this.addAttribute(doc, "classpackage", this.codeGenConfiguration.getPackageName(), rootElement);
        if (this.codeGenConfiguration.getSkeltonClassName() != null) {
            this.addAttribute(doc, "name", this.codeGenConfiguration.getSkeltonClassName(), rootElement);
        } else if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
            this.addAttribute(doc, "name", className + SKELETON_CLASS_SUFFIX_BACK, rootElement);
        } else {
            this.addAttribute(doc, "name", className + SKELETON_CLASS_SUFFIX, rootElement);
        }
        if (!this.codeGenConfiguration.isWriteTestCase()) {
            this.addAttribute(doc, "testOmit", "true", rootElement);
        }
        this.addAttribute(doc, "servicename", serviceName, rootElement);
        for (Object key : mepToClassMap.keySet()) {
            if (!Boolean.TRUE.equals(this.infoHolder.get(key))) continue;
            Element elt = this.addElement(doc, "messagereceiver", this.makeJavaClassName(serviceName) + mepToSuffixMap.get(key), rootElement);
            this.addAttribute(doc, "mepURI", key.toString(), elt);
        }
        this.loadOperations(doc, rootElement, null);
        return rootElement;
    }

    protected void writeSkeleton() throws Exception {
        Document skeletonModel = this.createDOMDocumentForSkeleton(this.codeGenConfiguration.isServerSideInterface());
        this.debugLogDocument("Document for skeleton:", skeletonModel);
        SkeletonWriter skeletonWriter = new SkeletonWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        skeletonWriter.setOverride(this.codeGenConfiguration.isOverride());
        this.writeFile(skeletonModel, skeletonWriter);
    }

    protected void writeSkeletonInterface() throws Exception {
        Document skeletonModel = this.createDOMDocumentForSkeletonInterface();
        this.debugLogDocument("Document for skeleton Interface:", skeletonModel);
        SkeletonInterfaceWriter skeletonInterfaceWriter = new SkeletonInterfaceWriter(this.codeGenConfiguration.isFlattenFiles() ? this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), null) : this.getOutputDirectory(this.codeGenConfiguration.getOutputLocation(), this.codeGenConfiguration.getSourceLocation()), this.codeGenConfiguration.getOutputLanguage());
        skeletonInterfaceWriter.setOverride(this.codeGenConfiguration.isOverride());
        this.writeFile(skeletonModel, skeletonInterfaceWriter);
    }

    protected Document createDOMDocumentForSkeleton(boolean isSkeletonInterface) {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String serviceName = this.makeJavaClassName(this.axisService.getName());
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
            this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getBindingName()) + SKELETON_CLASS_SUFFIX_BACK, rootElement);
        } else if (this.codeGenConfiguration.getSkeltonClassName() != null) {
            this.addAttribute(doc, "name", this.codeGenConfiguration.getSkeltonClassName(), rootElement);
        } else {
            this.addAttribute(doc, "name", serviceName + SKELETON_CLASS_SUFFIX, rootElement);
        }
        this.addAttribute(doc, "callbackname", serviceName + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.addAttribute(doc, "isbackcompatible", String.valueOf(this.codeGenConfiguration.isBackwordCompatibilityMode()), rootElement);
        if (isSkeletonInterface) {
            if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
                this.addAttribute(doc, "skeletonInterfaceName", this.makeJavaClassName(this.axisService.getEndpointName()) + SKELETON_INTERFACE_SUFFIX_BACK, rootElement);
            } else if (this.codeGenConfiguration.getSkeltonInterfaceName() != null) {
                this.addAttribute(doc, "skeletonInterfaceName", this.codeGenConfiguration.getSkeltonInterfaceName(), rootElement);
            } else {
                this.addAttribute(doc, "skeletonInterfaceName", serviceName + SKELETON_INTERFACE_SUFFIX, rootElement);
            }
        }
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected Document createDOMDocumentForSkeletonInterface() {
        Document doc = this.getEmptyDocument();
        Element rootElement = doc.createElement("interface");
        String serviceName = this.makeJavaClassName(this.axisService.getName());
        this.addAttribute(doc, "package", this.codeGenConfiguration.getPackageName(), rootElement);
        if (this.codeGenConfiguration.isBackwordCompatibilityMode()) {
            this.addAttribute(doc, "name", this.makeJavaClassName(this.axisService.getEndpointName()) + SKELETON_INTERFACE_SUFFIX_BACK, rootElement);
        } else if (this.codeGenConfiguration.getSkeltonInterfaceName() != null) {
            this.addAttribute(doc, "name", this.codeGenConfiguration.getSkeltonInterfaceName(), rootElement);
        } else {
            this.addAttribute(doc, "name", serviceName + SKELETON_INTERFACE_SUFFIX, rootElement);
        }
        this.addAttribute(doc, "callbackname", serviceName + CALL_BACK_HANDLER_SUFFIX, rootElement);
        this.addAttribute(doc, "isbackcompatible", String.valueOf(this.codeGenConfiguration.isBackwordCompatibilityMode()), rootElement);
        this.fillSyncAttributes(doc, rootElement);
        this.loadOperations(doc, rootElement, null);
        rootElement.appendChild(this.getUniqueListofFaults(doc));
        doc.appendChild(rootElement);
        return doc;
    }

    protected boolean loadOperations(Document doc, Element rootElement, String mep) {
        String serviceName = this.makeJavaClassName(this.axisService.getName());
        Iterator<AxisBindingOperation> bindingOperations = this.axisBinding.getChildren();
        boolean opsFound = false;
        AxisBindingOperation axisBindingOperation = null;
        AxisOperation axisOperation = null;
        while (bindingOperations.hasNext()) {
            Element methodElement;
            axisBindingOperation = bindingOperations.next();
            axisOperation = axisBindingOperation.getAxisOperation();
            String messageExchangePattern = axisOperation.getMessageExchangePattern();
            if (this.infoHolder.get(messageExchangePattern) == null) {
                this.infoHolder.put(messageExchangePattern, Boolean.TRUE);
            }
            if (mep == null) {
                opsFound = true;
                methodElement = this.generateMethodElement(doc, serviceName, axisBindingOperation);
                rootElement.appendChild(methodElement);
                continue;
            }
            if (!mep.equals(axisOperation.getMessageExchangePattern())) continue;
            opsFound = true;
            methodElement = this.generateMethodElement(doc, serviceName, axisBindingOperation);
            rootElement.appendChild(methodElement);
        }
        return opsFound;
    }

    protected Element generateMethodElement(Document doc, String endpointName, AxisBindingOperation bindingOperation) throws DOMException {
        Parameter dbgenimpl;
        Parameter dbmethname;
        AxisOperation axisOperation = bindingOperation.getAxisOperation();
        ArrayList soapHeaderInputParameterList = new ArrayList();
        ArrayList soapHeaderOutputParameterList = new ArrayList();
        Element methodElement = doc.createElement("method");
        String localPart = axisOperation.getName().getLocalPart();
        if (this.codeGenConfiguration.isUseOperationName()) {
            this.addAttribute(doc, "name", JavaUtils.xmlNameToJava(localPart), methodElement);
        } else {
            this.addAttribute(doc, "name", JavaUtils.xmlNameToJavaIdentifier(localPart), methodElement);
        }
        this.addAttribute(doc, "originalName", localPart, methodElement);
        this.addAttribute(doc, "namespace", axisOperation.getName().getNamespaceURI(), methodElement);
        this.addAttribute(doc, "style", (String)this.getBindingPropertyFromOperation("style", axisOperation.getName()), methodElement);
        String comment = SKELETON_INTERFACE_SUFFIX_BACK;
        if (axisOperation.getDocumentation() != null) {
            comment = axisOperation.getDocumentation().trim();
        }
        this.addAttribute(doc, "comment", comment, methodElement);
        String messageExchangePattern = axisOperation.getMessageExchangePattern();
        if ("jax-ws".equals(this.codeGenConfiguration.getOutputLanguage())) {
            AxisMessage msg;
            boolean wrapped = false;
            if (WSDLUtil.isInputPresentForMEP(messageExchangePattern) && (msg = axisOperation.getMessage("In")).getParameter("UnWrapped") != null) {
                wrapped = true;
            }
            this.addAttribute(doc, "parameterstyle", wrapped ? "WRAPPPED" : "BARE", methodElement);
        }
        this.addAttribute(doc, "dbsupportname", endpointName + localPart + DATABINDING_SUPPORTER_NAME_SUFFIX, methodElement);
        this.addAttribute(doc, "mep", Utils.getAxisSpecifMEPConstant(messageExchangePattern) + SKELETON_INTERFACE_SUFFIX_BACK, methodElement);
        this.addAttribute(doc, "mepURI", messageExchangePattern, methodElement);
        Parameter wsdl2StyleParameter = axisOperation.getParameter("operationStyle");
        if (wsdl2StyleParameter != null) {
            this.addAttribute(doc, "wsdl2Styles", this.arrayToString((URI[])wsdl2StyleParameter.getValue()), methodElement);
        }
        if ((dbmethname = axisOperation.getParameter("databinding-generated-receiver")) != null) {
            this.addAttribute(doc, "usedbmethod", (String)dbmethname.getValue(), methodElement);
        }
        if ((dbgenimpl = axisOperation.getParameter("databinding-generated-implementation")) != null && Boolean.TRUE.equals(dbgenimpl.getValue())) {
            this.addAttribute(doc, "usdbimpl", "true", methodElement);
        } else {
            this.addAttribute(doc, "usdbimpl", "false", methodElement);
        }
        this.addSOAPAction(doc, methodElement, bindingOperation.getName());
        this.addOutputAndFaultActions(doc, methodElement, axisOperation);
        this.addHeaderOperations(soapHeaderInputParameterList, bindingOperation, true);
        if (WSDLUtil.isInputPresentForMEP(messageExchangePattern)) {
            if ("jax-ws".equals(this.codeGenConfiguration.getOutputLanguage())) {
                this.useHolderClass_jaxws = false;
                AxisMessage inMessage = axisOperation.getMessage("In");
                if (WSDLUtil.isOutputPresentForMEP(messageExchangePattern)) {
                    AxisMessage outMessage = axisOperation.getMessage("Out");
                    if (inMessage.getName().equals(outMessage.getName())) {
                        this.useHolderClass_jaxws = true;
                        this.addAttribute(doc, "useholder", "true", methodElement);
                    }
                }
            }
            methodElement.appendChild(this.getInputElement(doc, bindingOperation, soapHeaderInputParameterList));
        }
        if (WSDLUtil.isOutputPresentForMEP(messageExchangePattern)) {
            methodElement.appendChild(this.getOutputElement(doc, bindingOperation, soapHeaderOutputParameterList));
        }
        methodElement.appendChild(this.getFaultElement(doc, axisOperation));
        this.setTransferCoding(axisOperation, methodElement, doc);
        String property = (String)this.getBindingPropertyFromOperation("whttp:queryParameterSeparator", axisOperation.getName());
        if (property != null) {
            methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.description.WSDL2Constants.ATTR_WHTTP_QUERY_PARAMETER_SEPARATOR", "\"" + property + "\""));
        }
        if ((property = (String)this.getBindingPropertyFromOperation("whttp:location", axisOperation.getName())) != null) {
            methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.description.WSDL2Constants.ATTR_WHTTP_LOCATION", "\"" + property + "\""));
        }
        String mep = (String)this.getBindingPropertyFromOperation("wsoap:mep", axisOperation.getName());
        String bindingType = null;
        if (this.axisBinding != null) {
            bindingType = this.axisBinding.getType();
        }
        if ("http://www.w3.org/2003/05/soap/mep/soap-response/".equalsIgnoreCase(mep)) {
            methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.Constants.Configuration.ENABLE_REST", "true"));
            methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.Constants.Configuration.HTTP_METHOD", "\"GET\""));
            methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.Constants.Configuration.CONTENT_TYPE", "\"application/x-www-form-urlencoded\""));
            methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.Constants.Configuration.MESSAGE_TYPE", "\"application/x-www-form-urlencoded\""));
            methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.Constants.Configuration.SOAP_RESPONSE_MEP", "true"));
        } else if (bindingType != null && bindingType.equals("http://www.w3.org/ns/wsdl/http")) {
            Parameter safe;
            methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.Constants.Configuration.ENABLE_REST", "true"));
            property = (String)this.getBindingPropertyFromOperation("whttp:method", axisOperation.getName());
            if (property != null) {
                methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.Constants.Configuration.HTTP_METHOD", "\"" + property + "\""));
            } else if (!"http://www.w3.org/2003/05/soap/mep/soap-response/".equalsIgnoreCase(mep) && (safe = axisOperation.getParameter("wsdlx:safe")) != null) {
                if (((Boolean)safe.getValue()).booleanValue()) {
                    methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.Constants.Configuration.HTTP_METHOD", "\"GET\""));
                } else {
                    methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.Constants.Configuration.HTTP_METHOD", "\"POST\""));
                }
            }
            Boolean value = (Boolean)this.getBindingPropertyFromOperation("whttp:ignoreUncited", axisOperation.getName());
            if (value != null) {
                methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.description.WSDL2Constants.ATTR_WHTTP_IGNORE_UNCITED", "\"" + value + "\""));
            }
            if ((property = (String)this.getBindingPropertyFromOperation("whttp:code", axisOperation.getName())) != null) {
                methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.description.WSDL2Constants.ATTR_WHTTP_CODE", "\"" + property + "\""));
            }
            if ((property = (String)this.getBindingPropertyFromOperation("whttp:inputSerialization", axisOperation.getName())) != null) {
                methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.Constants.Configuration.CONTENT_TYPE", "\"" + property + "\""));
                methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.Constants.Configuration.MESSAGE_TYPE", "\"" + property + "\""));
            }
        }
        return methodElement;
    }

    private String arrayToString(Object[] array) {
        if (array == null || array.length == 0) {
            return SKELETON_INTERFACE_SUFFIX_BACK;
        }
        int size = array.length;
        if (size == 1) {
            return String.valueOf(array[0]);
        }
        StringBuffer result = new StringBuffer(String.valueOf(array[0]));
        for (int i = 1; i < size; ++i) {
            result.append(",");
            result.append(String.valueOf(array[i]));
        }
        return result.toString();
    }

    private void setTransferCoding(AxisOperation axisOperation, Element methodElement, Document doc) {
        String transferCoding = (String)this.getBindingPropertyFromMessage("whttp:contentEncoding", axisOperation.getName(), "in");
        if (!SKELETON_INTERFACE_SUFFIX_BACK.equals(transferCoding) && ("gzip".equals(transferCoding) || "compress".equals(transferCoding))) {
            methodElement.appendChild(this.generateOptionParamComponent(doc, "org.apache.axis2.transport.http.HTTPConstants.MC_GZIP_REQUEST", "true"));
        }
    }

    private void setHttpHeaderOptions(AxisOperation axisOperation, Element methodElement, Document doc) {
    }

    protected Document getEmptyDocument() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    protected String makeJavaClassName(String word) {
        if (JavaUtils.isJavaKeyword(word)) {
            return JavaUtils.makeNonJavaKeyword(word);
        }
        return JavaUtils.capitalizeFirstChar(JavaUtils.xmlNameToJava(word));
    }

    protected void addAttribute(Document document, String AttribName, String attribValue, Element element) {
        XSLTUtils.addAttribute(document, AttribName, attribValue, element);
    }

    protected void fillSyncAttributes(Document doc, Element rootElement) {
        this.addAttribute(doc, "isAsync", this.codeGenConfiguration.isAsyncOn() ? "1" : "0", rootElement);
        this.addAttribute(doc, "isSync", this.codeGenConfiguration.isSyncOn() ? "1" : "0", rootElement);
    }

    protected void debugLogDocument(String description, Document doc) {
        if (log.isDebugEnabled()) {
            try {
                DOMSource source = new DOMSource(doc);
                StringWriter swrite = new StringWriter();
                swrite.write(description);
                swrite.write("\n");
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(source, new StreamResult(swrite));
                log.debug((Object)swrite.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected File getOutputDirectory(File outputDir, String dir2) {
        if (dir2 != null && !SKELETON_INTERFACE_SUFFIX_BACK.equals(dir2)) {
            outputDir = new File(outputDir, dir2);
        }
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            log.warn((Object)("Cannot create output directory " + outputDir.getAbsolutePath()));
        }
        return outputDir;
    }

    protected void writeFile(Document model, FileWriter writer) throws IOException, Exception {
        writer.loadTemplate();
        String packageName = model.getDocumentElement().getAttribute("package");
        String className = model.getDocumentElement().getAttribute("name");
        writer.createOutFile(packageName, className);
        this.codeGenConfiguration.addOutputFileName(writer.getOutputFile().getAbsolutePath());
        writer.parse(model, this.resolver);
    }

    protected void addSOAPAction(Document doc, Element rootElement, QName qName) {
        this.addAttribute(doc, "soapaction", (String)this.getBindingPropertyFromOperation("wsoap:action", qName), rootElement);
    }

    private void addOutputAndFaultActions(Document doc, Element methodElement, AxisOperation operation) {
        String[] faultActionNames;
        String outputAction = operation.getOutputAction();
        if (outputAction != null) {
            Element outputActionElt = doc.createElement("outputActionMapping");
            outputActionElt.setAttribute("Action", outputAction);
            methodElement.appendChild(outputActionElt);
        }
        if ((faultActionNames = operation.getFaultActionNames()) != null) {
            for (int i = 0; i < faultActionNames.length; ++i) {
                Element faultActionElt = doc.createElement("faultActionMapping");
                faultActionElt.setAttribute("faultName", faultActionNames[i]);
                faultActionElt.setAttribute("Action", operation.getFaultAction(faultActionNames[i]));
                methodElement.appendChild(faultActionElt);
            }
        }
    }

    protected void addHeaderOperations(List soapHeaderParameterQNameList, AxisBindingOperation bindingOperation, boolean input) {
        AxisOperation axisOperation = bindingOperation.getAxisOperation();
        ArrayList headerparamList = new ArrayList();
        String MEP2 = axisOperation.getMessageExchangePattern();
        if (input) {
            if (WSDLUtil.isInputPresentForMEP(MEP2)) {
                headerparamList = (ArrayList)this.getBindingPropertyFromMessage("wsoap:header", bindingOperation.getName(), "In");
            }
        } else if (WSDLUtil.isOutputPresentForMEP(MEP2)) {
            headerparamList = (ArrayList)this.getBindingPropertyFromMessage("wsoap:header", bindingOperation.getName(), "Out");
        }
        if (headerparamList != null) {
            for (SOAPHeaderMessage header : headerparamList) {
                soapHeaderParameterQNameList.add(header);
            }
        }
    }

    protected void addHeaderOperationsToFault(List soapHeaderParameterQNameList, AxisOperation axisOperation) {
        ArrayList headerparamList = new ArrayList();
        ArrayList<AxisMessage> faultMessages = axisOperation.getFaultMessages();
        for (AxisMessage axisFaultMessage : faultMessages) {
            headerparamList.addAll((ArrayList)this.getBindingPropertyFromMessageFault("wsoap:header", axisOperation.getName(), axisFaultMessage.getName()));
        }
        if (headerparamList != null) {
            for (SOAPHeaderMessage header : headerparamList) {
                soapHeaderParameterQNameList.add(header.getElement());
            }
        }
    }

    protected Element getInputElement(Document doc, AxisBindingOperation bindingOperation, List headerParameterQNameList) {
        AxisOperation operation = bindingOperation.getAxisOperation();
        Element inputElt = doc.createElement("input");
        String mep = operation.getMessageExchangePattern();
        if (WSDLUtil.isInputPresentForMEP(mep)) {
            Element[] param = this.getInputParamElement(doc, operation);
            for (int i = 0; i < param.length; ++i) {
                inputElt.appendChild(param[i]);
            }
            List parameterElementList = this.getParameterElementList(doc, headerParameterQNameList, "soap_header");
            parameterElementList.addAll(this.getParameterElementListForHttpHeader(doc, (ArrayList)this.getBindingPropertyFromMessage("whttp:header", operation.getName(), "in"), "http_header"));
            parameterElementList.addAll(this.getParameterElementListForSOAPModules(doc, (ArrayList)this.getBindingPropertyFromMessage("wsoap:module", operation.getName(), "in")));
            for (int i = 0; i < parameterElementList.size(); ++i) {
                inputElt.appendChild((Element)parameterElementList.get(i));
            }
            Policy policy = this.getBindingPolicyFromMessage(bindingOperation, "In");
            if (policy != null) {
                try {
                    this.addAttribute(doc, "policy", PolicyUtil.getSafeString(PolicyUtil.policyComponentToString((PolicyComponent)policy)), inputElt);
                }
                catch (Exception ex) {
                    throw new RuntimeException("can't serialize the policy ..", ex);
                }
            }
        }
        return inputElt;
    }

    protected Element getFaultElement(Document doc, AxisOperation operation) {
        Element faultElt = doc.createElement("fault");
        Element[] param = this.getFaultParamElements(doc, operation);
        for (int i = 0; i < param.length; ++i) {
            faultElt.appendChild(param[i]);
        }
        return faultElt;
    }

    protected Element getOutputElement(Document doc, AxisBindingOperation bindingOperation, List headerParameterQNameList) {
        AxisOperation operation = bindingOperation.getAxisOperation();
        Element outputElt = doc.createElement("output");
        String mep = operation.getMessageExchangePattern();
        if (WSDLUtil.isOutputPresentForMEP(mep)) {
            Element param = this.getOutputParamElement(doc, operation);
            if (param != null) {
                outputElt.appendChild(param);
            }
            List outputElementList = this.getParameterElementList(doc, headerParameterQNameList, "soap_header");
            outputElementList.addAll(this.getParameterElementListForHttpHeader(doc, (ArrayList)this.getBindingPropertyFromMessage("whttp:header", operation.getName(), "out"), "http_header"));
            for (int i = 0; i < outputElementList.size(); ++i) {
                outputElt.appendChild((Element)outputElementList.get(i));
            }
            Policy policy = this.getBindingPolicyFromMessage(bindingOperation, "Out");
            if (policy != null) {
                try {
                    this.addAttribute(doc, "policy", PolicyUtil.getSafeString(PolicyUtil.policyComponentToString((PolicyComponent)policy)), outputElt);
                }
                catch (Exception ex) {
                    throw new RuntimeException("can't serialize the policy ..", ex);
                }
            }
        }
        return outputElt;
    }

    protected Element[] getFaultParamElements(Document doc, AxisOperation operation) {
        ArrayList<Element> params = new ArrayList<Element>();
        ArrayList<AxisMessage> faultMessages = operation.getFaultMessages();
        if (faultMessages != null && !faultMessages.isEmpty()) {
            for (int i = 0; i < faultMessages.size(); ++i) {
                String typeMapping;
                Element paramElement = doc.createElement("param");
                AxisMessage msg = faultMessages.get(i);
                if (msg.getElementQName() == null) {
                    throw new RuntimeException("Element QName is null for " + msg.getName() + "!");
                }
                String faultComment = SKELETON_INTERFACE_SUFFIX_BACK;
                if (msg.getDocumentation() != null) {
                    faultComment = msg.getDocumentation().trim();
                }
                this.addAttribute(doc, "comment", faultComment, paramElement);
                this.addAttribute(doc, "name", (String)this.fullyQualifiedFaultClassNameMap.get(msg.getName()), paramElement);
                this.addAttribute(doc, "shortName", (String)this.faultClassNameMap.get(msg.getName()), paramElement);
                this.addAttribute(doc, "namespace", msg.getElementQName().getNamespaceURI(), paramElement);
                this.addAttribute(doc, "localname", msg.getElementQName().getLocalPart(), paramElement);
                if (msg.getElementQName() != null) {
                    Element qNameElement = doc.createElement("qname");
                    this.addAttribute(doc, "nsuri", msg.getElementQName().getNamespaceURI(), qNameElement);
                    this.addAttribute(doc, "localname", msg.getElementQName().getLocalPart(), qNameElement);
                    paramElement.appendChild(qNameElement);
                }
                this.addAttribute(doc, "type", (typeMapping = this.mapper.getTypeMappingName(msg.getElementQName())) == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping, paramElement);
                this.addShortType(paramElement, msg.getElementQName() == null ? null : msg.getElementQName().getLocalPart());
                String attribValue = (String)this.instantiatableMessageClassNames.get(msg.getElementQName());
                this.addAttribute(doc, "instantiatableType", attribValue == null ? SKELETON_INTERFACE_SUFFIX_BACK : attribValue, paramElement);
                if (this.mapper.getDefaultMappingName().equals(typeMapping)) {
                    this.addAttribute(doc, "default", "yes", paramElement);
                }
                this.addAttribute(doc, "value", this.getParamInitializer(typeMapping), paramElement);
                this.addAttribute(doc, "operationName", operation.getName().getLocalPart(), paramElement);
                Iterator iter = msg.getExtensibilityAttributes().iterator();
                while (iter.hasNext()) {
                }
                params.add(paramElement);
            }
            return params.toArray(new Element[params.size()]);
        }
        return new Element[0];
    }

    protected Element[] getInputParamElement(Document doc, AxisOperation operation) {
        AxisMessage inputMessage = operation.getMessage("In");
        ArrayList<Element> paramElementList = new ArrayList<Element>();
        if (inputMessage != null) {
            Element mainParameter = this.generateParamComponent(doc, inputMessage.getDocumentation(), this.mapper.getParameterName(inputMessage.getElementQName()), this.mapper.getTypeMappingName(inputMessage.getElementQName()), operation.getName(), inputMessage.getElementQName(), inputMessage.getPartName(), false, false);
            paramElementList.add(mainParameter);
            if ((this.codeGenConfiguration.isBackwordCompatibilityMode() || !this.codeGenConfiguration.isParametersWrapped()) && inputMessage.getParameter("complexType") != null) {
                Parameter parameter = inputMessage.getParameter("complexType");
                this.addAttribute(doc, "complextype", (String)parameter.getValue(), mainParameter);
            }
            if (!this.codeGenConfiguration.isParametersWrapped()) {
                this.addAttribute(doc, "unwrappParameters", "true", mainParameter);
            }
            if (inputMessage.getParameter("UnWrapped") != null) {
                Parameter detailsParameter = inputMessage.getParameter("UnWrapped_details");
                MessagePartInformationHolder infoHolder = (MessagePartInformationHolder)detailsParameter.getValue();
                List partsList = infoHolder.getPartsList();
                this.wrapped_jaxws = true;
                for (int i = 0; i < partsList.size(); ++i) {
                    QName qName = (QName)partsList.get(i);
                    mainParameter.appendChild(this.generateParamComponent(doc, null, this.mapper.getParameterName(qName), this.mapper.getTypeMappingName(qName), operation.getName(), qName, qName.getLocalPart(), this.mapper.getTypeMappingStatus(qName) != null, "arrayType".equals(this.mapper.getTypeMappingStatus(qName))));
                }
            }
        }
        return paramElementList.toArray(new Element[paramElementList.size()]);
    }

    protected Element generateParamComponent(Document doc, String comment, String paramName, String paramType, QName operationName, QName paramQName) {
        return this.generateParamComponent(doc, comment, paramName, paramType, operationName, paramQName, null, false, false);
    }

    protected Element generateParamComponent(Document doc, String comment, String paramName, String paramType, QName paramQName) {
        return this.generateParamComponent(doc, comment, paramName, paramType, null, paramQName, null, false, false);
    }

    protected Element generateOptionParamComponent(Document doc, String name, String value) {
        Element optionParamElement = doc.createElement("optionParam");
        this.addAttribute(doc, "name", name, optionParamElement);
        this.addAttribute(doc, "value", value, optionParamElement);
        return optionParamElement;
    }

    protected Element generateParamComponent(Document doc, String comment, String paramName, String paramType, QName opName, QName paramQName, String partName, boolean isPrimitive, boolean isArray) {
        Class primitive;
        Element paramElement = doc.createElement("param");
        this.addAttribute(doc, "name", paramName, paramElement);
        this.addAttribute(doc, "comment", comment == null ? SKELETON_INTERFACE_SUFFIX_BACK : comment, paramElement);
        if (this.codeGenConfiguration.getOutputLanguage().equals("jax-ws") && this.useHolderClass_jaxws && (primitive = JavaUtils.getWrapperClass(paramType)) != null) {
            paramType = primitive.getName();
        }
        this.addAttribute(doc, "type", paramType == null ? SKELETON_INTERFACE_SUFFIX_BACK : paramType, paramElement);
        this.addShortType(paramElement, paramQName == null ? null : paramQName.getLocalPart());
        if (this.mapper.getDefaultMappingName().equals(paramType)) {
            this.addAttribute(doc, "default", "yes", paramElement);
        }
        this.addAttribute(doc, "value", this.getParamInitializer(paramType), paramElement);
        this.addAttribute(doc, "location", "body", paramElement);
        if (opName != null) {
            String localPart = opName.getLocalPart();
            this.addAttribute(doc, "opname", JavaUtils.xmlNameToJava(localPart), paramElement);
        }
        if (paramQName != null) {
            Element qNameElement = doc.createElement("qname");
            this.addAttribute(doc, "nsuri", paramQName.getNamespaceURI(), qNameElement);
            this.addAttribute(doc, "localname", paramQName.getLocalPart(), qNameElement);
            paramElement.appendChild(qNameElement);
        }
        if (partName != null) {
            String javaName = null;
            javaName = JavaUtils.isJavaKeyword(partName) ? JavaUtils.makeNonJavaKeyword(partName) : (this.codeGenConfiguration.getOutputLanguage().equals("jax-ws") ? JavaUtils.xmlNameToJavaIdentifier(JavaUtils.xmlNameToJava(partName)) : JavaUtils.capitalizeFirstChar(JavaUtils.xmlNameToJava(partName)));
            this.addAttribute(doc, "partname", javaName, paramElement);
        }
        if (isPrimitive) {
            this.addAttribute(doc, "primitive", "yes", paramElement);
        }
        if (isArray) {
            this.addAttribute(doc, "array", "yes", paramElement);
        }
        return paramElement;
    }

    protected Element getOutputParamElement(Document doc, AxisOperation operation) {
        QName paramQName;
        String partName;
        Element paramElement = doc.createElement("param");
        AxisMessage outputMessage = operation.getMessage("Out");
        if (outputMessage == null) {
            return null;
        }
        String comment = null;
        String parameterName = this.mapper.getParameterName(outputMessage.getElementQName());
        comment = outputMessage.getDocumentation();
        String typeMapping = this.mapper.getTypeMappingName(outputMessage.getElementQName());
        String typeMappingStr = typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping;
        this.addAttribute(doc, "name", parameterName, paramElement);
        this.addAttribute(doc, "comment", comment == null ? SKELETON_INTERFACE_SUFFIX_BACK : comment, paramElement);
        this.addAttribute(doc, "type", typeMappingStr, paramElement);
        this.addShortType(paramElement, outputMessage.getElementQName() == null ? null : outputMessage.getElementQName().getLocalPart());
        if (this.mapper.getDefaultMappingName().equals(typeMappingStr)) {
            this.addAttribute(doc, "default", "yes", paramElement);
        }
        this.addAttribute(doc, "location", "body", paramElement);
        String localPart = operation.getName().getLocalPart();
        this.addAttribute(doc, "opname", JavaUtils.xmlNameToJava(localPart), paramElement);
        if ((this.codeGenConfiguration.isBackwordCompatibilityMode() || !this.codeGenConfiguration.isParametersWrapped()) && outputMessage.getParameter("complexType") != null) {
            Parameter parameter = outputMessage.getParameter("complexType");
            this.addAttribute(doc, "complextype", (String)parameter.getValue(), paramElement);
        }
        if ((partName = outputMessage.getPartName()) != null && this.codeGenConfiguration.getOutputLanguage().equals("jax-ws")) {
            String javaName = null;
            javaName = JavaUtils.isJavaKeyword(partName) ? JavaUtils.makeNonJavaKeyword(partName) : JavaUtils.xmlNameToJavaIdentifier(JavaUtils.xmlNameToJava(partName));
            this.addAttribute(doc, "partname", javaName, paramElement);
        }
        if (outputMessage.getParameter("UnWrapped") != null) {
            Parameter detailsParameter = outputMessage.getParameter("UnWrapped_details");
            MessagePartInformationHolder infoHolder = (MessagePartInformationHolder)detailsParameter.getValue();
            List partsList = infoHolder.getPartsList();
            for (QName qName : partsList) {
                paramElement.appendChild(this.generateParamComponent(doc, null, this.mapper.getParameterName(qName), this.mapper.getTypeMappingName(qName), operation.getName(), qName, qName.getLocalPart(), this.mapper.getTypeMappingStatus(qName) != null, "arrayType".equals(this.mapper.getTypeMappingStatus(qName))));
            }
        }
        if ((paramQName = outputMessage.getElementQName()) != null) {
            Element qNameElement = doc.createElement("qname");
            this.addAttribute(doc, "nsuri", paramQName.getNamespaceURI(), qNameElement);
            this.addAttribute(doc, "localname", paramQName.getLocalPart(), qNameElement);
            paramElement.appendChild(qNameElement);
        }
        return paramElement;
    }

    protected String getParamInitializer(String paramType) {
        String out = (String)constructorMap.get(paramType);
        if (out == null) {
            out = "null";
        }
        return out;
    }

    protected List getParameterElementList(Document doc, List parameters, String location) {
        ArrayList<Element> parameterElementList = new ArrayList<Element>();
        if (parameters != null && !parameters.isEmpty()) {
            int count = parameters.size();
            for (int i = 0; i < count; ++i) {
                Element param = doc.createElement("param");
                SOAPHeaderMessage header = (SOAPHeaderMessage)parameters.get(i);
                QName name = header.getElement();
                this.addAttribute(doc, "name", this.mapper.getParameterName(name), param);
                String typeMapping = this.mapper.getTypeMappingName(name);
                String typeMappingStr = typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping;
                this.addAttribute(doc, "type", typeMappingStr, param);
                this.addAttribute(doc, "location", location, param);
                if (header.isMustUnderstand()) {
                    this.addAttribute(doc, "mustUnderstand", "true", param);
                }
                if (name != null) {
                    Element qNameElement = doc.createElement("qname");
                    this.addAttribute(doc, "nsuri", name.getNamespaceURI(), qNameElement);
                    this.addAttribute(doc, "localname", name.getLocalPart(), qNameElement);
                    param.appendChild(qNameElement);
                }
                parameterElementList.add(param);
            }
        }
        return parameterElementList;
    }

    protected List getParameterElementListForHttpHeader(Document doc, List parameters, String location) {
        ArrayList<Element> parameterElementList = new ArrayList<Element>();
        if (parameters != null && !parameters.isEmpty()) {
            int count = parameters.size();
            for (int i = 0; i < count; ++i) {
                Element param = doc.createElement("param");
                HTTPHeaderMessage httpHeaderMessage = (HTTPHeaderMessage)parameters.get(i);
                QName qName = httpHeaderMessage.getqName();
                String name = httpHeaderMessage.getName();
                this.addAttribute(doc, "name", JavaUtils.xmlNameToJavaIdentifier(name), param);
                this.addAttribute(doc, "headername", name, param);
                String typeMapping = this.mapper.getTypeMappingName(qName);
                String typeMappingStr = typeMapping == null ? SKELETON_INTERFACE_SUFFIX_BACK : typeMapping;
                this.addAttribute(doc, "type", typeMappingStr, param);
                this.addAttribute(doc, "location", location, param);
                parameterElementList.add(param);
            }
        }
        return parameterElementList;
    }

    protected List getParameterElementListForSOAPModules(Document doc, List parameters) {
        ArrayList<Element> parameterElementList = new ArrayList<Element>();
        if (parameters != null && !parameters.isEmpty()) {
            int count = parameters.size();
            for (int i = 0; i < count; ++i) {
                Element param = doc.createElement("param");
                SOAPModuleMessage soapModuleMessage = (SOAPModuleMessage)parameters.get(i);
                this.addAttribute(doc, "uri", soapModuleMessage.getUri(), param);
                this.addAttribute(doc, "location", "wsoap_module", param);
                parameterElementList.add(param);
            }
        }
        return parameterElementList;
    }

    protected Element addElement(Document document, String eltName, String eltValue, Element element) {
        Element elt = XSLTUtils.addChildElement(document, eltName, element);
        if (eltValue != null) {
            elt.appendChild(document.createTextNode(eltValue));
        }
        return elt;
    }

    static {
        constructorMap = new HashMap(50);
        constructorMap.put("int", "0");
        constructorMap.put("float", "0");
        constructorMap.put("boolean", "true");
        constructorMap.put("double", "0");
        constructorMap.put("byte", "(byte)0");
        constructorMap.put("short", "(short)0");
        constructorMap.put("long", "0");
        constructorMap.put("java.lang.Boolean", "new java.lang.Boolean(false)");
        constructorMap.put("java.lang.Byte", "new java.lang.Byte((byte)0)");
        constructorMap.put("java.lang.Double", "new java.lang.Double(0)");
        constructorMap.put("java.lang.Float", "new java.lang.Float(0)");
        constructorMap.put("java.lang.Integer", "new java.lang.Integer(0)");
        constructorMap.put("java.lang.Long", "new java.lang.Long(0)");
        constructorMap.put("java.lang.Short", "new java.lang.Short((short)0)");
        constructorMap.put("java.math.BigDecimal", "new java.math.BigDecimal(0)");
        constructorMap.put("java.math.BigInteger", "new java.math.BigInteger(\"0\")");
        constructorMap.put("java.lang.Object", "new java.lang.String()");
        constructorMap.put("byte[]", "new byte[0]");
        constructorMap.put("java.util.Calendar", "java.util.Calendar.getInstance()");
        constructorMap.put("javax.xml.namespace.QName", "new javax.xml.namespace.QName(\"http://foo\", \"bar\")");
        mepToClassMap = new HashMap();
        mepToClassMap.put("http://www.w3.org/ns/wsdl/in-only", "org.apache.axis2.receivers.AbstractInMessageReceiver");
        mepToClassMap.put("http://www.w3.org/ns/wsdl/robust-in-only", "org.apache.axis2.receivers.AbstractMessageReceiver");
        mepToClassMap.put("http://www.w3.org/ns/wsdl/in-out", "org.apache.axis2.receivers.AbstractInOutMessageReceiver");
        mepToSuffixMap = new HashMap();
        mepToSuffixMap.put("http://www.w3.org/2004/08/wsdl/in-only", "MessageReceiverInOnly");
        mepToSuffixMap.put("http://www.w3.org/2006/01/wsdl/in-only", "MessageReceiverInOnly");
        mepToSuffixMap.put("http://www.w3.org/ns/wsdl/in-only", "MessageReceiverInOnly");
        mepToSuffixMap.put("http://www.w3.org/2004/08/wsdl/robust-in-only", "MessageReceiverRobustInOnly");
        mepToSuffixMap.put("http://www.w3.org/2006/01/wsdl/robust-in-only", "MessageReceiverRobustInOnly");
        mepToSuffixMap.put("http://www.w3.org/ns/wsdl/robust-in-only", "MessageReceiverRobustInOnly");
        mepToSuffixMap.put("http://www.w3.org/2004/08/wsdl/in-out", "MessageReceiverInOut");
        mepToSuffixMap.put("http://www.w3.org/2006/01/wsdl/in-out", "MessageReceiverInOut");
        mepToSuffixMap.put("http://www.w3.org/ns/wsdl/in-out", "MessageReceiverInOut");
        log = LogFactory.getLog(AxisServiceBasedMultiLanguageEmitter.class);
    }
}

