/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.control.wka;

import java.util.Arrays;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.tribes.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemberListCommand
extends ControlCommand {
    private static final Log log = LogFactory.getLog(MemberListCommand.class);
    private static final long serialVersionUID = 5687720124889269491L;
    private Member[] members;
    private transient MembershipManager membershipManager;

    public void setMembershipManager(MembershipManager membershipManager) {
        this.membershipManager = membershipManager;
    }

    public void setMembers(Member[] members) {
        this.members = members;
    }

    @Override
    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("MembershipManager#domain: " + new String(this.membershipManager.getDomain())));
        }
        Member localMember = this.membershipManager.getLocalMember();
        for (Member member : this.members) {
            this.addMember(localMember, member);
        }
    }

    private void addMember(Member localMember, Member member) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to add member " + TribesUtil.getName(member) + "..."));
        }
        if (localMember == null || !Arrays.equals(localMember.getHost(), member.getHost()) || localMember.getPort() != member.getPort()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added member " + TribesUtil.getName(member)));
            }
            this.membershipManager.memberAdded(member);
        }
    }
}

