/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.loader;

import java.util.ArrayList;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.wso2.carbon.webapp.mgt.loader.ClassloadingConfiguration;
import org.wso2.carbon.webapp.mgt.loader.ClassloadingContextBuilder;

public class WebappClassloadingContext {
    private static final Log log = LogFactory.getLog(WebappClassloadingContext.class);
    private boolean parentFirst = false;
    private String[] delegatedPackages;
    private String[] delegatedPackageStems;
    private String[] excludeedPackages;
    private String[] excludeedPackageStems;
    private boolean noExcludedPackages = true;
    private String[] repositories;
    private static ClassloadingConfiguration classloadingConfig;
    private boolean delegateAllPackages = false;

    public static ClassloadingConfiguration getClassloadingConfig() {
        return classloadingConfig;
    }

    public boolean isDelegatedPackage(String name) {
        if (this.delegateAllPackages) {
            return true;
        }
        if (name == null) {
            return false;
        }
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        String packageName = name.substring(0, pos);
        for (String delegatedPkg : this.delegatedPackageStems) {
            if (!packageName.startsWith(delegatedPkg)) continue;
            return true;
        }
        for (String delegatedPkg : this.delegatedPackages) {
            if (!packageName.equals(delegatedPkg)) continue;
            return true;
        }
        return false;
    }

    public void setDelegatedPackages(String[] delegatedPkgList) {
        ArrayList<String> delegatedPackageList = new ArrayList<String>();
        ArrayList<String> delegatedPackageStemList = new ArrayList<String>();
        ArrayList<String> excludedPackageList = new ArrayList<String>();
        ArrayList<String> excludedPackageStemList = new ArrayList<String>();
        for (String packageName : delegatedPkgList) {
            if (packageName.startsWith("!")) {
                if ((packageName = packageName.substring(1)).endsWith(".*")) {
                    excludedPackageStemList.add(packageName.substring(0, packageName.length() - 2));
                    continue;
                }
                excludedPackageList.add(packageName);
                continue;
            }
            if (packageName.equals("*")) {
                this.delegateAllPackages = true;
                continue;
            }
            if (packageName.endsWith(".*")) {
                delegatedPackageStemList.add(packageName.substring(0, packageName.length() - 2));
                continue;
            }
            delegatedPackageList.add(packageName);
        }
        if (excludedPackageList.size() > 0 || excludedPackageStemList.size() > 0) {
            this.noExcludedPackages = false;
        }
        if (!this.noExcludedPackages) {
            this.excludeedPackages = excludedPackageList.toArray(new String[excludedPackageList.size()]);
            this.excludeedPackageStems = excludedPackageStemList.toArray(new String[excludedPackageStemList.size()]);
        }
        if (!this.delegateAllPackages) {
            this.delegatedPackages = delegatedPackageList.toArray(new String[delegatedPackageList.size()]);
            this.delegatedPackageStems = delegatedPackageStemList.toArray(new String[delegatedPackageStemList.size()]);
        }
    }

    public String[] getProvidedRepositories() {
        return this.repositories;
    }

    public void setProvidedRepositories(String[] repositories) {
        this.repositories = repositories;
    }

    public boolean isParentFirst() {
        return this.parentFirst;
    }

    public void setParentFirst(boolean parentFirst) {
        this.parentFirst = parentFirst;
    }

    public boolean isExcludedPackage(String name) {
        if (this.noExcludedPackages) {
            return false;
        }
        if (name == null) {
            return false;
        }
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        String packageName = name.substring(0, pos);
        for (String excludedPkg : this.excludeedPackageStems) {
            if (!packageName.startsWith(excludedPkg)) continue;
            return true;
        }
        for (String excludedPkg : this.excludeedPackages) {
            if (!packageName.equals(excludedPkg)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            classloadingConfig = ClassloadingContextBuilder.buildSystemConfig();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

