/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataException;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.utils.Pageable;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.SessionMetadata;
import org.wso2.carbon.webapp.mgt.SessionsWrapper;
import org.wso2.carbon.webapp.mgt.TomcatUtil;
import org.wso2.carbon.webapp.mgt.VersionedWebappMetadata;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebappMetadata;
import org.wso2.carbon.webapp.mgt.WebappStatistics;
import org.wso2.carbon.webapp.mgt.WebappUploadData;
import org.wso2.carbon.webapp.mgt.WebappsConstants;
import org.wso2.carbon.webapp.mgt.WebappsWrapper;
import org.wso2.carbon.webapp.mgt.sync.ApplicationSynchronizeRequest;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;
import org.wso2.carbon.webapp.mgt.version.AppVersionGroupPersister;

public class WebappAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(WebappAdmin.class);
    private static Boolean defaultVersionManagement = null;
    private Map<String, Boolean> versioningConfiguration = new HashMap<String, Boolean>();
    private Map<String, String> appGroupToCurrentVersionMap = null;

    public WebappAdmin() {
    }

    public WebappAdmin(AxisConfiguration axisConfig) throws Exception {
        super(axisConfig);
    }

    public WebappsWrapper getPagedWebappsSummary(String webappSearchString, String webappState, String webappType, int pageNumber) throws AxisFault {
        if (webappState.equalsIgnoreCase("started")) {
            return this.getPagedWebapps(pageNumber, this.getStartedWebapps(webappType, webappSearchString), webappType);
        }
        if (webappState.equalsIgnoreCase("stopped")) {
            return this.getPagedWebapps(pageNumber, this.getStoppedWebapps(webappType, webappSearchString), webappType);
        }
        if (webappState.equalsIgnoreCase("all")) {
            Map<String, VersionedWebappMetadata> startedWebapps = this.getStartedWebapps(webappType, webappSearchString);
            Map<String, VersionedWebappMetadata> stoppedWebapps = this.getStoppedWebapps(webappType, webappSearchString);
            ConcurrentHashMap<String, VersionedWebappMetadata> webapps = new ConcurrentHashMap<String, VersionedWebappMetadata>(startedWebapps);
            for (String versionGroup : stoppedWebapps.keySet()) {
                if (webapps.containsKey(versionGroup)) {
                    for (WebappMetadata webappMetadata : stoppedWebapps.get(versionGroup).getVersionGroups()) {
                        ((VersionedWebappMetadata)webapps.get(versionGroup)).addWebappVersion(webappMetadata);
                    }
                    continue;
                }
                webapps.put(versionGroup, stoppedWebapps.get(versionGroup));
            }
            return this.getPagedWebapps(pageNumber, webapps, webappType);
        }
        throw new AxisFault("Invalid webapp state: ", webappState);
    }

    public WebappMetadata getStartedWebapp(String webappFileName) {
        WebApplicationsHolder holder = this.getWebappsHolder();
        WebApplication webApplication = holder.getStartedWebapps().get(webappFileName);
        WebappMetadata webappMetadata = null;
        if (webApplication != null) {
            webappMetadata = this.getWebapp(webApplication);
            webappMetadata.setStarted(true);
        }
        return webappMetadata;
    }

    public WebappMetadata getStoppedWebapp(String webappFileName) {
        WebApplicationsHolder holder = this.getWebappsHolder();
        WebApplication webApplication = holder.getStoppedWebapps().get(webappFileName);
        WebappMetadata webappMetadata = null;
        if (webApplication != null) {
            webappMetadata = this.getWebapp(webApplication);
            webappMetadata.setStarted(false);
        }
        return webappMetadata;
    }

    private WebappMetadata getWebapp(WebApplication webApplication) {
        WebappMetadata webappMetadata = new WebappMetadata();
        String appContext = WebAppUtils.checkJaxApplication(webApplication);
        if (appContext == null) {
            appContext = "/";
        } else if (appContext.endsWith("/*")) {
            appContext = appContext.substring(0, appContext.indexOf("/*"));
        }
        webappMetadata.setDisplayName(webApplication.getDisplayName());
        webappMetadata.setContext(webApplication.getContextName());
        webappMetadata.setServletContext(appContext);
        webappMetadata.setLastModifiedTime(webApplication.getLastModifiedTime());
        webappMetadata.setWebappFile(webApplication.getWebappFile().getName());
        webappMetadata.setState(webApplication.getState());
        webappMetadata.setServiceListPath(webApplication.getServiceListPath());
        webappMetadata.setAppVersion(webApplication.getVersion());
        webappMetadata.setContextPath(webApplication.getContext().getPath());
        WebApplication.Statistics statistics = webApplication.getStatistics();
        WebappStatistics stats = new WebappStatistics();
        stats.setActiveSessions(statistics.getActiveSessions());
        stats.setAvgSessionLifetime(statistics.getAvgSessionLifetime());
        stats.setExpiredSessions(statistics.getExpiredSessions());
        stats.setMaxActiveSessions(statistics.getMaxActiveSessions());
        stats.setMaxSessionInactivityInterval(statistics.getMaxSessionInactivityInterval());
        stats.setMaxSessionLifetime(statistics.getMaxSessionLifetime());
        stats.setRejectedSessions(statistics.getRejectedSessions());
        webappMetadata.setStatistics(stats);
        webappMetadata.setWebappType((String)webApplication.getProperty("webappFilter"));
        return webappMetadata;
    }

    public WebappsWrapper getPagedFaultyWebappsSummary(String webappSearchString, String webappType, int pageNumber) throws AxisFault {
        return this.getPagedWebapps(pageNumber, this.getFaultyWebapps(webappSearchString), webappType);
    }

    private WebappsWrapper getPagedWebapps(int pageNumber, Map<String, VersionedWebappMetadata> webapps, String webappType) {
        ArrayList<VersionedWebappMetadata> webappsList = new ArrayList<VersionedWebappMetadata>(webapps.values());
        WebApplicationsHolder webappsHolder = this.getWebappsHolder();
        WebappsWrapper webappsWrapper = this.getWebappsWrapper(webappsHolder, webappsList, webappType);
        try {
            webappsWrapper.setHostName(NetworkUtils.getLocalHostname());
        }
        catch (SocketException e) {
            log.error((Object)"Error occurred while getting local hostname", (Throwable)e);
        }
        if (this.getConfigContext().getAxisConfiguration().getTransportIn("http") != null) {
            int httpProxyPort = CarbonUtils.getTransportProxyPort((ConfigurationContext)this.getConfigContext(), (String)"http");
            if (httpProxyPort != -1) {
                webappsWrapper.setHttpPort(httpProxyPort);
            } else {
                int httpPort = CarbonUtils.getTransportPort((ConfigurationContext)this.getConfigContext(), (String)"http");
                webappsWrapper.setHttpPort(httpPort);
            }
        }
        if (this.getConfigContext().getAxisConfiguration().getTransportIn("https") != null) {
            int httpsProxyPort = CarbonUtils.getTransportProxyPort((ConfigurationContext)this.getConfigContext(), (String)"https");
            if (httpsProxyPort != -1) {
                webappsWrapper.setHttpsPort(httpsProxyPort);
            } else {
                int httpsPort = CarbonUtils.getTransportPort((ConfigurationContext)this.getConfigContext(), (String)"https");
                webappsWrapper.setHttpsPort(httpsPort);
            }
        }
        this.sortWebapps(webappsList);
        DataPaginator.doPaging((int)pageNumber, webappsList, (Pageable)webappsWrapper);
        return webappsWrapper;
    }

    private void sortWebapps(List<VersionedWebappMetadata> webapps) {
        if (webapps.size() > 0) {
            Collections.sort(webapps, new Comparator<VersionedWebappMetadata>(){

                @Override
                public int compare(VersionedWebappMetadata arg0, VersionedWebappMetadata arg1) {
                    return arg0.getAppVersionRoot().compareToIgnoreCase(arg1.getAppVersionRoot());
                }
            });
        }
        for (VersionedWebappMetadata versionedWebappMetadata : webapps) {
            versionedWebappMetadata.sort();
        }
    }

    private Map<String, VersionedWebappMetadata> getStartedWebapps(String webappType, String webappSearchString) {
        return this.getWebapps(this.getWebappsHolder().getStartedWebapps().values(), webappType, webappSearchString);
    }

    private Map<String, VersionedWebappMetadata> getStoppedWebapps(String webappType, String webappSearchString) {
        return this.getWebapps(this.getWebappsHolder().getStoppedWebapps().values(), webappType, webappSearchString);
    }

    private Map<String, VersionedWebappMetadata> getWebapps(Collection<WebApplication> allWebapps, String webappType, String webappsSearchString) {
        ConcurrentHashMap<String, VersionedWebappMetadata> webapps = new ConcurrentHashMap<String, VersionedWebappMetadata>();
        for (WebApplication webapp : allWebapps) {
            VersionedWebappMetadata versionedWebappMetadata;
            if (!this.doesWebappSatisfySearchString(webapp, webappsSearchString) || !this.isWebappRelevant(webapp, webappType)) continue;
            WebappMetadata webappMetadata = this.getWebapp(webapp);
            WebappStatistics stats = webappMetadata.getStatistics();
            String appVersionRoot = webappMetadata.getContext();
            if (!"/default".equals(webapp.getVersion())) {
                appVersionRoot = appVersionRoot.substring(0, appVersionRoot.lastIndexOf(webappMetadata.getAppVersion()));
            }
            if (webapps.containsKey(appVersionRoot)) {
                versionedWebappMetadata = (VersionedWebappMetadata)webapps.get(appVersionRoot);
            } else {
                versionedWebappMetadata = new VersionedWebappMetadata(appVersionRoot);
                webapps.put(appVersionRoot, versionedWebappMetadata);
            }
            versionedWebappMetadata.addWebappVersion(webappMetadata);
        }
        return webapps;
    }

    private Map<String, VersionedWebappMetadata> getFaultyWebapps(String webappsSearchString) {
        WebApplicationsHolder webappsHolder = this.getWebappsHolder();
        if (webappsHolder == null) {
            return null;
        }
        String faultyAppVersionRoot = "/faulty";
        ConcurrentHashMap<String, VersionedWebappMetadata> webapps = new ConcurrentHashMap<String, VersionedWebappMetadata>();
        VersionedWebappMetadata versionedWebappMetadata = new VersionedWebappMetadata(faultyAppVersionRoot);
        webapps.put(faultyAppVersionRoot, versionedWebappMetadata);
        for (WebApplication webapp : webappsHolder.getFaultyWebapps().values()) {
            if (!this.doesWebappSatisfySearchString(webapp, webappsSearchString)) continue;
            WebappMetadata webappMetadata = new WebappMetadata();
            webappMetadata.setContext(webapp.getContextName());
            webappMetadata.setLastModifiedTime(webapp.getLastModifiedTime());
            webappMetadata.setWebappFile(webapp.getWebappFile().getName());
            webappMetadata.setStarted(false);
            webappMetadata.setRunning(false);
            webappMetadata.setFaulty(true);
            StringWriter sw = new StringWriter();
            webapp.getFaultReason().printStackTrace(new PrintWriter(sw));
            String faultException = sw.toString();
            webappMetadata.setFaultException(faultException);
            versionedWebappMetadata.addWebappVersion(webappMetadata);
        }
        return webapps;
    }

    protected boolean doesWebappSatisfySearchString(WebApplication webapp, String searchString) {
        if (searchString != null) {
            String regex = searchString.toLowerCase().replace("..?", ".?").replace("..*", ".*").replaceAll("\\?", ".?").replaceAll("\\*", ".*?");
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(webapp.getContextName().toLowerCase());
            return regex.trim().length() == 0 || matcher.find();
        }
        return false;
    }

    private WebApplicationsHolder getWebappsHolder() {
        return (WebApplicationsHolder)this.getConfigContext().getProperty("carbon.webapps.holder");
    }

    private WebappsWrapper getWebappsWrapper(WebApplicationsHolder webappsHolder, List<VersionedWebappMetadata> webapps, String webappType) {
        WebappsWrapper webappsWrapper = new WebappsWrapper();
        webappsWrapper.setWebapps(webapps.toArray(new VersionedWebappMetadata[webapps.size()]));
        webappsWrapper.setNumberOfCorrectWebapps(this.getNumberOfWebapps(webappsHolder.getStartedWebapps(), webappType));
        webappsWrapper.setNumberOfFaultyWebapps(this.getNumberOfWebapps(webappsHolder.getFaultyWebapps(), webappType));
        return webappsWrapper;
    }

    private int getNumberOfWebapps(Map<String, WebApplication> webappMap, String webappType) {
        int number = 0;
        for (Map.Entry<String, WebApplication> webappEntry : webappMap.entrySet()) {
            if (!this.isWebappRelevant(webappEntry.getValue(), webappType)) continue;
            ++number;
        }
        return number;
    }

    protected boolean isWebappRelevant(WebApplication webapp, String webappType) {
        if (webapp.getContextName().contains("STRATOS_ROOT")) {
            return false;
        }
        String filterProp = (String)webapp.getProperty("webappFilter");
        if ("all".equalsIgnoreCase(webappType)) {
            return true;
        }
        if ("jaxWebapp".equalsIgnoreCase(webappType)) {
            return filterProp != null && "jaxWebapp".equalsIgnoreCase(filterProp);
        }
        if ("jaggeryWebapp".equalsIgnoreCase(webappType)) {
            return filterProp != null && "jaggeryWebapp".equalsIgnoreCase(filterProp);
        }
        return filterProp == null || "webapp".equalsIgnoreCase(filterProp);
    }

    public void deleteStartedWebapps(String[] webappFileNames) throws AxisFault {
        this.deleteWebapps(webappFileNames, this.getWebappsHolder().getStartedWebapps());
    }

    public void deleteStoppedWebapps(String[] webappFileNames) throws AxisFault {
        this.deleteWebapps(webappFileNames, this.getWebappsHolder().getStoppedWebapps());
    }

    public void deleteFaultyWebapps(String[] webappFileNames) throws AxisFault {
        this.deleteWebapps(webappFileNames, this.getWebappsHolder().getFaultyWebapps());
    }

    public void deleteAllWebApps(String[] webappFileNames) throws AxisFault {
        for (String webappFileName : webappFileNames) {
            this.deleteWebapp(webappFileName);
        }
    }

    public void deleteWebapp(String webappFileName) throws AxisFault {
        WebApplicationsHolder holder = this.getWebappsHolder();
        if (holder.getStartedWebapps().get(webappFileName) != null) {
            this.deleteStartedWebapps(new String[]{webappFileName});
        } else if (holder.getStoppedWebapps().get(webappFileName) != null) {
            this.deleteStoppedWebapps(new String[]{webappFileName});
        } else if (holder.getFaultyWebapps().get(webappFileName) != null) {
            this.deleteFaultyWebapps(new String[]{webappFileName});
        }
    }

    private void deleteWebapps(String[] webappFileNames, Map<String, WebApplication> webapps) throws AxisFault {
        for (String webappFileName : webappFileNames) {
            WebApplication webapp = webapps.get(webappFileName);
            try {
                webapps.remove(webappFileName);
                webapp.delete();
            }
            catch (CarbonException e) {
                this.handleException("Could not delete webapp " + webapp, (Exception)((Object)e));
            }
        }
    }

    private void undeployWebapps(String[] webappFileNames, Map<String, WebApplication> webapps) throws AxisFault {
        for (String webappFileName : webappFileNames) {
            WebApplication webapp = webapps.get(webappFileName);
            try {
                webapp.undeploy();
                webapps.remove(webappFileName);
            }
            catch (CarbonException e) {
                this.handleException("Could not delete webapp " + webapp, (Exception)((Object)e));
            }
        }
    }

    public void deleteAllStartedWebapps() throws AxisFault {
        this.deleteAllWebapps(this.getWebappsHolder().getStartedWebapps());
    }

    public void deleteAllStoppedWebapps() throws AxisFault {
        this.deleteAllWebapps(this.getWebappsHolder().getStoppedWebapps());
    }

    public void deleteAllFaultyWebapps() throws AxisFault {
        this.deleteAllWebapps(this.getWebappsHolder().getFaultyWebapps());
    }

    private void deleteAllWebapps(Map<String, WebApplication> webapps) throws AxisFault {
        for (WebApplication webapp : webapps.values()) {
            try {
                webapp.delete();
            }
            catch (CarbonException e) {
                this.handleException("Could not delete started webapp " + webapp, (Exception)((Object)e));
            }
        }
        webapps.clear();
    }

    public void reloadAllWebapps() {
        Map<String, WebApplication> startedWebapps = this.getWebappsHolder().getStartedWebapps();
        String[] webappFileNames = (String[])Arrays.copyOf(startedWebapps.keySet().toArray(), startedWebapps.size(), String[].class);
        for (WebApplication webapp : startedWebapps.values()) {
            webapp.reload();
        }
        this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.RELOAD, webappFileNames);
    }

    public void reloadWebapps(String[] webappFileNames) {
        for (String webappFileName : webappFileNames) {
            this.getWebappsHolder().getStartedWebapps().get(webappFileName).reload();
        }
        this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.RELOAD, webappFileNames);
    }

    public void setBamConfiguration(String webappFileName, String value) {
        this.getWebappsHolder().getStartedWebapps().get(webappFileName).updateWebappMetaDataforBam(value);
    }

    public String getBamConfiguration(String webappFileName) {
        try {
            return this.getWebappsHolder().getStartedWebapps().get(webappFileName).getBamEnableFromWebappMetaData();
        }
        catch (Exception e) {
            log.error((Object)"Unable to read bam configurations", (Throwable)e);
            return null;
        }
    }

    public void stopAllWebapps() throws AxisFault {
        Map<String, WebApplication> startedWebapps = this.getWebappsHolder().getStartedWebapps();
        String[] webappFileNames = (String[])Arrays.copyOf(startedWebapps.keySet().toArray(), startedWebapps.size(), String[].class);
        for (WebApplication webapp : startedWebapps.values()) {
            try {
                webapp.stop();
            }
            catch (CarbonException e) {
                this.handleException("Error occurred while undeploying all webapps", (Exception)((Object)e));
            }
        }
        startedWebapps.clear();
        this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.STOP, webappFileNames);
    }

    public void stopWebapps(String[] webappFileNames) throws AxisFault {
        WebApplicationsHolder webappsHolder = this.getWebappsHolder();
        Map<String, WebApplication> startedWebapps = webappsHolder.getStartedWebapps();
        for (String webappFileName : webappFileNames) {
            try {
                WebApplication webApplication = startedWebapps.get(webappFileName);
                if (webApplication == null) continue;
                webappsHolder.stopWebapp(webApplication);
            }
            catch (CarbonException e) {
                this.handleException("Error occurred while undeploying webapps", (Exception)((Object)e));
            }
        }
        this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.STOP, webappFileNames);
    }

    public void startAllWebapps() throws AxisFault {
        Map<String, WebApplication> stoppedWebapps = this.getWebappsHolder().getStoppedWebapps();
        String[] webappFileNames = (String[])Arrays.copyOf(stoppedWebapps.keySet().toArray(), stoppedWebapps.size(), String[].class);
        Deployer webappDeployer = ((DeploymentEngine)this.getAxisConfig().getConfigurator()).getDeployer("webapps", "war");
        for (WebApplication webapp : stoppedWebapps.values()) {
            this.startWebapp(stoppedWebapps, webapp);
        }
        stoppedWebapps.clear();
        this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.START, webappFileNames);
    }

    public void startWebapps(String[] webappFileNames) throws AxisFault {
        WebApplicationsHolder webappsHolder = this.getWebappsHolder();
        Map<String, WebApplication> stoppedWebapps = webappsHolder.getStoppedWebapps();
        Deployer webappDeployer = ((DeploymentEngine)this.getAxisConfig().getConfigurator()).getDeployer("webapps", "war");
        for (String webappFileName : webappFileNames) {
            WebApplication webapp = stoppedWebapps.get(webappFileName);
            if (webapp == null) continue;
            this.startWebapp(stoppedWebapps, webapp);
        }
        this.sendClusterSyncMessage(WebappsConstants.ApplicationOpType.START, webappFileNames);
    }

    private void startWebapp(Map<String, WebApplication> stoppedWebapps, WebApplication webapp) throws AxisFault {
        try {
            boolean started = webapp.start();
            if (started) {
                String webappFileName = webapp.getWebappFile().getName();
                stoppedWebapps.remove(webappFileName);
                WebApplicationsHolder webappsHolder = this.getWebappsHolder();
                Map<String, WebApplication> startedWebapps = webappsHolder.getStartedWebapps();
                startedWebapps.put(webappFileName, webapp);
            }
        }
        catch (CarbonException e) {
            String msg = "Cannot start webapp " + webapp;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public SessionsWrapper getActiveSessions(String webappFileName, int pageNumber) {
        WebApplication webapp = this.getWebappsHolder().getStartedWebapps().get(webappFileName);
        ArrayList<SessionMetadata> sessionMetadataList = new ArrayList<SessionMetadata>();
        int numOfActiveSessions = 0;
        if (webapp != null) {
            List<WebApplication.HttpSession> sessions = webapp.getSessions();
            numOfActiveSessions = sessions.size();
            for (WebApplication.HttpSession session : sessions) {
                sessionMetadataList.add(new SessionMetadata(session));
            }
        }
        this.sortSessions(sessionMetadataList);
        SessionsWrapper sessionsWrapper = new SessionsWrapper(sessionMetadataList);
        DataPaginator.doPaging((int)pageNumber, sessionMetadataList, (Pageable)sessionsWrapper);
        sessionsWrapper.setWebappFileName(webappFileName);
        sessionsWrapper.setNumberOfActiveSessions(numOfActiveSessions);
        return sessionsWrapper;
    }

    private void sortSessions(List<SessionMetadata> sessions) {
        if (sessions.size() > 0) {
            Collections.sort(sessions, new Comparator<SessionMetadata>(){

                @Override
                public int compare(SessionMetadata arg0, SessionMetadata arg1) {
                    return (int)(arg0.getLastAccessedTime() - arg1.getLastAccessedTime());
                }
            });
        }
    }

    public void expireSessionsInAllWebapps() {
        Map<String, WebApplication> webapps = this.getWebappsHolder().getStartedWebapps();
        for (WebApplication webapp : webapps.values()) {
            webapp.expireAllSessions();
        }
    }

    public void expireSessionsInWebapps(String[] webappFileNames) {
        Map<String, WebApplication> webapps = this.getWebappsHolder().getStartedWebapps();
        for (String webappFileName : webappFileNames) {
            WebApplication webapp = webapps.get(webappFileName);
            webapp.expireAllSessions();
        }
    }

    public void expireSessionsInWebapp(String webappFileName, long maxSessionLifetimeMillis) {
        Map<String, WebApplication> webapps = this.getWebappsHolder().getStartedWebapps();
        WebApplication webapp = webapps.get(webappFileName);
        webapp.expireSessions(maxSessionLifetimeMillis);
    }

    public void expireSessions(String webappFileName, String[] sessionIDs) throws AxisFault {
        Map<String, WebApplication> webapps = this.getWebappsHolder().getStartedWebapps();
        WebApplication webapp = webapps.get(webappFileName);
        try {
            webapp.expireSessions(sessionIDs);
        }
        catch (CarbonException e) {
            this.handleException("Cannot expire specified sessions in webapp " + webappFileName, (Exception)((Object)e));
        }
    }

    public void expireAllSessions(String webappFileName) {
        Map<String, WebApplication> webapps = this.getWebappsHolder().getStartedWebapps();
        WebApplication webapp = webapps.get(webappFileName);
        webapp.expireAllSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadWebapp(WebappUploadData[] webappUploadDataList) throws AxisFault {
        AxisConfiguration axisConfig = this.getAxisConfig();
        File webappsDir = new File(this.getWebappDeploymentDirPath("webapp"));
        if (!webappsDir.exists() && !webappsDir.mkdirs()) {
            log.warn((Object)("Could not create directory " + webappsDir.getAbsolutePath()));
        }
        for (WebappUploadData uploadData : webappUploadDataList) {
            String fileName = uploadData.getFileName();
            String version = uploadData.getVersion();
            if (version != "" && version != null) {
                if (fileName.contains(".war")) {
                    fileName = fileName.replace(".war", "#" + version + ".war");
                } else if (fileName.contains(".zip")) {
                    fileName = fileName.replace(".zip", "#" + version + ".zip");
                }
            }
            if (WebAppUtils.validateWebappFileName(fileName)) {
                String msg = "Web app file name consists unsupported characters  - " + fileName;
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
            fileName = fileName.substring(fileName.lastIndexOf(System.getProperty("file.separator")) + 1);
            File destFile = new File(webappsDir, fileName);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(destFile);
                uploadData.getDataHandler().writeTo((OutputStream)fos);
            }
            catch (IOException e) {
                this.handleException("Error occured while uploading the webapp " + fileName, e);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.flush();
                        fos.close();
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Could not close file " + destFile.getAbsolutePath()));
                }
            }
        }
        return true;
    }

    protected String getWebappDeploymentDirPath(String webappType) {
        String webappDeploymentDir = "jaggeryWebapp".equalsIgnoreCase(webappType) ? "jaggeryapps" : "webapps";
        return this.getAxisConfig().getRepository().getPath() + File.separator + webappDeploymentDir;
    }

    protected String getWebappDeploymentFile(String fileName, String webappType) {
        WebApplicationsHolder webappsHolder = this.getWebappsHolder();
        File webappFile = webappsHolder.getStartedWebapps().get(fileName).getWebappFile();
        if (webappFile.getAbsolutePath().contains("carbonapps")) {
            return webappFile.getAbsolutePath();
        }
        String webappDeploymentDir = "jaggeryWebapp".equalsIgnoreCase(webappType) ? "jaggeryapps" : "webapps";
        return this.getAxisConfig().getRepository().getPath() + File.separator + webappDeploymentDir + File.separator + fileName;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataHandler downloadWarFileHandler(String fileName, String webappType) {
        String repoPath = this.getAxisConfig().getRepository().getPath();
        String appsPath = this.getWebappDeploymentFile(fileName, webappType);
        File webAppFile = new File(appsPath);
        DataHandler handler = null;
        if (webAppFile.isDirectory()) {
            String zipTo = "tmp" + File.separator + fileName + ".zip";
            File fDownload = new File(zipTo);
            ArchiveManipulator archiveManipulator = new ArchiveManipulator();
            WebappAdmin webappAdmin = this;
            synchronized (webappAdmin) {
                try {
                    archiveManipulator.archiveDir(zipTo, webAppFile.getAbsolutePath());
                    FileDataSource datasource = new FileDataSource(fDownload);
                    handler = new DataHandler((DataSource)datasource);
                }
                catch (IOException e) {
                    log.error((Object)"Error downloading WAR file.", (Throwable)e);
                }
            }
        }
        FileDataSource datasource = new FileDataSource(new File(appsPath));
        handler = new DataHandler((DataSource)datasource);
        return handler;
    }

    public boolean isUnpackWARs() {
        return TomcatUtil.checkUnpackWars();
    }

    private void sendClusterSyncMessage(WebappsConstants.ApplicationOpType applicationOpType, String[] webappFileNames) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        ClusteringAgent clusteringAgent = DataHolder.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
        if (clusteringAgent != null) {
            int numberOfRetries = 0;
            UUID messageId = UUID.randomUUID();
            ApplicationSynchronizeRequest request = new ApplicationSynchronizeRequest(tenantId, tenantDomain, messageId, applicationOpType, webappFileNames);
            while (numberOfRetries < 60) {
                try {
                    clusteringAgent.sendMessage((ClusteringMessage)request, true);
                    log.info((Object)("Sent [" + (Object)((Object)request) + "]"));
                    break;
                }
                catch (ClusteringFault e) {
                    if (++numberOfRetries < 60) {
                        log.warn((Object)("Could not send SynchronizeRepositoryRequest for tenant " + tenantId + ". Retry will be attempted in 2s. Request: " + (Object)((Object)request)), (Throwable)e);
                    } else {
                        log.error((Object)("Could not send SynchronizeRepositoryRequest for tenant " + tenantId + ". Several retries failed. Request:" + (Object)((Object)request)), (Throwable)e);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ignored) {}
                }
            }
        }
    }

    public void changeDefaultAppVersion(String appGroupName, String fileName) throws AxisFault, ArtifactMetadataException {
        String appGroup = "";
        String tenantDomain = CarbonContext.getCurrentContext().getTenantDomain();
        if ("carbon.super".equals(tenantDomain)) {
            appGroup = appGroupName.replace("/", "");
        } else {
            String[] parts = appGroupName.split("/");
            appGroup = parts[parts.length - 1];
        }
        if (appGroup != null && fileName != null && this.isDefaultVersionManagementEnabled()) {
            boolean proceed = false;
            boolean noCurrentDefaultApp = false;
            AxisConfiguration axisConfig = this.getAxisConfig();
            String webappsDirPath = this.getWebappDeploymentDirPath("webapp");
            if (new File(webappsDirPath).exists()) {
                proceed = true;
            }
            if (proceed) {
                String originalNameOfCurrentDefaultApp = this.getOriginalNameOfCurrentDefaultApp(appGroup);
                File currentAppFile = new File(webappsDirPath, appGroup.concat(".war"));
                File currentAppOriginalFile = new File(webappsDirPath, originalNameOfCurrentDefaultApp);
                if (currentAppFile.exists() && !currentAppOriginalFile.exists()) {
                    this.handleWebappMetaDetaFile(appGroup.concat(".war"), originalNameOfCurrentDefaultApp, 1);
                    proceed = currentAppFile.renameTo(currentAppOriginalFile);
                }
            }
            if (proceed) {
                File newAppOriginalFile = new File(webappsDirPath, fileName);
                File newAppFile = new File(webappsDirPath, appGroup.concat(".war"));
                if (newAppOriginalFile.exists() && !newAppFile.exists()) {
                    proceed = newAppOriginalFile.renameTo(newAppFile);
                    if (proceed && log.isWarnEnabled()) {
                        this.setOriginalNameOfCurrentDefaultApp(appGroup, fileName);
                        log.info((Object)(fileName + " is marked as new default version "));
                    } else if (log.isWarnEnabled()) {
                        log.info((Object)("Error occurred making " + fileName + " as the default version"));
                    }
                }
            }
            if (!proceed && log.isWarnEnabled()) {
                log.info((Object)("Error occurred making " + fileName + " as the default version"));
            }
        }
    }

    private void setOriginalNameOfCurrentDefaultApp(String appName, String fileName) throws AxisFault, ArtifactMetadataException {
        AppVersionGroupPersister.persistWebappGroupMetadata(appName, fileName, this.getAxisConfig());
    }

    private void handleWebappMetaDetaFile(String originalFileName, String newFileName, int handlingStrategy) {
        switch (handlingStrategy) {
            case 1: {
                WebApplicationsHolder holder = this.getWebappsHolder();
                WebApplication webApplication = holder.getStartedWebapps().get(originalFileName);
                webApplication.addParameter("keepWebappMetadataHistory", Boolean.TRUE.toString());
            }
        }
    }

    private String getOriginalNameOfCurrentDefaultApp(String appName) throws AxisFault, ArtifactMetadataException {
        String originalName = AppVersionGroupPersister.readWebappGroupMetadata(appName, this.getAxisConfig());
        if (originalName == null) {
            StringBuilder builder = new StringBuilder(appName);
            builder.append("#").append("0").append(".war");
            return builder.toString();
        }
        return originalName;
    }

    public boolean isDefaultVersionManagementEnabled() {
        return defaultVersionManagement == null ? Boolean.parseBoolean(System.getProperty("webapp.defaultversion")) : defaultVersionManagement;
    }
}

