/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.log;

import java.util.Stack;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class LogHostObject
extends ScriptableObject {
    public static final String LOG_LEVEL = "hostobject.log.loglevel";
    public static final String JAGGERY_INCLUDES_CALLSTACK = "jaggery.includes.callstack";
    private static final String HOSTOBJECT_NAME = "Log";
    private static final String ROOT_LOGGER = "JAGGERY";
    private static final String LOG_LEVEL_INFO = "info";
    private static final String LOG_LEVEL_WARN = "warn";
    private static final String LOG_LEVEL_DEBUG = "debug";
    private static final String LOG_LEVEL_ERROR = "error";
    private static final String LOG_LEVEL_FATAL = "fatal";
    private Logger logger;

    public String getClassName() {
        return HOSTOBJECT_NAME;
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        String loggerName;
        int argsCount = args.length;
        if (argsCount > 1) {
            HostObjectUtil.invalidNumberOfArgs((String)HOSTOBJECT_NAME, (String)HOSTOBJECT_NAME, (int)argsCount, (boolean)true);
        }
        JaggeryContext context = (JaggeryContext)RhinoEngine.getContextProperty((Object)"engine.jaggeryContext");
        if (argsCount == 1 && args[0] instanceof String) {
            loggerName = (String)args[0];
        } else {
            String requestString = (String)((Stack)context.getProperty(JAGGERY_INCLUDES_CALLSTACK)).peek();
            loggerName = ROOT_LOGGER + requestString.replace(".jag", ":jag").replace(".js", ":js").replace("/", ".");
        }
        LogHostObject logObj = new LogHostObject();
        logObj.logger = Logger.getLogger((String)loggerName);
        String logLevel = (String)context.getProperty(LOG_LEVEL);
        if (LOG_LEVEL_FATAL.equalsIgnoreCase(logLevel)) {
            logObj.logger.setLevel(Level.FATAL);
        } else if (LOG_LEVEL_WARN.equalsIgnoreCase(logLevel)) {
            logObj.logger.setLevel(Level.WARN);
        } else if (LOG_LEVEL_DEBUG.equalsIgnoreCase(logLevel)) {
            logObj.logger.setLevel(Level.DEBUG);
        } else if (LOG_LEVEL_ERROR.equalsIgnoreCase(logLevel)) {
            logObj.logger.setLevel(Level.ERROR);
        } else {
            logObj.logger.setLevel(Level.INFO);
        }
        return logObj;
    }

    public static void jsFunction_debug(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = LOG_LEVEL_DEBUG;
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)HOSTOBJECT_NAME, (String)functionName, (int)argsCount, (boolean)false);
        }
        LogHostObject logObj = (LogHostObject)thisObj;
        logObj.logger.debug((Object)HostObjectUtil.serializeObject((Object)args[0]));
    }

    public static void jsFunction_info(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = LOG_LEVEL_INFO;
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)HOSTOBJECT_NAME, (String)functionName, (int)argsCount, (boolean)false);
        }
        LogHostObject logObj = (LogHostObject)thisObj;
        logObj.logger.info((Object)HostObjectUtil.serializeObject((Object)args[0]));
    }

    public static void jsFunction_error(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = LOG_LEVEL_ERROR;
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)HOSTOBJECT_NAME, (String)functionName, (int)argsCount, (boolean)false);
        }
        LogHostObject logObj = (LogHostObject)thisObj;
        logObj.logger.error((Object)HostObjectUtil.serializeObject((Object)args[0]));
    }

    public static void jsFunction_warn(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = LOG_LEVEL_WARN;
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)HOSTOBJECT_NAME, (String)functionName, (int)argsCount, (boolean)false);
        }
        LogHostObject logObj = (LogHostObject)thisObj;
        logObj.logger.warn((Object)HostObjectUtil.serializeObject((Object)args[0]));
    }

    public static void jsFunction_fatal(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = LOG_LEVEL_FATAL;
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)HOSTOBJECT_NAME, (String)functionName, (int)argsCount, (boolean)false);
        }
        LogHostObject logObj = (LogHostObject)thisObj;
        logObj.logger.fatal((Object)HostObjectUtil.serializeObject((Object)args[0]));
    }

    public boolean jsFunction_isDebugEnabled() throws ScriptException {
        return this.logger.isDebugEnabled();
    }

    public boolean jsFunction_isTraceEnabled() throws ScriptException {
        return this.logger.isTraceEnabled();
    }
}

