/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.xslt;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.core.SolrConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerProvider {
    public static TransformerProvider instance = new TransformerProvider();
    private final TransformerFactory tFactory = TransformerFactory.newInstance();
    private String lastFilename;
    private Templates lastTemplates = null;
    private long cacheExpires = 0L;
    private static Logger log;

    private TransformerProvider() {
        log = LoggerFactory.getLogger((String)TransformerProvider.class.getName());
        log.warn("The TransformerProvider's simplistic XSLT caching mechanism is not appropriate for high load scenarios, unless a single XSLT transform is used and xsltCacheLifetimeSeconds is set to a sufficiently high value.");
    }

    public synchronized Transformer getTransformer(SolrConfig solrConfig, String filename, int cacheLifetimeSeconds) throws IOException {
        if (this.lastTemplates != null && filename.equals(this.lastFilename) && System.currentTimeMillis() < this.cacheExpires) {
            if (log.isDebugEnabled()) {
                log.debug("Using cached Templates:" + filename);
            }
        } else {
            this.lastTemplates = this.getTemplates(solrConfig.getResourceLoader(), filename, cacheLifetimeSeconds);
        }
        Transformer result = null;
        try {
            result = this.lastTemplates.newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            log.error(this.getClass().getName(), (Object)"getTransformer", (Object)tce);
            IOException ioe = new IOException("newTransformer fails ( " + this.lastFilename + ")");
            ioe.initCause(tce);
            throw ioe;
        }
        return result;
    }

    private Templates getTemplates(ResourceLoader loader, String filename, int cacheLifetimeSeconds) throws IOException {
        Templates result = null;
        this.lastFilename = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("compiling XSLT templates:" + filename);
            }
            InputStream xsltStream = loader.openResource("xslt/" + filename);
            result = this.tFactory.newTemplates(new StreamSource(xsltStream));
        }
        catch (Exception e) {
            log.error(this.getClass().getName(), (Object)"newTemplates", (Object)e);
            IOException ioe = new IOException("Unable to initialize Templates '" + filename + "'");
            ioe.initCause(e);
            throw ioe;
        }
        this.lastFilename = filename;
        this.lastTemplates = result;
        this.cacheExpires = System.currentTimeMillis() + (long)(cacheLifetimeSeconds * 1000);
        return result;
    }
}

