/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.rahas.EncryptedKeyToken;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rampart.RampartException;
import org.apache.rampart.policy.model.KerberosConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.security.WSParameterCallback;
import org.apache.ws.security.WSPasswordCallback;
import org.w3c.dom.Element;

public class TokenCallbackHandler
implements CallbackHandler {
    private TokenStorage store;
    private CallbackHandler handler;
    private String tokenIdentifier;
    private RampartConfig config;

    public TokenCallbackHandler(TokenStorage store, CallbackHandler handler) {
        this.store = store;
        this.handler = handler;
        this.tokenIdentifier = null;
    }

    public TokenCallbackHandler(TokenStorage store, CallbackHandler handler, RampartConfig config) {
        this.store = store;
        this.handler = handler;
        this.config = config;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                String id = pc.getIdentifer();
                if ((pc.getUsage() == 6 || pc.getUsage() == 7) && this.store != null) {
                    try {
                        Token tok = this.store.getToken(id);
                        if (tok == null) continue;
                        pc.setKey(tok.getSecret());
                        pc.setCustomToken((Element)tok.getToken());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                }
                if (pc.getUsage() == 8) {
                    try {
                        String[] tokenIdentifiers = this.store.getTokenIdentifiers();
                        for (int j = 0; j < tokenIdentifiers.length; ++j) {
                            Token tok = this.store.getToken(tokenIdentifiers[j]);
                            if (tok == null || tok.getToken() == null) continue;
                            String tokenNS = tok.getToken().getNamespace().getNamespaceURI();
                            if (tok instanceof EncryptedKeyToken && ((EncryptedKeyToken)tok).getSHA1().equals(id)) {
                                pc.setKey(tok.getSecret());
                                pc.setCustomToken((Element)tok.getToken());
                                this.tokenIdentifier = tokenIdentifiers[j];
                                continue;
                            }
                            if (!tokenNS.equals("urn:oasis:names:tc:SAML:1.0:assertion") && !tokenNS.equals("urn:oasis:names:tc:SAML:2.0:assertion") || !tok.getUnattachedReference().getFirstElement().getText().equals(id)) continue;
                            pc.setKey(tok.getSecret());
                            pc.setCustomToken((Element)tok.getToken());
                        }
                        continue;
                    }
                    catch (TrustException e) {
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                }
                if (this.handler == null) continue;
                this.handler.handle(new Callback[]{pc});
                continue;
            }
            if (callbacks[i] instanceof WSParameterCallback) {
                KerberosConfig krbConfig;
                WSParameterCallback para = (WSParameterCallback)callbacks[i];
                if (para.getProperty() == 0) {
                    if (this.config == null) continue;
                    krbConfig = this.config.getKerberosConfig();
                    int factor = 0;
                    String fac = null;
                    if (krbConfig != null && (fac = krbConfig.getProp().getProperty("kdc.des.aes.factor")) != null) {
                        try {
                            factor = Integer.parseInt(fac);
                        }
                        catch (Exception e) {
                            factor = 0;
                        }
                    }
                    para.setIntValue(factor);
                    continue;
                }
                if (para.getProperty() != 1 || this.config == null) continue;
                krbConfig = this.config.getKerberosConfig();
                String password = null;
                if (krbConfig == null || (password = krbConfig.getProp().getProperty("service.principal.password")) == null) continue;
                para.setStringValue(password);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    public void removeEncryptedToken() throws RampartException {
        try {
            if (this.tokenIdentifier != null) {
                this.store.removeToken(this.tokenIdentifier);
            }
        }
        catch (TrustException e) {
            throw new RampartException(e.getMessage(), e);
        }
    }
}

