/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.util.SAML2KeyInfo;
import org.apache.rahas.impl.util.SAML2Utils;
import org.apache.rampart.PolicyValidatorCallbackHandler;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.ServiceNonceCache;
import org.apache.rampart.TokenCallbackHandler;
import org.apache.rampart.ValidatorData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.KerberosTokenPrincipal;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.xml.XMLObject;

public class RampartEngine {
    private static Log log = LogFactory.getLog(RampartEngine.class);
    private static Log tlog = LogFactory.getLog((String)"org.apache.rampart.TIME");
    private static ServiceNonceCache serviceNonceCache = new ServiceNonceCache();

    public Vector process(MessageContext msgCtx) throws WSSPolicyException, RampartException, WSSecurityException, AxisFault {
        RampartConfig rampartConfig;
        String actorValue;
        boolean doDebug = log.isDebugEnabled();
        boolean dotDebug = tlog.isDebugEnabled();
        log.debug((Object)"Enter process(MessageContext msgCtx)");
        RampartMessageData rmd = new RampartMessageData(msgCtx, false);
        RampartPolicyData rpd = rmd.getPolicyData();
        if (log.isDebugEnabled() && rpd != null && rpd.getRampartConfig() != null && rpd.getRampartConfig().isOptimizeMessageProcessingForTransportBinding()) {
            log.debug((Object)"Optimized Message Processing enabled for transport binding.");
        }
        msgCtx.setProperty("rampartPolicyData", (Object)rpd);
        RampartUtil.validateTransport(rmd);
        if (rpd == null) {
            return null;
        }
        if (this.isSecurityFault(rmd) || !RampartUtil.isSecHeaderRequired(rpd, rmd.isInitiator(), true)) {
            SOAPEnvelope env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
            msgCtx.setEnvelope(env);
            Axis2Util.useDOOM(false);
            log.debug((Object)"Return process MessageContext msgCtx)");
            return null;
        }
        Vector results = null;
        WSSecurityEngine engine = new WSSecurityEngine();
        ValidatorData data = new ValidatorData(rmd);
        SOAPHeader header = rmd.getMsgContext().getEnvelope().getHeader();
        if (header == null) {
            throw new RampartException("missingSOAPHeader");
        }
        ArrayList headerBlocks = header.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SOAPHeaderBlock secHeader = null;
        if (headerBlocks != null) {
            for (SOAPHeaderBlock elem : headerBlocks) {
                if (!elem.getLocalName().equals("Security")) continue;
                secHeader = elem;
                break;
            }
        }
        if (secHeader == null) {
            throw new RampartException("missingSecurityHeader");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (dotDebug) {
            t0 = System.currentTimeMillis();
        }
        if ((actorValue = secHeader.getAttributeValue(new QName(rmd.getSoapConstants().getEnvelopeURI(), "actor"))) == null) {
            actorValue = secHeader.getAttributeValue(new QName(rmd.getSoapConstants().getEnvelopeURI(), "role"));
        }
        Crypto signatureCrypto = RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader());
        TokenCallbackHandler tokenCallbackHandler = null;
        tokenCallbackHandler = rpd != null ? new TokenCallbackHandler(rmd.getTokenStorage(), RampartUtil.getPasswordCB(rmd), rpd.getRampartConfig()) : new TokenCallbackHandler(rmd.getTokenStorage(), RampartUtil.getPasswordCB(rmd));
        if (rpd.isSymmetricBinding()) {
            log.debug((Object)"Processing security header using SymetricBinding");
            results = engine.processSecurityHeader(rmd.getDocument(), actorValue, (CallbackHandler)tokenCallbackHandler, signatureCrypto, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader()));
            if (rmd.isInitiator() && (msgCtx.getFLOW() == 1 || msgCtx.getFLOW() == 3)) {
                tokenCallbackHandler.removeEncryptedToken();
            }
        } else {
            log.debug((Object)"Processing security header in normal path");
            results = engine.processSecurityHeader(rmd.getDocument(), actorValue, (CallbackHandler)tokenCallbackHandler, signatureCrypto, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader()));
        }
        if (dotDebug) {
            t1 = System.currentTimeMillis();
        }
        for (int j = 0; j < results.size(); ++j) {
            String clientPricipalName;
            KerberosTokenPrincipal principal;
            WSSecurityEngineResult wser = (WSSecurityEngineResult)results.get(j);
            Integer actInt = (Integer)wser.get((Object)"action");
            if (8 == actInt) {
                Token token;
                TokenStorage store;
                Assertion assertion;
                if (wser.get((Object)"saml-assertion") instanceof Assertion) {
                    assertion = (Assertion)wser.get((Object)"saml-assertion");
                    Subject subject = assertion.getSubject();
                    if (subject != null && subject.getNameID() != null) {
                        msgCtx.setProperty("saml.subject.id", (Object)subject.getNameID().getValue());
                    }
                    if (TrustUtil.getSAML2SubjectConfirmationMethod((Assertion)assertion).equals("urn:oasis:names:tc:SAML:2.0:cm:bearer") || TrustUtil.getSAML2SubjectConfirmationMethod((Assertion)assertion).equals("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches")) break;
                    String id = assertion.getID();
                    Date dateOfCreation = null;
                    Date dateOfExpiration = null;
                    if (assertion.getConditions() != null) {
                        Conditions conditions = assertion.getConditions();
                        if (conditions.getNotBefore() != null) {
                            dateOfCreation = conditions.getNotBefore().toDate();
                        }
                        if (conditions.getNotOnOrAfter() != null) {
                            dateOfExpiration = conditions.getNotOnOrAfter().toDate();
                        }
                    } else {
                        SubjectConfirmationData scData = ((SubjectConfirmation)subject.getSubjectConfirmations().get(0)).getSubjectConfirmationData();
                        if (scData.getNotBefore() != null) {
                            dateOfCreation = scData.getNotBefore().toDate();
                        }
                        if (scData.getNotOnOrAfter() != null) {
                            dateOfExpiration = scData.getNotOnOrAfter().toDate();
                        }
                    }
                    SAML2KeyInfo saml2KeyInfo = SAML2Utils.getSAML2KeyInfo((Assertion)assertion, (Crypto)signatureCrypto, (CallbackHandler)tokenCallbackHandler);
                    try {
                        store = rmd.getTokenStorage();
                        if (store.getToken(id) != null) continue;
                        token = new Token(id, (OMElement)SAML2Utils.getElementFromAssertion((XMLObject)assertion), dateOfCreation, dateOfExpiration);
                        token.setSecret(saml2KeyInfo.getSecret());
                        store.add(token);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RampartException("errorInAddingTokenIntoStore", e);
                    }
                }
                assertion = (SAMLAssertion)wser.get((Object)"saml-assertion");
                Iterator iterator = assertion.getStatements();
                while (iterator.hasNext()) {
                    SAMLSubjectStatement samlSubjectStatement = (SAMLSubjectStatement)iterator.next();
                    SAMLSubject samlSubject = samlSubjectStatement.getSubject();
                    if (samlSubject == null || samlSubject.getNameIdentifier() == null) continue;
                    msgCtx.setProperty("saml.subject.id", (Object)samlSubject.getNameIdentifier().getName());
                }
                if ("urn:oasis:names:tc:SAML:1.0:cm:bearer".equals(TrustUtil.getSAML11SubjectConfirmationMethod((SAMLAssertion)assertion)) || "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches".equals(TrustUtil.getSAML11SubjectConfirmationMethod((SAMLAssertion)assertion))) break;
                String id = assertion.getId();
                Date created = assertion.getNotBefore();
                Date expires = assertion.getNotOnOrAfter();
                SAMLKeyInfo samlKi = SAMLUtil.getSAMLKeyInfo((SAMLAssertion)assertion, (Crypto)signatureCrypto, (CallbackHandler)tokenCallbackHandler);
                try {
                    store = rmd.getTokenStorage();
                    if (store.getToken(id) != null) continue;
                    token = new Token(id, (OMElement)assertion.toDOM(), created, expires);
                    token.setSecret(samlKi.getSecret());
                    store.add(token);
                    continue;
                }
                catch (Exception e) {
                    throw new RampartException("errorInAddingTokenIntoStore", e);
                }
            }
            if (1 == actInt) {
                String serviceEndpointName;
                boolean valueRepeating;
                WSUsernameTokenPrincipal userNameTokenPrincipal = (WSUsernameTokenPrincipal)wser.get((Object)"principal");
                String username = userNameTokenPrincipal.getName();
                msgCtx.setProperty("username", (Object)username);
                if (userNameTokenPrincipal.getNonce() == null) continue;
                int nonceLifeTimeInSeconds = 0;
                if (rpd.getRampartConfig() != null) {
                    String stringLifeTime = rpd.getRampartConfig().getNonceLifeTime();
                    try {
                        nonceLifeTimeInSeconds = Integer.parseInt(stringLifeTime);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)"Invalid value for nonceLifeTime in rampart configuration file.", (Throwable)e);
                        throw new RampartException("invalidNonceLifeTime", e);
                    }
                }
                if (valueRepeating = serviceNonceCache.isNonceRepeatingForService(serviceEndpointName = msgCtx.getAxisService().getEndpointName(), username, userNameTokenPrincipal.getNonce())) {
                    throw new RampartException("repeatingNonceValue", new Object[]{userNameTokenPrincipal.getNonce(), username});
                }
                serviceNonceCache.addNonceForService(serviceEndpointName, username, userNameTokenPrincipal.getNonce(), nonceLifeTimeInSeconds);
                continue;
            }
            if (2 == actInt) {
                X509Certificate cert = (X509Certificate)wser.get((Object)"x509-certificate");
                if (rpd.isAsymmetricBinding() && cert == null && rpd.getInitiatorToken() != null && !rpd.getInitiatorToken().isDerivedKeys()) {
                    throw new RampartException("invalidSignatureAlgo");
                }
                msgCtx.setProperty("X509Certificate", (Object)cert);
                continue;
            }
            if (4608 == actInt) {
                principal = null;
                principal = (KerberosTokenPrincipal)wser.get((Object)"principal");
                if (principal == null) continue;
                clientPricipalName = principal.getClientPrincipalName();
                String servicePricipalName = principal.getServicePrincipalName();
                if (clientPricipalName != null) {
                    msgCtx.getOptions().setProperty("client.principal.name", (Object)clientPricipalName);
                }
                if (servicePricipalName == null) continue;
                msgCtx.getOptions().setProperty("service.principal.name", (Object)servicePricipalName);
                continue;
            }
            if (5632 == actInt) {
                principal = null;
                principal = (KerberosTokenPrincipal)wser.get((Object)"principal");
                if (principal == null) continue;
                clientPricipalName = principal.getClientPrincipalName();
                String servicePricipalName = principal.getServicePrincipalName();
                if (clientPricipalName != null) {
                    msgCtx.getOptions().setProperty("client.principal.name", (Object)clientPricipalName);
                }
                if (servicePricipalName == null) continue;
                msgCtx.getOptions().setProperty("service.principal.name", (Object)servicePricipalName);
                continue;
            }
            if (5120 != actInt) continue;
            principal = null;
            principal = (KerberosTokenPrincipal)wser.get((Object)"principal");
            if (principal == null) continue;
            clientPricipalName = principal.getClientPrincipalName();
            String servicePricipalName = principal.getServicePrincipalName();
            if (clientPricipalName != null) {
                msgCtx.getOptions().setProperty("client.principal.name", (Object)clientPricipalName);
            }
            if (servicePricipalName == null) continue;
            msgCtx.getOptions().setProperty("service.principal.name", (Object)servicePricipalName);
        }
        if ((rampartConfig = rpd.getRampartConfig()) != null && !rampartConfig.isOptimizeMessageProcessingForTransportBinding()) {
            SOAPEnvelope env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
            msgCtx.setEnvelope(env);
        }
        if (dotDebug) {
            t2 = System.currentTimeMillis();
        }
        Axis2Util.useDOOM(false);
        PolicyValidatorCallbackHandler validator = RampartUtil.getPolicyValidatorCB(msgCtx, rpd);
        validator.validate(data, results);
        if (dotDebug) {
            t3 = System.currentTimeMillis();
            tlog.debug((Object)("processHeader by WSSecurityEngine took : " + (t1 - t0) + ", DOOM conversion took :" + (t2 - t1) + ", PolicyBasedResultsValidattor took " + (t3 - t2)));
        }
        log.debug((Object)"Return process(MessageContext msgCtx)");
        return results;
    }

    private boolean isSecurityFault(RampartMessageData rmd) {
        SOAPFaultValue faultSubCodeValue;
        SOAPFaultSubCode faultSubCode;
        SOAPEnvelope soapEnvelope = rmd.getMsgContext().getEnvelope();
        SOAPFault soapFault = soapEnvelope.getBody().getFault();
        if (soapFault == null) {
            return false;
        }
        String soapVersionURI = rmd.getMsgContext().getEnvelope().getNamespace().getNamespaceURI();
        SOAPFaultCode faultCode = soapFault.getCode();
        if (faultCode == null) {
            return false;
        }
        return soapVersionURI.equals("http://schemas.xmlsoap.org/soap/envelope/") ? faultCode.getTextAsQName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") : soapVersionURI.equals("http://www.w3.org/2003/05/soap-envelope") && (faultSubCode = faultCode.getSubCode()) != null && (faultSubCodeValue = faultSubCode.getValue()) != null && faultSubCodeValue.getTextAsQName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    }
}

