/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMDocumentImplUtil;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.CommentImpl;
import org.apache.axiom.om.impl.dom.DOMImplementationImpl;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.DocumentFragmentImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.ProcessingInstructionImpl;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.om.impl.dom.XMLChar;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends ParentNode
implements Document,
OMDocument {
    private String xmlVersion;
    private boolean xmlStandalone = false;
    private String charEncoding;
    private Vector idAttrs;
    protected ElementImpl documentElement;
    protected Hashtable identifiers;

    public DocumentImpl(DocumentImpl ownerDocument, OMFactory factory) {
        super(ownerDocument, factory);
        ((OMDOMFactory)factory).setDocument(this);
        this.done = true;
    }

    public DocumentImpl(OMXMLParserWrapper parserWrapper, OMFactory factory) {
        super(factory);
        this.builder = parserWrapper;
        ((OMDOMFactory)factory).setDocument(this);
    }

    public DocumentImpl(OMFactory factory) {
        super(factory);
        ((OMDOMFactory)factory).setDocument(this);
        this.done = true;
    }

    @Override
    public void setType(int nodeType) throws OMException {
        throw new UnsupportedOperationException("In OM Document object doesn't have a type");
    }

    @Override
    public int getType() throws OMException {
        throw new UnsupportedOperationException("In OM Document object doesn't have a type");
    }

    @Override
    public void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        this.internalSerialize(writer, cache, !((MTOMXMLStreamWriter)writer).isIgnoreXMLDeclaration());
    }

    @Override
    public OMNode getNextOMSibling() throws OMException {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public OMContainer getParent() throws OMException {
        throw new UnsupportedOperationException("This is the document node");
    }

    @Override
    public OMNode getPreviousOMSibling() {
        throw new UnsupportedOperationException("This is the document node");
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public void setNextOMSibling(OMNode node) {
        throw new UnsupportedOperationException("This is the document node");
    }

    @Override
    public void setParent(OMContainer element) {
        throw new UnsupportedOperationException("This is the document node");
    }

    @Override
    public void setPreviousOMSibling(OMNode node) {
        throw new UnsupportedOperationException("This is the document node");
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        if (!DOMUtil.isQualifiedName(name)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 5, null);
            throw new DOMException(5, msg);
        }
        return new AttrImpl(this, name, this.factory);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName = DOMUtil.getLocalName(qualifiedName);
        String prefix = DOMUtil.getPrefix(qualifiedName);
        if ("xmlns".equals(localName)) {
            return this.createAttribute(localName);
        }
        this.checkQName(prefix, localName);
        return new AttrImpl(this, localName, new NamespaceImpl(namespaceURI, prefix), this.factory);
    }

    @Override
    public CDATASection createCDATASection(String arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Comment createComment(String data) {
        return new CommentImpl(this, data, this.factory);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this, this.factory);
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        return new ElementImpl(this, tagName, this.factory);
    }

    @Override
    public Element createElementNS(String ns, String qualifiedName) throws DOMException {
        if (ns == null) {
            ns = "";
        }
        String localName = DOMUtil.getLocalName(qualifiedName);
        String prefix = DOMUtil.getPrefix(qualifiedName);
        if (prefix == null) {
            prefix = "";
        }
        if (!prefix.isEmpty()) {
            this.checkQName(prefix, localName);
        }
        NamespaceImpl namespace = new NamespaceImpl(ns, prefix);
        return new ElementImpl(this, localName, namespace, this.factory);
    }

    @Override
    public EntityReference createEntityReference(String arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return new ProcessingInstructionImpl(this, target, data, this.factory);
    }

    @Override
    public Text createTextNode(String value) {
        return new TextImpl(this, value, this.factory);
    }

    @Override
    public DocumentType getDoctype() {
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof DocumentType) {
                return (DocumentType)child;
            }
            if (!(child instanceof Element)) continue;
            return null;
        }
        return null;
    }

    @Override
    public Element getElementById(String elementId) {
        if (this.idAttrs == null) {
            return null;
        }
        Enumeration attrEnum = this.idAttrs.elements();
        while (attrEnum.hasMoreElements()) {
            Attr tempAttr = (Attr)attrEnum.nextElement();
            if (!tempAttr.getValue().equals(elementId)) continue;
            return tempAttr.getOwnerElement();
        }
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public NodeList getElementsByTagNameNS(String arg0, String arg1) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public DOMImplementation getImplementation() {
        return new DOMImplementationImpl();
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        short type = importedNode.getNodeType();
        Node newNode = null;
        switch (type) {
            case 1: {
                Element newElement;
                if (importedNode.getLocalName() == null) {
                    newElement = this.createElement(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newElement = this.createElementNS(ns, importedNode.getNodeName());
                }
                NamedNodeMap sourceAttrs = importedNode.getAttributes();
                if (sourceAttrs != null) {
                    int length = sourceAttrs.getLength();
                    for (int index = 0; index < length; ++index) {
                        Attr newAttr;
                        Attr attr = (Attr)sourceAttrs.item(index);
                        if (attr.getNamespaceURI() != null && !attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                            newAttr = (Attr)this.importNode(attr, true);
                            newElement.setAttributeNodeNS(newAttr);
                            continue;
                        }
                        newAttr = (Attr)this.importNode(attr, true);
                        newElement.setAttributeNode(newAttr);
                    }
                }
                newNode = newElement;
                break;
            }
            case 2: {
                if ("".equals(importedNode.getNamespaceURI()) || importedNode.getNamespaceURI() == null) {
                    newNode = this.createAttribute(importedNode.getNodeName());
                } else if ("xmlns".equals(importedNode.getNodeName())) {
                    newNode = this.createAttribute(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newNode = this.createAttributeNS(ns, importedNode.getNodeName());
                }
                ((Attr)newNode).setValue(importedNode.getNodeValue());
                break;
            }
            case 3: {
                newNode = this.createTextNode(importedNode.getNodeValue());
                break;
            }
            case 8: {
                newNode = this.createComment(importedNode.getNodeValue());
                break;
            }
            case 11: {
                newNode = this.createDocumentFragment();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                throw new UnsupportedOperationException("TODO : Implement handling of org.w3c.dom.Node type == " + type);
            }
            default: {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 9, null);
                throw new DOMException(9, msg);
            }
        }
        if (deep && !(importedNode instanceof Attr)) {
            for (Node srckid = importedNode.getFirstChild(); srckid != null; srckid = srckid.getNextSibling()) {
                newNode.appendChild(this.importNode(srckid, true));
            }
        }
        return newNode;
    }

    @Override
    public String getCharsetEncoding() {
        return this.charEncoding;
    }

    @Override
    public String getXMLVersion() {
        return this.xmlVersion;
    }

    @Override
    public String isStandalone() {
        return this.xmlStandalone ? "yes" : "no";
    }

    @Override
    public void setCharsetEncoding(String charsetEncoding) {
        this.charEncoding = charsetEncoding;
    }

    @Override
    public void setOMDocumentElement(OMElement rootElement) {
        this.firstChild = (ElementImpl)rootElement;
    }

    @Override
    public void setStandalone(String isStandalone) {
        this.xmlStandalone = "yes".equalsIgnoreCase(isStandalone);
    }

    @Override
    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerialize(writer, false);
        writer.flush();
    }

    @Override
    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerialize(writer, true);
        writer.flush();
    }

    @Override
    public void setXMLVersion(String version) {
        this.xmlVersion = version;
    }

    @Override
    public OMElement getOMDocumentElement() {
        while (this.documentElement == null && !this.done) {
            this.builder.next();
        }
        return this.documentElement;
    }

    @Override
    public Element getDocumentElement() {
        return (Element)((Object)this.getOMDocumentElement());
    }

    protected final void checkQName(String prefix, String local) {
        boolean validNCName;
        boolean bl = validNCName = (prefix == null || XMLChar.isValidNCName(prefix)) && XMLChar.isValidNCName(local);
        if (!validNCName) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 5, null);
            throw new DOMException(5, msg);
        }
        if (prefix == null || prefix.equals("")) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 14, null);
            throw new DOMException(14, msg);
        }
    }

    protected void addIdAttr(Attr attr) {
        if (this.idAttrs == null) {
            this.idAttrs = new Vector();
        }
        this.idAttrs.add(attr);
    }

    protected void removeIdAttr(Attr attr) {
        if (this.idAttrs != null) {
            this.idAttrs.remove(attr);
        }
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        return this.importNode(node, true);
    }

    @Override
    public String getDocumentURI() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public String getInputEncoding() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public String getXmlEncoding() {
        return this.charEncoding;
    }

    @Override
    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    @Override
    public String getXmlVersion() {
        return this.getXMLVersion();
    }

    @Override
    public void normalizeDocument() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Node renameNode(Node arg0, String arg1, String arg2) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void setDocumentURI(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void setStrictErrorChecking(boolean arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void setXmlStandalone(boolean standalone) throws DOMException {
        this.xmlStandalone = standalone;
    }

    @Override
    public void setXmlVersion(String version) throws DOMException {
        this.setXMLVersion(version);
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache, boolean includeXMLDeclaration) throws XMLStreamException {
        OMDocumentImplUtil.internalSerialize(this, writer, cache, includeXMLDeclaration);
    }
}

