/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.solr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.search.SolrQueryParser;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.solr.IndexDocument;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.SAXException;

public class SolrClient {
    public static final Log log = LogFactory.getLog(SolrClient.class);
    private static volatile SolrClient instance;
    private SolrServer server;

    protected SolrClient() throws IOException, ParserConfigurationException, SAXException {
        String[] filePaths;
        File solrHome = new File(CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "conf", "solr");
        if (!solrHome.exists() && !solrHome.mkdirs()) {
            throw new IOException("Solr Home Directory could not be created. Path: " + solrHome);
        }
        File confDir = new File(solrHome, "conf");
        if (!confDir.exists() && !confDir.mkdirs()) {
            throw new IOException("Solf conf directory could not be created! Path: " + confDir);
        }
        for (String path : filePaths = new String[]{"elevate.xml", "protwords.txt", "schema.xml", "scripts.conf", "solrconfig.xml", "spellings.txt", "stopwords.txt", "synonyms.txt"}) {
            InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(path);
            if (resourceAsStream == null) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can not find resource " + path + " from the classpath");
            }
            File file = new File(confDir, path);
            if (file.exists()) continue;
            this.write2File(resourceAsStream, file);
        }
        System.setProperty("solr.solr.home", solrHome.getPath());
        CoreContainer.Initializer initializer = new CoreContainer.Initializer();
        CoreContainer coreContainer = initializer.initialize();
        this.server = new EmbeddedSolrServer(coreContainer, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SolrClient getInstance() throws IndexerException {
        if (instance != null) return instance;
        Class<SolrClient> clazz = SolrClient.class;
        synchronized (SolrClient.class) {
            try {
                instance = new SolrClient();
            }
            catch (Exception e) {
                log.error((Object)"Could not instantiate Solr client", (Throwable)e);
                throw new IndexerException("Could not instantiate Solr client", e);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write2File(InputStream in, File file) throws IOException {
        byte[] buf = new byte[1024];
        FileOutputStream out = new FileOutputStream(file);
        try {
            int read;
            while ((read = in.read(buf)) >= 0) {
                out.write(buf, 0, read);
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    private String generateId(int tenantId, String path) {
        return path + "tenantId" + tenantId;
    }

    private void addDocument(IndexDocument indexDoc) throws SolrException {
        try {
            String path = indexDoc.getPath();
            String rawContent = indexDoc.getRawContent();
            String contentAsText = indexDoc.getContentAsText();
            int tenantId = indexDoc.getTenantId();
            Map<String, List<String>> fields = indexDoc.getFields();
            String id = this.generateId(tenantId, path);
            if (id == null) {
                id = "id" + rawContent.hashCode();
            }
            SolrInputDocument document = new SolrInputDocument();
            document.addField("id", (Object)id, 1.0f);
            document.addField("text", (Object)rawContent, 1.0f);
            document.addField("tenantId", (Object)String.valueOf(tenantId));
            if (contentAsText != null) {
                document.addField("contentOnly", (Object)contentAsText);
            }
            if (fields != null && fields.size() > 0) {
                for (Map.Entry<String, List<String>> e : fields.entrySet()) {
                    String key = e.getKey() + "_s";
                    if (e.getValue().size() == 1) {
                        document.addField(key, (Object)e.getValue().get(0));
                        continue;
                    }
                    if (e.getValue().size() <= 1) continue;
                    StringBuilder builder = new StringBuilder();
                    for (String s : e.getValue()) {
                        builder.append(s).append(",");
                    }
                    document.addField(key, (Object)builder.substring(0, builder.length() - 1));
                }
            }
            this.server.add(document);
            UpdateResponse response = this.server.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Indexed document " + id + " with " + response.getStatus()));
            }
        }
        catch (SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error at indexing", (Throwable)e);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error at indexing", (Throwable)e);
        }
    }

    public void indexDocument(AsyncIndexer.File2Index fileData, Indexer indexer) throws RegistryException {
        IndexDocument doc = indexer.getIndexedDocument(fileData);
        doc.setTenantId(fileData.tenantId);
        this.addDocument(doc);
    }

    public synchronized void deleteFromIndex(String path, int tenantId) throws SolrException {
        try {
            String id = this.generateId(tenantId, path);
            this.server.deleteById(id);
            this.server.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Delete the document " + id));
            }
        }
        catch (SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failure at deleting", (Throwable)e);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failure at deleting", (Throwable)e);
        }
    }

    public SolrDocumentList query(String keywords, int tenantId) throws SolrException {
        return this.query(keywords, tenantId, Collections.<String, String>emptyMap());
    }

    public SolrDocumentList query(int tenantId, Map<String, String> fields) throws SolrException {
        return this.query("[* TO *]", tenantId, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrDocumentList query(String keywords, int tenantId, Map<String, String> fields) throws SolrException {
        try {
            QueryResponse queryresponse;
            MessageContext messageContext;
            SolrQuery query = new SolrQuery(keywords);
            query.setRows(Integer.valueOf(Integer.MAX_VALUE));
            if (tenantId == -1234) {
                query.addFilterQuery(new String[]{"tenantId:\\" + tenantId});
            } else {
                query.addFilterQuery(new String[]{"tenantId:" + tenantId});
            }
            if (fields.size() > 0 && fields.get("mediaType").equals("application/policy+xml")) {
                query.addFilterQuery(new String[]{"id:/_system/governance*"});
            }
            if (fields.size() > 0) {
                for (Map.Entry<String, String> e : fields.entrySet()) {
                    query.addFilterQuery(new String[]{e.getKey() + "_s:" + SolrQueryParser.escape((String)e.getValue())});
                }
            }
            if ((messageContext = MessageContext.getCurrentMessageContext()) != null && PaginationUtils.isPaginationHeadersExist((MessageContext)messageContext)) {
                try {
                    PaginationContext paginationContext = PaginationUtils.initPaginationContext((MessageContext)messageContext);
                    String sortBy = paginationContext.getSortBy();
                    if (sortBy.length() > 0) {
                        query.setSortField(sortBy + "_s", paginationContext.getSortOrder().equals("ASC") ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
                    }
                    queryresponse = this.server.query((SolrParams)query);
                }
                finally {
                    PaginationContext.destroy();
                }
            } else {
                queryresponse = this.server.query((SolrParams)query);
            }
            return queryresponse.getResults();
        }
        catch (SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failure at query " + keywords, (Throwable)e);
        }
    }

    public void cleanAllDocuments() {
        try {
            QueryResponse results = this.server.query((SolrParams)new SolrQuery("ICWS"));
            SolrDocumentList resultsList = results.getResults();
            for (int i = 0; i < resultsList.size(); ++i) {
                String id = (String)((SolrDocument)resultsList.get(i)).getFieldValue("id");
                UpdateResponse deleteById = this.server.deleteById(id);
                this.server.commit();
                log.debug((Object)("Deleted ID " + id + " Status " + deleteById.getStatus()));
            }
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

