/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.service;

import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static RegistryService registryService;

    public static void setRegistryService(RegistryService service) {
        registryService = service;
    }

    public static Registry getRegistry() throws RegistryException {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext == null) {
            String msg = "Could not get the user's Registry session. Message context not found.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty("transport.http.servletRequest");
        Registry registry = (Registry)request.getSession().getAttribute("user_registry");
        if (registry == null) {
            String msg = "User's Registry instance is not found. Creating a anonymous Registry instance for the user.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            if (registryService == null) {
                msg = "Unable to create anonymous Registry instance for user. Registry Service was not found.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            registry = registryService.getUserRegistry();
            request.getSession().setAttribute("user_registry", (Object)registry);
        }
        return registry;
    }
}

