/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.oauth;

import org.scribe.builder.api.DefaultApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.utils.OAuthEncoder;
import org.scribe.utils.Preconditions;

public class GenericOAuth20Api
extends DefaultApi20 {
    private String AUTHORIZE_URL;
    private String ACCESS_TOKEN_EP;
    private String CALLBACK_URL;

    public void setAuthorizeUrl(String authorizeUrl) {
        this.AUTHORIZE_URL = authorizeUrl;
    }

    public void setAccessTokenEP(String accessTokenEP) {
        this.ACCESS_TOKEN_EP = accessTokenEP;
    }

    public String getAccessTokenEndpoint() {
        return this.ACCESS_TOKEN_EP;
    }

    public String getCallBackUrl() {
        return this.CALLBACK_URL;
    }

    public void setCallBackUrl(String cALLBACK_URL) {
        this.CALLBACK_URL = cALLBACK_URL;
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        Preconditions.checkValidUrl((String)this.getCallBackUrl(), (String)"Must provide a valid url as callback.");
        if (config.hasScope()) {
            return this.AUTHORIZE_URL + "?client_id=" + config.getApiKey() + "&response_type=code" + "&redirect_uri=" + OAuthEncoder.encode((String)this.getCallBackUrl()) + "&scope=" + OAuthEncoder.encode((String)config.getScope());
        }
        return this.AUTHORIZE_URL + "?client_id=" + config.getApiKey() + "&response_type=code" + "&redirect_uri=" + OAuthEncoder.encode((String)this.getCallBackUrl());
    }
}

