/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.common.eventing;

import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;

public class RegistryEvent<T> {
    public static final String TOPIC_SEPARATOR = "/";
    public static final String TOPIC_PREFIX = "/registry/notifications";
    public static final String REGISTRY_EVENT_NS = "http://wso2.org/ns/2011/01/eventing/registry/event";
    private String topic;
    private T message;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private int tenantId = -1;
    private String timestamp;
    private RegistrySession registrySessionDetails = new RegistrySession();
    private Context contextDetails = new Context();
    private Operation operationDetails = new Operation();
    private static Server serverDetails = new Server();

    public RegistryEvent() {
        this(null);
    }

    public RegistryEvent(T message) {
        this.message = message;
        Date date = new Date();
        this.timestamp = DATE_FORMAT.format(date);
        CarbonContext carbonContext = CarbonContext.getCurrentContext();
        this.contextDetails.setUsername(carbonContext.getUsername());
        this.contextDetails.setTenantId(carbonContext.getTenantId());
        this.registrySessionDetails.setChroot(CurrentSession.getChroot());
        this.registrySessionDetails.setUsername(CurrentSession.getUser());
        this.registrySessionDetails.setTenantId(CurrentSession.getTenantId());
    }

    public void setOperationDetails(String path, String eventType, ResourceType resourceType) {
        if (path != null) {
            this.operationDetails.setPath(path);
        } else {
            this.operationDetails.setPath("unknown");
        }
        this.operationDetails.setEventType(eventType);
        switch (resourceType) {
            case RESOURCE: {
                this.operationDetails.setResourceType("resource");
                break;
            }
            case COLLECTION: {
                this.operationDetails.setResourceType("collection");
                break;
            }
            default: {
                this.operationDetails.setResourceType("unknown");
            }
        }
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public RegistrySession getRegistrySessionDetails() {
        return this.registrySessionDetails;
    }

    public Context getContextDetails() {
        return this.contextDetails;
    }

    public Operation getOperationDetails() {
        return this.operationDetails;
    }

    public static Server getServerDetails() {
        return serverDetails;
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setTopic(String topic) {
        this.topic = !topic.startsWith(TOPIC_PREFIX) ? TOPIC_PREFIX + topic : topic;
    }

    public T getMessage() {
        return this.message;
    }

    public void setMessage(T message) {
        this.message = message;
    }

    public String getTopic() {
        return this.topic;
    }

    static {
        try {
            serverDetails.setHostIPAddress(NetworkUtils.getLocalHostname());
        }
        catch (SocketException ignored) {
            serverDetails.setHostIPAddress("unknown");
        }
        serverDetails.setProductName(CarbonUtils.getServerConfiguration().getFirstProperty("Name"));
        serverDetails.setProductVersion(CarbonUtils.getServerConfiguration().getFirstProperty("Version"));
        serverDetails.getJVMDetails().setJavaVersion(System.getProperty("java.version"));
        serverDetails.getJVMDetails().setJavaVMName(System.getProperty("java.vm.name"));
        serverDetails.getJVMDetails().setJavaVMVersion(System.getProperty("java.vm.version"));
        serverDetails.getJVMDetails().setJavaVendor(System.getProperty("java.vendor"));
        serverDetails.getOSUser().setUsername(System.getProperty("user.name"));
        serverDetails.getOSUser().setCountry(System.getProperty("user.country"));
        serverDetails.getOSUser().setLanguage(System.getProperty("user.language"));
        serverDetails.getOSUser().setTimezone(System.getProperty("user.timezone"));
        serverDetails.getOSDetails().setOperatingSystemName(System.getProperty("os.name"));
        serverDetails.getOSDetails().setOperatingSystemVersion(System.getProperty("os.version"));
        serverDetails.getOSDetails().setOperatingSystemArchitecture(System.getProperty("os.arch"));
    }

    public static final class Server {
        private String productName = null;
        private String productVersion = null;
        private String hostIPAddress = null;
        private OperatingSystem osDetails = new OperatingSystem();
        private OperatingSystemUser osUser = new OperatingSystemUser();
        private JVM jvmDetails = new JVM();

        public String getProductName() {
            return this.productName;
        }

        public void setProductName(String productName) {
            this.productName = productName;
        }

        public String getProductVersion() {
            return this.productVersion;
        }

        public void setProductVersion(String productVersion) {
            this.productVersion = productVersion;
        }

        public String getHostIPAddress() {
            return this.hostIPAddress;
        }

        public void setHostIPAddress(String hostIPAddress) {
            this.hostIPAddress = hostIPAddress;
        }

        public OperatingSystem getOSDetails() {
            return this.osDetails;
        }

        public OperatingSystemUser getOSUser() {
            return this.osUser;
        }

        public JVM getJVMDetails() {
            return this.jvmDetails;
        }

        public static final class OperatingSystemUser {
            private String username = null;
            private String language = null;
            private String country = null;
            private String timezone = null;

            public String getUsername() {
                return this.username;
            }

            public void setUsername(String username) {
                this.username = username;
            }

            public String getLanguage() {
                return this.language;
            }

            public void setLanguage(String language) {
                this.language = language;
            }

            public String getCountry() {
                return this.country;
            }

            public void setCountry(String country) {
                this.country = country;
            }

            public String getTimezone() {
                return this.timezone;
            }

            public void setTimezone(String timezone) {
                this.timezone = timezone;
            }
        }

        public static final class JVM {
            private String javaVersion = null;
            private String javaVMName = null;
            private String javaVMVersion = null;
            private String javaVendor = null;

            public String getJavaVersion() {
                return this.javaVersion;
            }

            public void setJavaVersion(String javaVersion) {
                this.javaVersion = javaVersion;
            }

            public String getJavaVMName() {
                return this.javaVMName;
            }

            public void setJavaVMName(String javaVMName) {
                this.javaVMName = javaVMName;
            }

            public String getJavaVMVersion() {
                return this.javaVMVersion;
            }

            public void setJavaVMVersion(String javaVMVersion) {
                this.javaVMVersion = javaVMVersion;
            }

            public String getJavaVendor() {
                return this.javaVendor;
            }

            public void setJavaVendor(String javaVendor) {
                this.javaVendor = javaVendor;
            }
        }

        public static final class OperatingSystem {
            private String operatingSystemName = null;
            private String operatingSystemVersion = null;
            private String operatingSystemArchitecture = null;

            public String getOperatingSystemName() {
                return this.operatingSystemName;
            }

            public void setOperatingSystemName(String operatingSystemName) {
                this.operatingSystemName = operatingSystemName;
            }

            public String getOperatingSystemVersion() {
                return this.operatingSystemVersion;
            }

            public void setOperatingSystemVersion(String operatingSystemVersion) {
                this.operatingSystemVersion = operatingSystemVersion;
            }

            public String getOperatingSystemArchitecture() {
                return this.operatingSystemArchitecture;
            }

            public void setOperatingSystemArchitecture(String operatingSystemArchitecture) {
                this.operatingSystemArchitecture = operatingSystemArchitecture;
            }
        }
    }

    public static final class Operation {
        private String path = null;
        private String eventType = null;
        private String resourceType = null;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getEventType() {
            return this.eventType;
        }

        public void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }
    }

    public static final class Context {
        private String username = null;
        private int tenantId = -1;

        public int getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(int tenantId) {
            this.tenantId = tenantId;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }

    public static final class RegistrySession {
        private String username = null;
        private int tenantId = -1;
        private String chroot;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public int getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(int tenantId) {
            this.tenantId = tenantId;
        }

        public String getChroot() {
            return this.chroot;
        }

        public void setChroot(String chroot) {
            this.chroot = chroot;
        }
    }

    public static enum ResourceType {
        COLLECTION,
        RESOURCE,
        UNKNOWN;

    }
}

