/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.lang.management.ManagementPermission;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.JavaUtils;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.core.StandardContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataException;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataManager;
import org.wso2.carbon.core.persistence.metadata.ArtifactType;
import org.wso2.carbon.core.persistence.metadata.DeploymentArtifactMetadataFactory;
import org.wso2.carbon.core.session.CarbonTomcatClusterableSessionManager;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.tomcat.ext.utils.URLMappingHolder;
import org.wso2.carbon.webapp.mgt.CarbonTomcatSessionManager;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatUtil;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;
import org.wso2.carbon.webapp.mgt.WebappsConstants;

public class TomcatGenericWebappsDeployer {
    private static Log log = LogFactory.getLog(TomcatGenericWebappsDeployer.class);
    protected String webContextPrefix;
    protected int tenantId;
    protected String tenantDomain;
    protected ConfigurationContext configurationContext;
    protected WebApplicationsHolder webappsHolder;
    protected Map<String, CarbonTomcatClusterableSessionManager> sessionManagerMap = new ConcurrentHashMap<String, CarbonTomcatClusterableSessionManager>();

    public TomcatGenericWebappsDeployer(String webContextPrefix, int tenantId, String tenantDomain, WebApplicationsHolder webappsHolder, ConfigurationContext configurationContext) {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.webContextPrefix = webContextPrefix;
        this.webappsHolder = webappsHolder;
        this.configurationContext = configurationContext;
    }

    public void deploy(File webappFile, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String webappName = webappFile.getName();
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        if (webappFile.isDirectory()) {
            privilegedCarbonContext.setApplicationName(webappName);
        } else if (webappName.contains(".war") || webappName.contains(".zip")) {
            privilegedCarbonContext.setApplicationName(webappName.substring(0, webappName.indexOf(".war")));
        }
        long lastModifiedTime = webappFile.lastModified();
        WebApplication deployedWebapp = this.webappsHolder.getStartedWebapps().get(webappFile.getName());
        WebApplication undeployedWebapp = this.webappsHolder.getStoppedWebapps().get(webappFile.getName());
        WebApplication faultyWebapp = this.webappsHolder.getFaultyWebapps().get(webappFile.getName());
        if (deployedWebapp == null && faultyWebapp == null && undeployedWebapp == null) {
            this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
        } else if (deployedWebapp != null && deployedWebapp.getLastModifiedTime() != lastModifiedTime) {
            this.handleHotUpdate(deployedWebapp, webContextParams, applicationEventListeners);
        } else if (faultyWebapp != null && faultyWebapp.getLastModifiedTime() != lastModifiedTime) {
            this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
        }
    }

    protected void handleHotDeployment(File webapp, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webapp.getName();
        if (webapp.isDirectory()) {
            this.handleExplodedWebappDeployment(webapp, webContextParams, applicationEventListeners);
        } else if (filename.endsWith(".war")) {
            this.handleWarWebappDeployment(webapp, webContextParams, applicationEventListeners);
        } else if (filename.endsWith(".zip")) {
            this.handleZipWebappDeployment(webapp, webContextParams, applicationEventListeners);
        }
    }

    protected void handleWarWebappDeployment(File webappWAR, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webappWAR.getName();
        String warContext = "";
        if (filename.equals("ROOT.war")) {
            if (this.webContextPrefix != null && !this.webContextPrefix.endsWith("/")) {
                warContext = "/";
            }
        } else {
            warContext = filename.substring(0, filename.indexOf(".war"));
        }
        if (!warContext.equals("/") && this.webContextPrefix.length() == 0) {
            this.webContextPrefix = "/";
        }
        String contextPath = this.handleAppVersion(this.webContextPrefix + warContext);
        this.handleWebappDeployment(webappWAR, contextPath, webContextParams, applicationEventListeners);
    }

    protected void handleZipWebappDeployment(File webapp, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
    }

    protected void handleExplodedWebappDeployment(File webappDir, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webappDir.getName();
        String warContext = "";
        if (filename.equals("ROOT")) {
            if (this.webContextPrefix != null && !this.webContextPrefix.endsWith("/")) {
                warContext = "/";
            }
        } else {
            warContext = filename;
        }
        if (!warContext.equals("/") && this.webContextPrefix.length() == 0) {
            this.webContextPrefix = "/";
        }
        String contextPath = this.handleAppVersion(this.webContextPrefix + warContext);
        this.handleWebappDeployment(webappDir, contextPath, webContextParams, applicationEventListeners);
    }

    protected void handleWebappDeployment(File webappFile, String contextStr, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webappFile.getName();
        try {
            Context context = DataHolder.getCarbonTomcatService().addWebApp(contextStr, webappFile.getAbsolutePath());
            if (DataHolder.getHotUpdateService() != null) {
                List hostNames = DataHolder.getHotUpdateService().getMappigsPerWebapp(contextStr);
                for (String hostName : hostNames) {
                    CarbonTomcatService carbonTomcatService = DataHolder.getCarbonTomcatService();
                    Host host = DataHolder.getHotUpdateService().addHost(hostName);
                    URLMappingHolder.getInstance().putUrlMappingForApplication(hostName, contextStr);
                    Context contextForHost = DataHolder.getCarbonTomcatService().addWebApp(host, "/", webappFile.getAbsolutePath());
                    log.info((Object)("Deployed webapp on host: " + contextForHost));
                }
            }
            if (context.getDistributable() && DataHolder.getCarbonTomcatService().getTomcat().getService().getContainer().getCluster() != null) {
                CarbonTomcatClusterableSessionManager sessionManager = new CarbonTomcatClusterableSessionManager(this.tenantId);
                context.setManager((Manager)sessionManager);
                this.sessionManagerMap.put(context.getName(), sessionManager);
                this.configurationContext.setProperty("CarbonTomcatSessionManagerMap", this.sessionManagerMap);
            } else {
                context.setManager((Manager)new CarbonTomcatSessionManager(this.tenantId));
            }
            context.setReloadable(false);
            WebApplication webapp = new WebApplication(this, context, webappFile);
            webapp.setServletContextParameters(webContextParams);
            String bamEnable = this.recievePersistedWebappMetaData(webappFile.getName(), "enable.statistics");
            if ((bamEnable == null || "".equals(bamEnable)) && ((bamEnable = context.findParameter("enable.statistics")) == null || "".equals(bamEnable))) {
                bamEnable = "false";
            }
            webapp.addParameter("enable.statistics", bamEnable);
            webapp.setState("Started");
            this.webappsHolder.getStartedWebapps().put(filename, webapp);
            this.webappsHolder.getFaultyWebapps().remove(filename);
            this.registerApplicationEventListeners(applicationEventListeners, context);
            log.info((Object)("Deployed webapp: " + webapp));
        }
        catch (Throwable e) {
            StandardContext context = new StandardContext();
            context.setName(webappFile.getName());
            context.addParameter("faulty.webapp", "true");
            WebApplication webapp = new WebApplication(this, (Context)context, webappFile);
            String msg = "Error while deploying webapp: " + webapp;
            log.error((Object)msg, e);
            webapp.setFaultReason(new Exception(msg, e));
            this.webappsHolder.getFaultyWebapps().put(filename, webapp);
            this.webappsHolder.getStartedWebapps().remove(filename);
            throw new CarbonException(msg, e);
        }
    }

    private void registerApplicationEventListeners(List<Object> applicationEventListeners, Context context) {
        Object[] originalEventListeners = context.getApplicationEventListeners();
        Object[] newEventListeners = new Object[originalEventListeners.length + applicationEventListeners.size()];
        if (originalEventListeners.length != 0) {
            System.arraycopy(originalEventListeners, 0, newEventListeners, 0, originalEventListeners.length);
            int i = originalEventListeners.length;
            for (Object eventListener : applicationEventListeners) {
                newEventListeners[i++] = eventListener;
            }
        } else {
            newEventListeners = applicationEventListeners.toArray(new Object[applicationEventListeners.size()]);
        }
        context.setApplicationEventListeners(newEventListeners);
    }

    protected void handleHotUpdate(WebApplication webApplication, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        File webappFile = webApplication.getWebappFile();
        if (webappFile.isDirectory()) {
            webApplication.reload();
            webApplication.setServletContextParameters(webContextParams);
            webApplication.setLastModifiedTime(webappFile.lastModified());
        } else {
            this.undeploy(webApplication);
            this.handleWarWebappDeployment(webappFile, webContextParams, applicationEventListeners);
        }
        log.info((Object)("Redeployed webapp: " + webApplication));
    }

    public void undeploy(File webappFile) throws CarbonException {
        Map<String, WebApplication> deployedWebapps = this.webappsHolder.getStartedWebapps();
        Map<String, WebApplication> stoppedWebapps = this.webappsHolder.getStoppedWebapps();
        String fileName = webappFile.getName();
        this.removeMetadata(fileName);
        if (deployedWebapps.containsKey(fileName)) {
            this.undeploy(deployedWebapps.get(fileName));
        }
        if (!fileName.endsWith(".war")) {
            String warFileName = fileName.concat(".war");
            if (deployedWebapps.containsKey(warFileName)) {
                this.undeploy(deployedWebapps.get(warFileName));
            }
        } else if (stoppedWebapps.containsKey(fileName)) {
            this.undeploy(stoppedWebapps.get(fileName));
        }
        this.clearFaultyWebapp(fileName);
    }

    public void lazyUnload(File webappFile) throws CarbonException {
        String fileName;
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        Map<String, WebApplication> deployedWebapps = this.webappsHolder.getStartedWebapps();
        if (deployedWebapps.containsKey(fileName = webappFile.getName())) {
            WebApplication deployWebapp = deployedWebapps.get(fileName);
            Context context = deployWebapp.getContext();
            privilegedCarbonContext.setApplicationName(TomcatUtil.getApplicationNameFromContext(context.getBaseName()));
            deployWebapp.lazyUnload();
        }
        this.clearFaultyWebapp(fileName);
    }

    private void clearFaultyWebapp(String fileName) {
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        Map<String, WebApplication> faultyWebapps = this.webappsHolder.getFaultyWebapps();
        if (faultyWebapps.containsKey(fileName)) {
            WebApplication faultyWebapp = faultyWebapps.get(fileName);
            Context context = faultyWebapp.getContext();
            privilegedCarbonContext.setApplicationName(TomcatUtil.getApplicationNameFromContext(context.getBaseName()));
            faultyWebapps.remove(fileName);
            log.info((Object)("Removed faulty webapp " + faultyWebapp));
        }
    }

    protected String recievePersistedWebappMetaData(String artifactName, String propertyName) throws AxisFault, ArtifactMetadataException {
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        ArtifactType type = new ArtifactType("webapp", WebappsConstants.WEBAPP_METADATA_DIR);
        ArtifactMetadataManager manager = DeploymentArtifactMetadataFactory.getInstance((AxisConfiguration)axisConfig).getMetadataManager();
        return manager.loadParameter(artifactName, type, propertyName);
    }

    protected void setPersistedWebappMetaData(String artifactName, String propertyName, String value) throws AxisFault, ArtifactMetadataException {
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        ArtifactType type = new ArtifactType("webapp", WebappsConstants.WEBAPP_METADATA_DIR);
        ArtifactMetadataManager manager = DeploymentArtifactMetadataFactory.getInstance((AxisConfiguration)axisConfig).getMetadataManager();
        manager.setParameter(artifactName, type, propertyName, value, true);
    }

    private void removeMetadata(String artifactFileName) throws CarbonException {
        try {
            Map<String, WebApplication> deployedWebapps = this.webappsHolder.getStartedWebapps();
            Map<String, WebApplication> stoppedWebapps = this.webappsHolder.getStoppedWebapps();
            String keepMetadataHistory = null;
            if (deployedWebapps.containsKey(artifactFileName)) {
                keepMetadataHistory = deployedWebapps.get(artifactFileName).findParameter("keepWebappMetadataHistory");
            }
            if (keepMetadataHistory == null && stoppedWebapps.containsKey(artifactFileName)) {
                keepMetadataHistory = stoppedWebapps.get(artifactFileName).findParameter("keepWebappMetadataHistory");
            }
            if (!JavaUtils.isFalse(keepMetadataHistory)) {
                return;
            }
            AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
            ArtifactType type = new ArtifactType("webapp", WebappsConstants.WEBAPP_METADATA_DIR);
            ArtifactMetadataManager manager = DeploymentArtifactMetadataFactory.getInstance((AxisConfiguration)axisConfig).getMetadataManager();
            manager.deleteMetafile(artifactFileName, type);
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
    }

    private void undeploy(WebApplication webapp) throws CarbonException {
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        Context context = webapp.getContext();
        privilegedCarbonContext.setApplicationName(TomcatUtil.getApplicationNameFromContext(context.getBaseName()));
        this.webappsHolder.undeployWebapp(webapp);
        log.info((Object)("Undeployed webapp: " + webapp));
    }

    protected String handleAppVersion(String warContext) {
        String path = warContext;
        int versionIndex = path.indexOf("##");
        String version = null;
        if (versionIndex > -1) {
            version = path.substring(versionIndex + 2);
            path = path.substring(0, versionIndex);
        }
        if (path.contains("#")) {
            path = path.replaceAll("#", "/");
        }
        if (version != null) {
            return path + "##" + version;
        }
        return path;
    }

    private boolean isUnpackedDirExists(String warPath) {
        File dir = new File(warPath.replace(".war", ""));
        return dir.exists() && dir.isDirectory();
    }
}

