/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.loader;

import org.apache.catalina.loader.WebappClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.webapp.mgt.loader.WebappClassloadingContext;

public class CarbonWebappClassLoader
extends WebappClassLoader {
    private static final Log log = LogFactory.getLog(CarbonWebappClassLoader.class);
    private WebappClassloadingContext webappCC;

    public CarbonWebappClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void setWebappCC(WebappClassloadingContext classloadingContext) {
        this.webappCC = classloadingContext;
    }

    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int i;
        Class<?> clazz;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadClass(" + name + ", " + resolve + ")"));
        }
        if (!this.started) {
            try {
                throw new IllegalStateException();
            }
            catch (IllegalStateException e) {
                log.info((Object)sm.getString("webappClassLoader.stopped", new Object[]{name}), (Throwable)e);
            }
        }
        if ((clazz = this.findLoadedClass0(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        try {
            clazz = this.system.loadClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                log.info((Object)error, (Throwable)se);
                throw new ClassNotFoundException(error, se);
            }
        }
        boolean delegatedPkg = this.webappCC.isDelegatedPackage(name);
        boolean excludedPkg = this.webappCC.isExcludedPackage(name);
        if (this.webappCC.isParentFirst() && delegatedPkg && !excludedPkg && (clazz = this.findClassFromParent(name, resolve)) != null) {
            return clazz;
        }
        clazz = this.findLocalClass(name, resolve);
        if (clazz != null) {
            return clazz;
        }
        if (!this.webappCC.isParentFirst() && delegatedPkg && !excludedPkg && (clazz = this.findClassFromParent(name, resolve)) != null) {
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    protected Class<?> findClassFromParent(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader loader;
        Class<?> clazz = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Delegating to parent classloader1 " + this.parent));
        }
        if ((loader = this.parent) == null) {
            loader = this.system;
        }
        try {
            clazz = Class.forName(name, false, loader);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Loading class from parent");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return clazz;
    }

    protected Class<?> findLocalClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return clazz;
    }
}

