/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.internal;

import java.util.ArrayList;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.ArtifactUnloader;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.tomcat.ext.valves.CarbonTomcatValve;
import org.wso2.carbon.tomcat.ext.valves.TomcatValveContainer;
import org.wso2.carbon.url.mapper.UrlMapperValve;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.deployment.GhostMetaArtifactsLoader;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.GhostWebappDeployerValve;
import org.wso2.carbon.webapp.mgt.TenantLazyLoaderValve;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;
import org.wso2.carbon.webapp.mgt.multitenancy.GhostWebappMetaArtifactsLoader;
import org.wso2.carbon.webapp.mgt.multitenancy.WebappUnloader;

public class WebappManagementServiceComponent {
    private static final Log log = LogFactory.getLog(WebappManagementServiceComponent.class);

    protected void activate(ComponentContext ctx) {
        try {
            ArrayList<Object> valves = new ArrayList<Object>();
            valves.add(new TenantLazyLoaderValve());
            if (GhostDeployerUtils.isGhostOn()) {
                valves.add(new GhostWebappDeployerValve());
                WebappUnloader webappUnloader = new WebappUnloader();
                ctx.getBundleContext().registerService(ArtifactUnloader.class.getName(), (Object)webappUnloader, null);
                GhostWebappMetaArtifactsLoader artifactsLoader = new GhostWebappMetaArtifactsLoader();
                ctx.getBundleContext().registerService(GhostMetaArtifactsLoader.class.getName(), (Object)artifactsLoader, null);
            } else {
                this.setServerURLParam(DataHolder.getServerConfigContext());
            }
            if (DataHolder.getHotUpdateService() != null && TomcatValveContainer.isValveExits((CarbonTomcatValve)new UrlMapperValve())) {
                TomcatValveContainer.addValves((int)0, valves);
            } else {
                TomcatValveContainer.addValves(valves);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while activating WebappManagementServiceComponent", e);
        }
    }

    protected void deactivate(ComponentContext ctx) {
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        DataHolder.setServerConfigContext(contextService.getServerConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        DataHolder.setServerConfigContext(null);
    }

    protected void setRealmService(RealmService realmService) {
        DataHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
    }

    protected void setRegistryService(RegistryService registryService) {
    }

    protected void unsetRegistryService(RegistryService registryService) {
    }

    protected void setDeploymentSynchronizerService(DeploymentSynchronizer depSynchService) {
        DataHolder.setDeploymentSynchronizerService(depSynchService);
    }

    protected void unsetDeploymentSynchronizerService(DeploymentSynchronizer depSynchService) {
        DataHolder.setDeploymentSynchronizerService(null);
    }

    private void setServerURLParam(ConfigurationContext configurationContext) {
        WebApplicationsHolder webApplicationsHolder = (WebApplicationsHolder)configurationContext.getProperty("carbon.webapps.holder");
        WebContextParameter serverUrlParam = new WebContextParameter("webServiceServerURL", CarbonUtils.getServerURL((ServerConfigurationService)ServerConfiguration.getInstance(), (ConfigurationContext)configurationContext));
        ArrayList servletContextParameters = (ArrayList)configurationContext.getProperty("servlet.context.parameters.list");
        if (servletContextParameters != null) {
            servletContextParameters.add(serverUrlParam);
        }
        if (webApplicationsHolder != null) {
            for (WebApplication application : webApplicationsHolder.getStartedWebapps().values()) {
                application.getContext().getServletContext().setInitParameter(serverUrlParam.getName(), serverUrlParam.getValue());
            }
        }
    }
}

