/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.SolrRequestHandler;

public class PingRequestHandler
extends RequestHandlerBase {
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        RequiredSolrParams required = params.required();
        SolrCore core = req.getCore();
        String healthcheck = core.getSolrConfig().get("admin/healthcheck/text()", null);
        if (healthcheck != null && !new File(healthcheck).exists()) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Service disabled", true);
        }
        String qt = ((SolrParams)required).get("qt");
        SolrRequestHandler handler = core.getRequestHandler(qt);
        if (handler == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown RequestHandler: " + qt);
        }
        Throwable ex = null;
        try {
            SolrQueryResponse pingrsp = new SolrQueryResponse();
            core.execute(handler, req, pingrsp);
            ex = pingrsp.getException();
        }
        catch (Throwable th) {
            ex = th;
        }
        if (ex != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Ping query caused exception: " + ex.getMessage(), ex);
        }
        rsp.add("status", "OK");
    }

    public String getVersion() {
        return "$Revision: 593627 $";
    }

    public String getDescription() {
        return "Reports application health to a load-balancer";
    }

    public String getSourceId() {
        return "$Id: PingRequestHandler.java 593627 2007-11-09 19:24:18Z ryan $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/PingRequestHandler.java $";
    }
}

