/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.internal;

import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.service.ContentBasedSearchService;
import org.wso2.carbon.registry.indexing.service.ContentSearchService;
import org.wso2.carbon.registry.indexing.service.SearchResultsBean;
import org.wso2.carbon.utils.WaitBeforeShutdownObserver;

public class IndexingServiceComponent {
    private static Log log = LogFactory.getLog(IndexingServiceComponent.class);
    private Registry registry = null;
    private boolean initialized = false;
    private static Stack<ServiceRegistration> registrations = new Stack();

    protected void activate(ComponentContext context) {
        registrations.push(context.getBundleContext().registerService(ContentSearchService.class.getName(), (Object)new ContentSearchServiceImpl(), null));
        registrations.push(context.getBundleContext().registerService(WaitBeforeShutdownObserver.class.getName(), (Object)new WaitBeforeShutdownObserver(){
            boolean status = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startingShutdown() {
                try {
                    IndexingManager.getInstance().stopIndexing();
                }
                finally {
                    this.status = true;
                }
            }

            public boolean isTaskComplete() {
                return this.status;
            }
        }, null));
        log.debug((Object)"******* Registry Indexing bundle is activated ******* ");
    }

    protected void deactivate(ComponentContext context) {
        while (!registrations.empty()) {
            registrations.pop().unregister();
        }
        log.debug((Object)"******* Registry Indexing bundle is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        Utils.setRegistryService(registryService);
        this.startIndexing();
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.stopIndexing();
        Utils.setRegistryService(null);
    }

    private void startIndexing() {
        IndexingManager.getInstance().startIndexing();
    }

    private void stopIndexing() {
        IndexingManager.getInstance().stopIndexing();
    }

    private static class ContentSearchServiceImpl
    implements ContentSearchService {
        private ContentSearchServiceImpl() {
        }

        public ResourceData[] search(UserRegistry registry, String query) throws RegistryException {
            SearchResultsBean resultsBean = null;
            try {
                resultsBean = new ContentBasedSearchService().searchContent(query, registry);
            }
            catch (IndexerException e) {
                throw new RegistryException("Unable to obtain an instance of a Solr client", (Throwable)e);
            }
            String errorMessage = resultsBean.getErrorMessage();
            if (errorMessage != null) {
                throw new RegistryException(errorMessage);
            }
            return resultsBean.getResourceDataList();
        }

        public ResourceData[] search(int tenantId, String query) throws RegistryException {
            return this.search(Utils.getRegistryService().getRegistry("wso2.system.user", tenantId), query);
        }

        public ResourceData[] search(String query) throws RegistryException {
            return this.search(-1234, query);
        }
    }
}

