/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.search.services.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.search.beans.CustomSearchParameterBean;

public class AdvancedSearchFilterActions {
    public static CustomSearchParameterBean getAdvancedSearchQueryBean(UserRegistry userRegistry, String filterName) throws RegistryException {
        CustomSearchParameterBean bean = new CustomSearchParameterBean();
        Resource r = userRegistry.get("users/" + userRegistry.getUserName() + "/searchFilters/" + filterName);
        Properties props = r.getProperties();
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key;
            List valueList;
            if (!(e.getKey() instanceof String) || !(e.getValue() instanceof List) || (valueList = (List)e.getValue()).size() == 0 || RegistryUtils.isHiddenProperty((String)(key = (String)e.getKey()))) continue;
            propertyMap.put(key, (String)valueList.get(0));
        }
        LinkedList<String[]> propArray = new LinkedList<String[]>();
        for (Map.Entry e : propertyMap.entrySet()) {
            String[] entry = new String[]{(String)e.getKey(), (String)e.getValue()};
            propArray.add(entry);
        }
        bean.setParameterValues((String[][])propArray.toArray((T[])new String[propArray.size()][2]));
        return bean;
    }

    public static void saveAdvancedSearchQueryBean(UserRegistry userRegistry, CustomSearchParameterBean bean, String filterName) throws RegistryException {
        Resource r = userRegistry.newResource();
        if (bean.getParameterValues() != null) {
            for (String[] prop : bean.getParameterValues()) {
                r.setProperty(prop[0], prop[1]);
            }
        }
        userRegistry.put("users/" + userRegistry.getUserName() + "/searchFilters/" + filterName, r);
    }

    public static String[] getSavedFilterNames(UserRegistry configUserRegistry) throws RegistryException {
        String filterPath = "users/" + configUserRegistry.getUserName() + "/searchFilters";
        if (!configUserRegistry.resourceExists(filterPath)) {
            return null;
        }
        Collection c = (Collection)configUserRegistry.get(filterPath);
        String[] children = c.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i] = children[i].substring(children[i].lastIndexOf(47) + 1);
        }
        return children;
    }
}

