/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.handler.component.SimpleStats;
import org.apache.solr.handler.component.StatsInfo;
import org.apache.solr.handler.component.StatsValues;

public class StatsComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "stats";

    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            rb.setNeedDocSet(true);
            rb.doStats = true;
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
        if (rb.doStats) {
            SolrParams params = rb.req.getParams();
            SimpleStats s = new SimpleStats(rb.req, rb.getResults().docSet, params);
            rb.rsp.add(COMPONENT_NAME, s.getStatsCounts());
        }
    }

    public int distributedProcess(ResponseBuilder rb) throws IOException {
        return ResponseBuilder.STAGE_DONE;
    }

    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.doStats) {
            return;
        }
        if ((sreq.purpose & 4) != 0) {
            sreq.purpose |= 0x200;
            StatsInfo si = rb._statsInfo;
            if (si == null) {
                rb._statsInfo = si = new StatsInfo();
                si.parse(rb.req.getParams(), rb);
            }
        } else {
            sreq.params.set(COMPONENT_NAME, "false");
        }
    }

    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doStats || (sreq.purpose & 0x200) == 0) {
            return;
        }
        StatsInfo si = rb._statsInfo;
        for (ShardResponse srsp : sreq.responses) {
            NamedList stats = (NamedList)srsp.getSolrResponse().getResponse().get(COMPONENT_NAME);
            NamedList stats_fields = (NamedList)stats.get("stats_fields");
            if (stats_fields == null) continue;
            for (int i = 0; i < stats_fields.size(); ++i) {
                String field = stats_fields.getName(i);
                StatsValues stv = si.statsFields.get(field);
                NamedList shardStv = (NamedList)stats_fields.get(field);
                stv.accumulate(shardStv);
            }
        }
    }

    public void finishStage(ResponseBuilder rb) {
        if (!rb.doStats || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        StatsInfo si = rb._statsInfo;
        SimpleOrderedMap stats = new SimpleOrderedMap();
        SimpleOrderedMap stats_fields = new SimpleOrderedMap();
        stats.add("stats_fields", stats_fields);
        for (String field : si.statsFields.keySet()) {
            NamedList<?> stv = si.statsFields.get(field).getStatsValues();
            if ((Long)stv.get("count") != 0L) {
                stats_fields.add(field, stv);
                continue;
            }
            stats_fields.add(field, null);
        }
        rb.rsp.add(COMPONENT_NAME, stats);
        rb._statsInfo = null;
    }

    public String getDescription() {
        return "Calculate Statistics";
    }

    public String getVersion() {
        return "$Revision$";
    }

    public String getSourceId() {
        return "$Id$";
    }

    public String getSource() {
        return "$URL$";
    }
}

