/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.search.services.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.search.beans.MediaTypeValueList;

public class CustomSearchParameterPopulator {
    private static Map<String, String[]> mediatypeParameterList = new HashMap<String, String[]>();
    private static String parameterListResourcePath = "/_system/config/repository/components/org.wso2.carbon.governance/media-types/search/";

    public static MediaTypeValueList getMediaTypeParameterValues(UserRegistry registry, String mediaType) throws RegistryException {
        MediaTypeValueList bean = new MediaTypeValueList();
        try {
            ArrayList<String> returnList = new ArrayList<String>();
            if (!registry.resourceExists(parameterListResourcePath)) {
                HashMap<String, String[]> types = new HashMap<String, String[]>();
                types.put("application/wsdl+xml", new String[]{"WSDL Validation", "WSI Validation"});
                types.put("application/x-xsd+xml", new String[]{"Schema Validation", "targetNamespace"});
                for (Map.Entry e : types.entrySet()) {
                    Resource resource = registry.newResource();
                    for (String value : (String[])e.getValue()) {
                        resource.setProperty(value, "true");
                    }
                    registry.put(parameterListResourcePath + ((String)e.getKey()).replace("/", "-").replace(".", "-").replace("+", "-"), resource);
                }
            }
            if (!"".equals(mediaType)) {
                Resource resource = registry.get(parameterListResourcePath + mediaType.replace("/", "-").replace(".", "-").replace("+", "-"));
                Properties property = resource.getProperties();
                for (Map.Entry<Object, Object> entry : property.entrySet()) {
                    if (!((ArrayList)entry.getValue()).contains("true")) continue;
                    returnList.add(entry.getKey().toString());
                }
            }
            bean.setMediaType(mediaType);
            if (returnList.size() > 0) {
                String[] tempString = new String[returnList.size()];
                tempString = returnList.toArray(tempString);
                bean.setSearchFields(tempString);
            }
        }
        catch (RegistryException e) {
            throw new RegistryException("No parameters are set for this media type", (Throwable)e);
        }
        return bean;
    }
}

