/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.message.WSBaseMessage;
import org.apache.ws.security.util.WSSecurityUtil;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSAddSAMLToken
extends WSBaseMessage {
    private static Log log = LogFactory.getLog((String)WSSAddSAMLToken.class.getName());

    public WSSAddSAMLToken() {
    }

    public WSSAddSAMLToken(String actor) {
        super(actor);
    }

    public WSSAddSAMLToken(String actor, boolean mu) {
        super(actor, mu);
    }

    public Document build(Document doc, SAMLAssertion assertion) {
        log.debug((Object)"Begin add SAMLAssertion token...");
        try {
            Element element = (Element)assertion.toDOM(doc);
            Element securityHeader = this.insertSecurityHeader(doc);
            WSSecurityUtil.prependChildElement(securityHeader, element);
        }
        catch (SAMLException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            throw new RuntimeException(ex.toString(), ex);
        }
        return doc;
    }
}

