/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.indexer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrException;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.solr.IndexDocument;

public class PDFIndexer
implements Indexer {
    public static final Log log = LogFactory.getLog(PDFIndexer.class);

    @Override
    public IndexDocument getIndexedDocument(AsyncIndexer.File2Index fileData) throws SolrException {
        try {
            PDFParser parser = new PDFParser((InputStream)new ByteArrayInputStream(fileData.data));
            parser.parse();
            COSDocument cosDoc = parser.getDocument();
            PDFTextStripper stripper = new PDFTextStripper();
            String docText = stripper.getText(new PDDocument(cosDoc));
            cosDoc.close();
            return new IndexDocument(fileData.path, docText, null);
        }
        catch (IOException e) {
            String msg = "Failed to write to the index";
            log.error((Object)msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
    }
}

