/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class FastInputStream
extends InputStream
implements DataInput {
    private final InputStream in;
    private final byte[] buf;
    private int pos;
    private int end;

    public FastInputStream(InputStream in) {
        this(in, new byte[8192], 0, 0);
    }

    public FastInputStream(InputStream in, byte[] tempBuffer, int start, int end) {
        this.in = in;
        this.buf = tempBuffer;
        this.pos = start;
        this.end = end;
    }

    public static FastInputStream wrap(InputStream in) {
        return in instanceof FastInputStream ? (FastInputStream)in : new FastInputStream(in);
    }

    public int read() throws IOException {
        if (this.pos >= this.end) {
            this.refill();
            if (this.pos >= this.end) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public int readUnsignedByte() throws IOException {
        if (this.pos >= this.end) {
            this.refill();
            if (this.pos >= this.end) {
                throw new EOFException();
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public void refill() throws IOException {
        this.end = this.in.read(this.buf, 0, this.buf.length);
        this.pos = 0;
    }

    public int available() throws IOException {
        return this.end - this.pos;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int r = 0;
        if (this.end - this.pos > 0) {
            r = Math.min(this.end - this.pos, len);
            System.arraycopy(this.buf, this.pos, b, off, r);
            this.pos += r;
        }
        if (r == len) {
            return r;
        }
        if (len - r >= this.buf.length) {
            int ret = this.in.read(b, off + r, len - r);
            if (ret == -1) {
                return r == 0 ? -1 : r;
            }
            return r += ret;
        }
        this.refill();
        if (this.end - this.pos > 0) {
            int toRead = Math.min(this.end - this.pos, len - r);
            System.arraycopy(this.buf, this.pos, b, off + r, toRead);
            this.pos += toRead;
            return r += toRead;
        }
        return r > 0 ? r : -1;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int ret = this.read(b, off, len);
            if (ret == -1) {
                throw new EOFException();
            }
            off += ret;
            len -= ret;
        }
    }

    public int skipBytes(int n) throws IOException {
        if (this.end - this.pos >= n) {
            this.pos += n;
            return n;
        }
        if (this.end - this.pos < 0) {
            return -1;
        }
        int r = this.end - this.pos;
        this.pos = this.end;
        while (r < n) {
            this.refill();
            if (this.end - this.pos <= 0) {
                return r;
            }
            int toRead = Math.min(this.end - this.pos, n - r);
            r += toRead;
            this.pos += toRead;
        }
        return r;
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    public byte readByte() throws IOException {
        if (this.pos >= this.end) {
            this.refill();
            if (this.pos >= this.end) {
                throw new EOFException();
            }
        }
        return this.buf[this.pos++];
    }

    public short readShort() throws IOException {
        return (short)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
    }

    public int readUnsignedShort() throws IOException {
        return this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    public char readChar() throws IOException {
        return (char)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
    }

    public int readInt() throws IOException {
        return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    public long readLong() throws IOException {
        return (long)this.readUnsignedByte() << 56 | (long)this.readUnsignedByte() << 48 | (long)this.readUnsignedByte() << 40 | (long)this.readUnsignedByte() << 32 | (long)this.readUnsignedByte() << 24 | (long)(this.readUnsignedByte() << 16) | (long)(this.readUnsignedByte() << 8) | (long)this.readUnsignedByte();
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        return new DataInputStream(this).readLine();
    }

    public String readUTF() throws IOException {
        return new DataInputStream(this).readUTF();
    }
}

