/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.FieldFacetStats;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.UnInvertedField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleStats {
    protected DocSet docs;
    protected SolrParams params;
    protected SolrIndexSearcher searcher;
    protected SolrQueryRequest req;

    public SimpleStats(SolrQueryRequest req, DocSet docs, SolrParams params) {
        this.req = req;
        this.searcher = req.getSearcher();
        this.docs = docs;
        this.params = params;
    }

    public NamedList<Object> getStatsCounts() throws IOException {
        SimpleOrderedMap<Object> res = new SimpleOrderedMap<Object>();
        res.add("stats_fields", this.getStatsFields());
        return res;
    }

    public NamedList getStatsFields() throws IOException {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] statsFs = this.params.getParams("stats.field");
        boolean isShard = this.params.getBool("isShard", false);
        if (null != statsFs) {
            for (String f : statsFs) {
                NamedList<?> stv;
                String[] facets = this.params.getFieldParams(f, "stats.facet");
                if (facets == null) {
                    facets = new String[]{};
                }
                SchemaField sf = this.searcher.getSchema().getField(f);
                FieldType ft = sf.getType();
                String prefix = TrieField.getMainValuePrefix(ft);
                if (sf.multiValued() || ft.multiValuedFieldCache() || prefix != null) {
                    UnInvertedField uif = UnInvertedField.getUnInvertedField(f, this.searcher);
                    stv = uif.getStats(this.searcher, this.docs, facets).getStatsValues();
                } else {
                    stv = this.getFieldCacheStats(f, facets);
                }
                if (isShard || (Long)stv.get("count") > 0L) {
                    res.add(f, stv);
                    continue;
                }
                res.add(f, null);
            }
        }
        return res;
    }

    public NamedList getFieldCacheStats(String fieldName, String[] facet) {
        FieldType ft = this.searcher.getSchema().getFieldType(fieldName);
        FieldCache.StringIndex si = null;
        try {
            si = FieldCache.DEFAULT.getStringIndex(this.searcher.getReader(), fieldName);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to open field cache for: " + fieldName, e);
        }
        FieldFacetStats all = new FieldFacetStats("all", si, ft, 0);
        StatsValues allstats = new StatsValues();
        if (all.nTerms <= 0 || this.docs.size() <= 0) {
            return allstats.getStatsValues();
        }
        int i = 0;
        FieldFacetStats[] finfo = new FieldFacetStats[facet.length];
        for (String f : facet) {
            ft = this.searcher.getSchema().getFieldType(f);
            try {
                si = FieldCache.DEFAULT.getStringIndex(this.searcher.getReader(), f);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to open field cache for: " + f, e);
            }
            finfo[i++] = new FieldFacetStats(f, si, ft, 0);
        }
        DocIterator iter = this.docs.iterator();
        while (iter.hasNext()) {
            int docID = iter.nextDoc();
            String raw = all.getTermText(docID);
            Double v = null;
            if (raw != null) {
                v = Double.parseDouble(all.ft.indexedToReadable(raw));
                allstats.accumulate(v);
            } else {
                ++allstats.missing;
            }
            for (FieldFacetStats f : finfo) {
                f.facet(docID, v);
            }
        }
        if (finfo.length > 0) {
            allstats.facets = new HashMap<String, Map<String, StatsValues>>();
            for (FieldFacetStats f : finfo) {
                allstats.facets.put(f.name, f.facetStatsValues);
            }
        }
        return allstats.getStatsValues();
    }
}

