/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.common;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Calendar;
import org.wso2.carbon.registry.common.TagCount;
import org.wso2.carbon.registry.common.utils.CommonUtil;

@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class ResourceData {
    private String name;
    private String resourcePath;
    private String relativePath;
    private String realPath;
    private String resourceType;
    private String authorUserName;
    private String description;
    private float averageRating;
    private String[] averageStars = new String[5];
    private Calendar createdOn;
    private boolean deleteAllowed;
    private boolean putAllowed;
    private boolean getAllowed;
    private TagCount[] tagCounts;
    private boolean link;
    private boolean externalLink;
    private boolean mounted;
    private String absent = "false";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        String[] q = name.split("\\?");
        if (q.length == 2 && q[1].startsWith("v=")) {
            name = q[0];
        }
        this.name = name;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        if ("/".equals(resourcePath)) {
            this.relativePath = "";
        } else if (resourcePath.startsWith("/")) {
            this.relativePath = resourcePath.substring(1, resourcePath.length());
        }
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getAuthorUserName() {
        return this.authorUserName;
    }

    public void setAuthorUserName(String authorUserName) {
        this.authorUserName = authorUserName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public float getAverageRating() {
        return this.averageRating;
    }

    public void setAverageRating(float averageRating) {
        this.averageRating = averageRating;
    }

    public String[] getAverageStars() {
        return this.averageStars;
    }

    public void setAverageStars(String[] averageStars) {
        this.averageStars = averageStars;
    }

    public Calendar getCreatedOn() {
        return this.createdOn;
    }

    public String getFormattedCreatedOn() {
        return CommonUtil.formatDate(this.createdOn.getTime());
    }

    public void setCreatedOn(Calendar createdOn) {
        this.createdOn = createdOn;
    }

    public boolean isDeleteAllowed() {
        return this.deleteAllowed;
    }

    public void setDeleteAllowed(boolean deleteAllowed) {
        this.deleteAllowed = deleteAllowed;
    }

    public boolean isPutAllowed() {
        return this.putAllowed;
    }

    public void setPutAllowed(boolean putAllowed) {
        this.putAllowed = putAllowed;
    }

    public TagCount[] getTagCounts() {
        return this.tagCounts;
    }

    public void setTagCounts(TagCount[] tagCounts) {
        this.tagCounts = tagCounts;
    }

    public boolean isLink() {
        return this.link;
    }

    public void setLink(boolean link) {
        this.link = link;
    }

    public boolean isExternalLink() {
        return this.externalLink;
    }

    public void setExternalLink(boolean externalLink) {
        this.externalLink = externalLink;
    }

    public boolean isMounted() {
        return this.mounted;
    }

    public void setMounted(boolean mounted) {
        this.mounted = mounted;
    }

    public void setGetAllowed(boolean getAllowed) {
        this.getAllowed = getAllowed;
    }

    public boolean isGetAllowed() {
        return this.getAllowed;
    }

    public String getRealPath() {
        return this.realPath;
    }

    public void setRealPath(String realPath) {
        this.realPath = realPath;
    }

    public String getAbsent() {
        return this.absent;
    }

    public void setAbsent(String absent) {
        if (absent != null) {
            this.absent = absent;
        }
    }
}

