/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public final class CzechAnalyzer
extends Analyzer {
    public static final String[] CZECH_STOP_WORDS = new String[]{"a", "s", "k", "o", "i", "u", "v", "z", "dnes", "cz", "t\u00edmto", "bude\u0161", "budem", "byli", "jse\u0161", "m\u016fj", "sv\u00fdm", "ta", "tomto", "tohle", "tuto", "tyto", "jej", "zda", "pro\u010d", "m\u00e1te", "tato", "kam", "tohoto", "kdo", "kte\u0159\u00ed", "mi", "n\u00e1m", "tom", "tomuto", "m\u00edt", "nic", "proto", "kterou", "byla", "toho", "proto\u017ee", "asi", "ho", "na\u0161i", "napi\u0161te", "re", "co\u017e", "t\u00edm", "tak\u017ee", "sv\u00fdch", "jej\u00ed", "sv\u00fdmi", "jste", "aj", "tu", "tedy", "teto", "bylo", "kde", "ke", "prav\u00e9", "ji", "nad", "nejsou", "\u010di", "pod", "t\u00e9ma", "mezi", "p\u0159es", "ty", "pak", "v\u00e1m", "ani", "kdy\u017e", "v\u0161ak", "neg", "jsem", "tento", "\u010dl\u00e1nku", "\u010dl\u00e1nky", "aby", "jsme", "p\u0159ed", "pta", "jejich", "byl", "je\u0161t\u011b", "a\u017e", "bez", "tak\u00e9", "pouze", "prvn\u00ed", "va\u0161e", "kter\u00e1", "n\u00e1s", "nov\u00fd", "tipy", "pokud", "m\u016f\u017ee", "strana", "jeho", "sv\u00e9", "jin\u00e9", "zpr\u00e1vy", "nov\u00e9", "nen\u00ed", "v\u00e1s", "jen", "podle", "zde", "u\u017e", "b\u00fdt", "v\u00edce", "bude", "ji\u017e", "ne\u017e", "kter\u00fd", "by", "kter\u00e9", "co", "nebo", "ten", "tak", "m\u00e1", "p\u0159i", "od", "po", "jsou", "jak", "dal\u0161\u00ed", "ale", "si", "se", "ve", "to", "jako", "za", "zp\u011bt", "ze", "do", "pro", "je", "na", "atd", "atp", "jakmile", "p\u0159i\u010dem\u017e", "j\u00e1", "on", "ona", "ono", "oni", "ony", "my", "vy", "j\u00ed", "ji", "m\u011b", "mne", "jemu", "tomu", "t\u011bm", "t\u011bmu", "n\u011bmu", "n\u011bmu\u017e", "jeho\u017e", "j\u00ed\u017e", "jeliko\u017e", "je\u017e", "jako\u017e", "na\u010de\u017e"};
    private Set stoptable;
    private final Version matchVersion;

    public CzechAnalyzer() {
        this(Version.LUCENE_23);
    }

    public CzechAnalyzer(Version matchVersion) {
        this.stoptable = StopFilter.makeStopSet(CZECH_STOP_WORDS);
        this.matchVersion = matchVersion;
    }

    public CzechAnalyzer(String[] stopwords) {
        this(Version.LUCENE_23, stopwords);
    }

    public CzechAnalyzer(Version matchVersion, String[] stopwords) {
        this.stoptable = StopFilter.makeStopSet(stopwords);
        this.matchVersion = matchVersion;
    }

    public CzechAnalyzer(HashSet stopwords) {
        this(Version.LUCENE_23, stopwords);
    }

    public CzechAnalyzer(Version matchVersion, HashSet stopwords) {
        this.stoptable = stopwords;
        this.matchVersion = matchVersion;
    }

    public CzechAnalyzer(File stopwords) throws IOException {
        this(Version.LUCENE_23, stopwords);
    }

    public CzechAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this.stoptable = WordlistLoader.getWordSet(stopwords);
        this.matchVersion = matchVersion;
    }

    public void loadStopWords(InputStream wordfile, String encoding) {
        this.setPreviousTokenStream(null);
        if (wordfile == null) {
            this.stoptable = new HashSet();
            return;
        }
        try {
            String word;
            this.stoptable = new HashSet();
            InputStreamReader isr = encoding == null ? new InputStreamReader(wordfile) : new InputStreamReader(wordfile, encoding);
            LineNumberReader lnr = new LineNumberReader(isr);
            while ((word = lnr.readLine()) != null) {
                this.stoptable.add(word);
            }
        }
        catch (IOException e) {
            this.stoptable = new HashSet();
        }
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(this.matchVersion, reader);
        result = new StandardFilter(result);
        result = new LowerCaseFilter(result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), result, this.stoptable);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(this.matchVersion, reader);
            streams.result = new StandardFilter(streams.source);
            streams.result = new LowerCaseFilter(streams.result);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), streams.result, this.stoptable);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

