/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSSecEncrypt
extends WSSecEncryptedKey {
    private static Log log = LogFactory.getLog((String)WSSecEncrypt.class.getName());
    protected String symEncAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    protected String encCanonAlgo = null;
    protected byte[] embeddedKey = null;
    protected String embeddedKeyName = null;
    protected boolean useKeyIdentifier;
    protected SecretKey symmetricKey = null;
    protected SecurityTokenReference securityTokenReference = null;
    private boolean encryptSymmKey = true;
    private String customReferenceValue;
    private String encKeyValueType;
    private boolean encKeyIdDirectId;

    public void setKey(byte[] key) {
        this.embeddedKey = key;
    }

    public void setKeyEnc(String keyEnc) {
        this.keyEncAlgo = keyEnc;
    }

    public void setEmbeddedKeyName(String embeddedKeyName) {
        this.embeddedKeyName = embeddedKeyName;
    }

    public void setUseKeyIdentifier(boolean useKeyIdentifier) {
        this.useKeyIdentifier = useKeyIdentifier;
    }

    public void setSymmetricEncAlgorithm(String algo) {
        this.symEncAlgo = algo;
    }

    public void setEncCanonicalization(String algo) {
        this.encCanonAlgo = algo;
    }

    public String getSymmetricEncAlgorithm() {
        return this.symEncAlgo;
    }

    public boolean getUseKeyIdentifier() {
        return this.useKeyIdentifier;
    }

    public void prepare(Document doc, Crypto crypto) throws WSSecurityException {
        this.document = doc;
        if (this.ephemeralKey == null) {
            if (this.symmetricKey == null) {
                KeyGenerator keyGen = this.getKeyGenerator();
                this.symmetricKey = keyGen.generateKey();
            }
            this.ephemeralKey = this.symmetricKey.getEncoded();
        }
        if (this.symmetricKey == null) {
            this.symmetricKey = WSSecurityUtil.prepareSecretKey(this.symEncAlgo, this.ephemeralKey);
        }
        if (this.encryptSymmKey) {
            X509Certificate remoteCert = null;
            if (this.useThisCert != null) {
                remoteCert = this.useThisCert;
            } else {
                X509Certificate[] certs = crypto.getCertificates(this.user);
                if (certs == null || certs.length <= 0) {
                    throw new WSSecurityException(0, "noUserCertsFound", new Object[]{this.user, "encryption"});
                }
                remoteCert = certs[0];
            }
            this.prepareInternal(this.ephemeralKey, remoteCert, crypto);
        } else {
            this.encryptedEphemeralKey = this.ephemeralKey;
        }
    }

    public Document build(Document doc, Crypto crypto, WSSecHeader secHeader) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.keyIdentifierType == 5 || this.keyIdentifierType == 6) {
            return this.buildEmbedded(doc, secHeader);
        }
        if (this.doDebug) {
            log.debug((Object)"Beginning Encryption...");
        }
        this.prepare(doc, crypto);
        if (this.envelope == null) {
            this.envelope = this.document.getDocumentElement();
        }
        if (this.parts == null) {
            this.parts = new Vector();
            SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(this.envelope);
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        Element refs = this.encryptForInternalRef(null, this.parts);
        if (this.encryptedKeyElement != null) {
            this.addInternalRefElement(refs);
            this.prependToHeader(secHeader);
        } else {
            WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), refs);
        }
        if (this.bstToken != null) {
            this.prependBSTElementToHeader(secHeader);
        }
        log.debug((Object)"Encryption complete.");
        return doc;
    }

    public Element encryptForInternalRef(Element dataRef, Vector references) throws WSSecurityException {
        Vector encDataRefs = this.doEncryption(this.document, this.symmetricKey, references);
        Element referenceList = dataRef;
        if (referenceList == null) {
            referenceList = this.document.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
        }
        WSSecEncrypt.createDataRefList(this.document, referenceList, encDataRefs);
        return referenceList;
    }

    public Element encryptForExternalRef(Element dataRef, Vector references) throws WSSecurityException {
        Vector encDataRefs = this.doEncryption(this.document, this.symmetricKey, references);
        Element referenceList = dataRef;
        if (referenceList == null) {
            referenceList = this.document.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
            if (!this.encryptSymmKey) {
                WSSecurityUtil.setNamespace(referenceList, "http://www.w3.org/2001/04/xmlenc#", "xenc");
            }
        }
        WSSecEncrypt.createDataRefList(this.document, referenceList, encDataRefs);
        return referenceList;
    }

    public void addInternalRefElement(Element dataRef) {
        this.encryptedKeyElement.appendChild(dataRef);
    }

    public void addExternalRefElement(Element dataRef, WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), dataRef);
    }

    private Vector doEncryption(Document doc, SecretKey secretKey, Vector references) throws WSSecurityException {
        KeyInfo keyInfo = null;
        if (this.useKeyIdentifier && this.keyIdentifierType == 10) {
            keyInfo = new KeyInfo(this.document);
            SecurityTokenReference secToken = new SecurityTokenReference(this.document);
            if (this.customReferenceValue != null) {
                secToken.setKeyIdentifierEncKeySHA1(this.customReferenceValue);
            } else {
                secToken.setKeyIdentifierEncKeySHA1(this.getSHA1(this.encryptedEphemeralKey));
            }
            keyInfo.addUnknownElement(secToken.getElement());
            Element keyInfoElement = keyInfo.getElement();
            keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        }
        return this.doEncryption(doc, secretKey, keyInfo, references);
    }

    private Vector doEncryption(Document doc, SecretKey secretKey, KeyInfo keyInfo, Vector references) throws WSSecurityException {
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance(this.symEncAlgo);
        }
        catch (XMLEncryptionException e3) {
            throw new WSSecurityException(2, null, null, e3);
        }
        Vector<String> encDataRef = new Vector<String>();
        boolean cloneKeyInfo = false;
        for (int part = 0; part < references.size(); ++part) {
            WSEncryptionPart encPart = (WSEncryptionPart)references.get(part);
            String idToEnc = encPart.getId();
            String elemName = encPart.getName();
            String nmSpace = encPart.getNamespace();
            String modifier = encPart.getEncModifier();
            Element body = null;
            if (idToEnc != null) {
                body = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToEnc, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                if (body == null) {
                    body = WSSecurityUtil.findElementById(this.document.getDocumentElement(), idToEnc, null);
                }
            } else {
                body = (Element)WSSecurityUtil.findElement(this.document, elemName, nmSpace);
            }
            if (body == null) {
                throw new WSSecurityException(0, "noEncElement", new Object[]{"{" + nmSpace + "}" + elemName});
            }
            boolean content = modifier.equals("Content");
            String xencEncryptedDataId = this.wssConfig.getIdAllocator().createId("EncDataId-", body);
            encPart.setEncId(xencEncryptedDataId);
            cloneKeyInfo = true;
            if (keyInfo == null) {
                keyInfo = new KeyInfo(this.document);
                SecurityTokenReference secToken = new SecurityTokenReference(this.document);
                if (this.useKeyIdentifier && "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(this.customReferenceValue)) {
                    secToken.setSAMLKeyIdentifier((this.encKeyIdDirectId ? "" : "#") + this.encKeyId);
                } else {
                    Reference ref = new Reference(this.document);
                    if (this.encKeyIdDirectId) {
                        ref.setURI(this.encKeyId);
                    } else {
                        ref.setURI("#" + this.encKeyId);
                    }
                    if (this.encKeyValueType != null) {
                        ref.setValueType(this.encKeyValueType);
                    }
                    secToken.setReference(ref);
                }
                keyInfo.addUnknownElement(secToken.getElement());
                Element keyInfoElement = keyInfo.getElement();
                keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
            }
            try {
                if (modifier.equals("Header")) {
                    Element elem = doc.createElementNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:EncryptedHeader");
                    WSSecurityUtil.setNamespace(elem, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11");
                    String wsuPrefix = WSSecurityUtil.setNamespace(elem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
                    elem.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", wsuPrefix + ":Id", this.wssConfig.getIdAllocator().createId("EncHeader-", body));
                    NamedNodeMap map = body.getAttributes();
                    for (int i = 0; i < map.getLength(); ++i) {
                        Attr attr = (Attr)map.item(i);
                        if (!attr.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && !attr.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) continue;
                        String soapEnvPrefix = WSSecurityUtil.setNamespace(elem, attr.getNamespaceURI(), "soapenv");
                        elem.setAttributeNS(attr.getNamespaceURI(), soapEnvPrefix + ":" + attr.getLocalName(), attr.getValue());
                    }
                    xmlCipher.init(1, secretKey);
                    EncryptedData encData = xmlCipher.getEncryptedData();
                    encData.setId(xencEncryptedDataId);
                    encData.setKeyInfo(keyInfo);
                    xmlCipher.doFinal(doc, body, content);
                    Element encDataElem = WSSecurityUtil.findElementById(this.document.getDocumentElement(), xencEncryptedDataId, null);
                    Node clone = encDataElem.cloneNode(true);
                    elem.appendChild(clone);
                    encDataElem.getParentNode().appendChild(elem);
                    encDataElem.getParentNode().removeChild(encDataElem);
                } else {
                    xmlCipher.init(1, secretKey);
                    EncryptedData encData = xmlCipher.getEncryptedData();
                    encData.setId(xencEncryptedDataId);
                    encData.setKeyInfo(keyInfo);
                    xmlCipher.doFinal(doc, body, content);
                }
                if (cloneKeyInfo) {
                    keyInfo = new KeyInfo((Element)keyInfo.getElement().cloneNode(true), null);
                }
            }
            catch (Exception e2) {
                throw new WSSecurityException(9, null, null, e2);
            }
            encDataRef.add("#" + xencEncryptedDataId);
        }
        return encDataRef;
    }

    private Document buildEmbedded(Document doc, WSSecHeader secHeader) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.doDebug) {
            log.debug((Object)"Beginning Encryption embedded...");
        }
        this.envelope = doc.getDocumentElement();
        this.envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        if (this.symmetricKey == null) {
            if (this.embeddedKey == null) {
                throw new WSSecurityException(0, "noKeySupplied");
            }
            this.symmetricKey = WSSecurityUtil.prepareSecretKey(this.symEncAlgo, this.embeddedKey);
        }
        KeyInfo keyInfo = null;
        if (this.keyIdentifierType == 5) {
            keyInfo = new KeyInfo(doc);
            keyInfo.addKeyName(this.embeddedKeyName == null ? this.user : this.embeddedKeyName);
        } else if (this.keyIdentifierType == 6) {
            if (this.securityTokenReference == null) {
                throw new WSSecurityException(7, "You must set keyInfo element, if the keyIdentifier == EMBED_SECURITY_TOKEN_REF");
            }
            keyInfo = new KeyInfo(doc);
            Element tmpE = this.securityTokenReference.getElement();
            tmpE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + tmpE.getPrefix(), tmpE.getNamespaceURI());
            keyInfo.addUnknownElement(this.securityTokenReference.getElement());
        }
        Element keyInfoElement = keyInfo.getElement();
        keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(this.envelope);
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        Vector encDataRefs = this.doEncryption(doc, this.symmetricKey, keyInfo, this.parts);
        Element wsseSecurity = secHeader.getSecurityHeader();
        Element referenceList = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
        referenceList = WSSecEncrypt.createDataRefList(doc, referenceList, encDataRefs);
        WSSecurityUtil.prependChildElement(wsseSecurity, referenceList);
        return doc;
    }

    private KeyGenerator getKeyGenerator() throws WSSecurityException {
        try {
            String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI(this.symEncAlgo);
            KeyGenerator keyGen = KeyGenerator.getInstance(keyAlgorithm);
            if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                keyGen.init(128);
            } else if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                keyGen.init(192);
            } else if (this.symEncAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                keyGen.init(256);
            }
            return keyGen;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(2, null, null, e);
        }
    }

    public static Element createDataRefList(Document doc, Element referenceList, Vector encDataRefs) {
        for (int i = 0; i < encDataRefs.size(); ++i) {
            String dataReferenceUri = (String)encDataRefs.get(i);
            Element dataReference = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:DataReference");
            dataReference.setAttributeNS(null, "URI", dataReferenceUri);
            referenceList.appendChild(dataReference);
        }
        return referenceList;
    }

    public SecretKey getSymmetricKey() {
        return this.symmetricKey;
    }

    public void setSymmetricKey(SecretKey key) {
        this.symmetricKey = key;
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(SecurityTokenReference reference) {
        this.securityTokenReference = reference;
    }

    public boolean isEncryptSymmKey() {
        return this.encryptSymmKey;
    }

    public void setEncryptSymmKey(boolean encryptSymmKey) {
        this.encryptSymmKey = encryptSymmKey;
    }

    private String getSHA1(byte[] input) throws WSSecurityException {
        try {
            MessageDigest sha = null;
            sha = MessageDigest.getInstance("SHA-1");
            sha.reset();
            sha.update(input);
            byte[] data = sha.digest();
            return Base64.encode(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(2, null, null, e);
        }
    }

    public void setCustomReferenceValue(String customReferenceValue) {
        this.customReferenceValue = customReferenceValue;
    }

    public void setEncKeyValueType(String e) {
        this.encKeyValueType = e;
    }

    public void setEncKeyIdDirectId(boolean b) {
        this.encKeyIdDirectId = b;
    }
}

