/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.wso2.carbon.registry.admin.api.indexing.IContentBasedSearchService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.service.SearchResultsBean;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.registry.indexing.utils.IndexingUtils;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class ContentBasedSearchService
extends RegistryAbstractAdmin
implements IContentBasedSearchService {
    private static final Log log = LogFactory.getLog(ContentBasedSearchService.class);
    private String solrServerUrl;

    public String getSolrUrl(int tenantId) throws IOException, FileNotFoundException, RegistryException {
        if (this.solrServerUrl == null) {
            this.solrServerUrl = IndexingUtils.getSolrUrl();
        }
        return this.solrServerUrl;
    }

    public SearchResultsBean getContentSearchResults(String searchQuery) throws AxisFault {
        try {
            UserRegistry registry = (UserRegistry)this.getRootRegistry();
            return this.searchContent(searchQuery, registry);
        }
        catch (Exception e) {
            log.error((Object)("Error " + e.getMessage() + "at the content search back end component."), (Throwable)e);
            return new SearchResultsBean();
        }
    }

    public SearchResultsBean searchContent(String searchQuery, UserRegistry registry) throws IndexerException, RegistryException {
        SearchResultsBean resultsBean = new SearchResultsBean();
        SolrClient client = SolrClient.getInstance();
        SolrDocumentList results = client.query(searchQuery, registry.getTenantId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("result received " + results));
        }
        ArrayList<ResourceData> filteredResults = new ArrayList<ResourceData>();
        int i = 0;
        while ((long)i < results.getNumFound()) {
            SolrDocument solrDocument = (SolrDocument)results.get(i);
            String path = this.getPathFromId((String)solrDocument.getFirstValue("id"));
            if (registry.resourceExists(path) && this.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get")) {
                filteredResults.add(this.loadResourceByPath(registry, path));
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("filtered results " + filteredResults + " for user " + registry.getUserName()));
        }
        resultsBean.setResourceDataList(filteredResults.toArray(new ResourceData[0]));
        return resultsBean;
    }

    public void restartIndexing() throws RegistryException {
        IndexingManager manager = IndexingManager.getInstance();
        manager.restartIndexing();
    }

    private String getPathFromId(String id) {
        return id.substring(0, id.lastIndexOf("tenantId"));
    }

    private boolean isAuthorized(UserRegistry registry, String resourcePath, String action) throws RegistryException {
        UserRealm userRealm = registry.getUserRealm();
        String userName = ContentBasedSearchService.getLoggedInUserName();
        try {
            if (!userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, action)) {
                return false;
            }
        }
        catch (UserStoreException e) {
            throw new RegistryException("Error at Authorizing " + resourcePath + " with user " + userName + ":" + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private ResourceData loadResourceByPath(UserRegistry registry, String path) throws RegistryException {
        Resource child;
        ResourceData resourceData = new ResourceData();
        resourceData.setResourcePath(path);
        if (path != null) {
            if ("/".equals(path)) {
                resourceData.setName("root");
            } else {
                String[] parts = path.split("/");
                resourceData.setName(parts[parts.length - 1]);
            }
        }
        resourceData.setResourceType((child = registry.get(path)) instanceof Collection ? "collection" : "resource");
        resourceData.setAuthorUserName(child.getAuthorUserName());
        resourceData.setDescription(child.getDescription());
        resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
        Calendar createdDateTime = Calendar.getInstance();
        createdDateTime.setTime(child.getCreatedTime());
        resourceData.setCreatedOn(createdDateTime);
        CommonUtil.populateAverageStars((ResourceData)resourceData);
        child.discard();
        return resourceData;
    }

    public static String getLoggedInUserName() {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String userName = (String)request.getSession().getAttribute("wso2carbon.admin.logged.in");
        return userName;
    }
}

