/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.solr.client.solrj.request.DocumentAnalysisRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.AnalysisRequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentAnalysisRequestHandler
extends AnalysisRequestHandlerBase {
    public static final Logger log = LoggerFactory.getLogger(DocumentAnalysisRequestHandler.class);
    private static final float DEFAULT_BOOST = 1.0f;
    private XMLInputFactory inputFactory;

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.inputFactory = XMLInputFactory.newInstance();
        try {
            this.inputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to set the 'reuse-instance' property for the input factory: " + this.inputFactory);
        }
    }

    @Override
    protected NamedList doAnalysis(SolrQueryRequest req) throws Exception {
        DocumentAnalysisRequest analysisRequest = this.resolveAnalysisRequest(req);
        return this.handleAnalysisRequest(analysisRequest, req.getSchema());
    }

    @Override
    public String getDescription() {
        return "Provides a breakdown of the analysis process of provided documents";
    }

    @Override
    public String getVersion() {
        return "$Revision: 824333 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: DocumentAnalysisRequestHandler.java 824333 2009-10-12 13:40:27Z ehatcher $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/DocumentAnalysisRequestHandler.java $";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DocumentAnalysisRequest resolveAnalysisRequest(SolrQueryRequest req) throws IOException, XMLStreamException {
        DocumentAnalysisRequest documentAnalysisRequest;
        XMLStreamReader parser;
        Reader reader;
        block8: {
            DocumentAnalysisRequest request = new DocumentAnalysisRequest();
            SolrParams params = req.getParams();
            String query = params.get("analysis.query", params.get("q", null));
            request.setQuery(query);
            boolean showMatch = params.getBool("analysis.showmatch", false);
            request.setShowMatch(showMatch);
            ContentStream stream = this.extractSingleContentStream(req);
            reader = stream.getReader();
            parser = this.inputFactory.createXMLStreamReader(reader);
            try {
                while (true) {
                    int event = parser.next();
                    switch (event) {
                        case 8: {
                            parser.close();
                            documentAnalysisRequest = request;
                            Object var13_12 = null;
                            break block8;
                        }
                        case 1: {
                            String currTag = parser.getLocalName();
                            if ("doc".equals(currTag)) {
                                log.trace("Reading doc...");
                                SolrInputDocument document = this.readDocument(parser, req.getSchema());
                                request.addDocument(document);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                parser.close();
                IOUtils.closeQuietly((Reader)reader);
                throw throwable;
            }
        }
        parser.close();
        IOUtils.closeQuietly((Reader)reader);
        return documentAnalysisRequest;
    }

    NamedList<Object> handleAnalysisRequest(DocumentAnalysisRequest request, IndexSchema schema) {
        SchemaField uniqueKeyField = schema.getUniqueKeyField();
        SimpleOrderedMap<Object> result = new SimpleOrderedMap<Object>();
        for (SolrInputDocument document : request.getDocuments()) {
            SimpleOrderedMap theTokens = new SimpleOrderedMap();
            result.add(document.getFieldValue(uniqueKeyField.getName()).toString(), theTokens);
            for (String name : document.getFieldNames()) {
                SchemaField field = schema.getField(name);
                if (!field.indexed()) continue;
                SimpleOrderedMap fieldTokens = new SimpleOrderedMap();
                theTokens.add(name, fieldTokens);
                FieldType fieldType = schema.getFieldType(name);
                HashSet<String> termsToMatch = new HashSet<String>();
                if (request.getQuery() != null && request.isShowMatch()) {
                    try {
                        List<Token> tokens = this.analyzeValue(request.getQuery(), fieldType.getQueryAnalyzer());
                        for (Token token : tokens) {
                            termsToMatch.add(token.term());
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (request.getQuery() != null) {
                    try {
                        AnalysisRequestHandlerBase.AnalysisContext analysisContext = new AnalysisRequestHandlerBase.AnalysisContext(fieldType, fieldType.getQueryAnalyzer(), Collections.EMPTY_SET);
                        NamedList<List<NamedList>> tokens = this.analyzeValue(request.getQuery(), analysisContext);
                        fieldTokens.add("query", tokens);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                Analyzer analyzer = fieldType.getAnalyzer();
                AnalysisRequestHandlerBase.AnalysisContext analysisContext = new AnalysisRequestHandlerBase.AnalysisContext(fieldType, analyzer, termsToMatch);
                Collection<Object> fieldValues = document.getFieldValues(name);
                SimpleOrderedMap<NamedList<List<NamedList>>> indexTokens = new SimpleOrderedMap<NamedList<List<NamedList>>>();
                for (Object fieldValue : fieldValues) {
                    NamedList<List<NamedList>> tokens = this.analyzeValue(fieldValue.toString(), analysisContext);
                    indexTokens.add(String.valueOf(fieldValue), tokens);
                }
                fieldTokens.add("index", indexTokens);
            }
        }
        return result;
    }

    SolrInputDocument readDocument(XMLStreamReader reader, IndexSchema schema) throws XMLStreamException {
        SolrInputDocument doc = new SolrInputDocument();
        String uniqueKeyField = schema.getUniqueKeyField().getName();
        StringBuilder text = new StringBuilder();
        String fieldName = null;
        boolean hasId = false;
        block5: while (true) {
            int event = reader.next();
            switch (event) {
                case 4: 
                case 6: 
                case 12: {
                    text.append(reader.getText());
                    break;
                }
                case 2: {
                    if ("doc".equals(reader.getLocalName())) {
                        if (!hasId) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "All documents must contain a unique key value: '" + doc.toString() + "'");
                        }
                        return doc;
                    }
                    if (!"field".equals(reader.getLocalName())) break;
                    doc.addField(fieldName, text.toString(), 1.0f);
                    if (!uniqueKeyField.equals(fieldName)) break;
                    hasId = true;
                    break;
                }
                case 1: {
                    text.setLength(0);
                    String localName = reader.getLocalName();
                    if (!"field".equals(localName)) {
                        log.warn("unexpected XML tag doc/" + localName);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag doc/" + localName);
                    }
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String attrName = reader.getAttributeLocalName(i);
                        if (!"name".equals(attrName)) continue;
                        fieldName = reader.getAttributeValue(i);
                    }
                    continue block5;
                }
            }
        }
    }

    private ContentStream extractSingleContentStream(SolrQueryRequest req) {
        Iterable<ContentStream> streams = req.getContentStreams();
        if (streams == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "DocumentAnlysisRequestHandler expects a single content stream with documents to analyze");
        }
        Iterator<ContentStream> iter = streams.iterator();
        if (!iter.hasNext()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "DocumentAnlysisRequestHandler expects a single content stream with documents to analyze");
        }
        ContentStream stream = iter.next();
        if (iter.hasNext()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "DocumentAnlysisRequestHandler expects a single content stream with documents to analyze");
        }
        return stream;
    }
}

