/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.db;

import com.google.gson.Gson;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.RDBMSDataSource;

public class DatabaseHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(DatabaseHostObject.class);
    private static final String hostObjectName = "Database";
    public static final String COM_MYSQL_JDBC_DRIVER = "com.mysql.jdbc.Driver";
    public static final String ORG_H2_DRIVER = "org.h2.Driver";
    public static final String ORACLE_JDBC_ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    public static final String MYSQL = "jdbc:mysql";
    public static final String H2 = "jdbc:h2";
    public static final String ORACLE = "jdbc:oracle";
    private boolean autoCommit = true;
    private Context context = null;
    private Connection conn = null;
    static RDBMSDataSource rdbmsDataSource = null;
    private Map<String, Savepoint> savePoints = new HashMap<String, Savepoint>();

    public String getClassName() {
        return hostObjectName;
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        int argsCount = args.length;
        DatabaseHostObject db = new DatabaseHostObject();
        if (argsCount != 1 && argsCount != 3 && argsCount != 4) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)hostObjectName, (int)argsCount, (boolean)true);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)hostObjectName, (String)"1", (String)"string", (Object)args[0], (boolean)true);
        }
        if (argsCount == 1) {
            String dataSourceName = (String)args[0];
            DataSourceManager dataSourceManager = new DataSourceManager();
            try {
                CarbonDataSource carbonDataSource = dataSourceManager.getInstance().getDataSourceRepository().getDataSource(dataSourceName);
                DataSource dataSource = (DataSource)carbonDataSource.getDSObject();
                db.conn = dataSource.getConnection();
                db.context = cx;
                return db;
            }
            catch (DataSourceException e) {
                log.error((Object)("Failed to access datasource " + dataSourceName), (Throwable)e);
            }
            catch (SQLException e) {
                log.error((Object)"Failed to get connection", (Throwable)e);
            }
        }
        if (!(args[1] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)hostObjectName, (String)"2", (String)"string", (Object)args[1], (boolean)true);
        }
        if (!(args[2] instanceof String) && !(args[2] instanceof Integer)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)hostObjectName, (String)"3", (String)"string", (Object)args[2], (boolean)true);
        }
        NativeObject configs = null;
        if (argsCount == 4) {
            if (!(args[3] instanceof NativeObject)) {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)hostObjectName, (String)"4", (String)"object", (Object)args[3], (boolean)true);
            }
            configs = (NativeObject)args[3];
        }
        String dbUrl = (String)args[0];
        RDBMSConfiguration rdbmsConfig = new RDBMSConfiguration();
        try {
            if (configs != null) {
                Gson gson = new Gson();
                rdbmsConfig = (RDBMSConfiguration)gson.fromJson(HostObjectUtil.serializeJSON((Object)configs), RDBMSConfiguration.class);
            }
            if (rdbmsConfig.getDriverClassName() == null || rdbmsConfig.getDriverClassName().equals("")) {
                rdbmsConfig.setDriverClassName(DatabaseHostObject.getDriverClassName(dbUrl));
            }
            rdbmsConfig.setUsername((String)args[1]);
            rdbmsConfig.setPassword((String)args[2]);
            rdbmsConfig.setUrl(dbUrl);
            try {
                rdbmsDataSource = new RDBMSDataSource(rdbmsConfig);
            }
            catch (DataSourceException e) {
                throw new ScriptException((Exception)((Object)e));
            }
            db.conn = rdbmsDataSource.getDataSource().getConnection();
            db.context = cx;
            return db;
        }
        catch (SQLException e) {
            String msg = "Error connecting to the database : " + dbUrl;
            log.warn((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    private static String getDriverClassName(String dburl) {
        if (dburl.contains(MYSQL)) {
            return COM_MYSQL_JDBC_DRIVER;
        }
        if (dburl.contains(H2)) {
            return ORG_H2_DRIVER;
        }
        if (dburl.contains(ORACLE)) {
            return ORACLE_JDBC_ORACLE_DRIVER;
        }
        return null;
    }

    public boolean jsGet_autoCommit() throws ScriptException {
        return this.autoCommit;
    }

    public void jsSet_autoCommit(Object object) throws ScriptException {
        if (!(object instanceof Boolean)) {
            HostObjectUtil.invalidProperty((String)hostObjectName, (String)"autoCommit", (String)"boolean", (Object)object);
        }
        this.autoCommit = (Boolean)object;
    }

    public static Object jsFunction_query(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, SQLException {
        String functionName = "query";
        int argsCount = args.length;
        if (argsCount == 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        DatabaseHostObject db = (DatabaseHostObject)thisObj;
        if (argsCount == 1) {
            Function callback = null;
            if (!(args[0] instanceof String)) {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
            }
            String query = (String)args[0];
            PreparedStatement stmt = db.conn.prepareStatement(query);
            return DatabaseHostObject.executeQuery(cx, db, stmt, query, callback, true);
        }
        if (argsCount == 2) {
            if (!(args[0] instanceof String)) {
                Function callback = null;
                if (!(args[0] instanceof NativeArray)) {
                    HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
                }
                NativeArray queries = (NativeArray)args[0];
                NativeArray values = null;
                if (args[1] instanceof Function) {
                    callback = (Function)args[1];
                } else if (args[1] instanceof NativeArray) {
                    values = (NativeArray)args[1];
                } else {
                    HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"array | function", (Object)args[0], (boolean)false);
                }
                return DatabaseHostObject.executeBatch(cx, db, queries, values, callback);
            }
            Function callback = null;
            String query = (String)args[0];
            PreparedStatement stmt = db.conn.prepareStatement(query);
            if (args[1] instanceof Function) {
                callback = (Function)args[1];
            } else if (args[1] instanceof String) {
                DatabaseHostObject.setQueryParams(stmt, args, 1, 1);
            }
            return DatabaseHostObject.executeQuery(cx, db, stmt, query, callback, true);
        }
        if (argsCount == 3) {
            if (!(args[0] instanceof String)) {
                Function callback = null;
                if (!(args[0] instanceof NativeArray)) {
                    HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"array", (Object)args[0], (boolean)false);
                }
                if (!(args[1] instanceof NativeArray)) {
                    HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"array", (Object)args[1], (boolean)false);
                }
                if (!(args[2] instanceof Function)) {
                    HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"3", (String)"function", (Object)args[2], (boolean)false);
                }
                NativeArray queries = (NativeArray)args[0];
                NativeArray values = (NativeArray)args[1];
                callback = (Function)args[2];
                return DatabaseHostObject.executeBatch(cx, db, queries, values, callback);
            }
            Function callback = null;
            String query = (String)args[0];
            PreparedStatement stmt = db.conn.prepareStatement(query);
            if (args[2] instanceof Function) {
                callback = (Function)args[2];
                DatabaseHostObject.setQueryParams(stmt, args, 1, 1);
            } else {
                DatabaseHostObject.setQueryParams(stmt, args, 1, 2);
            }
            return DatabaseHostObject.executeQuery(cx, db, stmt, query, callback, true);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        Function callback = null;
        String query = (String)args[0];
        PreparedStatement stmt = db.conn.prepareStatement(query);
        if (args[argsCount - 1] instanceof Function) {
            callback = (Function)args[argsCount - 1];
            DatabaseHostObject.setQueryParams(stmt, args, 1, argsCount - 1);
        } else {
            DatabaseHostObject.setQueryParams(stmt, args, 1, argsCount - 1);
        }
        return DatabaseHostObject.executeQuery(cx, db, stmt, query, callback, true);
    }

    public static String jsFunction_savePoint(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, SQLException {
        String savePoint;
        String functionName = "savePoint";
        int argsCount = args.length;
        if (argsCount == 0) {
            savePoint = UUID.randomUUID().toString();
        } else {
            if (argsCount != 1) {
                HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
            }
            if (!(args[0] instanceof String)) {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
            }
            savePoint = (String)args[0];
        }
        DatabaseHostObject db = (DatabaseHostObject)thisObj;
        db.savePoints.put(savePoint, db.conn.setSavepoint(savePoint));
        return savePoint;
    }

    public static void jsFunction_releasePoint(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "releasePoint";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        String savePoint = (String)args[0];
        DatabaseHostObject db = (DatabaseHostObject)thisObj;
        try {
            db.conn.releaseSavepoint(db.savePoints.remove(savePoint));
        }
        catch (SQLException e) {
            String msg = "Error while releasing the savepoint : " + savePoint;
            log.warn((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    public static void jsFunction_rollback(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "rollback";
        int argsCount = args.length;
        if (argsCount > 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        String savePoint = null;
        if (argsCount == 1) {
            if (!(args[0] instanceof String)) {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
            }
            savePoint = (String)args[0];
        }
        DatabaseHostObject db = (DatabaseHostObject)thisObj;
        if (savePoint != null) {
            try {
                db.conn.rollback(db.savePoints.get(savePoint));
            }
            catch (SQLException e) {
                String msg = "Error while rolling back the transaction to savepoint : " + savePoint;
                log.warn((Object)msg, (Throwable)e);
                throw new ScriptException(msg, (Exception)e);
            }
        }
        try {
            db.conn.rollback();
        }
        catch (SQLException e) {
            String msg = "Error while rolling back the transaction";
            log.warn((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    public static void jsFunction_commit(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "commit";
        int argsCount = args.length;
        if (argsCount > 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        DatabaseHostObject db = (DatabaseHostObject)thisObj;
        try {
            db.conn.commit();
        }
        catch (SQLException e) {
            String msg = "Error while committing the transaction";
            log.warn((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    public static void jsFunction_close(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "c";
        int argsCount = args.length;
        if (argsCount > 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        DatabaseHostObject db = (DatabaseHostObject)thisObj;
        try {
            db.conn.close();
            if (rdbmsDataSource != null) {
                rdbmsDataSource.getDataSource().close();
            }
        }
        catch (SQLException e) {
            String msg = "Error while closing the Database Connection";
            log.warn((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    private static String replaceWildcards(DatabaseHostObject db, String query, NativeArray params) throws SQLException {
        String openedChar = null;
        String lastChar = null;
        StringBuffer newQuery = new StringBuffer();
        int paramIndex = 0;
        for (int i = 0; i < query.length(); ++i) {
            String c;
            block11: {
                block12: {
                    block13: {
                        block9: {
                            block10: {
                                c = Character.toString(query.charAt(i));
                                if (lastChar == null) {
                                    lastChar = c;
                                    if (c.equals("'") || c.equals("\"")) {
                                        openedChar = c;
                                    }
                                    newQuery.append(c);
                                    continue;
                                }
                                if (!c.equals("'")) break block9;
                                if (openedChar != null) break block10;
                                openedChar = c;
                                break block11;
                            }
                            if (!openedChar.equals(c) || lastChar.equals("\\")) break block11;
                            openedChar = null;
                            break block11;
                        }
                        if (!c.equals("\"")) break block12;
                        if (openedChar != null) break block13;
                        openedChar = c;
                        break block11;
                    }
                    if (!openedChar.equals(c) || lastChar.equals("\\")) break block11;
                    openedChar = null;
                    break block11;
                }
                if (c.equals("?")) {
                    String nextChart;
                    if (openedChar == null) {
                        newQuery.append(HostObjectUtil.serializeObject((Object)params.get(paramIndex, (Scriptable)db)));
                        ++paramIndex;
                        continue;
                    }
                    if (lastChar.equals("'")) {
                        if (openedChar.equals("'") && (nextChart = Character.toString(query.charAt(i + 1))).equals("'")) {
                            newQuery.append(HostObjectUtil.serializeObject((Object)params.get(paramIndex, (Scriptable)db)));
                            continue;
                        }
                    } else if (lastChar.equals("\"") && openedChar.equals("\"") && (nextChart = Character.toString(query.charAt(i + 1))).equals("\"")) {
                        newQuery.append(HostObjectUtil.serializeObject((Object)params.get(paramIndex, (Scriptable)db)));
                        continue;
                    }
                }
            }
            newQuery.append(c);
            lastChar = c;
        }
        return newQuery.toString();
    }

    private static void setQueryParams(PreparedStatement stmt, Object[] params, int from, int to) throws SQLException {
        for (int i = from; i < to + 1; ++i) {
            DatabaseHostObject.setQueryParam(stmt, params[i], i);
        }
    }

    private static void setQueryParam(PreparedStatement stmt, Object obj, int index) throws SQLException {
        if (obj instanceof String) {
            stmt.setString(index, (String)obj);
        } else if (obj instanceof Integer) {
            stmt.setInt(index, (Integer)obj);
        } else if (obj instanceof Double) {
            stmt.setDouble(index, (Double)obj);
        } else {
            stmt.setString(index, HostObjectUtil.serializeObject((Object)obj));
        }
    }

    private static Object executeQuery(Context cx, final DatabaseHostObject db, final PreparedStatement stmt, String query, final Function callback, final boolean keyed) throws ScriptException {
        String regex = "^[\\s\\t\\r\\n]*[Ss][Ee][Ll][Ee][Cc][Tt].*";
        final boolean isSelect = query.matches(regex);
        if (callback != null) {
            final ContextFactory factory = cx.getFactory();
            final ExecutorService es = Executors.newSingleThreadExecutor();
            es.submit(new Callable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call() throws Exception {
                    Context cx = RhinoEngine.enterContext((ContextFactory)factory);
                    try {
                        Integer result = isSelect ? DatabaseHostObject.processResults(cx, (Scriptable)db, db, stmt.executeQuery(), keyed) : Integer.valueOf(stmt.executeUpdate());
                        callback.call(db.context, (Scriptable)db, (Scriptable)db, new Object[]{result});
                    }
                    catch (SQLException e) {
                        log.warn((Object)e);
                    }
                    finally {
                        es.shutdown();
                        RhinoEngine.exitContext();
                    }
                    return null;
                }
            });
            return null;
        }
        try {
            if (isSelect) {
                return DatabaseHostObject.processResults(cx, (Scriptable)db, db, stmt.executeQuery(), keyed);
            }
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new ScriptException((Exception)e);
        }
    }

    private static Object executeBatch(Context cx, final DatabaseHostObject db, NativeArray queries, NativeArray params, final Function callback) throws ScriptException, SQLException {
        if (params != null && queries.getLength() != params.getLength()) {
            String msg = "Query array and values array should be in the same size. HostObject : Database, Method : query";
            log.warn((Object)msg);
            throw new ScriptException(msg);
        }
        final Statement stmt = db.conn.createStatement();
        Integer[] arr$ = (Integer[])queries.getIds();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int index = arr$[i$];
            Object obj = queries.get(index, (Scriptable)db);
            if (!(obj instanceof String)) {
                String msg = "Invalid query type : " + obj.toString() + ". Query should be a string";
                log.warn((Object)msg);
                throw new ScriptException(msg);
            }
            String query = (String)obj;
            if (params != null) {
                Object valObj = params.get(index, (Scriptable)db);
                if (!(valObj instanceof NativeArray)) {
                    String msg = "Invalid value type : " + obj.toString() + " for the query " + query;
                    log.warn((Object)msg);
                    throw new ScriptException(msg);
                }
                query = DatabaseHostObject.replaceWildcards(db, query, (NativeArray)valObj);
            }
            stmt.addBatch(query);
        }
        if (callback != null) {
            final ContextFactory factory = cx.getFactory();
            final ExecutorService es = Executors.newSingleThreadExecutor();
            es.submit(new Callable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call() throws Exception {
                    RhinoEngine.enterContext((ContextFactory)factory);
                    try {
                        int[] result = stmt.executeBatch();
                        callback.call(db.context, (Scriptable)db, (Scriptable)db, new Object[]{result});
                    }
                    catch (SQLException e) {
                        log.warn((Object)e);
                    }
                    finally {
                        es.shutdown();
                        RhinoEngine.exitContext();
                    }
                    return null;
                }
            });
            return null;
        }
        return stmt.executeBatch();
    }

    private static Scriptable processResults(Context cx, Scriptable scope, DatabaseHostObject db, ResultSet results, boolean keyed) throws SQLException, ScriptException {
        ArrayList<NativeObject> rows = new ArrayList<NativeObject>();
        while (results.next()) {
            int i;
            NativeObject row;
            ResultSetMetaData rsmd = results.getMetaData();
            if (keyed) {
                row = new NativeObject();
                for (i = 0; i < rsmd.getColumnCount(); ++i) {
                    String columnName = rsmd.getColumnName(i + 1);
                    Object columnValue = DatabaseHostObject.getValue(db, results, i + 1, rsmd.getColumnType(i + 1));
                    row.put(columnName, (Scriptable)row, columnValue);
                }
            } else {
                row = (ScriptableObject)cx.newArray(scope, rsmd.getColumnCount());
                for (i = 0; i < rsmd.getColumnCount(); ++i) {
                    Object columnValue = DatabaseHostObject.getValue(db, results, i + 1, rsmd.getColumnType(i + 1));
                    row.put(i + 1, (Scriptable)row, columnValue);
                }
            }
            rows.add(row);
        }
        return db.context.newArray((Scriptable)db, rows.toArray());
    }

    private static Object getValue(DatabaseHostObject db, ResultSet results, int index, int type) throws SQLException, ScriptException {
        Context cx = db.context;
        switch (type) {
            case 2003: {
                return cx.newArray((Scriptable)db, new Object[]{results.getArray(index)});
            }
            case -5: {
                return results.getBigDecimal(index).toPlainString();
            }
            case -2: {
                return HostObjectUtil.streamToString((InputStream)results.getBinaryStream(index));
            }
            case 2005: {
                return cx.newObject((Scriptable)db, "Stream", new Object[]{results.getClob(index).getAsciiStream()});
            }
        }
        return Context.javaToJS((Object)results.getObject(index), (Scriptable)db);
    }
}

