/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.scriptengine.cache;

import java.util.HashMap;
import java.util.Map;
import org.jaggeryjs.scriptengine.cache.CacheManager;
import org.jaggeryjs.scriptengine.cache.CachingContext;
import org.jaggeryjs.scriptengine.cache.CompilationContext;
import org.jaggeryjs.scriptengine.cache.PackageWrapper;

public class ContextWrapper {
    private Map<String, PackageWrapper> packages = new HashMap<String, PackageWrapper>();
    private CompilationContext compilationContext = null;

    public CompilationContext getCompilationContext() {
        return this.compilationContext;
    }

    public void setCompilationContext(CompilationContext compilationContext) {
        this.compilationContext = compilationContext;
    }

    public int getPathCount() {
        return this.packages.size();
    }

    public Map<String, PackageWrapper> getPackages() {
        return this.packages;
    }

    public PackageWrapper getPackage(String path) {
        return this.packages.get(CacheManager.getPackage(path));
    }

    public void removePackage(String path) {
        this.packages.remove(CacheManager.getPackage(path));
    }

    public void removeCachingContext(String path, String cacheKey) {
        PackageWrapper packageWrapper = this.getPackage(path);
        if (packageWrapper == null) {
            return;
        }
        packageWrapper.removeCachingContext(cacheKey);
        if (packageWrapper.getCachingContextCount() == 0) {
            this.removePackage(path);
        }
    }

    public void setPackage(String path, PackageWrapper packageWrapper) {
        this.packages.put(CacheManager.getPackage(path), packageWrapper);
    }

    public void setCachingContext(String path, String cacheKey, CachingContext ctx) {
        PackageWrapper packageWrapper = this.getPackage(path);
        if (packageWrapper == null) {
            packageWrapper = new PackageWrapper();
            this.setPackage(path, packageWrapper);
        }
        packageWrapper.setCachingContexts(cacheKey, ctx);
    }
}

