/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.axiom.om.util.Base64;
import org.jaggeryjs.jaggery.core.task.JaggeryTask;
import org.jaggeryjs.jaggery.core.task.JaggeryTaskInfo;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.core.TaskInfo;

public class JaggeryTaskUtils {
    public static JaggeryTaskInfo convert(TaskInfo taskInfo) {
        JaggeryTaskInfo jaggeryTaskInfo = new JaggeryTaskInfo();
        jaggeryTaskInfo.setName(taskInfo.getName());
        TaskInfo.TriggerInfo triggerInfo = taskInfo.getTriggerInfo();
        jaggeryTaskInfo.setCronExpression(triggerInfo.getCronExpression());
        jaggeryTaskInfo.setStartTime(JaggeryTaskUtils.dateToCal(triggerInfo.getStartTime()));
        jaggeryTaskInfo.setEndTime(JaggeryTaskUtils.dateToCal(triggerInfo.getEndTime()));
        jaggeryTaskInfo.setTaskCount(triggerInfo.getRepeatCount());
        jaggeryTaskInfo.setTaskInterval(triggerInfo.getIntervalMillis());
        return jaggeryTaskInfo;
    }

    public static TaskInfo convert(JaggeryTaskInfo jaggeryTaskInfo) {
        TaskInfo.TriggerInfo triggerInfo = new TaskInfo.TriggerInfo();
        triggerInfo.setCronExpression(jaggeryTaskInfo.getCronExpression());
        if (jaggeryTaskInfo.getStartTime() != null) {
            triggerInfo.setStartTime(jaggeryTaskInfo.getStartTime().getTime());
        }
        if (jaggeryTaskInfo.getEndTime() != null) {
            triggerInfo.setEndTime(jaggeryTaskInfo.getEndTime().getTime());
        }
        triggerInfo.setIntervalMillis((int)jaggeryTaskInfo.getTaskInterval());
        triggerInfo.setRepeatCount(jaggeryTaskInfo.getTaskCount());
        return new TaskInfo(jaggeryTaskInfo.getName(), JaggeryTask.class.getName(), jaggeryTaskInfo.getTaskProperties(), triggerInfo);
    }

    public static Calendar dateToCal(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static synchronized Object fromString(String encodedString) throws IOException, ClassNotFoundException {
        byte[] data = Base64.decode((String)encodedString);
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(data));
        Object readObject = objectInputStream.readObject();
        objectInputStream.close();
        return readObject;
    }

    public static synchronized String toString(Serializable object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        return new String(Base64.encode((byte[])byteArrayOutputStream.toByteArray()));
    }

    public static String getTenantDomainFromId(int tid) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getCurrentContext().setTenantId(tid);
        String tenantDomain = PrivilegedCarbonContext.getCurrentContext().getTenantDomain();
        PrivilegedCarbonContext.endTenantFlow();
        return tenantDomain;
    }
}

